/**********************************************************-*-verilog-*-
 *
 *	Project: TORIYA --
 *	THE TOP MODULE of TRIP for the Legacy Serial
 *	$Id: top_ser.v 118 2007-04-11 04:55:06Z chapuni $
 *
 */

module top_ser(CLK1P, CLK4P, CLK14P,
			   TxD1, RTS1, RxD1, CTS1,
			   SWIN,
			   LEDDB, LEDOEN);

	input			CLK1P;		// on-board clock generator
	input			CLK4P;		// same as CLK1P
	input			CLK14P;		// same as CLK1P
	output 			TxD1;
	output 			RTS1;
	input 			RxD1;
	input 			CTS1;
	input [1:5] 	SWIN;		// functional switch
	output [7:0] 	LEDDB;
	output [4:0] 	LEDOEN;

`include "func_des.v"
`include "func_salt.v"
`include "func_util.v"

	// ̉HŎgpř!!!
	parameter 		NCAP = 54;	// łLc
	parameter 		NCTH = 0;

	// SaltŒŁAgbvЂ˂oǂ
	parameter		SALT_MSB = 1'b0;

	// ZbǵAHɂĐ_ŎgpB
	wire 			clk_locked;
	wire 			serclk_locked;
	wire 			rst = !SWIN[5] || !clk_locked || !serclk_locked;
	reg 			trip_rstgo;
	wire 			trip_rst = rst || trip_rstgo;

	// x5 PLL
	wire 			clk, clk5, st_gate;
	clockgen pllx5(CLK4P, clk5, clk, st_gate, clk_locked);

	// Serial clock
	wire 			txclk, rxclk, hostclk, ledclk;
	wire 			serclk16;
	serclockgen serclkx16(CLK14P, serclk16, serclk_locked);
	reg [12:0] 		serclk_div;
	assign 			hostclk = serclk_div[1];	// 1/4
	assign 			rxclk = serclk_div[1];		// 1/4
	assign 			txclk = serclk_div[3];		// 1/16
	assign 			ledclk = serclk_div[12];	// Ԃ225Hz

	// FIFO
	wire [55:0] 	fifo_data;
	reg 			fifo_rdreq;
	wire 			fifo_wrreq;
	wire [55:0] 	fifo_q;
	wire 			fifo_rdempty;
	wire [12:0] 	fifo_usedw;
	wire 			fifo_wrfull;
	kfifo fifo1(fifo_data, fifo_wrreq, fifo_rdreq,
				hostclk, clk, rst,
				fifo_q, fifo_rdempty, fifo_usedw,
				fifo_wrfull);

	// LED driver
	wire [7:0] 		led_d8;
	wire [15:0] 	led_h8b;
	wire [3:0] 		led_d4;
	leddrv4 led7sg(ledclk, rst,
				   LEDDB, LEDOEN,
				   led_h8b[15:12],
				   led_h8b[11: 8],
				   led_h8b[ 7: 4],
				   led_h8b[ 3: 0],
				   led_d4[3],
				   led_d4[2],
				   led_d4[1],
				   led_d4[0]);

	// Serial clock generator(serclk16 = 32MHz * 36 / 625)
	always @(posedge serclk16)
	  serclk_div <= serclk_div + 1;

	// Serial Rx driver
	wire [7:0] 		rxdata;
	wire 			rxrdy;
	reg 			rxack;
	rxdriver rxdrv1(rxclk, rst, RxD1, RTS1, rxrdy, rxdata, rxack);

	// Serial Tx Driver
	reg [7:0] 		txdata;
	reg 			txwe;
	wire 			txrdy;
	txdriver txdrv1(txclk, rst, TxD1, CTS1, txwe, txdata, txrdy);

	// TRIP ENGINE
	reg 			tripper_ken;
	reg 			tripper_wait;
	reg [11:0] 		salt;
	reg [27:0] 		kl, kr;
	wire [27:0] 	kli, kri;
	wire 			tripper_bsy;
	wire 			tripper_oen;
	wire [55:0] 	o_k;
	wire [1:64] 	o_h;

	parameter		krstep = 28'b0000_0001_0000_0000_000_000_000_000;
	parameter		krmask = 28'b0000_0000_1111_1111_111_111_111_111;
	assign 			{kli, kri} = {kl, kr} + {28'b0, krstep};

	crypt22 #(krmask)
	tripper(rst,
			clk, clk5, st_gate,
			tripper_ken, salt, {kr, kl},
			tripper_bsy,
			tripper_oen, o_k, o_h);

	// ܂̓^C~OIɌ o_h oĂ܂
	reg 			men0;
	reg [55:0] 		fk0;
	reg [1:66] 		fh0;
	always @(posedge clk)
	begin
		men0 <= tripper_oen;
		fk0 <= kmux({krmask, 28'b0},
					{kr, kl},
					o_k);
		fh0 <= {o_h, 2'b0};
	end

	// r}V[(gݍ킹H)
	wire 			matched;
	reg 			c_we;	// pulse
	reg [55:0] 		fk1;
	reg [7:0] 		c_wu;
	reg [7:0] 		c_txd;
	comparators #(NCAP, NCTH)
	cmps(rst,
		 clk,
		 men0,
		 fk0, fh0,		// ʂL[
		 fk1, matched,	// qbg
		 hostclk,
		 c_we, c_wu, c_txd);

	assign 			fifo_wrreq = matched;
	assign 			fifo_data = pc1(fk1);

	// FIFO ́Ardreq PTCNxŏoĂ!
	reg 			fifo_rdrdy;

	// R}hꗗ
	parameter 		CMD_READY	= 8'b0000_0001;
	parameter 		CMD_RESET	= 8'b0000_0011;
	parameter 		CMD_GETCAP	= 8'b0000_0111;
	parameter 		CMD_TEXT	= 8'b0000_1101;
	parameter 		CMD_STANDBY	= 8'b0000_1111;
	parameter 		CMD_SETCOND	= 2'b01;
	parameter 		CMD_SETKEY	= 8'b1000_0000;

	// R}h̃Xe[gȂ
	reg [3:0] 		st_cmd;
	parameter 		ST_CMD_STANDBY		= 4'b0000;
	parameter 		ST_CMD_READY		= 4'b0001;
	parameter 		ST_CMD_TEXT			= 4'b0010;
	parameter 		ST_CMD_GETTING_CAP	= 4'b1000;
	parameter 		ST_CMD_SENDING		= 4'b1001;
	parameter 		ST_CMD_TEXT_SENDING	= 4'b1010;
	parameter 		ST_CMD_SETTING_COND	= 4'b1011;
	parameter 		ST_CMD_SETTING_KEY1	= 4'b1101;
	parameter 		ST_CMD_SETTING_KEY2	= 4'b1110;
	parameter 		ST_CMD_SETTING_KEY3	= 4'b1111;

	// M邽߂̈ꎞWX^
	reg [4:0] 		st_send;	// 0..16
	reg [63:0] 		found_key;

	wire 			rdy_led;
	assign 			rdy_led = !fifo_rdempty || st_cmd == ST_CMD_READY;

	// Ԃ̃|[gLED
	assign 			led_d8 = {1'b0,
							  1'b0,
							  1'b0,
							  1'b0,
							  1'b0,
							  1'b0,
							  1'b0,
							  1'b0};
	assign 			led_h8b = (SWIN[1] ? kl[27:12]
							   : SWIN[4] ? kr[23: 8]
							   : SWIN[2] ? {3'b0, fifo_usedw}
							   : {kl[11:0], kr[27:24]});
	assign 			led_d4 = {1'b0,
							  rdy_led,
							  ~CTS1 & ~kr[23],
							  fifo_wrfull};

	/*
	 *	zXgC^tFCXBȂƂȂserclkŉ񂵂Ă݂
	 */
	always @(posedge hostclk or posedge rst)
	  if (rst)
	  begin
		  // reset
		  fifo_rdreq <= 0;
		  fifo_rdrdy <= 0;
		  txwe <= 0;
		  rxack <= 0;
		  trip_rstgo <= 0;
		  st_cmd <= ST_CMD_STANDBY;
		  tripper_ken <= 0;
		  tripper_wait <= 0;
		  kl <= 28'b0;
		  kr <= 28'b0;
		  c_we <= 0;
		  c_wu <= 0;
		  found_key <= 0;
	  end
	  else
	  begin
		  /*
		   *  L[܂킵
		   */
		  if (!tripper_ken && !tripper_bsy && !tripper_wait)
		  begin
			  tripper_ken <= 1;
		  end
		  else if (tripper_ken && tripper_bsy && !tripper_wait)
		  begin
			  tripper_wait <= 1;
		  end
		  else if (tripper_ken && !tripper_bsy && tripper_wait)
		  begin
			  tripper_wait <= 0;
			  tripper_ken <= 0;
			  {kl, kr} <= {kli, kri};
			  salt <= {mksalt({SALT_MSB, kli[24:22], kri[23:20]}),
					   mksalt({SALT_MSB, kli[27:25], kri[27:24]})};
		  end

		  /*
		   *  R}hM
		   */
		  if (st_cmd == ST_CMD_STANDBY
			  //|| st_cmd == ST_CMD_TEXT
			  || st_cmd == ST_CMD_READY)
		  begin
			  if (!c_we && rxrdy && !rxack)
				case (rxdata)
				  CMD_RESET:
					begin
						rxack <= 1;
						trip_rstgo <= 1;
						st_cmd <= ST_CMD_STANDBY;
					end
				  CMD_READY:
					begin
						rxack <= 1;
						st_cmd <= ST_CMD_READY;
					end
				  CMD_STANDBY:
					begin
						// L[񍐂ăX^oC
						rxack <= 1;
						st_cmd <= ST_CMD_STANDBY;
					end
				  /*
				  CMD_TEXT:
					begin
						rxack <= 1;
						st_cmd <= ST_CMD_TEXT;
					end
				   */
				  CMD_GETCAP:
					if (txrdy && !txwe)
					begin
						rxack <= 1;
						st_cmd <= ST_CMD_GETTING_CAP;

						// Rp[^̑𑗂
						// ܂͂𑗂Ă܂
						txdata[5:0] <= NCAP;
						txdata[7:6] <= 2'b0;
						txwe <= 1;
						c_wu <= 0;
					end
				  CMD_SETKEY:
					begin
						st_cmd <= ST_CMD_SETTING_KEY1;
						rxack <= 1;
					end
				  default:
					case (rxdata[7:6])
					  CMD_SETCOND:
						begin
							// Xbg#󂯎
							c_wu <= {2'b0, rxdata[5:0]};
							st_cmd <= ST_CMD_SETTING_COND;
							rxack <= 1;
						end
					  default:
						rxack <= 1;	// ǂݎ̂
					endcase
				endcase
		  end
		  /*
		   *  R}h
		   */
		  case (st_cmd)
			ST_CMD_GETTING_CAP:
			  if (txrdy && !txwe)
			  begin
				  st_cmd <= ST_CMD_STANDBY;
				  /*
				  // 㑱ɁA\͂Am点
				  txdata <= c_cap;
				  txwe <= 1;
				  if (c_wu == NCAP - 1)
					st_cmd <= ST_CMD_STANDBY;
				  c_wu <= c_wu + 1;
				   */
			  end
			ST_CMD_SETTING_KEY1:
			  // KEY ́ANETWORK ORDER̋t(shit!)
			  if (rxrdy && !rxack)
			  begin
				  kl[11: 4] <= rxdata;
				  rxack <= 1;
				  st_cmd <= ST_CMD_SETTING_KEY2;
			  end
			ST_CMD_SETTING_KEY2:
			  if (rxrdy && !rxack)
			  begin
				  kl[19:12] <= rxdata;
				  rxack <= 1;
				  st_cmd <= ST_CMD_SETTING_KEY3;
			  end
			ST_CMD_SETTING_KEY3:
			  if (rxrdy && !rxack)
			  begin
				  kl[27:20] <= rxdata;
				  rxack <= 1;
				  tripper_ken <= 0;
				  tripper_wait <= 0;
				  st_cmd <= ST_CMD_STANDBY;
			  end
			ST_CMD_SETTING_COND:
			  if (rxrdy && !rxack && !c_we)
			  begin
				  // L[󂯎APcl߂Ă
				  c_txd <= rxdata;
				  c_we <= 1;
				  rxack <= 1;
				  st_cmd <= ST_CMD_STANDBY;
			  end
			ST_CMD_READY:
			  begin
				  /* L[𔭌zXgɑԂ[h */
				  if (CTS1)
				  begin
					  fifo_rdreq <= 0;
					  fifo_rdrdy <= 0;
					  st_cmd <= ST_CMD_STANDBY;
				  end
				  else if (!fifo_rdempty && !fifo_rdreq && !fifo_rdrdy)
				  begin
					  // FIFOւ̃f[^v
					  fifo_rdreq <= 1;
					  fifo_rdrdy <= 0;
				  end
				  else if (fifo_rdreq && !fifo_rdrdy)
				  begin
					  fifo_rdreq <= 0;
					  fifo_rdrdy <= 1;
				  end
				  else if (!fifo_rdreq && fifo_rdrdy)
				  begin
					  // FIFO̎荞
					  // f[^́ALITTLE ENDIAN(
					  found_key <= i_pc1(fifo_q, SALT_MSB);
					  fifo_rdreq <= 0;
					  st_send <= 0;
					  fifo_rdrdy <= 0;
					  st_cmd <= ST_CMD_SENDING;
				  end
			  end
			ST_CMD_SENDING:
			  if (txrdy && !txwe)
			  begin
				  /*
				   *  vL[oCiɂđM郂[h
				   */
				  // J(pos, data)𑗂oĂ
				  // Ƃ̂͌ÂdlB
				  // ܂́Adata ݂̂Ђ瑗oĂB
				  txdata <= found_key[63:56];
				  txwe <= 1;
				  found_key <= {found_key[55:0], 8'b0000_0000};
				  st_send <= st_send + 1;
				  if (st_send == 8 - 1)
					st_cmd <= CTS1 ? ST_CMD_STANDBY : ST_CMD_READY;
			  end
		  endcase

		  /*
		   *  MACK߂
		   */
		  if (!txrdy && txwe)
			txwe <= 0;
		  if (!rxrdy && rxack)
			rxack <= 0;

		  /*
		   *  WX^ we (pX) ߂
		   */
		  if (c_we)
			c_we <= 0;

		  /*
		   *  GWZbgAT[gĂ
		   *  ₪ălQ[g悤ɂĂ݂
		   */
		  if (trip_rstgo)
			trip_rstgo <= 0;
	  end

endmodule // top_ser

/*-------------------------------------------------------------------------------------------+
; Fitter Resource Usage Summary                                                              ;
+---------------------------------------------+----------------------------------------------+
; Resource                                    ; Usage                                        ;
+---------------------------------------------+----------------------------------------------+
; Total logic elements                        ; 10,307 / 10,570 ( 98 % )                     ;
;     -- Combinational with no register       ; 1086                                         ;
;     -- Register only                        ; 3862                                         ;
;     -- Combinational with a register        ; 5359                                         ;
;                                             ;                                              ;
; Logic element usage by number of LUT inputs ;                                              ;
;     -- 4 input functions                    ; 4530                                         ;
;     -- 3 input functions                    ; 565                                          ;
;     -- 2 input functions                    ; 1306                                         ;
;     -- 1 input functions                    ; 1858                                         ;
;     -- 0 input functions                    ; 2048                                         ;
;                                             ;                                              ;
; Logic elements by mode                      ;                                              ;
;     -- normal mode                          ; 10123                                        ;
;     -- arithmetic mode                      ; 184                                          ;
;     -- qfbk mode                            ; 2735                                         ;
;     -- register cascade mode                ; 499                                          ;
;     -- synchronous clear/load mode          ; 5526                                         ;
;     -- asynchronous clear/load mode         ; 4198                                         ;
;                                             ;                                              ;
; Total registers                             ; 9,221 / 13,052 ( 71 % )                      ;
; Total LABs                                  ; 1,048 / 1,057 ( 99 % )                       ;
; Logic elements in carry chains              ; 200                                          ;
; User inserted logic elements                ; 0                                            ;
; Virtual pins                                ; 0                                            ;
; I/O pins                                    ; 25 / 427 ( 6 % )                             ;
;     -- Clock pins                           ; 3 / 16 ( 19 % )                              ;
; Global signals                              ; 8                                            ;
; M512s                                       ; 94 / 94 ( 100 % )                            ;
; M4Ks                                        ; 60 / 60 ( 100 % )                            ;
; M-RAMs                                      ; 1 / 1 ( 100 % )                              ;
; Total memory bits                           ; 752,640 / 920,448 ( 82 % )                   ;
; Total RAM block bits                        ; 920,448 / 920,448 ( 100 % )                  ;
; DSP block 9-bit elements                    ; 0 / 48 ( 0 % )                               ;
; PLLs                                        ; 2 / 6 ( 33 % )                               ;
; Global clocks                               ; 8 / 16 ( 50 % )                              ;
; Regional clocks                             ; 0 / 16 ( 0 % )                               ;
; Fast regional clocks                        ; 0 / 8 ( 0 % )                                ;
; SERDES transmitters                         ; 0 / 44 ( 0 % )                               ;
; SERDES receivers                            ; 0 / 44 ( 0 % )                               ;
; Average interconnect usage                  ; 28%                                          ;
; Peak interconnect usage                     ; 45%                                          ;
; Maximum fan-out node                        ; clockgen:pllx5|altpll:altpll_component|_clk0 ;
; Maximum fan-out                             ; 5274                                         ;
; Highest non-global fan-out signal           ; ~GND                                         ;
; Highest non-global fan-out                  ; 240                                          ;
; Total fan-out                               ; 46320                                        ;
; Average fan-out                             ; 4.42                                         ;
+---------------------------------------------+---------------------------------------------*/

/*
 *  Local variables:
 *  tab-width: 4
 *  End:
 */
