#include <key.h>

static char KeyMapASCII[256] = {
  KEY_NULL, KEY_ESC, KEY_1, KEY_2, KEY_3, KEY_4, KEY_5, KEY_6, //00 - 07
  KEY_7, KEY_8, KEY_9, KEY_0, KEY_MINUS, KEY_POW, KEY_BACK, KEY_TAB, //08 - 0F
  KEY_Q, KEY_W, KEY_E, KEY_R, KEY_T, KEY_Y, KEY_U, KEY_I, //10 - 17
  KEY_O, KEY_P, KEY_ATTO, KEY_LEFTBIGCACCO, KEY_ENTER, KEY_BACKSLASH,
  KEY_A, KEY_S, //18 - 1F
  KEY_D, KEY_F, KEY_G, KEY_H, KEY_J, KEY_K, KEY_L, KEY_PLUS, //20 - 27
  KEY_ASTA, KEY_NULL, KEY_LEFTSHIFT, KEY_RIGHTBIGCACCO, KEY_Z, KEY_X, KEY_C,
  KEY_V, //28 - 2F
  KEY_B, KEY_N, KEY_M, KEY_SMALL, KEY_DOT, KEY_SLASH, KEY_RIGHTSHIFT,
  KEY_NULL, //30 - 37
  KEY_LEFTALT, KEY_SPACE, KEY_CAPS, KEY_F1, KEY_F2, KEY_F3, KEY_F4,
  KEY_F5, //38 - 3F
  KEY_F6, KEY_F7, KEY_F8, KEY_F9, KEY_F10, KEY_NULL, KEY_NULL, 
  KEY_NULL, //40 - 47
  KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL,
  KEY_NULL, //48 - 4F
  KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL,
  KEY_F11, //50 - 57
  KEY_F12, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL,
  KEY_NULL, //58 - 5F
  KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL,
  KEY_NULL, //60 - 67
  KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL,
  KEY_NULL, //68 - 6F
  KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL,
  KEY_NULL, //70 - 77
  KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL,
  KEY_NULL, //78 - 7F
  KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL,
  KEY_NULL, //80 - 87
  KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL,
  KEY_NULL, //88 - 8F
  KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL,
  KEY_NULL, //90 - 97
  KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL,
  KEY_NULL, //98 - 9F
  KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL,
  KEY_NULL, //A0 - A7
  KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL,
  KEY_NULL, //A8 - AF
  KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL,
  KEY_NULL, //B0 - BF
  KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL,
  KEY_NULL, //C0 - C7
  KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL,
  KEY_NULL, //C8 - CF
  KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL,
  KEY_NULL, //D0 - D7
  KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL,
  KEY_NULL, //D8 - DF
  KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL,
  KEY_NULL, //E0 - E7
  KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL,
  KEY_NULL, //E8 - EF
  KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL,
  KEY_NULL, //F0 - F7
  KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL, KEY_NULL,
  KEY_NULL  //F8 - FF
};

PRIVATE struct stdin_list* keylist_head;
PRIVATE struct stdin_list* keylist_current;

PUBLIC void init_key()
{
  keylist_head = kalloc(sizeof(struct stdin_list));
  memset(keylist_head, 0, sizeof(struct stdin_list));
  keylist_current = keylist_head;
}

PUBLIC char get_keymap(u_int8_t c)
{
  return KeyMapASCII[c];
}

PUBLIC char set_stdin(u_int8_t c)
{
  if (keylist_current->nums == KEY_BUF) {
    keylist_current->next = kalloc(sizeof(struct stdin_list));
    memset(keylist_current->next, 0, sizeof(struct stdin_list));
    keylist_current = keylist_current->next;
    keylist_current->buf[keylist_current->nums++] = KeyMapASCII[c];
  } else {
    keylist_current->buf[keylist_current->nums++] = KeyMapASCII[c];    
  }

  return KeyMapASCII[c];
}

PUBLIC char* get_stdin(char* tobuf)
{
  char *ret;
  //asm __volatile__("cli");
  if (keylist_current->nums == 0 && keylist_current->next == NULL) {
    return NULL;
  } else {
    ret = keylist_current->buf;
    memcpy(tobuf, ret, keylist_current->nums);
    keylist_current->nums = 0;

    struct stdin_list  *p, *prev;
    for (p = keylist_head; p != keylist_current; p = p->next)
      prev = p;
    if (p != keylist_head) {
      kfree(prev->next);
      prev->next = NULL;
    }
  }
  //asm __volatile__("sti");
  return ret;
}
