/* VF֌W */

#include "bootpack.h"

struct TASK *open_constask(struct SHEET *sht)
{
	struct TASK *task = task_alloc();
	int *cons_fifo = (int *) memman_alloc_4k(128 * 4);
	
	task->cons_stack = memman_alloc_4k(64 * 1024);
	task->tss.esp = task->cons_stack + 64 * 1024 - 12;
	task->tss.eip = (int) &console_task;
	task->tss.es = 1 * 8;
	task->tss.cs = 2 * 8;
	task->tss.ss = 1 * 8;
	task->tss.ds = 1 * 8;
	task->tss.fs = 1 * 8;
	task->tss.gs = 1 * 8;
	*((int *) (task->tss.esp + 4)) = (int) sht;
	*((int *) (task->tss.esp + 8)) = memtest(0x00400000, 0xbfffffff);
	task_run(task, 2, 2, "shell"); /* level=2, priority=2 */
	fifo32_init(&task->fifo, 128, cons_fifo, task);
	
	return task;
}

struct SHEET *open_console(void)
{
	struct SHEET *sht = sheet_alloc();
	UCHAR *buf = (UCHAR *) memman_alloc_4k(540 * 380);
	
	sheet_setbuf(sht, buf, 540, 380, -1); /* FȂ */
	draw_window8(buf, 540, 380, "System Shell", 0);
	draw_textbox8(sht, 8, 28, 524, 343, COL8_000000);
	set_taskbar(sht->id, "System Shell");
	sht->task = open_constask(sht);
	sht->flags |= 0x20;	/* J[\ */
	sht->ktype = KERNELWINDOW_CONS;
	
	return sht;
}

void close_constask(struct TASK *task)
{
	task_sleep(task);
	
	memman_free_4k(task->cons_stack, 64 * 1024);
	memman_free_4k((int) task->fifo.buf, 128 * 4);
	task->flags = 0; /* task_free(task); ̑ */
	
	return;
}

void close_console(struct SHEET *sht)
{	
	memman_free_4k((int)sht->buf, 540 * 380);
	sheet_free(sht);
	close_constask(sht->task);
	return;
}


void console_task(struct SHEET *sheet, int memtotal)
{
	struct TASK *task = task_now();
	int i, *fat = (int *) memman_alloc_4k(4 * 2880);
	struct CONSOLE cons;
	struct FILEHANDLE fhandle[8];
	char cmdline[256];
	UCHAR *nihongo = (char *) *((int *) 0x0fe8);

	cons.sht = sheet;
	cons.cur_x =  8;
	cons.cur_y = 28;
	cons.cur_c = -1;
	task->cons = &cons;
	task->cmdline = cmdline;
	cons.ch = 0;
	
	if (cons.sht != 0) {
		cons.timer = timer_alloc();
		timer_init(cons.timer, &task->fifo, 1);
		timer_settime(cons.timer, 50);
	}
	file_readfat(fat, (UCHAR *) (ADR_DISKIMG + 0x000200));
	for (i = 0; i < 8; i++) {
		fhandle[i].buf = 0;	/* gp}[N */
	}
	task->fhandle = fhandle;
	task->fat = fat;
	if (nihongo[4096] != 0xff) {	/* {tHgt@Cǂݍ߂H */
		task->langmode = 1;
	} else {
		task->langmode = 0;
	}
	task->langbyte1 = 0;

	/* o[W\ */
	cons_putstr0(&cons, (char *)VERSIONDATA_TAG);
	cons_newline(&cons);
	
	/* vvg\ */
	cons_putchar(&cons, '>', 1);

	for (;;) {
		io_cli();
		if (fifo32_status(&task->fifo) == 0) {
			task_sleep(task);
			io_sti();
		} else {
			i = fifo32_get(&task->fifo);
			io_sti();
			if (i <= 1 && cons.sht != 0) { /* J[\p^C} */
				if (i != 0) {
					timer_init(cons.timer, &task->fifo, 0); /* 0 */
					if (cons.cur_c >= 0) {
						cons.cur_c = COL8_FFFFFF;
					}
				} else {
					timer_init(cons.timer, &task->fifo, 1); /* 1 */
					if (cons.cur_c >= 0) {
						cons.cur_c = COL8_000000;
					}
				}
				timer_settime(cons.timer, 50);
			}
			if (i == 2) {	/* J[\ON */
				cons.cur_c = COL8_FFFFFF;
			}
			if (i == 3) {	/* J[\OFF */
				if (cons.sht != 0) {
					boxfill8(cons.sht->buf, cons.sht->bxsize, COL8_000000,
						cons.cur_x, cons.cur_y, cons.cur_x + 7, cons.cur_y + 15);
				}
				cons.cur_c = -1;
			}
			if (i == 4) {	/* R\[́u~v{^NbN */
				cmd_exit(&cons, fat);
			}
			if (256 <= i && i <= 511) { /* L[{[hf[^i^XNAoRj */
				if (i == 8 + 256) {
					/* obNXy[X */
					if (cons.ch > 0) {
						if (cons.cur_y >= 16 && cons.cur_x <= 8) {
							cons_putchar(&cons, ' ', 0);
							cons.cur_y -= 16;
							cons.cur_x = 524 - 12;
						} else {
							cons_putchar(&cons, ' ', 0);
							cons.cur_x -= 8;
						}	
						cons.ch--;
					}
				} else if (i == 10 + 256) {
					/* Enter */
					/* J[\Xy[XŏĂs */
					cons_putchar(&cons, ' ', 0);
					cmdline[cons.ch] = 0;
					cons_newline(&cons);
					cons_runcmd(cmdline, &cons, fat, memtotal);	/* R}hs */
					if (cons.sht == 0) {
						cmd_exit(&cons, fat);
					}

					/* IR}hC͋ɂ */
					memset(cmdline, 0, 256);
					
					/* vvg\ */
					cons_putchar(&cons, '>', 1);
					cons.ch = 0;
				} else {
					/* ʕ */
					if (cons.cur_x < 520 + 8) {
						/* ꕶ\ĂAJ[\1i߂ */
						cmdline[cons.ch] = i - 256;
						cons_putchar(&cons, i - 256, 1);
					} else if (cons.cur_x <= 520) {
						if (cons.cur_y >= 320) {
							cons_newline(&cons);
						}  else {
							cons.cur_x = 8;
							cons.cur_y += 16;	
						}
					}
					cons.ch++;
				}
			}
			/* J[\ĕ\ */
			if (cons.sht != 0) {
				if (cons.cur_c >= 0) {
					boxfill8(cons.sht->buf, cons.sht->bxsize, cons.cur_c, 
						cons.cur_x, cons.cur_y, cons.cur_x + 7, cons.cur_y + 15);
				}
				sheet_refresh(cons.sht, cons.cur_x, cons.cur_y, cons.cur_x + 8, cons.cur_y + 16);
			}
		}
	}
}

void cons_putchar(struct CONSOLE *cons, int chr, char move)
{
	char s[2];
	s[0] = chr;
	s[1] = 0;
	
	if (s[0] == 0x09) {	/* ^u */
		for (;;) {
			if (cons->sht != 0) {
				putfonts8_asc_sht(cons->sht, cons->cur_x, cons->cur_y, COL8_FFFFFF, COL8_000000, " ", 1);
			}
			cons->cur_x += 8;
			if (cons->cur_x == 8 + /*240*/524) {
				cons_newline(cons);
			}
			if (((cons->cur_x - 8) & 0x1f) == 0) {
				break;	/* 32Ŋ؂ꂽbreak */
			}
		}
	} else if (s[0] == 0x0a || s[0] == '\n') {	/* s */
		cons_newline(cons);
	} else if (s[0] == 0x0d) {	/* A */
		/* Ƃ肠ȂɂȂ */
	} else {	/* ʂ̕ */
		if (cons->sht != 0) {
			putfonts8_asc_sht(cons->sht, cons->cur_x, cons->cur_y, COL8_FFFFFF, COL8_000000, s, 1);
		}
		if (move != 0) {
			/* move0̂Ƃ̓J[\i߂Ȃ */
			cons->cur_x += 8;
			if (cons->cur_x == 520 + 8/*8 + 240*/) {
				if (cons->cur_y >= 320) {
					cons_newline(cons);
				} else {
					cons->cur_x = 8;
					cons->cur_y += 16;					
				}
			}
		}
	}
	
	return;
}

void cons_newline(struct CONSOLE *cons)
{
	int x, y;
	struct SHEET *sheet = cons->sht;
	struct TASK *task = task_now();
	
	if (cons->cur_y < 28 + 320) {
		cons->cur_y += 16; /* ̍s */
	} else {
		/* XN[ */
		if (sheet != 0) {
			for (y = 28; y < 28 + 320; y++) {
				for (x = 8; x < 8 + 524; x++) {
					sheet->buf[x + y * sheet->bxsize] = sheet->buf[x + (y + 16) * sheet->bxsize];
				}
			}
			for (y = 28 + 320; y < 28 + 343; y++) {
				for (x = 8; x < 8 + 524; x++) {
					sheet->buf[x + y * sheet->bxsize] = COL8_000000;
				}
			}
			sheet_refresh(sheet, 8, 28, 8 + 524, 28 + 343);
		}
	}
	cons->cur_x = 8;
	if (task->langmode == 1 && task->langbyte1 != 0) {
		cons->cur_x = 16;
	}
	
	return;
}

void cons_putstr0(struct CONSOLE *cons, char *s)
{
	for (; *s != 0; s++) {
		cons_putchar(cons, *s, 1);
	}
	
	return;
}

void cons_putstr1(struct CONSOLE *cons, char *s, int l)
{
	int i;
	
	for (i = 0; i < l; i++) {
		cons_putchar(cons, s[i], 1);
	}
	
	return;
}

int *inthandler0c(int *esp)
{
	struct TASK *task = task_now();
	char s[256];

	sprintf(s, "It makes Stack exception!(INT 0x0C)\n[ EIP Address = %08X ]", esp[11]);
	show_mesbox("Error", s);
	send_kernellog("INT 0C : Stack exception");
	
	return &(task->tss.esp0);	/* ُI */
}

int *inthandler0d(int *esp)
{
	struct TASK *task = task_now();
	char s[256];
	
	sprintf(s, "It makes General Protected Exception!(INT 0x0D)\n[ EIP Address = %08X ]", esp[11]);
	show_mesbox("Error", s);
	send_kernellog("INT 0C : General protected exception");
	
	return &(task->tss.esp0);	/* ُI */
}

/* R}hs */
void cons_runcmd(char *cmdline, struct CONSOLE *cons, int *fat, int memtotal)
{
	int i;
	char name[256], *argw = 0;
	
	/* R}hCR}h𐶐 */
	for (;*cmdline == ' ';cmdline++);
	for (i = 0; i < 256; i++) {
		if (cmdline[i] <= ' ') {
			name[i] = 0;
			break;
		} else if (cmdline[i] == 0) {
			break;
		}
		name[i] = cmdline[i];
	}
	
	/*  */
	argw = (char *)(cmdline + i);
	for (;*argw == ' ';argw++);
	
	/* R}h */
	if (!strcmp(name, "mem") && cons->sht) cmd_mem(cons, memtotal);
	else if (!strcmp(name, "cls") && cons->sht) cmd_cls(cons);
	else if (!strcmp(name, "dir") && cons->sht) cmd_dir(cons, argw);
	else if (!strcmp(name, "exit") && cons->sht) cmd_exit(cons, fat);
	else if (!strcmp(name, "start") && cons->sht) cmd_start(cons, argw);
	else if (!strcmp(name, "ncst") && cons->sht) cmd_ncst(cons, argw);
	else if (!strcmp(name, "lmod") && cons->sht) cmd_lmod(cons, argw);
	else if (!strcmp(name, "reset") && cons->sht) cmd_reset(cons);
	else if (!strcmp(name, "tdev") && cons->sht) cmd_tdev(cons);
	else if (!strcmp(name, "ps") && cons->sht) cmd_ps(cons);
	else if (!strcmp(name, "klog") && cons->sht) cmd_klog(cons, argw);
	else if (!strcmp(name, "date") && cons->sht) cmd_date(cons);
	else if (!strcmp(name, "tser") && cons->sht) cmd_tser(cons, argw);
	else if (!strcmp(name, "kill") && cons->sht) cmd_kill(cons, argw);
	else if (!strcmp(name, "help") && cons->sht) cmd_help(cons);
	else if (!strcmp(name, "crfile") && cons->sht) cmd_crfile(cons, fat, argw);
	else if (!strcmp(name, "rmfile") && cons->sht) cmd_rmfile(cons, fat, argw);
	else if (!strcmp(name, "rnfile") && cons->sht) cmd_rnfile(cons, fat, argw);
	else if (!strcmp(name, "test") && cons->sht) cmd_test(cons, fat);
	else if (!strcmp(name, "ver") && cons->sht) cmd_ver(cons);
	else if (!strcmp(name, "bootd") && cons->sht) cmd_bootd(cons);
	else if (!strcmp(name, "trashes") && cons->sht) cmd_trashes(cons, argw);
	else if (cmdline[0]) {
		if (cmd_app(cons, fat, cmdline) == 0) { 
			/* R}hł͂ȂAAvłȂAɋsłȂ */
			cons_putstr0(cons, "It may be wrong command or not existing file.\n");
		}
	}
	if (cmdline[0]) {
		cons_newline(cons);
	}
	
	return;
}

