/* FDC֘A */
/* hrb-wikiadvanceQlɂ */

#include "bootpack.h"

struct TASK *fdctask;

/* FDC^XNN */
void run_fdc(void)
{
	int *fdc_fifo = (int *)memman_alloc_4k(128 * 4);
	
	fdctask = task_alloc();
	fdctask->tss.esp = memman_alloc_4k(64 * 1024) + 64 * 1024;
	fdctask->tss.eip = (int)&fdc_task;
	fdctask->tss.es = 1 * 8;
	fdctask->tss.cs = 2 * 8;
	fdctask->tss.ss = 1 * 8;
	fdctask->tss.ds = 1 * 8;
	fdctask->tss.fs = 1 * 8;
	fdctask->tss.gs = 1 * 8;
	task_run(fdctask, 2, 2, "fdc");
	fifo32_init(&fdctask->fifo, 128, fdc_fifo, fdctask);
	
	return;
}

/* FDC^XNI */
void stop_fdc(void)
{
	task_sleep(fdctask);
	memman_free_4k(fdctask->tss.esp, 64 * 1024);
	memman_free_4k((int)fdctask->fifo.buf, 128 * 4);
	fdctask->flags = 0;
	return;
}

void fdc_task(void)
{
	struct TASK *task = task_now();

	io_out8(0x00d6, 0xc0); /* }X^ch0JXP[h[h */
	io_out8(0x00c0, 0x00); /* X[uDMA */
	io_out8(0x000a, 0x06); /* }X^ch2DMA}XN */

	for (;;) {
		io_hlt();
	}
}

void fdc_comsend(int data)
{
	/* R}h𑗐M */
	return;
}

int fdc_statread(int size)
{
	/* UgXe[^XM */
	return 0;
}

void inthandler26(int *esp)
{
	io_in8(0x03f4); /* ǂ݁FIRQCPUCÂƂFDC֋Ă */
	io_out8(PIC0_OCW2, 0x66); /* IRQ-06I */

	/* fdcpfifoɉĂ */

	return;
}

