/// @file guishell.c
/// Negitoro OS GUI Shell ̃C.
/// ݂̓J[l[hœ삷邪, Iɂ̓[UAvP[VɂĂ.
/// @author Sero_S
/// @since 2010-10-(18-20)(r95)
/// @todo ȑÕR[hڐA(Ƃ͍Ďɋ߂).
/// @todo mۉ̃R[hΉ邩ǂ. ̓R[hSǂݒ̂ɋ߂ƂɂȂ, ʓ|Ȃ̂Ō񂵂Ƃ.

#include "bootpack.h"

// --------------------------------
//   fobOpc[.
// --------------------------------

#define DEBUG	///< `ƃfobOp}N ::DBG, ::ASSERT_ON_COMPILE LɂȂ.

/// @def DBG
/// }N ::DEBUG `ĂƂ, ̂ƂɌ蒼̈ꕶ(ł܂Ȃ)s.
/// o͊oĂȂ, ƒׂ肨炭 http://yomi.mobi/read.cgi/ex25/ex25_news4vip_1211348705 234o.
/// @par Example:
/// @code
/// DBG printf("Debug informations...");
/// @endcode
/// @code
/// DBG {
/// 	"For debug.";
/// } else {
/// 	"For non-debug.";
/// }
/// @endcode
#ifdef DEBUG
	#define DBG if (1)
#else
	#define DBG if (0)
#endif

/// @def ASSERT_ON_COMPILE(expr)
/// RpCɏ @a expr 邱Ƃ. 񐬗ȂRpCG[ɂȂ.
/// ̎, dl錾ɕނ̂, ֐E̐擪̐錾܂̓O[oXR[v̂ǂ炩Ŏg.
/// ::VAL_NAME ̎ɊւĂ http://chihiro718.jpn.org/JPN/etc/program/macro.html Q.
/// @param[in] expr . RpCɕ]̂Œ萔łȂ΂ȂȂ.
/// @attention `ɍsԍ(`ς݃}N __LINE__)gĂ̂ňs2ȏケ̃}NgĂ͂ȂȂ.
/// @par Example:
/// @code
/// ASSERT_ON_COMPILE(sizeof(int) >= 4);	// int ^4oCgȏłȂ΂ȂȂ.
/// @endcode
#ifdef DEBUG
	#define CONCAT(a, b) a ## b	///< ̈̌.
	#define VAL_NAME(a, b) CONCAT(a, b)	///< `ς݃}N __LINE__ ̓WJ邽߂̕⏕}N.
	#define ASSERT_ON_COMPILE(expr) enum { VAL_NAME(assert, __LINE__) = 1 / (expr) }
#else
	#define ASSERT_ON_COMPILE(expr)
#endif

// --------------------------------
//   Cu⊮.
// --------------------------------

#define EXTRA_SIZE	16	///< ::malloc mۗ̈̑傫L^邽ߗ]Ɋmۂ郁̑傫.

/// mۂ.
/// ::memman_alloc_4k ̂܂܎gȂ͉̂ɃTCYw肷ԂȂ.
/// @param[in] size mۃTCY.
/// @return mۂւ̃|C^܂ ::NULL (G[).
static void *malloc(unsigned int size) {
	unsigned int addr;
	if (size <= 0)
		return NULL;
	size += EXTRA_SIZE;
	addr = memman_alloc_4k(size);
	if (addr) {
		*(unsigned int *)addr = size;
		return (void *)(addr + EXTRA_SIZE);
	} else
		return NULL;
}

/// .
/// ::malloc Ŋmۂ̂̂ݑΉ.
/// @param[in,out] ptr 郁.
static void free(void *ptr) {
	unsigned int addr, size;
	if (!ptr)
		return;
	addr = (unsigned int)ptr - EXTRA_SIZE;
	size = *(unsigned int *)addr;
	if (size <= 0) {
		DBG {
			char s[64];
			sprintf(s, "Bad memory free: size <= 0 (ptr: %08x) in 'free'", ptr);
			send_kernellog(s);
		}
		return;
	}
	memman_free_4k(addr, size);
	*(unsigned int *)addr = 0;	// 2ȏ ::free ĂяoƂ̂߂̕ی.
}

/// ^XN.
/// @param[in,out] task  ::TASK.
/// @attention 𑱍słȂ̂, g̃^XNɑ΂ČĂяoĂ͂ȂȂ. K̃^XNĂяo.
static void task_free(struct TASK *task) {
	if (!task)
		return;
	task_sleep(task);
	task->flags = 0;
}

/// @fn void putfonts8_asc_sht(struct SHEET *sht, int x, int y, int c, int b, char *s, int l)
///  @a l ̕ @a s , F @a c wiF @a b ŃV[g @a sht ̍W(@a x, @a y)ɕ`悵, @a sht ̕`悵 ::sheet_refresh .
/// s̃^XNASCII[hłoCg1oCgڂ`ς݂Ȃ甼 refresh .
/// @param[in,out] sht `悷V[g.
/// @param[in] x `悷WxW.
/// @param[in] y `悷WyW.
/// @param[in] c F.
/// @param[in] b wiF.
/// @param[in] s .
/// @param[in] l `悷镶̒.
/// @sa draw_menu
/// @todo ̕ const ̂قǂ.
/// @todo ̃^XNLV[gւ̕`Ōꃂ[h̐HႢɂȂ邩Ȃ.
/// @todo Ɋ֘A, oCg1oCgڂʂ̏ꏊɕ`悳Ă܂Ăꍇ, \邩Ȃ.

// --------------------------------
//   GUI Shell C.
// --------------------------------

#define WINSIZE_W	480	///< EBhE̕.
#define WINSIZE_H	360	///< EBhE̍.

#define TITLE		"GUI Shell"	///< EBhẼ^Cg.

#define TASK_A_FIFO	(*(struct FIFO32 **)0x0fec)	///< task_a  ::FIFO32.
#define SHEET_CTRL	(*(struct SHTCTL **)0x0fe4)	///< ::SHTCTL. O͏dłȂ̂œK.

/// task_a  GUI Shell  TASK::fifo ɑ郁bZ[W.
enum {
	SYSMSG_TIMER		= 1,	///< ^C}.
	SYSMSG_SETFOCUS		= 2,	///< tH[JX𓾂.
	SYSMSG_KILLFOCUS	= 3,	///< tH[JX.
	SYSMSG_QUIT			= 4,	///< Iv.
	SYSMSG_CHAR_L		= 256,	///< (̉).
	SYSMSG_CHAR_H		= 512,	///< (̏).
};

/// GUI Shell ̓pbZ[W. MSG::message Ɋi[.
enum {
	MSG_SETFOCUS = 1,
	MSG_KILLFOCUS,
	MSG_QUIT,
	MSG_CHAR,
	MSG_TIMER,
	MSG_MOUSEMOVE,
	MSG_LBUTTONDOWN,
	MSG_LBUTTONUP,
	MSG_RBUTTONDOWN,
	MSG_RBUTTONUP,
	MSG_UNKNOWN = -1,
};

/// GUI Shell ̃EBhE.
struct GUISHELL {
	struct SHEET *sht;		///< EBhE ::SHEET.
	struct TIMER *timer;	///< gĂ ::TIMER.
	int mx,	///< }EXxW.
		my;	///< }EXyW.
	int cnt;				///< NĂ̎ԃJEg. TODO.
};

/// GUI Shell œ`BẽbZ[W.
struct MSG {
	int	message,	///< bZ[W.
		param;		///< p[^.
};

/// GUI Shell ɓ͂f[^ ::MSG ɕϊ.
/// TASK::fifo Ƀf[^͂܂ ::task_sleep , ͂f[^ ::MSG ɕϊĊi[. .
/// @param[out] pmsg ϊ ::MSG ̊i[.
/// @param[in,out] gs  GUI Shell  ::GUISHELL.
/// @retval -1  @c pmsg ܂ @c gs sł.
/// @retval 0 IbZ[WM.
/// @retval otherwise IbZ[WłȂbZ[WM.
/// @todo c̎.
static int get_message(struct MSG *pmsg, struct GUISHELL *gs) {
	struct TASK *task;
	int i;
	if (!pmsg || !gs)
		return -1;
	task = gs->sht->task;
	for (;;) {
		io_cli();
		if (fifo32_status(&task->fifo) != 0)
			break;
		task_sleep(task);
		io_sti();
	}
	i = fifo32_get(&task->fifo);
	io_sti();
	if (i == SYSMSG_TIMER)
		pmsg->message = MSG_TIMER;
	else if (i == SYSMSG_SETFOCUS)
		pmsg->message = MSG_SETFOCUS;
	else if (i == SYSMSG_KILLFOCUS)
		pmsg->message = MSG_KILLFOCUS;
	else if (i == SYSMSG_QUIT)
		return 0;
	else if (SYSMSG_CHAR_L <= i && i < SYSMSG_CHAR_H) {
		pmsg->message = MSG_CHAR;
		pmsg->param = i - SYSMSG_CHAR_L;
	} else {
		pmsg->message = MSG_UNKNOWN;
		pmsg->param = i;
		DBG {
			char s[48];
			sprintf(s, TITLE ": received unknown data(0x%x)", i);
			send_kernellog(s);
		}
	}
	return 1;
}

/// GUI Shell ̏In߂.
/// ^XNŎsłȂtask_aɈ˗.
/// @param[in,out] gs I GUI Shell  ::GUISHELL.
static void guishell_exit(struct GUISHELL *gs) {
	DBG send_kernellog(TITLE ": exit.");
	timer_cancel(gs->timer);
	io_cli();
	fifo32_put(TASK_A_FIFO, gs->sht - SHEET_CTRL->sheets0 + 3072);
	for (;;)
		task_sleep(task_now());
}

/// ̃bZ[W.
/// .
/// @param[in,out] gs bZ[W GUI Shell  ::GUISHELL.
/// @param[in] msg bZ[W.
/// @param[in] param bZ[W̃p[^.
/// @retval 0 bZ[W.
/// @retval otherwise bZ[W͏ĂȂ.
/// @todo c̎.
static int process_message(struct GUISHELL *gs, int msg, int param) {
	char s[12];

	switch (msg) {
	case MSG_TIMER:
		sprintf(s, "%d", gs->cnt);
		putfonts8_asc_sht(gs->sht, 32, 64, COL8_000000, COL8_FFFFFF, s, 6);
		++gs->cnt;
		timer_settime(gs->timer, 5);
		return 0;
	case MSG_SETFOCUS:
		putfonts8_asc_sht(gs->sht, 32, 80, COL8_000000, COL8_FFFFFF, "Focus set.", 13);
		break;
	case MSG_KILLFOCUS:
		putfonts8_asc_sht(gs->sht, 32, 80, COL8_000000, COL8_FFFFFF, "Focus killed.", 13);
		break;
	case MSG_CHAR:
		s[0] = param;
		sprintf(s + 1, ": 0x%02x", param);
		putfonts8_asc_sht(gs->sht, 32, 48, COL8_000000, COL8_FFFFFF, s, 7);
		if (param == 'q')
			fifo32_put(&gs->sht->task->fifo, SYSMSG_QUIT);
		return 0;
	}
	return -1;
}

/// bZ[WK؂ɔz.
/// .
/// @param[in,out] gs bZ[W GUI Shell  ::GUISHELL.
/// @param[in] pmsg z ::MSG.
/// @return bZ[W[`̖߂l.
/// @todo c̎.
static int dispatch_message(struct GUISHELL *gs, const struct MSG *pmsg) {
	return process_message(gs, pmsg->message, pmsg->param);
}

/// j[`悷. .
/// @param[in,out] sht `悷EBhE(::SHEET).
/// @param[in] x0 [xW.
/// @param[in] y0 [yW.
/// @param[in] x1 E[xW(̍Wɂ`悳).
/// @param[in] y1 [yW(̍Wɂ`悳).
/// @param[in] label j[̃x.
/// @param[in] len @a label ̒.
/// @todo c̎.
static void draw_menu(struct SHEET *sht, int x0, int y0, int x1, int y1, const char *label, int len) {
	putfonts8_asc_sht(sht, x0 + 7, y0 + 2, COL8_000000, COL8_C6C6C6, (char *)label, len);
/*	boxfill8(sht->buf, sht->bxsize, COL8_FFFFFF, x0+1, y0, x1-1, y0  );
	boxfill8(sht->buf, sht->bxsize, COL8_FFFFFF, x0  , y0, x0  , y1-1);
	boxfill8(sht->buf, sht->bxsize, COL8_848484, x0  , y1, x1-1, y1  );
	boxfill8(sht->buf, sht->bxsize, COL8_848484, x1  , y0, x1  , y1  );
*/	sheet_refresh(sht, x0, y0, x1+1, y1+1);
}

/// GUI Shell ^XÑC.
/// @param[in,out] sht  GUI Shell ̃EBhE(::SHEET).
/// @attention ̊֐ GUI Shell ^XÑCGgȂ̂łȊÕ^XNĂł͂ȂȂ.
static void guishell_main(struct SHEET *sht) {
	struct TASK * const task = task_now();
	struct GUISHELL gs;

	ASSERT_ON_COMPILE(sizeof(struct GUISHELL) <= 12);

	if (task != sht->task) {
		send_kernellog(TITLE ": bad task.");
		return;
	}

	gs.sht = sht;
	gs.mx = gs.my = -1;
	gs.cnt = 0;
	gs.timer = timer_alloc();
	timer_init(gs.timer, &task->fifo, SYSMSG_TIMER);
	timer_settime(gs.timer, 5);

	{int x0 = 3, y0 = 22, x1 = 3+7+8*7+7, y1 = 22+2+16+3;
	draw_menu(sht, x0, y0, x1, y1, "File(F)", 7);}
	draw_textbox8(sht, 3 + 3, 22+2+16+3+2 + 3, WINSIZE_W-((3+3)+6), WINSIZE_H-((22+2+16+3+2)+9), COL8_FFFFFF);
	sheet_refresh(sht, 3, 22+2+16+3+2, WINSIZE_W, WINSIZE_H);

	for (;;) {
		struct MSG msg;
		int ret = get_message(&msg, &gs);
		if (!ret || ret == -1)	// IbZ[WM܂͎Ms.
			break;
		dispatch_message(&gs, &msg);
	}

	guishell_exit(&gs);	// I.
	io_cli();			// ::guishell_exit ͋AĂȂ͂یƂ.
	for (;;)
		task_sleep(task_now());
}

/// GUI Shell ̃^XN𐶐.
/// @return  GUI Shell ̃EBhE(::SHEET)ւ̃|C^܂ ::NULL (G[).
struct SHEET *guishell_open(void) {
	struct TASK *task = task_alloc();
	void *stack = malloc(3072);
	int *fifo = malloc(sizeof(int)*64);
	struct SHEET *sht = sheet_alloc();
	UCHAR *buf = malloc(WINSIZE_W * WINSIZE_H);

	if (task && stack && fifo && sht && buf) {
		task->cons_stack = (int)stack;	// {͂܂Ǘp.
		task->tss.eip = (int)guishell_main;
		task->tss.esp = (int)stack + 3072 - 8;
		*(struct SHEET **)(task->tss.esp + 4) = sht;
		task->tss.es = task->tss.ss = task->tss.ds = task->tss.fs = task->tss.gs = 1 * 8;
		task->tss.cs = 2 * 8;
		fifo32_init(&task->fifo, 64, fifo, task);

		sheet_setbuf(sht, buf, WINSIZE_W, WINSIZE_H, -1);
		draw_window8(buf, WINSIZE_W, WINSIZE_H, TITLE, 0);
		set_taskbar(sht->id, TITLE);
		sht->flags |= 0x20;	// J[lEBhË.
		sht->ktype = KERNELWINDOW_GSHELL;
		sht->task = task;

		task_run(task, 2, 2, "guishell");
	} else {
		char s[64];
		const char *t;
		if (!task)
			t = "Task";
		else if (!sht)
			t = "Sheet";
		else
			t = "Memory";
		sprintf(s, "%s allocation failed. Starting GUI shell was canceled.", t);
		show_mesbox("Error", s);
		send_kernellog("Starting GUI shell was failed.");

		task_free(task);
		free(stack);
		free(fifo);
		if (sht)
			sheet_free(sht);
		free(buf);

		sht = NULL;
	}

	return sht;
}

/// GUI Shell ̃^XNj.
/// @param[in,out] sht j GUI Shell ̃EBhE(::SHEET)ւ̃|C^.
void guishell_close(struct SHEET *sht) {
	if (!sht)
		return;
	task_sleep(sht->task);	// ÔsleepĂjn߂.
	free((void *)sht->task->cons_stack);
	free(sht->task->fifo.buf);
	task_free(sht->task);
	free(sht->buf);
	sheet_free(sht);
	DBG send_kernellog(TITLE ": close finished.");
}
