/* O֘A */

#include "bootpack.h"

#define LOG_DATA_MAX 64

struct LOG_DATAS {
	char log[128];
	int var, flag;
};

struct LOG_DATAS logd_ker[LOG_DATA_MAX];	/* klog */
struct LOG_DATAS logd_dbg[LOG_DATA_MAX];	/* dlog */
struct LOG_DATAS logd_copy[LOG_DATA_MAX];
int current1, current2;

void init_log(void)
{
	int j;
	
	for (j = 0;j < LOG_DATA_MAX;j++) {		
		memset(logd_ker[j].log, 0, 128);
		logd_ker[j].var = 0;
		logd_ker[j].flag = 0;	
		memset(logd_dbg[j].log, 0, 128);
		logd_ker[j].var = 0;
		logd_ker[j].flag = 0;		
	}
	current1 = 0;
	current2 = 0;
	
	return;
}

void init_logcopy(void)
{
	int j;

	for (j = 0;j < LOG_DATA_MAX;j++) {
		memset(logd_copy[j].log, 0, 128);
		logd_copy[j].var = 0;
		logd_copy[j].flag = 0;
	}

	return;
}

void show_log(struct CONSOLE *cons, int id)
{
	int j;
	
	if (!id) {
		for (j = 0;j < LOG_DATA_MAX;j++) {
			if (logd_ker[j].flag) {
				cons_putstr0(cons, logd_ker[j].log);
			}
		}
	} else {
		for (j = 0;j < LOG_DATA_MAX;j++) {
			if (logd_dbg[j].flag) {
				cons_putstr0(cons, logd_dbg[j].log);
			}
		}	
	}
	
	return;
}

void send_kernellog(char *data)
{
	int j;
	unsigned char d[7];
	
	readdate_cmos(d);
	sprintf(logd_ker[current1].log, 
			"[%02x:%02x:%02x] %s\n",
			d[2], d[1], d[0], data);
	
	logd_ker[current1].flag = 1;
	if (current1 == LOG_DATA_MAX) {
		init_logcopy();
		for (j = 0;j < 32;j++) {
			logd_copy[j] = logd_ker[32 + j];
			logd_ker[j] = logd_copy[j];
		}
		current1 = 32;
	} else {
		current1++;
	}
	
	return;
}

void send_debuglog(char *data, int var)
{
	int j;
	unsigned char d[7];
	
	readdate_cmos(d);
	sprintf(logd_dbg[current2].log, 
			"[%02x:%02x:%02x] %s (var = %d)\n", 
			d[2], d[1], d[0], data, var);
	
	logd_dbg[current2].flag = 1;
	if (current2 == LOG_DATA_MAX) {
		init_logcopy();
		for (j = 0;j < 32;j++) {
			logd_copy[j] = logd_dbg[32 + j];
			logd_dbg[j] = logd_copy[j];
		}
		current2 = 32;
	} else {
		current2++;
	}
	
	return;
}
