/* EBhE֌W */

#include "bootpack.h"

void draw_window8(unsigned char *buf, int xsize, int ysize, char *title, char act)
{
	boxfill8(buf, xsize, COL8_C6C6C6, 0,         0,         xsize - 1, 0        );
	boxfill8(buf, xsize, COL8_FFFFFF, 1,         1,         xsize - 2, 1        );
	boxfill8(buf, xsize, COL8_C6C6C6, 0,         0,         0,         ysize - 1);
	boxfill8(buf, xsize, COL8_FFFFFF, 1,         1,         1,         ysize - 2);
	boxfill8(buf, xsize, COL8_848484, xsize - 2, 1,         xsize - 2, ysize - 2);
	boxfill8(buf, xsize, COL8_000000, xsize - 1, 0,         xsize - 1, ysize - 1);
	boxfill8(buf, xsize, COL8_C6C6C6, 2,         2,         xsize - 3, ysize - 3);
	boxfill8(buf, xsize, COL8_848484, 1,         ysize - 2, xsize - 2, ysize - 2);
	boxfill8(buf, xsize, COL8_000000, 0,         ysize - 1, xsize - 1, ysize - 1);
	draw_wtitle8(buf, xsize, title, act);
	return;
}

struct TASKBAR {
	char name[64];
	int length, id;
};

int taskbars, length_all;
struct TASKBAR tb[10];

/* ^XNo[̊֘Ȁ */
void init_taskbar(void)
{
	int j;
	
	taskbars = 0;
	length_all = 0;
	for (j = 0;j < 10;j++) {
		memset(tb[j].name, 0, 64);
		tb[j].length = 0;
		tb[j].id = 0;
	}
	
	return;
}

/* ^XNo[ɃZbg */
void set_taskbar(int id, char *name)
{
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	int length1, j, length2, len_s;
	
	/* name̕o[̒vZ */
	len_s = strlen(name);
	length1 = len_s * 8;
	length2 = (int)length1 / len_s;
	
	/* Aj[V */
	for (j = 1;j <= len_s;j++) {
		boxfill8(sht_back->buf, binfo->scrnx, COL8_000000, binfo->scrnx - (length2 * j + 20) - length_all, 
						binfo->scrny - 27, binfo->scrnx - 2 - length_all, binfo->scrny - 2);
		boxfill8(sht_back->buf, binfo->scrnx, COL8_FFFFFF, binfo->scrnx - (length2 * j + 20) + 1 - length_all, 
						binfo->scrny - 26, binfo->scrnx - 3 - length_all, binfo->scrny - 3);
		sheet_refresh(sht_back, binfo->scrnx - (length2 * j + 20) - length_all, 
						binfo->scrny - 27, binfo->scrnx - 2 - length_all, binfo->scrny - 2);
		kernel_sleep(1);
	}

	/*  */
	putfonts8_asc(sht_back->buf, binfo->scrnx, binfo->scrnx - (length1 + 20) + 10 - length_all, 
						binfo->scrny - 23, COL8_000000, name);
	sheet_refresh(sht_back, 0, binfo->scrny - 50, binfo->scrnx, binfo->scrny);
	
	/* ւ̏ */
	length_all += length2 * len_s + 20;
	tb[taskbars].length = length1 + 20;
	tb[taskbars].id = id;
	strcpy(tb[taskbars].name, name);
	taskbars++;
	
	return;
}

/* ^XNo[폜 */
void delete_taskbar(char *name)
{
	taskbars--;
	return;
}	

void draw_button(unsigned char *buf, int xsize)
{
	int x, y, c;
	
	static char stnbtn[14][16] = {
		"QQQQQQQQQQQQQQQQ",
		"QQQQQQQQQQQQQQ$Q",
		"QQQQQQQQQQQQQQ$Q",
		"QQQQQQQQQQQQQQ$Q",
		"QQQQQQQQQQQQQQ$Q",
		"QQQQQQQQQQQQQQ$Q",
		"QQQQQQQQQQQQQQ$Q",
		"QQQQQQQQQQQQQQ$Q",
		"QQQQQQQQQQQQQQ$Q",
		"QQQQQQQQQQQQQQ$Q",
		"QQQQQQQQQQQQQQ$Q",
		"QQQQQQQQQQQQQQ$Q",
		"Q$$$$$$$$$$$$$$Q",
		"QQQQQQQQQQQQQQQQ"
	};

	/* {^` */
	for (y = 0; y < 14; y++) {
		for (x = 0; x < 16; x++) {
			c = stnbtn[y][x];
			if (c == '@') {
				c = COL8_000000;
			} else if (c == '$') {
				c = COL8_848484;
			} else if (c == 'Q') {
				c = COL8_C6C6C6;
			} else {
				c = COL8_FFFFFF;
			}
			/* ŏ{^ */
			buf[(5 + y) * xsize + (5 + x)] = c;
			/* I{^ */
			buf[(5 + y) * xsize + (xsize - 21 + x)] = c;			
		}
	}
	
	return;
} 

void draw_wtitle8(unsigned char *buf, int xsize, char *title, char act)
{
	int len;
	char tc, tbc;
	
	if (act != 0) tc = COL8_000000;
	else tc = COL8_C6C6C6;
	
	tbc = rgb2pal(153, 255, 204, 0, 0);
	boxfill8(buf, xsize, tbc, 3, 3, xsize - 4, 20);		
	
	draw_button(buf, xsize);
	
	/* ^Cg̍WvZ */
	len = strlen(title) * 8 / 2;
	putfonts8_asc(buf, xsize, xsize / 2 - len, 4, tc, title);
	
	return;
}

void putfonts8_asc_sht(struct SHEET *sht, int x, int y, int c, int b, char *s, int l)
{
	struct TASK *task = task_now();
	boxfill8(sht->buf, sht->bxsize, b, x, y, x + l * 8 - 1, y + 15);
	if (task->langmode != 0 && task->langbyte1 != 0) {
		putfonts8_asc(sht->buf, sht->bxsize, x, y, c, s);
		sheet_refresh(sht, x - 8, y, x + l * 8, y + 16);
	} else {
		putfonts8_asc(sht->buf, sht->bxsize, x, y, c, s);
		sheet_refresh(sht, x, y, x + l * 8, y + 16);
	}
	return;
}

void draw_textbox8(struct SHEET *sht, int x0, int y0, int sx, int sy, int c)
{
	int x1 = x0 + sx, y1 = y0 + sy;
	boxfill8(sht->buf, sht->bxsize, COL8_848484, x0 - 2, y0 - 3, x1 + 1, y0 - 3);
	boxfill8(sht->buf, sht->bxsize, COL8_848484, x0 - 3, y0 - 3, x0 - 3, y1 + 1);
	boxfill8(sht->buf, sht->bxsize, COL8_FFFFFF, x0 - 3, y1 + 2, x1 + 1, y1 + 2);
	boxfill8(sht->buf, sht->bxsize, COL8_FFFFFF, x1 + 2, y0 - 3, x1 + 2, y1 + 2);
	boxfill8(sht->buf, sht->bxsize, COL8_000000, x0 - 1, y0 - 2, x1 + 0, y0 - 2);
	boxfill8(sht->buf, sht->bxsize, COL8_000000, x0 - 2, y0 - 2, x0 - 2, y1 + 0);
	boxfill8(sht->buf, sht->bxsize, COL8_C6C6C6, x0 - 2, y1 + 1, x1 + 0, y1 + 1);
	boxfill8(sht->buf, sht->bxsize, COL8_C6C6C6, x1 + 1, y0 - 2, x1 + 1, y1 + 1);
	boxfill8(sht->buf, sht->bxsize, c,           x0 - 1, y0 - 1, x1 + 0, y1 + 0);
	return;
}

void change_wtitle8(struct SHEET *sht, char act)
{
	int x, y, xsize = sht->bxsize;
	char c, tc_new, tbc_new, tc_old, tbc_old, *buf = sht->buf;
	
	if (act != 0) {
		tc_new  = COL8_000000;
		tbc_new = rgb2pal(153, 255, 204, 0, 0);
		tc_old  = COL8_C6C6C6;
		tbc_old = rgb2pal(153, 255, 204, 0, 0);
	} else {
		tc_new  = COL8_C6C6C6;
		tbc_new = rgb2pal(153, 255, 204, 0, 0);
		tc_old  = COL8_000000;
		tbc_old = rgb2pal(153, 255, 204, 0, 0);
	}
	for (y = 3; y <= 20; y++) {
		for (x = 3; x <= xsize - 4; x++) {
			c = buf[y * xsize + x];
			if (c == tc_old) c = tc_new;
			else if (c == tbc_old) c = tbc_new;
			buf[y * xsize + x] = c;
		}
	}

	draw_button(buf, xsize);
	
	sheet_refresh(sht, 3, 3, xsize, 21);
	
	return;
}

/* EBhE */
struct SHEET *make_window(char *wname, int ww, int wh, int act, int col_inv)
{
	struct SHEET *sht;
	unsigned char *buf;

	sht = sheet_alloc();
	buf = (unsigned char *)memman_alloc_4k(ww * wh);
	sheet_setbuf(sht, buf, ww, wh, col_inv);
	draw_window8(buf, ww, wh, wname, act);
	
	return sht;
}

/* EBhE */
void break_window(struct SHEET *sht)
{
	memman_free_4k((int)sht->buf, sht->bxsize * sht->bysize);
	sheet_free(sht);
	return;
}
