/* R}h֌W */

#include "bootpack.h"

/* bootinfo̕\ */
void cmd_bootd(struct CONSOLE *cons)
{
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	char s[128];
	
	logging(LOG_KERNEL, "com executed : bootd");
	
	/* bootinfo */
	sprintf(s, "Read Cyls: %d\nVideo Mode: %d\nDisp Width: %d\nDisp Height: %d\n",
	binfo->cyls, binfo->vmode, binfo->scrnx, binfo->scrny);
	cons_putstr0(cons, s);
	
	/* apm */
	sprintf(s, "APM Version: %d.%d\n", 
		(unsigned)*((int *)APM_VERSION) >> 8,
		(unsigned)*((int *)APM_VERSION) & 0xff);
	cons_putstr0(cons, s);
	
	/* vbe */
	sprintf(s, "VBE Version: %d.%d\n",
		(unsigned)*((int *)VBE_VERSION) >> 8,
		(unsigned)*((int *)VBE_VERSION) & 0xff);
	cons_putstr0(cons, s);
	
	return;
}

/* o[W */
void cmd_ver(struct CONSOLE *cons)
{
	logging(LOG_KERNEL, "com executed : ver");
	cons_putstr0(cons, (char *)VERSIONDATA_TAG);
	return;
}

/* 낢eXgp */
void cmd_test(struct CONSOLE *cons, int *fat)
{
	struct FILEINFO *finfo;
	char s[64];
	int j;
	
	/* t@Cďł݂eXg */
	file_createfile("test.txt", fat);
	finfo = file_search("test.txt", (struct FILEINFO *)(ADR_DISKIMG + 0x002600), 224);
	if (finfo) {
		sprintf(s, "clustno = %d\n", finfo->clustno);
		cons_putstr0(cons, s);
		
		/* 65 x 9 = 520 ( > 512) */
		/* 1NX^܂ŏ݂ł邩 */
		for (j = 0;j < 402;j++) {
			if (file_writefile(finfo, "Negitoro", 8)) {
				cons_putstr0(cons, "Writing error happened.\n");
				return;
			}
		}
		cons_putstr0(cons, "Writing is success.\n");	
	}
	
	return;
}



/* t@C쐬 */
void cmd_crfile(struct CONSOLE *cons, int *fat, char *cmdline)
{	
	logging(LOG_KERNEL, "com executed : crfile");
	
	if (!cmdline[0]) {
		cons_putstr0(cons, " usage: >crfile [filename]\n");
	} else {
		if (!file_createfile(cmdline, fat)) {
			cons_putstr0(cons, "Error happened.\n");
		}
	}
	
	return;
}

/* t@C폜 */
void cmd_rmfile(struct CONSOLE *cons, int *fat, char *cmdline)
{
	logging(LOG_KERNEL, "com executed : rmfile");
	
	if (!cmdline[0]) {
		cons_putstr0(cons, " usage: >rmfile [filename]\n");
	} else {
		if (!file_removefile(cmdline, fat)) ;
		else cons_putstr0(cons, "Such file is not found.\n");
	}
	
	return;
}

/* t@Cl[ */
void cmd_rnfile(struct CONSOLE *cons, int *fat, char *cmdline)
{
	logging(LOG_KERNEL, "com executed : rnfile");
	return;
}

/* LinuxłhistoryR}hɑ */
void cmd_hists(struct CONSOLE *cons, char *cmdline)
{
	logging(LOG_KERNEL, "com executed : hists");	
	return;
}

void cmd_help(struct CONSOLE *cons)
{
	char help_data[] = "mem cls dir exit start ncst lmod klog ver ps\n"
						"date kill help reset crfile rmfile bootd tser\n"
						"hists\n";

	logging(LOG_KERNEL, "com executed : help");
	cons_putstr0(cons, help_data);
	
	return;
}

/* J[l̃O\ */
/* ftHgstdO\ */
void cmd_klog(struct CONSOLE *cons, char *cmdline)
{
	logging(LOG_KERNEL, "com executed : klog");
	
	if (!cmdline[0]) {
		goto std_log;
	} else if (cmdline[0] == '?') {
		cons_putstr0(cons, " usage: >klog (opt)\n");
	} else if (!strcmp(cmdline, "dbg")) {
		cons_putstr0(cons, "<< Debug Log >>\n");
		show_log(cons, DATA_TO_DEBUG);
	} else if (!strcmp(cmdline, "std")) {
std_log:
		cons_putstr0(cons, "<< Kernel Log >>\n");
		show_log(cons, DATA_TO_KERNEL);		
	} else {
		cons_putstr0(cons, "option error.\n");
	}
	return;
}

/* ݂̓t\ */
void cmd_date(struct CONSOLE *cons)
{
	UCHAR date[7];
	char buf[64];
	
	logging(LOG_KERNEL, "com executed : date");
	readdate_cmos(date);
	sprintf(buf, "%02x%02x/%02x/%02x %02x:%02x:%02x\n", date[6],
			date[5], date[4], date[3], date[2], date[1], date[0]);
	cons_putstr0(cons, buf);
	
	return;
}

/* w肳ꂽvZXI */
/* ̓AvEȂ */
void cmd_kill(struct CONSOLE *cons, char *cmdline)
{
	unsigned long id;
	int i;
	char s[64];
	
	logging(LOG_KERNEL, "com executed : kill");	
	
	if (!cmdline[0]) {
		cons_putstr0(cons, " usage: >kill [taskID]\n");
	} else {
		id = atoi(cmdline);
		if (!id) {
			cons_putstr0(cons, "id number is unusual.\n");
		} else if (id > 32797) {
			cons_putstr0(cons, "id number is too large.\n");
		} else {
			/* taskctl̒IDTċI */
			for (i = 0; i < MAX_TASKS; i++) {
				if (taskctl->tasks0[i].flags) {
					if (taskctl->tasks0[i].id == id) {
						if (taskctl->tasks0[i].cons->sht) {
							/* IiR\[j */
							io_cli();
							fifo32_put(&taskctl->tasks0[i].fifo, 4);
							io_sti();
						} else {
							/* IiAvOŁj */
							io_cli();
							taskctl->tasks0[i].tss.eax = (int)&(taskctl->tasks0[i].tss.esp0);
							taskctl->tasks0[i].tss.eip = (int)asm_end_app;
							io_sti();
							task_run(&taskctl->tasks0[i], -1, 0, taskctl->tasks0[i].taskname);						
						}
						sprintf(s, "%s terminated (%d)\n",
							taskctl->tasks0[i].taskname, taskctl->tasks0[i].id);
						cons_putstr0(cons, s);				
						return;
					} 
				}
			}
			cons_putstr0(cons, "Such ID is not found.\n");
		}
	}
	
	return;
}

/* vZX\ */
void cmd_ps(struct CONSOLE *cons)
{
	int j, v;
	char buf[64];
	
	logging(LOG_KERNEL, "com executed : ps");
	cons_putstr0(cons, "<< Now runnings >>\n");
	for (j = 0;j < MAX_TASKS;j++) {
		if (taskctl->tasks0[j].flags > 0) {

			/* VXe֘AIDB */
			if (!strcmp(taskctl->tasks0[j].taskname, "system") ||
				!strcmp(taskctl->tasks0[j].taskname, "mpm") ||
				!strcmp(taskctl->tasks0[j].taskname, "idle") ||
				!strcmp(taskctl->tasks0[j].taskname, "clock") ||
				!strcmp(taskctl->tasks0[j].taskname, "fdc")) {
				v = 0;
			} else { 
				v = taskctl->tasks0[j].id;
			}

			sprintf(buf, "%s (%d, %d) %d\n",taskctl->tasks0[j].taskname, 
				taskctl->tasks0[j].level, taskctl->tasks0[j].priority, v);
			cons_putstr0(cons, buf);
		}
	}
	
	return;
}

/* eXgp */
void cmd_tdev(struct CONSOLE *cons)
{
	int j, r1, r2;
	char s[128];
	
	logging(LOG_KERNEL, "com executed : tdev");
	
	/* TEhfoCX֘A */
	cons_putstr0(cons, "SB16/Adlib install : ");
	if (detect_fmchip()) { 
		cons_putstr0(cons, "Yes\n");
		cons_putstr0(cons, "Sound testing..\n");
		test_adlib();
	} else {
		cons_putstr0(cons, "No\n");
	}

	/* p|[gTĂ݂ */
	cons_putstr0(cons, "\n");
	for (j = 0;j < 3;j++) {
		set_mode(j, CAN_RECV);
		r1 = is_ready(j);
		strobing(j, 0);
		set_mode(j, CAN_SEND);
		r2 = is_ready(j);
		strobing(j, 0);
		sprintf(s, "LPT%d : RECV=%s SEND=%s\n", 
			j + 1, (r1 ? "NO" : "YES"), (r2 ? "NO" : "YES"));
		cons_putstr0(cons, s);
	}
	
	return;
}

/* VA|[g̃XL(?) */
void cmd_tser(struct CONSOLE *cons, char *cmdline)
{
	int ret = 0, j = 0, port = 0, tp = 0;
	char str[128];
	
	/* VA|[ǧ^ */
	char *uart_name[5]={
		"None",
		"UART8250",
		"UART16450",
		"UART16550A",
		"UART16750"
	};
	
	logging(LOG_KERNEL, "com executed : tser");
	
	/* VA|[gT */
	if (!cmdline[0]) {
		for (j = 0;j < 4;j++) {
			sprintf(str, "COM%d : %s\n", j + 1, uart_name[detect_serialport(j)]);
			cons_putstr0(cons, str);
		}
	} else if (cmdline[0] == '?') {
		cons_putstr0(cons, " usage: >tser (port)\n");
	} else {
		/* ɏăf[^M */
		/* ܂Ă悤(qemuŊmFς) */
		port = atoi(cmdline);
		if (!port) {
			cons_putstr0(cons, "port number error.\n");
		} else {
			tp = port - 1; /* COM1->COM0, COM2->COM1, ...ƔFĂ邽 */
			sprintf(str, "- Serial Port Check (COM%d) -\n", port);
			cons_putstr0(cons, str);
			init_serialport(tp, 0x06);
			cons_putstr0(cons, "Initialized.\n");
			cons_putstr0(cons, "Sent a word \"Hello!\n");
			send_string_serialport(tp, "Hello");
			
			ret = receive_stat_serialport(tp);
			if (!(ret & 6)) cons_putstr0(cons, "The data was sent perfectly.\n");
			else cons_putstr0(cons, "Error happened.\n");
		}
	}

	return;
}

void cmd_reset(struct CONSOLE *cons)
{
	logging(LOG_KERNEL, "com executed : reset");
	cons_putstr0(cons, "\nNegitoro is being reseted...\n");
	kernel_sleep(200);
	
	/* ő̃^XNXgbv鏈Kv */
	
	wait_KBC_sendready();
	io_out8(PORT_KEYCMD, 0xfe);
	for (;;) io_hlt();
	return;
}

void cmd_mem(struct CONSOLE *cons, int memtotal)
{
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	char s[60];
	
	logging(LOG_KERNEL, "com executed : mem");
	sprintf(s, "total   %dMB\nfree %dKB\n", memtotal / (1024 * 1024), memman_total(memman) / 1024);
	cons_putstr0(cons, s);
	
	return;
}

void cmd_cls(struct CONSOLE *cons)
{
	int x, y;
	struct SHEET *sheet = cons->sht;
	
	logging(LOG_KERNEL, "com executed : cls");
	for (y = 28; y < 28 + 343; y++) {
		for (x = 8; x < 8 + 524; x++) {
			sheet->buf[x + y * sheet->bxsize] = COL8_000000;
		}
	}
	sheet_refresh(sheet, 8, 28, 8 + 524, 28 + 343);
	cons->cur_y = 28;
	
	return;
}

/* t@CT[`@\ */
/* ChJ[hȂĂ͎̂g܂ */
void cmd_dir(struct CONSOLE *cons, char *cmdline)
{
	struct FILEINFO *finfo = (struct FILEINFO *) (ADR_DISKIMG + 0x002600);
	int i, j;
	char s[30];
	
	logging(LOG_KERNEL, "com executed : dir");
	
	if (!cmdline[0]) {
		for (i = 0; i < 224; i++) {
			if (finfo[i].name[0] == 0x00) {
				break;
			}
			if (finfo[i].name[0] != 0xe5) {
				if ((finfo[i].type & 0x18) == 0) {
					sprintf(s, "filename.ext   %7d\n", finfo[i].size);
					for (j = 0; j < 8; j++) {
						s[j] = finfo[i].name[j];
					}
					s[ 9] = finfo[i].ext[0];
					s[10] = finfo[i].ext[1];
					s[11] = finfo[i].ext[2];
					cons_putstr0(cons, s);
				}
			}
		}
	} else if (cmdline[0] == '?') {
		cons_putstr0(cons, " usage: >dir (filename)\n");
	} else {
		finfo = file_search(cmdline, (struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224);
		if (finfo) {
			sprintf(s, "filename.ext   %7d\n", finfo->size);
			for (j = 0; j < 8; j++) {
				s[j] = finfo->name[j];
			}
			s[ 9] = finfo->ext[0];
			s[10] = finfo->ext[1];
			s[11] = finfo->ext[2];
			cons_putstr0(cons, "The file is found.\n\n");
			cons_putstr0(cons, s);			
		} else {
			cons_putstr0(cons, "Such file is not found.\n");
		}
	}
	
	return;
}

void cmd_exit(struct CONSOLE *cons, int *fat)
{
	struct TASK *task = task_now();
	struct SHTCTL *shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
	struct FIFO32 *fifo = (struct FIFO32 *) *((int *) 0x0fec);
	
	logging(LOG_KERNEL, "com executed : exit");
	if (cons->sht != 0) {
		timer_cancel(cons->timer);
	}
	memman_free_4k((int) fat, 4 * 2880);
	io_cli();
	if (cons->sht != 0) {
		fifo32_put(fifo, cons->sht - shtctl->sheets0 + 768);	/* 768`1023 */
	} else {
		fifo32_put(fifo, task - taskctl->tasks0 + 1024);	/* 1024`2023 */
	}
	io_sti();
	for (;;) {
		task_sleep(task);
	}
	
	return;
}

void cmd_start(struct CONSOLE *cons, char *cmdline)
{
	struct SHTCTL *shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
	struct SHEET *sht;
	struct FIFO32 *fifo;
	int i;
	
	logging(LOG_KERNEL, "com executed : start");
	
	if (!cmdline[0]) {
		cons_putstr0(cons, " usage: >start [filename]\n");
	} else {
		sht = open_console();
		fifo = &sht->task->fifo;
		sheet_slide(sht, 32, 4);
		sheet_updown(sht, shtctl->top);
		for (i = 0; cmdline[i] != 0; i++) {
			fifo32_put(fifo, cmdline[i] + 256);
		}
		fifo32_put(fifo, 10 + 256);
	}
	
	return;
}


void cmd_ncst(struct CONSOLE *cons, char *cmdline)
{
	struct TASK *task;
	struct FIFO32 *fifo;
	int i;
	
	logging(LOG_KERNEL, "com executed : ncst");
	
	if (!cmdline[0]) {
		cons_putstr0(cons, " usage: >ncst [filename]\n");
	} else {
		task = open_constask(0);
		fifo = &task->fifo;
		for (i = 0; cmdline[i] != 0; i++) {
			fifo32_put(fifo, cmdline[i] + 256);
		}
		fifo32_put(fifo, 10 + 256);
	}

	return;
}

void cmd_lmod(struct CONSOLE *cons, char *cmdline)
{
	struct TASK *task = task_now();
	UCHAR mode;
	
	logging(LOG_KERNEL, "com executed : lmod");
	
	if (!cmdline[0]) {
		cons_putstr0(cons, " usage: >lmod [langmode]\n");
	} else {
		mode = atoi(cmdline);
		if (mode <= 2) {
			task->langmode = mode;
			switch (task->langmode) {
				case 0: cons_putstr0(cons, "Set to English ASCII.\n"); break;
				case 1: cons_putstr0(cons, "Set to Japanese SHIFT JIS.\n"); break;
				case 2: cons_putstr0(cons, "Set to Japanee EUC.\n"); break;
			}
		} else {
			cons_putstr0(cons, "Mode number error.\n");
		}
	}
	
	return;
}

int cmd_app(struct CONSOLE *cons, int *fat, char *cmdline)
{
	struct FILEINFO *finfo;
	char name[18], *p, *q, buf[64];
	struct TASK *task = task_now();
	int i, segsiz, datsiz, esp, dathrb, appsiz;
	struct SHTCTL *shtctl;
	struct SHEET *sht;

	/* R}hCt@C𐶐 */
	for (i = 0; i < 13; i++) {
		if (cmdline[i] <= ' ') {
			break;
		}
		name[i] = cmdline[i];
	}
	name[i] = 0;

	
	/* t@CT */
	finfo = file_search(name, (struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224);
	if (finfo == 0 && name[i - 1] != '.') {
		/* Ȃ̂Ō".nxe"ĂxTĂ݂ */
		name[i    ] = '.';
		name[i + 1] = 'N';
		name[i + 2] = 'X';
		name[i + 3] = 'E';
		name[i + 4] = 0;
		finfo = file_search(name, (struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224);
	}

	if (finfo != 0) {
		/* t@Cꍇ */
		sprintf(buf, ".nxe file executed : %s", name);
		logging(LOG_KERNEL, buf);
		appsiz = finfo->size;
		p = file_loadfile2(finfo->clustno, &appsiz, fat);
		if (appsiz >= 36 && strncmp(p + 4, "Negi", 4) == 0 && *p == 0x00) {
			segsiz = *((int *) (p + 0x0000));
			esp    = *((int *) (p + 0x000c));
			datsiz = *((int *) (p + 0x0010));
			dathrb = *((int *) (p + 0x0014));
			q = (char *) memman_alloc_4k(segsiz);
			task->ds_base = (int) q;
			set_segmdesc(task->ldt + 0, appsiz - 1, (int) p, AR_CODE32_ER + 0x60);
			set_segmdesc(task->ldt + 1, segsiz - 1, (int) q, AR_DATA32_RW + 0x60);
			for (i = 0; i < datsiz; i++) {
				q[esp + i] = p[dathrb + i];
			}
			start_app(0x1b, 0 * 8 + 4, esp, 1 * 8 + 4, &(task->tss.esp0));
			shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
			for (i = 0; i < MAX_SHEETS; i++) {
				sht = &(shtctl->sheets0[i]);
				if ((sht->flags & 0x11) == 0x11 && sht->task == task) {
					/* AvJςȂɂ𔭌 */
					sheet_free(sht);	/*  */
				}
			}
			for (i = 0; i < 8; i++) {	/* N[YĂȂt@CN[Y */
				if (task->fhandle[i].buf != 0) {
					memman_free_4k((int) task->fhandle[i].buf, task->fhandle[i].size);
					task->fhandle[i].buf = 0;
				}
			}
			timer_cancelall(&task->fifo);
			memman_free_4k((int) q, segsiz);
			task->langbyte1 = 0;
		} else {
			cons_putstr0(cons, ".nxe file format error.\n");
		}
		memman_free_4k((int) p, appsiz);
		return 1;
	}
	/* t@CȂꍇ */
	return 0;
}


