/* FDC֘A */
/* hrb-wikiadvanceTbitOS̃\[XR[hQlɂ */

#include "bootpack.h"

#define FDC_MOTOR	0x03f2	/* [^̏ */
#define FDC_STAT	0x03f4	/* FDCԃWX^ */
#define FDC_DATA	0x03f5	/* FDC̃f[^ */

#define FDCFIFO_MTR 1 		/* [^[~ */
#define FDCFIFO_INT 2 		/* 荞 */
#define FDCFIFO_COM 3 		/* FDCR}h */
#define FDCFIFO_CNT 4 		/* FDCĊJ */

#define MAX_ERR 	5 		/* ő̍ĊJ */

#define MOTOR_ON	1		/* fdc_ctlmotorp */
#define MOTOR_OFF	0

#define WAIT		300		/* [^[̑҂ */

struct TASK *fdctask;
struct FIFO32 *fdcfifo;
struct TIMER *timer;
int motor, st0;

void fdc_initdma(void);
void fdc_waitmotor(void);
void fdc_ctlmotor(int sw);
void fdc_getstat(void);
void fdc_comsend(int data);
char fdc_statread(void);
void fdc_initwait(int wait);
void fdc_task(void);

/* FDC^XNN */
void run_fdc(void)
{
	int *fdc_fifo = (int *)memman_alloc_4k(128 * 4);
	
	fdctask = task_alloc();
	fdctask->tss.esp = memman_alloc_4k(64 * 1024) + 64 * 1024;
	fdctask->tss.eip = (int)&fdc_task;
	fdctask->tss.es = 1 * 8;
	fdctask->tss.cs = 2 * 8;
	fdctask->tss.ss = 1 * 8;
	fdctask->tss.ds = 1 * 8;
	fdctask->tss.fs = 1 * 8;
	fdctask->tss.gs = 1 * 8;
	task_run(fdctask, 2, 2, "fdc");
	fifo32_init(&fdctask->fifo, 128, fdc_fifo, fdctask);
	fdcfifo = &fdctask->fifo;
	
	debugmsg("Running FDC..");
	
	return;
}

/* FDC^XNI */
void stop_fdc(void)
{
	task_sleep(fdctask);
	memman_free_4k(fdctask->tss.esp, 64 * 1024);
	memman_free_4k((int)fdctask->fifo.buf, 128 * 4);
	fdctask->flags = 0;
	return;
}

/* FDC^XN{ */
void fdc_task(void)
{
	int sig;
	
	fdc_initdma();
	fdc_ctlmotor(0);
	
	timer = timer_alloc();
	timer_init(timer, fdcfifo, FDCFIFO_MTR);

	for (;;) {
		io_cli();
		if (fifo32_status(fdcfifo) == 0) {
			task_sleep(fdctask);
			io_sti();
		} else {
			sig = fifo32_get(fdcfifo);
			io_sti();
			if (sig == FDCFIFO_INT) {
				fdc_getstat();
				if ((st0 & 0xc0) == 0x00) {
					/* I */
					debugmsg("[FDC] normal terminated.");
					st0 = 0;
				} else if ((st0 & 0xc0) == 0x40) {
					/* ُI */
					debugmsg("[FDC] abnormal terminated.");
					st0 = 1;
				} else {
					/* ςȃXe[^X */
					debugmsg("[FDC] unusual status.");
					st0 = 2;
				}
				fifo32_put(fdcfifo, FDCFIFO_CNT);
			} else if (sig == FDCFIFO_MTR) { 
				if (motor) {
					fdc_ctlmotor(MOTOR_OFF);
				} else {
					/* --Ńwbh̒-- */
				}
			} else if (sig == FDCFIFO_COM) {
				if (!motor) {
					fdc_ctlmotor(MOTOR_ON);
					fdc_waitmotor();
				} else {
					timer_cancel(timer);
					/* --ŃR}hs-- */
				}
			} else if (sig == FDCFIFO_CNT) {
				io_out8(0x000a, 0x06);
				fdc_waitmotor();
			}
		}
	}
}

/* DMA */
void fdc_initdma(void)
{
	io_out8(0x00d6, 0xc0); /* }X^ch0JXP[h[h */
	io_out8(0x00c0, 0x00); /* X[uDMA */
	io_out8(0x000a, 0x06); /* }X^ch2DMA}XN */
	return;
}

/* [^[~̎cJEg */
void fdc_waitmotor(void)
{
	timer_settime(timer, WAIT);
	return;
}

/* [^[ */
void fdc_ctlmotor(int sw)
{
	if (sw) {
		io_out8(FDC_MOTOR, 0x1c); /* ON */
		motor = 1;
		debugmsg("[FDC] motor on.");
	} else {
		io_out8(FDC_MOTOR, 0x0c); /* OFF */
		motor = 0;
		debugmsg("[FDC] motor off.");
	}
	return;
}

/* ST0擾 */
void fdc_getstat(void)
{
	fdc_initwait(0x10);
	fdc_comsend(0x08);
	st0 = fdc_statread();
	return;
}

/* R}h𑗐M */
void fdc_comsend(int data)
{
	for (;;) {
		if ((io_in8(FDC_STAT) & 0xc0) == 0x80) {
			io_out8(FDC_DATA, data);
			return;
		}
	}	
}

/* Xe[^XM */
char fdc_statread(void)
{	
	for (;;) {
		if ((io_in8(FDC_STAT) & 0xc0) == 0xc0) {
			return (char)io_in8(FDC_DATA);
		}
	}
}

/* R}h҂̂H */
void fdc_initwait(int wait)
{
	for (;;) {
		if ((io_in8(FDC_STAT) & wait) == 0) {
			return;
		}
	}
}

void inthandler26(int *esp)
{
	io_in8(0x03f4); /* ǂ݁FIRQCPUCÂƂFDC֋Ă */
	io_out8(PIC0_OCW2, 0x66); /* IRQ-06I */
	fifo32_put(fdcfifo, 2);
	return;
}

