/* t@C֌W */

/* << R[h >> */
/* file_writefile by JsZ */

#include "bootpack.h"

/* fBXNC[WFAT̈kƂ */
void file_readfat(int *fat, unsigned char *img)
{
	int i, j = 0;
	for (i = 0; i < 2880; i += 2) {
		fat[i + 0] = (img[j + 0]      | img[j + 1] << 8) & 0xfff;
		fat[i + 1] = (img[j + 1] >> 4 | img[j + 2] << 4) & 0xfff;
		j += 3;
	}
	return;
}

/* TbitOS痬p */
/* dg݂͗ǂȂ */
void file_writefat(int no, int data)
{
	unsigned char *img = (unsigned char *)(ADR_DISKIMG + FAT_ADDR);
	int i = no / 2, j, k;

	/* C[WɃf[^ */
	fat[no] = data;

	if((no & 1) == 0) {	/* noȂÔ̂ƈꏏɍXV */
		j = fat[no - 1];
		k = fat[no];
	} else {	/* noȂ̂̂ƈꏏɍXV */
		j = fat[no];
		k = fat[no + 1];
	}

	/* }X^XV */
	img[i * 3] = (unsigned char) (j & 0x0ff);
	img[i * 3 + 1] = (unsigned char) ((k & 0x00f) << 4 | (j & 0xf00) >> 8);
	img[i * 3 + 2] = (unsigned char) ((k & 0xff0) >> 4);

	/* X[uXV */
	img[2880 + i * 3] = img[i * 3];
	img[2880 + i * 3 + 1] = img[i * 3 + 1];
	img[2880 + i * 3 + 2] = img[i * 3 + 1];
	
	return;
}

unsigned short file_getfat(int *fat)
{
	int i;
	for (i = 0; i < 2880; i++) {
		if (fat[i] == 0) {
			fat[i] = 0x1000;
			return i;
		}
	}
	return 0;
}

void file_setname(struct FILEINFO *finfo, char *name)
{
	int i, j;
	unsigned char s[12];
	
	for (i = 0; i < 11; i++) { s[i] = ' '; }
	i = 0;
	for (j = 0; name[j] != 0; j++) {
		if (i >= 11) { return; }
		if (name[j] == '.' && j <= 8) {
			i = 8;
		} else {
			s[i] = name[j];
			if ('a' <= s[i] && s[i] <= 'z') { s[i] -= 0x20; }
			i++;
		}
	}
	for (i = 0; i < 11; i++) { finfo->name[i] = s[i]; }
	
	return;
}

int file_removefile(char *filename, int *fat)
{
	struct FILEINFO *finfo = file_search(filename, (struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224);
	
	if (finfo != 0) {
		if ((finfo->type & 0x18) == 0) {
			io_cli();
			finfo->name[0] = 0xe5;	/* 폜 */
			file_writefat(finfo->clustno, 0x0000);
			io_sti();
		}
		return 0;
	}
	
	return 1;
}

struct FILEINFO *file_createfile(char *filename, int *fat)
{
	struct FILEINFO *finfo = (struct FILEINFO *) (ADR_DISKIMG + 0x002600);
	int i;
	
	/* t@C̖ꏊT */
	for (i = 0;i < 224;i++) {
		if (finfo[i].type == 0x00 || finfo[i].name[0] == 0xe5) {
			/* t@C쐬 */
			io_cli();
			file_setname(finfo + i, filename);
			finfo[i].size = 0;
			finfo[i].type = 0x20;
			finfo[i].clustno = file_getfat(fat);
			file_writefat(finfo[i].clustno, 0x0fff);
			io_sti();
			return finfo + i;
		}
	}
	
	return 0;	
}

/* t@C֏ށij */
int file_writefile(struct FILEINFO *finfo, char *buf, int size)
{
	int i, j = 0, l, ncno = 0, nsize;
	int clustno = finfo->clustno;
	char *img = (char *)(ADR_DISKIMG + 0x003e00);
	
	/* Ƃ肠̂Ƃ̓AbvGh     */
	
	for (;;) {
		/* 512oCgȏ̂ƂfatHȂ */
		/* ȉɂȂ甲 */
		nsize = finfo->size;
		if (size <= 512) {
			for (i = 0, j = 0;i < size;i++, j++) {
				if (nsize + i >= 512) {
					for (l = 0;nsize >= 512;nsize -= 512, l++) ;
					for (;l > 0;l--) {
						if (fat[clustno] >= 0x0ff8) {
							file_writefat(clustno, 0x0fff);
							ncno = file_getfat(fat);
							file_writefat(clustno, ncno);
						} 
						clustno = fat[clustno];
					}
/*					debugmsg("clustno = %08X, nsize = %d", clustno, nsize);
*/					j = 0;
				}
				img[clustno * 512 + j + nsize] = buf[i];
			}
			finfo->size += size;
			if (fat[clustno] == 0x1000) {
				file_writefat(clustno, 0x0fff);
			}
			break;
		}
		
		for (i = 0;i < 512;i++) {
			img[clustno * 512 + i + finfo->size] = buf[i];
		}
		size -= 512;
		buf += 512;	
		finfo->size += 512;
		clustno = fat[clustno];
	}
		
	return 0;
}

void file_loadfile(int clustno, int size, char *buf)
{
	int i;
	char *img = (char *)(ADR_DISKIMG + 0x003e00);
	
	for (;;) {
		if (size <= 512) {
			for (i = 0; i < size; i++) {
				buf[i] = img[clustno * 512 + i];
			}
			break;
		}
		for (i = 0; i < 512; i++) {
			buf[i] = img[clustno * 512 + i];
		}
		size -= 512;
		buf += 512;
		clustno = fat[clustno];
	}
	
	return;
}

/* t@CT */
struct FILEINFO *file_search(char *name, struct FILEINFO *finfo, int max)
{
	int i, j;
	char s[12];
	
	for (j = 0; j < 11; j++) {
		s[j] = ' ';
	}
	j = 0;
	for (i = 0; name[i] != 0; i++) {
		if (j >= 11) { return 0; /* Ȃ */ }
		if (name[i] == '.' && j <= 8) {
			j = 8;
		} else {
			s[j] = name[i];
			if ('a' <= s[j] && s[j] <= 'z') {
				/* ͑啶ɒ */
				s[j] -= 0x20;
			} 
			j++;
		}
	}
	for (i = 0; i < max; ) {
		if (finfo->name[0] == 0x00) {
			break;
		}
		if ((finfo[i].type & 0x18) == 0) {
			for (j = 0; j < 11; j++) {
				if (finfo[i].name[j] != s[j]) {
					goto next;
				}
			}
			return finfo + i; /* t@C */
		}
next:
		i++;
	}
	
	return 0; /* Ȃ */
}

char *file_loadfile2(int clustno, int *psize, int *fat)
{
	int size = *psize, size2;
	char *buf, *buf2;
	
	buf = (char *) memman_alloc_4k(size);
	file_loadfile(clustno, size, buf);
	
	if (size >= 17) {
		size2 = tek_getsize(buf);
		if (size2 > 0) {	/* tekkĂ */
			buf2 = (char *) memman_alloc_4k(size2);
			tek_decomp(buf, buf2, size2);
			memman_free_4k((int) buf, size);
			buf = buf2;
			*psize = size2;
		}
	}
	
	return buf;
}

/* tHgt@C̓ǂݍ */
void file_readfont(char *filename, UCHAR *fontbuf)
{
	struct FILEINFO *finfo;
	int size;
	extern char hankaku[4096];
	
	finfo = file_search(filename, (struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224);
	if (finfo) {
		size = finfo->size;
		fontbuf = file_loadfile2(finfo->clustno, &size, fat);
	} else {
		fontbuf = (UCHAR *) memman_alloc_4k(16 * 256 + 32 * 94 * 47);
		for (size = 0; size < 16 * 256; size++) {
			fontbuf[size] = hankaku[size]; /* tHgȂ̂ŔpRs[ */
		}
		for (size = 16 * 256; size < 16 * 256 + 32 * 94 * 47; size++) {
			fontbuf[size] = 0xff; /* tHgȂ̂őSp0xffŖߐs */
		}
	}
	
	*((int *) 0x0fe8) = (int)fontbuf;
	
	return;
}
