/* RTC֘A */

#include "bootpack.h"

/* CMOSf[^擾 */
int readdate_cmos(unsigned char *a)
{
	char ef;
	static unsigned char adr[7] = { 0x00, 0x02, 0x04, 0x07, 0x08, 0x09, 0x32 };
	static unsigned char max[7] = { 0x60, 0x59, 0x23, 0x31, 0x12, 0x99, 0x99 };
	int i;	
	
	/*  ** ڍ׏ **
		0x00 b
		0x02 
		0x04 
		0x07 
		0x08 
		0x09 N̉Q
		0x32 N̏Q
	*/

	/* xǂ݂܂ł̃[v */
	for (;;) {
		ef = 0;
		for (i = 0;i < 7;i++) {
			io_out8(0x70, adr[i]);
			a[i] = io_in8(0x71);
		}
		for (i = 0;i < 7;i++) {
			io_out8(0x70, adr[i]);
			if (a[i] != io_in8(0x71) || (a[i] & 0x0f) > 9 || a[i] > max[i]) {
				ef = 1;
			}
		}
		if (ef == 0) {
			return 0;
		}
	}
}

struct TASK *clktask;
struct TIMER *clktimer;

/* vN */
void run_clock(void)
{
	int *clockbuf = (int *)memman_alloc_4k(128 * 4);
	
	clktask = task_alloc();
	clktask->tss.esp = memman_alloc_4k(64 * 1024) + 64 * 1024;
	clktask->tss.eip = (int) &clock_task;
	clktask->tss.es = 1 * 8;
	clktask->tss.cs = 2 * 8;
	clktask->tss.ss = 1 * 8;
	clktask->tss.ds = 1 * 8;
	clktask->tss.fs = 1 * 8;
	clktask->tss.gs = 1 * 8;
	task_run(clktask, 2, 2, "clock");
	fifo32_init(&clktask->fifo, 128, clockbuf, clktask);
	
	debugmsg("Running clock..");
	clktimer = timer_alloc();
	
	return;
}

/* vI */
void stop_clock(void)
{
	timer_free(clktimer);
	task_sleep(clktask);
	memman_free_4k(clktask->tss.esp, 64 * 1024);
	memman_free_4k((int)clktask->fifo.buf, 128 * 4);
	clktask->flags = 0;
	return;
}

const int mark = 10;

/* v\XV */
void clock_refresh(void)
{
	fifo32_put(&clktask->fifo, mark);
	return;
}

/* v̖{ */
void clock_task(void)
{
	int sig, ffl;
	unsigned char date[7];
	char s[64];
	
	/* ꕪɍXV */
	timer_init(clktimer, &clktask->fifo, mark);
	timer_settime(clktimer, 6000);
	
	/* ŏ̋Nł͕\ */
	ffl = 0;
	if (!ffl) fifo32_put(&clktask->fifo, mark);
	
	for (;;) {
		io_cli();
		if (fifo32_status(&clktask->fifo) == 0) {
			task_sleep(clktask);
			io_sti();
		} else {
			sig = fifo32_get(&clktask->fifo);
			io_sti();
			if (sig == mark) {
				readdate_cmos(date);
				sprintf(s, "%02x:%02x", date[2], date[1]);
				boxfill8(sht_back->buf, sht_back->bxsize, COL8_FFFFFF, 
						sht_back->bxsize - 60, 2, sht_back->bxsize - 3, 21);
				putfonts8_asc(sht_back->buf, sht_back->bxsize, 
						sht_back->bxsize - 53, 4, COL8_000000, s);
				sheet_refresh(sht_back, sht_back->bxsize - 60, 2, sht_back->bxsize - 3, 21);
				if (!ffl) ffl = 1;
			}
		}
	}
}

