/*  
			ւۂAvP[V`[ Nokon0 4/5
*/
#include "bootpack.h"

struct SHEET *open_applaunch(struct SHTCTL *shtctl)
{
	int window_w = 150, window_h = 300;
	struct MEMMAN *memman = (struct MEMMAN *)MEMMAN_ADDR;
	struct SHEET *sht = sheet_alloc(shtctl);
	unsigned char *buf = (unsigned char *)memman_alloc_4k(memman, window_w * window_h);
	struct TASK *task = task_alloc();
	sheet_setbuf(sht, buf, window_w, window_h, -1);
	make_window8(buf, window_w, window_h, "Nokon0", 0);
	task->ds_base = memman_alloc_4k(memman, 64 * 1024);
	task->tss.esp = task->ds_base + 64 * 1024;
	task->tss.eip = (int)&applaunch_task;
	task->tss.es = 1 * 8;
	task->tss.cs = 2 * 8;
	task->tss.ss = 1 * 8;
	task->tss.ds = 1 * 8;
	task->tss.fs = 1 * 8;
	task->tss.gs = 1 * 8;
	task_run(task, 4, 2, "alaunch");	/* ̗Dx͋ɉĕύX */
	sht->flags |= SHEET_LAUNCH_FLAGS;	
	sht->task = task;	
	return sht;
}

void close_applaunch(struct TASK *task, struct SHEET *sht, unsigned long mem)
{
	struct MEMMAN *memman = (struct MEMMAN *)MEMMAN_ADDR;
	memman_free_4k(memman, task->ds_base, 64 * 1024);
	task_sleep(sht->task);
	sht->task->flags = 0;
	memman_free_4k(memman, (int)sht->buf, mem);
	sheet_free(sht);
	return;
}

void applaunch_task(void)
{
	for (;;) {
		io_hlt();
	}
	return;
}
