/* FIFOCu */

#include "bootpack.h"

#define FLAGS_OVERRUN		0x0001

void fifo32_init(struct FIFO32 *fifo, int size, int *buf, struct TASK *task)
/* FIFOobt@̏ */
{
	fifo->size = size;
	fifo->buf = buf;
	fifo->free = size; /*  */
	fifo->flags = 0;
	fifo->p = 0; /* ݈ʒu */
	fifo->q = 0; /* ǂݍ݈ʒu */
	fifo->task = task; /* f[^ƂɋN^XN */
	return;
}

int fifo32_put(struct FIFO32 *fifo, int data)
/* FIFOփf[^𑗂荞Œ~ */
{
	if (fifo->free == 0) {
		/* 󂫂ȂĂӂꂽ */
		fifo->flags |= FLAGS_OVERRUN;
		return -1;
	}
	fifo->buf[fifo->p] = data;
	fifo->p++;
	if (fifo->p == fifo->size) {
		fifo->p = 0;
	}
	fifo->free--;
	if (fifo->task != 0) {
		if (fifo->task->flags != 2) { /* ^XNQĂ */
			task_run(fifo->task, -1, 0, fifo->task->taskname); /* NĂ */
		}
	}
	return 0;
}

int fifo32_get(struct FIFO32 *fifo)
/* FIFOf[^ƂĂ */
{
	int data;
	if (fifo->free == fifo->size) {
		/* obt@ۂ̂Ƃ́AƂ肠-1Ԃ */
		return -1;
	}
	data = fifo->buf[fifo->q];
	fifo->q++;
	if (fifo->q == fifo->size) {
		fifo->q = 0;
	}
	fifo->free++;
	return data;
}

int fifo32_status(struct FIFO32 *fifo)
/* ǂ̂炢f[^܂Ă邩񍐂 */
{
	return fifo->size - fifo->free;
}
