/* bZ[W{bNX}l[W */

#include "bootpack.h"

struct TASK *mpmtask;
struct SHEET *mpmsht;

void run_mpm(void)
{	
	int *keyfifo = (int *)memman_alloc_4k(128 * 4);

	mpmtask = task_alloc();
	mpmtask->tss.esp = memman_alloc_4k(64 * 1024) + 64 * 1024;
	mpmtask->tss.eip = (int)&task_mpm;
	mpmtask->tss.es = 1 * 8;
	mpmtask->tss.cs = 2 * 8;
	mpmtask->tss.ss = 1 * 8;
	mpmtask->tss.ds = 1 * 8;
	mpmtask->tss.fs = 1 * 8;
	mpmtask->tss.gs = 1 * 8;
	task_run(mpmtask, 2, 2, "mpm");
	fifo32_init(&mpmtask->fifo, 128, keyfifo, mpmtask);

	return;
}

void stop_mpm(void)
{
	task_sleep(mpmtask);
	memman_free_4k(mpmtask->tss.esp, 64 * 1024);
	memman_free_4k((int)mpmtask->fifo.buf, 128 * 4);
	mpmtask->flags = 0;
	return;
}

void task_mpm(void)
{
	struct TASK *task = task_now();
	int i;
	
	for (;;) {
		io_cli();
		if (fifo32_status(&task->fifo) == 0) {
			task_sleep(task);
			io_sti();
		} else {
			i = fifo32_get(&task->fifo);
			io_sti();
			if (i == 4) {	/* EBhEj */
				close_mesbox();
			}
			if (256 <= i && i <= 511) { /* L[{[hf[^i^XNAoRj */
				io_cli();
				fifo32_put(&task->fifo, 4);
				io_sti();
			}			
		}
	}
}

void close_mesbox(void)
{	
	memman_free_4k((int)mpmsht->buf, mpmsht->bxsize * mpmsht->bysize);
	sheet_free(mpmsht);
	return;
}

void show_mesbox(char *caption, char *message)
{
	const int base_wy = 30;
	int posx, posy, wx, wy = base_wy, sposx, sposy, i, j;
	char *p;
	UCHAR *buf;
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	struct SHTCTL *shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
	
	mpmsht = sheet_alloc();
	mpmsht->task = mpmtask;
	mpmsht->flags |= 0x20;
	mpmsht->ktype = KERNELWINDOW_MPM;
	
	/* _CAȎ傫vZ */
	if (strlen(message) > strlen(caption)) {
		wx = strlen(message) * 8 + 20;
		sposx = 10;
	} else {
		wx = strlen(caption) * 8 + 70;
		sposx = wx / 2 - (strlen(message) * 8 / 2);
	}

	/* sJEg */
	for (p = message, i = 0;*p != 0;p++) {
		if (*p == '\n') i++;
	}
	wy += i * 40;
	
	buf = (UCHAR *)memman_alloc_4k(wx * wy);
	sheet_setbuf(mpmsht, buf, wx, wy, -1);
	draw_window8(buf, wx, wy, caption, 0);
	
	/* ` */
	
	/* ʒɕ\ */
	posx = (binfo->scrnx - wx) / 2;
	posy = (binfo->scrny - wy) / 2;
	sheet_slide(mpmsht, posx, posy);
	sheet_updown(mpmsht, shtctl->top);
	
	return;
}

