/* C[Wr[[ gview.h */

#define OUT_OF_MEMORY	1
#define FILE_TOO_LARGE	2
#define FILE_NOT_FOUND	3
#define CANT_DECODE		4

#define DATA_NOT_FOUND	5
#define ERR_POSITION	6
#define ERR_SIZE		7
#define ERR_NOT_FIT		8

struct DLL_STRPICENV {
	int work[64 * 1024 / 4];
};

struct RGB {
	unsigned char b, g, r, t;
};

struct IMAGE {
	struct RGB *data;
	int type, color, width, height;
};

/* bmp.nasm */
int info_BMP(struct DLL_STRPICENV *env, int *info, int size, char *fp);
int decode0_BMP(struct DLL_STRPICENV *env, int size, char *fp, int b_type, char *buf, int skip);

/* jpeg.c */
int info_JPEG(struct DLL_STRPICENV *env, int *info, int size, char *fp);
int decode0_JPEG(struct DLL_STRPICENV *env, int size, char *fp, int b_type, char *buf, int skip);

/* image.c */
unsigned char rgb2pal(int r, int g, int b, int x, int y);
int imageLoad(struct IMAGE *img, char *fname, int maxy, int maxx);
void imageTerm(struct IMAGE *img);
int imageDraw(unsigned char *buf, int x, int y, int w, int h, struct IMAGE *img, int ww, int wh);
