/* 摜֐Q */

/* SerõVF(negiEx01)ŎgĂ֐𗬗p by JsZ */

#include "apilib.h"
#include "gview.h"

/* ****** infon֐Ɋւ ****** */
/* ǂ炩info֐ƁAȉ̏infoɓĂ */
/*	info[0] : t@C^Cv (1:BMP, 2:JPEG) */
/*	info[1] : J[ */
/*	info[2] : xsize */
/*	info[3] : ysize */

/* ****** decoden֐Ɋւ ****** */
/* b_type = 4 ́A struct RGB `Ӗ */
/* skip0ɂĂ΂悢 */

/* --- w肳ꂽRGB璆ԐF𐶐 --- */
unsigned char rgb2pal(int r, int g, int b, int x, int y)
{
	static int table[4] = { 3, 1, 0, 2 };
	int i;
	
	x &= 1;
	y &= 1;
	i = table[x + y * 2];
	r = (r * 21) / 256;
	g = (g * 21) / 256;
	b = (b * 21) / 256;
	r = (r + i) / 4;
	g = (g + i) / 4;
	b = (b + i) / 4;
	
	return 16 + r + g * 6 + b * 36;
}

/* --- t@CC[W[h --- */
/* return 0:  ȊO͉炩̃G[ */
int imageLoad(struct IMAGE *img, char *fname, int maxy, int maxx) 
{
	int fh;
	struct DLL_STRPICENV env;
	unsigned char *filebuf = 0;
	int info[8], size = 0, ret = 0;
	
	fh = api_fopen(fname);
	if (fh == 0) {
		ret = FILE_NOT_FOUND;
		goto imgload_end;
	}
	
	filebuf = api_malloc(maxy * maxx);
	if (!filebuf) {
		ret = OUT_OF_MEMORY;
		goto imgload_end;
	}
	
	size = api_fsize(fh, 0);
	if (size > maxy * maxx) {
		ret = FILE_TOO_LARGE;
		goto imgload_end;
	}
	api_fread(filebuf, size, fh);

	if (info_BMP(&env, info, size, filebuf) == 0) {
		if (info_JPEG(&env, info, size, filebuf) == 0) {
			ret = CANT_DECODE;
			goto imgload_end;
		}
	}		
	
	img->width = info[2];
	img->height = info[3];
	if (info[2] > maxx || info[3] > maxy) {
		ret = FILE_TOO_LARGE;
		goto imgload_end;
	}
	
	img->type = info[0];
	img->color = info[1];
	img->data = (struct RGB *)api_malloc(sizeof(struct RGB) * img->width * img->height);
	if (!img->data) {
		ret = OUT_OF_MEMORY;
		goto imgload_end;
	}
	
	if (img->type == 2) {
		ret = decode0_JPEG(&env, size, filebuf, 4, (char *)img->data, 0);
	} else if (img->type == 1) {
		ret = decode0_BMP(&env, size, filebuf, 4, (char *)img->data, 0);
	}
	
	imgload_end: 
	{
		if (fh) api_fclose(fh);
		if (filebuf) api_free(filebuf, size);
		if (!ret) {
			return 0;
		} else {
			img->data = 0;
			img->type = 0;
			return ret;
		}
	}
}

/* --- [hꂽC[W폜 --- */
void imageTerm(struct IMAGE *img) 
{
	api_free((char *)img->data, sizeof(struct RGB) * img->width * img->height);
	img->data = 0;
	return;
}

/* --- w肳ꂽTCYŃC[W` --- */
/* return 1: G[ 0:  */
int imageDraw(unsigned char *buf, int x, int y, int w, int h, struct IMAGE *img, int ww, int wh) 
{
	int i, j;
	unsigned char *p;
	struct RGB *q;
	
	if (!buf || !img->data) return DATA_NOT_FOUND;
	else if (x < 0 || y < 0) return ERR_POSITION;
	else if (w < 0 || h < 0) return ERR_SIZE;
	else if (ww <= w || wh <= h || ww <= x || wh <= y) return ERR_NOT_FIT;
	
	for (i = 0; i < h; ++i) {
		p = buf + ww * (y + i);
		for (j = 0; j < w; ++j) {
			q = img->data + img->width * (i * img->height / h) + (j * img->width / w);
			p[x + j] = rgb2pal(q->r, q->g, q->b, j, i);
		}
	}
	
	return 0;
}
