/*----------------------------------*/
/*------------ o[V ------------*/
/*----------------------------------*/
/* Created by JsZ 2010 */

#include <apilib.h>
#include <stdio.h>
#include <string.h>


#define CPU_PIECE 1
#define PLAYER_PIECE 2
#define NOTHING 0

#define WIN_WIDTH 266
#define WIN_HEIGHT 311
#define MAXPOS_X 8
#define MAXPOS_Y 8

#define OUT_OF_BOARD 99  /* ՊÔƂ */
#define FAIL_PUTTING 100 /* uȂꏊɂƂ */

/* bZ[WIȂ */
#define WELCOME_MSG "WELCOME TO REVERSI WORLD!"


int force_pos[8][8];	/* |WVf[^ */
int player_val;			/* vC[̐΂̐ */
int cpu_val; 			/* CPU̐΂̐ */

/*--------------------------------------------*/
/*---------- Տ̃Obh` ------------*/
/*--------------------------------------------*/
void draw_grid(int win)
{
	int y, x;

	api_boxfilwin(win, 5, 25, WIN_WIDTH - 5, WIN_HEIGHT - 30, 0);
	
	for (x = 0;x < MAXPOS_X;x++) {
		for (y = 0;y < MAXPOS_Y;y++) {
			api_boxfilwin(win, 6 + (30 + 2) * x, 26 + (30 + 2) * y, 
					6 + 30 + (2 + 30) * x, 26 + 30 + (2 + 30) * y, 2);				
		}
	}

	return;
}
/*-----------------------------------------------------*/
/*------------- bZ[W{bNX` --------------*/
/*-----------------------------------------------------*/
void draw_msgbox(int win)
{
	api_boxfilwin(win, 5, WIN_HEIGHT - 27, WIN_WIDTH - 5, WIN_HEIGHT - 5, 7);
	return;
}

/*--------------------------------------------------------------*/
/*-------------- bZ[W{bNXɕ` ----------------*/
/*--------------------------------------------------------------*/
void put_msgbox(int win, char *msg)
{
	api_boxfilwin(win, 5, WIN_HEIGHT - 27, WIN_WIDTH - 5, WIN_HEIGHT - 5, 7);
	api_putstrwin(win, 6, WIN_HEIGHT - 24, 0, 32, msg);
	return;
}

/* Õ}EX|WVۑp */
static int old_xpos, old_ypos;

/*----------------------------------------------------------------*/
/*----------------- }EX̂鏊GtFNg -------------------*/
/*----------------------------------------------------------------*/
void effect_grid(int win, int *posx, int *posy) 
{
	struct MINFO *m;
	int y, x;

	api_getmouse(win, m);
	if (m->x > 5 && m->x < WIN_WIDTH - 5 && m->y > 25 && m->y < WIN_HEIGHT - 30) {
		for (x = 0;x < MAXPOS_X;x++) {
			for (y = 0;y < MAXPOS_Y;y++) {
				if (m->y >= 26 + (30 + 2) * y && m->y <= 26 + 30 + (2 + 30) * y &&
						m->x >= 6 + (30 + 2) * x && m->x <= 6 + 30 + (2 + 30) * x) {
					
					/* OɃ|C^ꂽ͌ɖ߂ */
					if (old_xpos != OUT_OF_BOARD && old_ypos != OUT_OF_BOARD &&
										force_pos[old_xpos][old_ypos] == NOTHING) {
						api_boxfilwin(win, 6 + (30 + 2) * old_xpos, 26 + (30 + 2) * old_ypos, 
								6 + 30 + (2 + 30) * old_xpos, 26 + 30 + (2 + 30) * old_ypos, 2);						
					}
					
					/* Տf[^mF */
					/* Ȃɂu */
					if (force_pos[x][y] == NOTHING) {

						/* }EXƂGtFNg */
						api_boxfilwin(win, 6 + (30 + 2) * x, 26 + (30 + 2) * y, 
								6 + 30 + (2 + 30) * x, 26 + 30 + (2 + 30) * y, 0);
						old_xpos = x;
						old_ypos = y;

						/* f[^n */
						*posx = x;
						*posy = y;
		
					} else {
						
						/* u܂Ƃf[^n */
						*posx = *posy = FAIL_PUTTING;
						
						/* ͂Ƃ肠ՊO */
						old_xpos = old_ypos = OUT_OF_BOARD;
						
					}

				}
			}
		}
	} else {
		
		/* ՊOɏoƂ̏ */
		api_boxfilwin(win, 6 + (30 + 2) * old_xpos, 26 + (30 + 2) * old_ypos, 
				6 + 30 + (2 + 30) * old_xpos, 26 + 30 + (2 + 30) * old_ypos, 2);
		old_xpos = old_ypos = OUT_OF_BOARD;

		/* ʊOf[^n */
		*posx = *posy = OUT_OF_BOARD;

	}

	return;
}

/*--------------------------------------*/
/*-------------- ΂u --------------*/
/*--------------------------------------*/
void put_stone(int win, int posx, int posy, int type) 
{
	/* ՊO */
	if (posx > MAXPOS_X || posy > MAXPOS_Y) return;	

	/* Տf[^XV */
	force_pos[posx][posy] = type;
	
	/* ΂` */
	api_boxfilwin(win, 6 + (30 + 2) * posx, 26 + (30 + 2) * posy, 
			6 + 30 + (2 + 30) * posx, 26 + 30 + (2 + 30) * posy, 2);
	if (type == PLAYER_PIECE) {
		api_boxfilwin(win, 6 + (30 + 2) * posx + 3, 26 + (30 + 2) * posy + 3, 
				6 + 30 + (2 + 30) * posx - 3, 26 + 30 + (2 + 30) * posy - 3, 0);
		player_val++;
	} else if (type == CPU_PIECE) {
		api_boxfilwin(win, 6 + (30 + 2) * posx + 3, 26 + (30 + 2) * posy + 3, 
				6 + 30 + (2 + 30) * posx - 3, 26 + 30 + (2 + 30) * posy - 3, 7);
		cpu_val++;
	}	

	return;
}

/*------------------------------------------------*/
/*------------ ̃Xe[^X\ --------------*/
/*------------------------------------------------*/
void put_stat(int win)
{
	char str[64];

	sprintf(str, "You : %d / CPU : %d", player_val, cpu_val);
	put_msgbox(win, str);

	return;
}

/*--------------------------------------------*/
/*---------------- CPU̎vl -----------------*/
/*--------------------------------------------*/
void thinking_cpu(int *posx, int *posy)
{
	
	/* 낢l */

	*posx = *posy = OUT_OF_BOARD;
	
	return;
}

/*----------------------------------------*/
/*--------- Տf[^̏ -----------*/
/*----------------------------------------*/
void init_board(int win)
{
	int x, y;

	/* SĖzuɂ */
	for (x = 0;x < MAXPOS_X;x++) {
		for (y = 0;y < MAXPOS_Y;y++) {
			force_pos[x][y] = NOTHING;
		}
	}
	player_val = cpu_val = 0;

	/* ŏ̂ */
	/* Ƃ肠vC[U */
	put_stone(win, 3, 3, CPU_PIECE);
	put_stone(win, 4, 4, CPU_PIECE);
	put_stone(win, 4, 3, PLAYER_PIECE);
	put_stone(win, 3, 4, PLAYER_PIECE); 

	return;
}

/*-----------------------------------------------------*/
/*--------------------- NegiMain ----------------------*/
/*-----------------------------------------------------*/
void NegiMain(void)
{
	struct MINFO *mf;
	char wbuf[WIN_WIDTH * WIN_HEIGHT];
	char str[64];
	int win;
	int posx, posy, cpux, cpuy;
	int oldposx1, oldposy1;
	int flag = 0, battle = 0;
	int key = -1;
	int nowturn = 1; /* 1 = vC[ / 2 = CPU */

	win = api_openwin(wbuf, WIN_WIDTH, WIN_HEIGHT, -1, "Reversi");

	/* Obh`ʁbZ{bNX` */
	draw_grid(win);
	draw_msgbox(win);

	/* Տ̏ */
	init_board(win);

	/* ϐ */
	old_xpos = old_ypos = OUT_OF_BOARD;
	oldposx1 = oldposy1 = OUT_OF_BOARD;
	posx = posy = OUT_OF_BOARD;

	put_msgbox(win, WELCOME_MSG);

	for (;;) {

		/* L[͏ */
		key = api_getkey(0);

		if (key == 'q') { /* (quit)Q[I */
			api_end();
		} else if (key == 'p') { /* (position)|WV\ */
			if (!flag) {
				flag = 1;
			} else {
				flag = 0;
				if (battle) put_stat(win); 
				else draw_msgbox(win); /* S */
			} 
		} else if (key == 's') { /* (start)Q[Jn */
			if (!battle) {
				put_msgbox(win, "Game has just started!");
				battle = 1;
				nowturn = 1;
			} else {
				put_msgbox(win, "You are in the middle of Game.");
			}
		} else if (key == 'b') { /* (break)Q[~ */
			if (battle) {
				put_msgbox(win, "Break in the Game!");			
				battle = 0;

				/* Sď */
				draw_grid(win);	
				init_board(win);							
				old_xpos = old_ypos = OUT_OF_BOARD;

			} else {
				put_msgbox(win, "Game has not started yet.");
			}
		} else if (key == 'h') {
			api_msgbox("Help", 
				"q : Quit game\ns : Start game\nb : Break game");
		}
		
		/* GtFNg */
		effect_grid(win, &posx, &posy);
		
		/* ogn܂Ă */
		if (battle) {
			if (nowturn == 1) {
				api_getmouse(win, mf);
				if (mf->state == 2) {

					/* ΂u */
					put_stone(win, posx, posy, PLAYER_PIECE);
					if (!flag) put_stat(win);					

					/* CPŨ^[ */
					nowturn = 2;

				}
			} else {
				
				/* CPȔ */
				thinking_cpu(&cpux, &cpuy);
				put_stone(win, cpux, cpuy, CPU_PIECE);				

				/* [U[̃^[ */				
				nowturn = 1;

			}
		}
		
		/* |WV\ */
		if (flag) {
			if (oldposx1 != posx || oldposy1 != posy) {
				sprintf(str, "posx=%d, posy=%d", posx, posy);
				put_msgbox(win, str);
				oldposx1 = posx;
				oldposy1 = posy;
			}
		}
		
		/* x܂ */
		api_sleep(5);
	}
}
