/// @file api.c
/// @brief API֘A.
///
/// APȈs
/// @author JsZ(is2os)
/// @since 2010-08-23(r41)

#include "bootpack.h"

/// @brief EDX̔ԍɉAPI
/// @return 0ȊO͕ԂȂ
/// @bug VA֘AAPI܂@\ĂȂlq by Jsz
int *hrb_api(int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax)
{
	struct TASK *task = task_now();
	int ds_base = task->ds_base;
	struct CONSOLE *cons = task->cons;
	struct SHTCTL *shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
	struct SHEET *sht;
	struct FIFO32 *sys_fifo = (struct FIFO32 *) *((int *) 0x0fec);
	int *reg = &eax + 1;	/* eax̎̔Ԓn */
		/* ۑ̂߂PUSHADɏ */
		/* reg[0] : EDI,   reg[1] : ESI,   reg[2] : EBP,   reg[3] : ESP */
		/* reg[4] : EBX,   reg[5] : EDX,   reg[6] : ECX,   reg[7] : EAX */
	int i;
	struct FILEINFO *finfo;
	struct FILEHANDLE *fh;
	char *p;
	struct TASK *task_cons;
	struct FIFO32 *fifo;
	struct MINFO *mif;
	int tx = 0, ty = 0;
	struct DATE *dt;
	unsigned char date[7];
	
	if (edx == 1) {
		cons_putchar(cons, eax & 0xff, 1);
	} else if (edx == 2) {
		cons_putstr0(cons, (char *) ebx + ds_base);
	} else if (edx == 3) {
		cons_putstr1(cons, (char *) ebx + ds_base, ecx);
	} else if (edx == 4) {
		logging(LOG_KERNEL, "Application broken (%d)", task->id);
		return &(task->tss.esp0);
	} else if (edx == 5) {
		sht = sheet_alloc();
		sht->task = task;
		sht->flags |= 0x10;
		sheet_setbuf(sht, (char *) ebx + ds_base, esi, edi, eax);
		draw_window8((char *) ebx + ds_base, esi, edi, (char *) ecx + ds_base, 0);
		strcpy(sht->title, (char *) ecx + ds_base);
		set_taskbar(sht->id, (char *) ecx + ds_base);	
		sheet_slide(sht, ((shtctl->xsize - esi) / 2) & ~3, (shtctl->ysize - edi) / 2);
		sheet_updown(sht, shtctl->top); /* ̃}EXƓɂȂ悤ɎwF }EX͂̏ɂȂ */
		if(shtctl->active) {
			keywin_off(shtctl->active);
		}
		keywin_on(sht);
		reg[7] = (int) sht;
	} else if (edx == 6) {
		sht = (struct SHEET *) (ebx & 0xfffffffe);
		if (is_window_compacted(sht)) {
			return 0;
		}
		putfonts8_asc(sht->buf, sht->bxsize, esi, edi, eax, (char *) ebp + ds_base);
		if ((ebx & 1) == 0) {
			sheet_refresh(sht, esi, edi, esi + ecx * 8, edi + 16);
		}
	} else if (edx == 7) {
		sht = (struct SHEET *) (ebx & 0xfffffffe);
		if (is_window_compacted(sht)) {
			return 0;
		}	
		boxfill8(sht->buf, sht->bxsize, ebp, eax, ecx, esi, edi);
		if ((ebx & 1) == 0) {
			sheet_refresh(sht, eax, ecx, esi + 1, edi + 1);
		}
	} else if (edx == 8) {
		memman_init((struct MEMMAN *) (ebx + ds_base));
		ecx &= 0xfffffff0;	/* 16oCgPʂ */
		memman_free((struct MEMMAN *) (ebx + ds_base), eax, ecx);
	} else if (edx == 9) {
		ecx = (ecx + 0x0f) & 0xfffffff0; /* 16oCgPʂɐ؂グ */
		reg[7] = memman_alloc((struct MEMMAN *) (ebx + ds_base), ecx);
	} else if (edx == 10) {
		ecx = (ecx + 0x0f) & 0xfffffff0; /* 16oCgPʂɐ؂グ */
		memman_free((struct MEMMAN *) (ebx + ds_base), eax, ecx);
	} else if (edx == 11) {
		sht = (struct SHEET *) (ebx & 0xfffffffe);
		if (is_window_compacted(sht)) {
			return 0;
		}
		sht->buf[sht->bxsize * edi + esi] = eax;
		if ((ebx & 1) == 0) {
			sheet_refresh(sht, esi, edi, esi + 1, edi + 1);
		}
	} else if (edx == 12) {
		sht = (struct SHEET *) ebx;
		if (is_window_compacted(sht)) {
			return 0;
		}
		sheet_refresh(sht, eax, ecx, esi, edi);
	} else if (edx == 13) {
		sht = (struct SHEET *) (ebx & 0xfffffffe);
		if (is_window_compacted(sht)) {
			return 0;
		}
		hrb_api_linewin(sht, eax, ecx, esi, edi, ebp);
		if ((ebx & 1) == 0) {
			if (eax > esi) {
				i = eax;
				eax = esi;
				esi = i;
			}
			if (ecx > edi) {
				i = ecx;
				ecx = edi;
				edi = i;
			}
			sheet_refresh(sht, eax, ecx, esi + 1, edi + 1);
		}
	} else if (edx == 14) {
		sheet_free((struct SHEET *) ebx);
	} else if (edx == 15) {
		for (;;) {
			io_cli();
			if (fifo32_status(&task->fifo) == 0) {
				if (eax != 0) {
					task_sleep(task);	/* FIFOȂ̂ŐQđ҂ */
				} else {
					io_sti();
					reg[7] = -1;
					return 0;
				}
			}
			i = fifo32_get(&task->fifo);
			io_sti();
			if (i <= 1 && cons->sht != 0) { /* J[\p^C} */
				/* Avs̓J[\oȂ̂ŁA͕\p1𒍕Ă */
				timer_init(cons->timer, &task->fifo, 1); /* 1 */
				timer_settime(cons->timer, 50);
			}
			if (i == 2) {	/* J[\ON */
				cons->cur_c = COL8_FFFFFF;
			}
			if (i == 3) {	/* J[\OFF */
				cons->cur_c = -1;
			}
			if (i == 4) {	/* R\[ */
				timer_cancel(cons->timer);
				io_cli();
				fifo32_put(sys_fifo, cons->sht - shtctl->sheets0 + 2024);	/* 2024`2279 */
				cons->sht = 0;
				io_sti();
			}
			if (i >= 256) { /* L[{[hf[^i^XNAoRjȂ */
				reg[7] = i - 256;
				return 0;
			}
		}
	} else if (edx == 16) {
		reg[7] = (int) timer_alloc();
		((struct TIMER *) reg[7])->flags2 = 1;	/* LZL */
	} else if (edx == 17) {
		timer_init((struct TIMER *) ebx, &task->fifo, eax + 256);
	} else if (edx == 18) {
		timer_settime((struct TIMER *) ebx, eax);
	} else if (edx == 19) {
		timer_free((struct TIMER *) ebx);
	} else if (edx == 20) {
		if (eax == 0) {
			i = io_in8(0x61);
			io_out8(0x61, i & 0x0d);
		} else {
			i = 1193180000 / eax;
			io_out8(0x43, 0xb6);
			io_out8(0x42, i & 0xff);
			io_out8(0x42, i >> 8);
			i = io_in8(0x61);
			io_out8(0x61, (i | 0x03) & 0x0f);
		}
	} else if (edx == 21) {
		for (i = 0; i < 8; i++) {
			if (task->fhandle[i].buf == 0) {
				break;
			}
		}
		fh = &task->fhandle[i];
		reg[7] = 0;
		if (i < 8) {
			finfo = file_search((char *)ebx + ds_base,
					(struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224);
			if (finfo != 0) {
				if (file_lock((char *)ebx + ds_base, task_now()->id)) {
					reg[7] = (int) fh;
					strcpy(fh->fname, (char *)ebx + ds_base);
					fh->size = finfo->size;
					fh->pos = 0;
					fh->buf = file_loadfile2(finfo->clustno, &fh->size, global_alloc_fat);
				} else {
					reg[7] = 0;
				}
			}
		}
	} else if (edx == 22) {
		fh = (struct FILEHANDLE *) eax;
		if (file_unlock(fh->fname)) {
			memman_free_4k((int) fh->buf, fh->size);
			fh->buf = 0;
			reg[7] = 1;
		} else {
			reg[7] = 0;
		}
	} else if (edx == 23) {
		fh = (struct FILEHANDLE *) eax;
		if (ecx == 0) {
			fh->pos = ebx;
		} else if (ecx == 1) {
			fh->pos += ebx;
		} else if (ecx == 2) {
			fh->pos = fh->size + ebx;
		}
		if (fh->pos < 0) {
			fh->pos = 0;
		}
		if (fh->pos > fh->size) {
			fh->pos = fh->size;
		}
	} else if (edx == 24) {
		fh = (struct FILEHANDLE *) eax;
		if (ecx == 0) {
			reg[7] = fh->size;
		} else if (ecx == 1) {
			reg[7] = fh->pos;
		} else if (ecx == 2) {
			reg[7] = fh->pos - fh->size;
		}
	} else if (edx == 25) {
		fh = (struct FILEHANDLE *) eax;
		for (i = 0; i < ecx; i++) {
			if (fh->pos == fh->size) {
				break;
			}
			*((char *) ebx + ds_base + i) = fh->buf[fh->pos];
			fh->pos++;
		}
		reg[7] = i;
	} else if (edx == 26) {
		i = 0;
		for (;;) {
			*((char *) ebx + ds_base + i) =  task->cmdline[i];
			if (task->cmdline[i] == 0) {
				break;
			}
			if (i >= ecx) {
				break;
			}
			i++;
		}
		reg[7] = i;
	} else if (edx == 27) {
		reg[7] = task->langmode;
	} else if (edx == 28) {
	/*	init_serialport(eax, ebx, 0x03, 0x0b);	*/
	} else if (edx == 29) {
	/*	send_string_serialport(eax, (char *)ebx + ds_base);	*/
	} else if (edx == 30) {
	/*	reg[7] = receive_stat_serialport(eax);	*/
	} else if (edx == 31) {
	/*	reg[7] = recv_char_serialport(eax);		*/
	} else if (edx == 32) {
		p = ((char *)eax + ds_base);
		task_cons = open_constask(0);
		fifo = &task_cons->fifo;
		for (i = 0; p[i] != 0; i++) {
			fifo32_put(fifo, p[i] + 256);
		}
		fifo32_put(fifo, 10 + 256);
	} else if (edx == 33) {
 		mif = (struct MINFO *)(ecx + ds_base);
 		if (eax != 0) {
 			sht = (struct SHEET *)(eax & 0xfffffffe);
 			tx = sht->vx0;
 			ty = sht->vy0;
 		}
 		mif->x = mf.x - tx;
 		mif->y = mf.y - ty;
 		mif->button = mf.button;
 		mif->state  = mf.state;
	} else if (edx == 34) {
		dt = (struct DATE *)(eax + ds_base);
		readdates(date);
		dt->year = ((date[6] >> 4) * 10 + (date[6] & 0x0f)) * 100;
		dt->year += (date[5] >> 4) * 10 + (date[5] & 0x0f);
		dt->month = (date[4] >> 4) * 10 + (date[4] & 0x0f);
		dt->day = (date[3] >> 4) * 10 + (date[3] & 0x0f);
		dt->hour = (date[2] >> 4) * 10 + (date[2] & 0x0f);
		dt->minutes = (date[1] >> 4) * 10 + (date[1] & 0x0f);
		dt->second = (date[0] >> 4) * 10 + (date[0] & 0x0f);
	} else if (edx == 35) {
		kernel_sleep(eax);
	} else if (edx == 36) {
		io_out8(eax, ecx);
	} else if (edx == 37) {
		reg[7] = io_in8(eax);
	} else if (edx == 38) {
		show_mesbox((char *)eax + ds_base, (char *)ebx + ds_base);
	} else if (edx == 39) {
		if(shtctl->active) {
			keywin_off(shtctl->active);
		}
		keywin_on((struct SHEET *)(eax & 0xfffffffe));		
	}
	
	return 0;
}

