/// @file bootpack.c
/// @brief J[l̃C.
///
/// J[l{̂𓮂OɕKvƂȂ鏈s
/// @author JsZ(is2os), Sero_S
/// @since 2010-08-23(r41)

#include "bootpack.h"

int *global_alloc_fat;			///< FAT
struct SHEET *global_sht_back;	///< wĩV[g
int global_mouse_x;				///< }EXXW(APIp)
int global_mouse_y;				///< }EXYW(APIp)

/// @brief Gg|Cg.
///
/// Negitoro OS J[lCꕔ̃Gg|Cg.
/// }`^XN̏task_aƂăbZ[W̏s.
void NegiMain(void)
{
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	struct SHTCTL *shtctl;
	struct MOUSE_DEC mdec;
	struct SHEET *sht_mouse;
	struct TASK *task_a, *task;
	struct SHEET *sht = 0, *key_win = 0, *sht2;	
	struct FIFO32 fifo, keycmd;
	
	int fifobuf[128], keycmd_buf[32], mx, my, i, new_mx = -1, 
		new_my = 0, new_wx = 0x7fffffff, new_wy = 0, key_shift = 0, 
		key_leds = (binfo->leds >> 4) & 7, keycmd_wait = -1, j, x, 
		y, mmx = -1, mmy = -1, mmx2 = 0, flag1 = 0, flag2 = 0;
	UINT32 memtotal;
	UCHAR buf_mouse[256], *buf_back;
	UCHAR *nihongo = 0;
	char s[40];
	
	static char keytable0[0x80] = {
		0,   0,   '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '^', 0x08, 0,
		'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '@', '[', 0x0a, 0, 'A', 'S',
		'D', 'F', 'G', 'H', 'J', 'K', 'L', ';', ':', 0,   0,   ']', 'Z', 'X', 'C', 'V',
		'B', 'N', 'M', ',', '.', '/', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
		'2', '3', '0', '.', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0x5c, 0,  0,   0,   0,   0,   0,   0,   0,   0,   0x5c, 0,  0
	};
	static char keytable1[0x80] = {
		0,   0,   '!', 0x22, '#', '$', '%', '&', 0x27, '(', ')', '~', '=', '~', 0x08, 0,
		'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '`', '{', 0x0a, 0, 'A', 'S',
		'D', 'F', 'G', 'H', 'J', 'K', 'L', '+', '*', 0,   0,   '}', 'Z', 'X', 'C', 'V',
		'B', 'N', 'M', '<', '>', '?', 0,   '*', 0,   ' ', 0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   '7', '8', '9', '-', '4', '5', '6', '+', '1',
		'2', '3', '0', '.', 0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
		0,   0,   0,   '_', 0,   0,   0,   0,   0,   0,   0,   0,   0,   '|', 0,   0
	}; 

	/*---------------------
	
		Ȏ厖Ȃ

	---------------------*/
	
	 /* p\VA|[g̏ */
	init_serialports(0x06);
	
	init_gdtidt();
	init_pic();
	init_pit();
	init_palette();
	
	/* IDT/PIC̏ÎCPŮ荞݋֎~ */
	io_sti(); 
	
	/* L[{[hƃ}EXFIFO蓖Ă */
	fifo32_init(&fifo, 128, fifobuf, 0);
	init_keyboard(&fifo, 256);
	enable_mouse(&fifo, 512, &mdec);
	fifo32_init(&keycmd, 32, keycmd_buf, 0);
	debugmsg("Initialized mouse and keyboard buffer.."); 
	
	enable_PICs();
	memtotal = init_memory();
	shtctl = shtctl_init(binfo->vram);
	task_a = task_init();
	
	*((int *) 0x0fec) = (int) &fifo;
	*((int *) 0x0fe4) = (int) shtctl;
	
	/*-------------------
	
		VXeN 
		
	-------------------*/

	/* FAT̊mۂƃVXe^XNN */
	alloc_global_fat();
	init_run_system(task_a, &fifo);
	
	/* t@CbNXg̏Ɠo^  */
	init_file_lock();
	file_lock(SYSTEMFILE_NAME, task_now()->id);

	/* tHgǂݍ */
	if (file_readfont(FONTFILE, nihongo)) {
		debugmsg("Font loaded.. (%s)", FONTFILE);
	} else {
		debugmsg("Font loading error!");
	}
	
	/* wi(sht_back)̃V[gݒ */
	global_sht_back = sheet_alloc();
	buf_back = (UCHAR *)memman_alloc_4k(binfo->scrnx * binfo->scrny);
	sheet_setbuf(global_sht_back, buf_back, binfo->scrnx, binfo->scrny, -1); /* FȂ */
	sheet_slide(global_sht_back, 0, 0);	
	sheet_updown(global_sht_back, 0);	
	
	/* }EX(sht_mouse)̃V[gݒ */
	sht_mouse = sheet_alloc();
	sheet_setbuf(sht_mouse, buf_mouse, 16, 16, 99);
	init_mouse_cursor8(buf_mouse, 99);
	mx = (binfo->scrnx - 16) / 2;
	my = (binfo->scrny - 28 - 16) / 2;

	/* N */
	loading_screen();
	
	/* ftHg̕ǎ͂Ƃ肠 */
	set_backscreen(0);
	init_log();
	init_taskbar();
	
	/*----------------------------
	
		J[lN̏
	
	----------------------------*/
	
	/* Ẽ\Jn */
	mem_display_on(1);

	/* }EX\ */
	sheet_slide(sht_mouse, mx, my);
	sheet_updown(sht_mouse, 2);	
	
	/* Kvȃ^XNN */
	run_mpm();
	run_clock();
	run_fdc();
	
	/* ŏ̓R\[ANeBu */
	key_win = open_console();
	sheet_active_top(key_win, 52, 72);
	
	/*--------------------
	
		VXe[v
	
	--------------------*/

	/* ŏɃL[{[hԂƂ̐HႢȂ悤ɁAݒ肵ĂƂɂ */
	fifo32_put(&keycmd, KEYCMD_LED);
	fifo32_put(&keycmd, key_leds);	
	
	for (;;) {
		if (fifo32_status(&keycmd) > 0 && keycmd_wait < 0) {
			/* L[{[hRg[ɑf[^΁A */
			keycmd_wait = fifo32_get(&keycmd);
			wait_KBC_sendready();
			io_out8(PORT_KEYDAT, keycmd_wait);
		}
		io_cli();
		if (fifo32_status(&fifo) == 0) {
			/* FIFOۂɂȂ̂ŁAۗĂ`悪Ύs */
			if (new_mx >= 0) {
				io_sti();
				sheet_slide(sht_mouse, new_mx, new_my);
				new_mx = -1;
			} else if (new_wx != 0x7fffffff) {
				io_sti();
				sheet_slide(sht, new_wx, new_wy);
				new_wx = 0x7fffffff;
			} else {
				task_sleep(task_a);
				io_sti();
			}
		} else {
			i = fifo32_get(&fifo);
			io_sti();
			if (shtctl->active != 0 && shtctl->active->flags == 0) {	/* EBhEꂽ */
				if (shtctl->top == 1) {	/* }EXƔwiȂ */
					key_win = 0;
					keywin_off(key_win);
				} else {
					key_win = shtctl->sheets[shtctl->top - 1];
					keywin_on(key_win);
				}
			}
			if (256 <= i && i <= 511) { /* L[{[hf[^ */
				if (i < 0x80 + 256) { /* L[R[h𕶎R[hɕϊ */
					if (key_shift == 0) {
						s[0] = keytable0[i - 256];
					} else {
						s[0] = keytable1[i - 256];
					}
				} else {
					s[0] = 0;
				}
				if ('A' <= s[0] && s[0] <= 'Z') {	/* ͕At@xbg */
					if (((key_leds & 4) == 0 && key_shift == 0) ||
							((key_leds & 4) != 0 && key_shift != 0)) {
						s[0] += 0x20;	/* 啶ɕϊ */
					}
				}
				if (s[0] != 0 && key_win != 0) { /* ʏ핶AobNXy[XAEnter */
				    fifo32_put(&shtctl->active->task->fifo, s[0] + 256);
				}
				if (i == 256 + 0x0f && shtctl->active != 0 && !there_messagebox) {	/* Tab */
					if (shtctl->top > 2 ) {
						keywin_off(shtctl->active);
						key_win = shtctl->sheets[1];
						sheet_updown(key_win, shtctl->top - 1);			
						keywin_on(key_win);
					}
				}
				if (i == 256 + 0x2a) {	/* Vtg ON */
					key_shift |= 1;
				}
				if (i == 256 + 0x36) {	/* EVtg ON */
					key_shift |= 2;
				}
				if (i == 256 + 0xaa) {	/* Vtg OFF */
					key_shift &= ~1;
				}
				if (i == 256 + 0xb6) {	/* EVtg OFF */
					key_shift &= ~2;
				}
				if (i == 256 + 0x3a) {	/* CapsLock */
					key_leds ^= 4;
					fifo32_put(&keycmd, KEYCMD_LED);
					fifo32_put(&keycmd, key_leds);
				}
				if (i == 256 + 0x45) {	/* NumLock */
					key_leds ^= 2;
					fifo32_put(&keycmd, KEYCMD_LED);
					fifo32_put(&keycmd, key_leds);
				}
				if (i == 256 + 0x46) {	/* ScrollLock */
					key_leds ^= 1;
					fifo32_put(&keycmd, KEYCMD_LED);
					fifo32_put(&keycmd, key_leds);
				}
				if (i == 256 + 0x3b && key_shift != 0 && key_win != 0) {	/* Shift+F1 */
					task = key_win->task;
					if (task != 0 && task->tss.ss0 != 0) {
						logging(LOG_KERNEL, "Application broken (%d)", task->id);
						io_cli();	/* IɃ^XNςƍ邩 */
						task->tss.eax = (int) &(task->tss.esp0);
						task->tss.eip = (int) asm_end_app;
						io_sti();
						task_run(task, -1, 0, task->taskname);	/* Imɂ点邽߂ɁAQĂN */
					}
				}
				if (i == 256 + 0x3c && key_shift != 0 && !there_messagebox) {	/* Shift+F2 */
					/* VR\[͑IԂɂîقe؂ˁHj */
					if (key_win != 0) {
						keywin_off(key_win);
					}
					key_win = open_console();
					sheet_active_top(key_win, 52, 72);
				}
				if (i == 256 + 0x58 && key_shift != 0) { /* Shift+F12 */
					/* ʕ\XV */
 					clock_refresh();
					showmemory_screen();
					debugmsg("Status showed in the desktop were refreshed and renewed.");
				}
				if (i == 256 + 0xfa) {	/* L[{[hf[^𖳎Ɏ󂯎 */
					keycmd_wait = -1;
				}
				if (i == 256 + 0xfe) {	/* L[{[hf[^𖳎Ɏ󂯎Ȃ */
					wait_KBC_sendready();
					io_out8(PORT_KEYDAT, keycmd_wait);
				}
			} else if (512 <= i && i <= 767) { /* }EXf[^ */
				if (mouse_decode(&mdec, i - 512) != 0) {
				
					/* }EXJ[\̈ړ */
					mx += mdec.x;
					my += mdec.y;
					if (mx < 0) {
						mx = 0;
					}
					if (my < 0) {
						my = 0;
					}
					if (mx > binfo->scrnx - 1) {
						mx = binfo->scrnx - 1;
					}
					if (my > binfo->scrny - 1) {
						my = binfo->scrny - 1;
					}
					new_mx = mx;
					new_my = my;
					
					/* {^Ă */
					if ((mdec.btn & 0x01)) {
						if (mmx < 0) {
							for (j = shtctl->top - 1; j >= 0; j--) {
								
								/* EBhEł̍WvZ */
								/* bZ[W{bNX */
								/* ̃EBhEւ͖̑ɂ */
								if (!there_messagebox) {
									sht = shtctl->sheets[j];
								} else {
									sht = shtctl->active;
								}
								x = mx - sht->vx0;
								y = my - sht->vy0;
								
								/* wîƂ */
								/* bZ[W{bNXƂ͖ */
								if (sht->id == global_sht_back->id) {
								
									/* Shell{^ŃVFN */
									/* {fifoshift+f2őقǂ */
									if (flag1) {
										if (mx >= 73 && my >= 3 && mx <= 121 && my <= 21) {
											if (key_win != 0) {
												keywin_off(key_win);
											}
											key_win = open_console();
											sheet_active_top(key_win, 52, 72);
										}
									}
									
									/* X^[gj[\ */
									if (flag2) {
									
										/* `ʏ */
									
									}
									
								/* ʂ̃EBhÊƂ */
								} else if (0 <= x && x < sht->bxsize && 0 <= y && y < sht->bysize) {
									if (sht->buf[y * sht->bxsize + x] != sht->col_inv) {
										
										/* ANeBuɂ	*/
										sheet_updown(sht, shtctl->top - 1);
										if (sht != shtctl->active) {
											keywin_off(shtctl->active);
											key_win = sht;
											keywin_on(key_win);
										}
										sht = shtctl->active;
										
										if (x >= 5 && x <= 20 && y >= 5 && y <= 21) {
											/* ŏ{^NbN */ 
											;
										} else if (sht->bxsize - 38 <= x && x < sht->bxsize - 23 && 5 <= y && y < 19) {
											/* RpNg{^NbN */
											/* ܂ */
											/*
											if ((sht->flags & 0x10) != 0) {
												if (!is_window_compacted(sht)) {
													sheet_save_svdat(sht);
													compacted_window(sht, 1);
													sht->mode = SHT_MODE_COMPACTED;
												} else {
													compacted_window(sht, 0);
													sheet_restore_svdat(sht);
													sheet_free_svdat(sht);
													sht->mode = SHT_MODE_USUAL;
												}
												sheet_active_top(sht, sht->vx0, sht->vy0);
											}
											*/
										} else if (sht->bxsize - 21 <= x && x < sht->bxsize - 5 && 5 <= y && y < 19) {
											/* I{^NbN */
											/* AvEBhE	*/
											if ((sht->flags & 0x10) != 0) {
												task = sht->task;
												logging(LOG_KERNEL, "Application broken (%d)", task->id);
												io_cli();	/* IɃ^XNςƍ邩 */
												task->tss.eax = (int) &(task->tss.esp0);
												task->tss.eip = (int) asm_end_app;
												io_sti();
												task_run(task, -1, 0, task->taskname);
												
											/* J[lñEBhEĂƁH */
											} else {
												if ((sht->flags & 0x20) != 0) {
													
													task = sht->task;
													sheet_updown(sht, -1); /* Ƃ肠\ɂĂ */
													keywin_off(shtctl->active);
													key_win = 0;
	
													/* R\[bZ[W{bNX */
													if (sht->ktype == KERNELWINDOW_CONS ||
														sht->ktype == KERNELWINDOW_MPM) {	
														io_cli();
														fifo32_put(&task->fifo, 4);
														io_sti();													
													}

													if (shtctl->top > 1) {
														key_win = shtctl->sheets[shtctl->top - 1];
														keywin_on(key_win);
													}
												}
											}	
										} else {
											/* EBhE{^̏łȂΈړ[h */
											if (3 <= x && x < sht->bxsize - 3 && 3 <= y && y < 21) {
												mmx = mx;	
												mmy = my;
												mmx2 = sht->vx0;
												new_wy = sht->vy0;
											}
										}
										break;
									}
								}
							}
						} else {
							/* EBhEړ[h̏ꍇ */
							x = mx - mmx;	/* }EẌړʂvZ */
							y = my - mmy;
							new_wx = (mmx2 + x + 2) & ~3;
							new_wy = new_wy + y;
							mmy = my;	/* ړ̍WɍXV */
						}
					
					/* E{^Ă */
					} else if ((mdec.btn & 0x02)) {
						if (mmx < 0) {
							for (j = shtctl->top - 1; j >= 0; j--) {	
						
								/* wîƂ */
								if (sht->id == global_sht_back->id) {
									
									/* Ȃ񂩃j[o */
								
								}
								
							}
						}
					} else {
						
						/* {^ĂȂ */
						mmx = -1;	/* ʏ탂[h */
						if (new_wx != 0x7fffffff) {
							sheet_slide(sht, new_wx, new_wy);	/* xm肳 */
							new_wx = 0x7fffffff;
						}
						
						/* {^̂ƂɋGtFNg */
						/* Negitoro */
						if (mx >= 2 && my >= 3 && mx <= 70 && my <= 21) {
							effect_screen(1, 1);
							flag2 = 1;
						} else {
							effect_screen(1, 0);
							flag2 = 0;
						}
						/* Shell */
						if (mx >= 73 && my >= 3 && mx <= 121 && my <= 21) {
							effect_screen(2, 1);
							flag1 = 1;
						} else {
							effect_screen(2, 0);
							flag1 = 0;
						}
					}
				}
			} else if (768 <= i && i <= 1023) {	/* R\[I */
				close_console(shtctl->sheets0 + (i - 768));
			} else if (1024 <= i && i <= 2023) {
				close_constask(taskctl->tasks0 + (i - 1024));
			} else if (2024 <= i && i <= 2279) {	/* R\[ */
				sht2 = shtctl->sheets0 + (i - 2024);
				memman_free_4k((int)sht2->buf, 540 * 380);
				sheet_free(sht2);
			}
		}
		
		/* }EXAPIp */
		global_mouse_x = mx;
		global_mouse_y = my;
		
	}
}

/// @brief VXe^XNN
/// @param task 蓖Ă^XN
/// @param fifo 蓖ĂFIFO
void init_run_system(struct TASK *task, struct FIFO32 *fifo)
{
	task_run(task, 1, 2, "system");
	fifo->task = task;
	task->langmode = 0;
	debugmsg("Running kernel..");
	return;
}

/// @brief FATׂ̈̃O[oȕϐm
void alloc_global_fat(void)
{
	global_alloc_fat = (int *)memman_alloc_4k(4 * 2880);
	
	file_readfat(global_alloc_fat, (UCHAR *) (ADR_DISKIMG + FAT_ADDR));	
	debugmsg("Memory allocated for FAT..");
	
	return;
}

/// @brief PITAPIC1ƃL[{[hA}EX
void enable_PICs(void)
{
	io_out8(PIC0_IMR, 0xf8); 
	io_out8(PIC1_IMR, 0xef); 
	debugmsg("Enabled PIT, PIC1, Mouse, keyboard..");
}

/// @brief w肵V[g̃L[͂OFF
/// @param key_win OFFɂV[g
void keywin_off(struct SHEET *key_win)
{
	struct SHTCTL *shtctl = (struct SHTCTL *) *((int *) 0x0fe4);

	change_wtitle8(key_win, 0);
	if ((key_win->flags & 0x20) != 0) {
		fifo32_put(&key_win->task->fifo, 3); /* R\[̃J[\OFF */
	}
	shtctl->active = 0;
	
	return;
}

/// @brief w肵V[g̃L[͂ON
/// @param key_win ONɂV[g
void keywin_on(struct SHEET *key_win)
{
	struct SHTCTL *shtctl = (struct SHTCTL *) *((int *) 0x0fe4);

	change_wtitle8(key_win, 1);
	if ((key_win->flags & 0x20) != 0) {
		fifo32_put(&key_win->task->fifo, 2); /* R\[̃J[\ON */
	}
	shtctl->active = key_win;
	
	return;
}

