/// @file bootpack.h
/// @brief Ŝ̃wb_[.
///
/// Negitoro OS ׂ̂Ă̊O錾.
/// @author JsZ(is2os), Sero_S
/// @since 2010-08-23(r41)

#include <stdio.h>
#include <string.h>

typedef unsigned char 	UCHAR;
typedef unsigned int 	UINT32;
typedef unsigned short	USHORT;
typedef unsigned long 	ULONG32;

#define ON 1
#define OFF 0
#define TRUE 1
#define FALSE 0

#define VERSIONDATA_TAG		"NegitoroOS [Version 0.0.1(Beta)]"			///< o[W^O
#define COPYRIGHTDATA_TAG 	"Copyright (c) 2009 Negitoro OS Project."	///< Rs[Cg^O

#define SYSTEMFILE_NAME 	"kernel.sys"	///< J[lVXet@C
#define HISTORY_FILE 		"hists.log"		///< qXg[t@C

#define KERNELWINDOW_MPM	1	///< MPM̍EBhEID.
#define KERNELWINDOW_CONS	2	///< R\[̃EBhEID.

/* asmhead.nas */
/// @brief u[gɓǂ񂾃f[^
/// @note 0x0ff0-0x0fff
struct BOOTINFO {
	char cyls; 		///< u[gZN^͂ǂ܂ŃfBXNǂ񂾂̂
	char leds; 		///< u[g̃L[{[hLED̏
	char vmode; 	///< rfI[h  rbgJ[
	char reserve;	///< U[u
	short scrnx; 	///< ʉ𑜓xX
	short scrny; 	///< ʉ𑜓xY
	char *vram;		///< vram̃AhX
};
#define ADR_BOOTINFO	0x00000ff0	///< BOOTINFÕf[^̂AhX
#define FAT_ADDR 		0x00000200	///< FAT̃AhX
#define ADR_DISKIMG		0x00100000	///< fBXNC[ŴAhX
#define APM_VERSION		0x1ff0		///< APM̃o[Wf[^̂AhX
#define VBE_VERSION		0x1ff3		///< VBẼo[Wf[^̂AhX

/* W֐n */
/* rand0`32797͈̔ */
int rand(void);
int atoi(const char *s);

/* strtok.c */
char *strtok(register char *string, const char *separators);

/* naskfunc.nas */
void io_hlt(void);
void io_cli(void);
void io_sti(void);
void io_stihlt(void);
int io_in8(int port);
int io_in16(int port);
int io_in32(int port);
void io_out8(int port, int data);
void io_out16(int port, int data);
void io_out32(int port, int data);
int io_load_eflags(void);
void io_store_eflags(int eflags);
void load_gdtr(int limit, int addr);
void load_idtr(int limit, int addr);
int load_cr0(void);
void store_cr0(int cr0);
void load_tr(int tr);
void asm_inthandler07(void);
void asm_inthandler0c(void);
void asm_inthandler0d(void);
void asm_inthandler20(void);
void asm_inthandler21(void);
void asm_inthandler23(void);
void asm_inthandler24(void);
void asm_inthandler26(void);
void asm_inthandler27(void);
void asm_inthandler2c(void);
UINT32 memtest_sub(UINT32 start, UINT32 end);
void farjmp(int eip, int cs);
void farcall(int eip, int cs);
void asm_hrb_api(void);
void start_app(int eip, int cs, int esp, int ds, int *tss_esp0);
void asm_end_app(void);
void clts(void);
void fnsave(int *addr);
void frstor(int *addr);

/* fifo.c */
/// @brief FIFOf[^
struct FIFO32 {
	int *buf;			///< f[^
	int p;				///< ݈ʒu
	int q;				///< ǂݍ݈ʒu
	int size;			///< FIFÕTCY
	int free;			///< FIFŐ󂫃TCY
	int flags;			///< FIFȌԓ
	int sw;				///< FIFOւ̑M̉
	struct TASK *task;	///< 蓖Ăꂽ^XN
};
void fifo32_init(struct FIFO32 *fifo, int size, int *buf, struct TASK *task);
int fifo32_put(struct FIFO32 *fifo, int data);
int fifo32_get(struct FIFO32 *fifo);
int fifo32_status(struct FIFO32 *fifo);
void fifo32_switch(struct FIFO32 *fifo, int sw);

/* memory.c */
#define MEMMAN_FREES	4090		///< 32K̋
#define MEMMAN_ADDR		0x003c0000	///< }l[W̔zuAhX
/// @brief ̋󂫏
struct FREEINFO {
	UINT32 addr;	///< 󂫊JnAhX
	UINT32 size;	///< 󂫃TCY
};
/// @brief Ǘ
struct MEMMAN {
	int frees;							///< 󂫗̈搔
	int maxfrees;						///< ő󂫗̈搔
	int lostsize;						///< ɎsvTCY
	int losts;							///< Ɏs
	struct FREEINFO free[MEMMAN_FREES]; ///< 󂫏
	int disp;							///< fXNgbv\ON/OFF
};
UINT32 memtest(UINT32 start, UINT32 end);
void memman_init(struct MEMMAN *man);
UINT32 memman_total(struct MEMMAN *man);
UINT32 memman_alloc(struct MEMMAN *man, UINT32 size);
int memman_free(struct MEMMAN *man, UINT32 addr, UINT32 size);
UINT32 memman_alloc_4k(UINT32 size);
int memman_free_4k(UINT32 addr, UINT32 size);
UINT32 init_memory(void);
UINT32 get_totalmem(void);
void mem_display_on(int on);

/* sheet.c */

#define MAX_SHEETS			256	///<gp\V[g̍ő
#define SHEET_USE			1	///<V[ggĂƂ}[N
#define SHT_MODE_COMPACTED	-1	///<V[gRpNgĂ
#define SHT_MODE_USUAL		0	///<V[g͒ʏ̏

/// @brief ̃V[gf[^
struct SHEET {
	struct SHTCTL *ctl;	///< SHTCTL
	struct TASK *task;	///< ^XN

	UCHAR *buf;			///< VRAM̃AhX
	int bxsize;			///< 
	int bysize;			///< c
	int vx0;			///< ʏXW
	int vy0;			///< ʏYW
	int col_inv;		///< 
	int height;			///< V[g̕
	int flags;			///< V[g̏ԓ
	int id;				///< V[gID
	int ktype;			///< V[g^Cv
	int mode;			///< V[g̏
	UCHAR *title;		///< V[g(EBhE)^Cg
	
	UCHAR *buf_sv;		///< RpNgbufۑp
	int bxsize_sv;		///< RpNgbxsizeۑp
	int bysize_sv;		///< RpNgbysizeۑp
	int vx0_sv;			///< RpNgvx0ۑp
	int vy0_sv;			///< RpNgvy0ۑp
	int saved;			///< RpNgpf[^ۑĂ邩ǂ
};

/// @brief V[g̓
struct SHTCTL {
	UCHAR *vram;						///< VRAM̃AhX
	UCHAR *map;							///< V[g݂VRAM̃AhX
	int xsize;							///< ʏc
	int ysize;							///< ʉ
	int top;							///< ԏ̃V[g̍
	struct SHEET *sheets[MAX_SHEETS];	///< V[g̃|C^íj
	struct SHEET sheets0[MAX_SHEETS];	///< V[g̃f[^iĂȂ́j
	struct SHEET *active;				///< ANeBuȃEBhẼV[g
};

struct SHTCTL *shtctl_init(UCHAR *vram);
struct SHEET *sheet_alloc(void);
void sheet_setbuf(struct SHEET *sht, UCHAR *buf, int xsize, int ysize, int col_inv);
void sheet_updown(struct SHEET *sht, int height);
void sheet_refresh(struct SHEET *sht, int bx0, int by0, int bx1, int by1);
void sheet_slide(struct SHEET *sht, int vx0, int vy0);
void sheet_free(struct SHEET *sht);
void sheet_active_top(struct SHEET *sht, int x, int y);
void sheet_save_svdat(struct SHEET *sht);
void sheet_free_svdat(struct SHEET *sht);
void sheet_restore_svdat(struct SHEET *sht);
int is_window_compacted(struct SHEET *sht);

/* graphic.c */

void init_screen8(char *vram);
void effect_screen(int id, int act);
void boxfill8(UCHAR *vram, int xsize, UCHAR c, int x0, int y0, int x1, int y1);
void putfont8(char *vram, int xsize, int x, int y, char c, char *font);
void putfonts8_asc(char *vram, int xsize, int x, int y, char c, UCHAR *s);
void init_mouse_cursor8(char *mouse, char bc);
void putblock8_8(char *vram, int vxsize, int pxsize,
	int pysize, int px0, int py0, char *buf, int bxsize);
	
#define COL8_000000		0		///< 
#define COL8_FF0000		1		///< 邢
#define COL8_00FF00		2		///< 邢
#define COL8_FFFF00		3		///< 邢F
#define COL8_0000FF		4		///< 邢
#define COL8_FF00FF		5		///< 邢
#define COL8_00FFFF		6		///< 邢F
#define COL8_FFFFFF		7		///< 
#define COL8_C6C6C6		8		///< 邢DF
#define COL8_840000		9		///< Â
#define COL8_008400		10		///< Â
#define COL8_848400		11		///< ÂF
#define COL8_000084		12		///< Â
#define COL8_840084		13		///< Â
#define COL8_008484		14		///< ÂF
#define COL8_848484		15		///< ÂDF

void set_backscreen(char *wallname);
void loading_screen(void);
void hrb_api_linewin(struct SHEET *sht, int x0, int y0, int x1, int y1, int col);
void showmemory_screen(void);
int draw_picture(struct SHEET *sht, char *fname, int posx, int posy);

/* color.c */
/// @brief RGBf[^
struct RGB {
	UCHAR b;	///< B
	UCHAR g;	///< G
	UCHAR r;	///< R
	UCHAR t;
};
/// @brief (64KB)摜f[^Ɨ̈H
struct DLL_STRPICENV {
	int work[64 * 1024 / 4]; ///< f[^
};
UCHAR rgb2pal(int r, int g, int b, int x, int y);
void init_palette(void);
void set_palette(int start, int end, UCHAR *rgb);

/* dsctbl.c */
/// @brief ZOgfBXNv^
/// @note ϐ̏ԂςĂ͂Ȃ
struct SEGMENT_DESCRIPTOR {
	short limit_low;	///< ~bgl(8rbg)
	short base_low;		///< ZOgx[X(8rbg)
	char base_mid;		///< ZOgx[X(8rbg)
	char access_right;	///< (8rbg)
	char limit_high;	///< ~bgl(8rbg)
	char base_high;		///< ZOgx[X(8rbg)
};
/// @brief Q[gfBXNv^
/// @note ϐ̏ԂςĂ͂Ȃ
struct GATE_DESCRIPTOR {
	short offset_low;	///< ItZbgAhX(16rbg)
	short selector;		///< ZN^l(8rbg)
	char dw_count;		///< X^bNRs[JE^(8rbg)
	char access_right;	///< (8rbg)
	short offset_high;	///< ItZbgAhX(16rbg)
};
void init_gdtidt(void);
void set_segmdesc(struct SEGMENT_DESCRIPTOR *sd, UINT32 limit, int base, int ar);
void set_gatedesc(struct GATE_DESCRIPTOR *gd, int offset, int selector, int ar);
#define ADR_IDT			0x0026f800
#define LIMIT_IDT		0x000007ff
#define ADR_GDT			0x00270000
#define LIMIT_GDT		0x0000ffff
#define ADR_BOTPAK		0x00280000
#define LIMIT_BOTPAK	0x0007ffff
#define AR_DATA32_RW	0x4092
#define AR_CODE32_ER	0x409a
#define AR_LDT			0x0082
#define AR_TSS32		0x0089
#define AR_INTGATE32	0x008e

/* int.c */
void init_pic(void);
#define PIC0_ICW1		0x0020
#define PIC0_OCW2		0x0020
#define PIC0_IMR		0x0021
#define PIC0_ICW2		0x0021
#define PIC0_ICW3		0x0021
#define PIC0_ICW4		0x0021
#define PIC1_ICW1		0x00a0
#define PIC1_OCW2		0x00a0
#define PIC1_IMR		0x00a1
#define PIC1_ICW2		0x00a1
#define PIC1_ICW3		0x00a1
#define PIC1_ICW4		0x00a1

/* keyboard.c */
void inthandler21(int *esp);
void wait_KBC_sendready(void);
void init_keyboard(struct FIFO32 *fifo, int data0);
#define PORT_KEYDAT	0x0060
#define PORT_KEYCMD	0x0064

/* mouse.c */
/// @brief }EX̃f[^
struct MOUSE_DEC {
	UCHAR buf[3];	///< 擾f[^
	UCHAR phase;	///< ݂̃tF[Y
	int x;			///< XW
	int y;			///< YW
	int btn;		///< {^̏
};
/// @brief }EX̏(APIp)
struct MINFO {
	int x;			///< wW
	int y;			///< xW
	int button;		///< {^̏
	int state;		///< ̑̏
};
void inthandler2c(int *esp);
void enable_mouse(struct FIFO32 *fifo, int data0, struct MOUSE_DEC *mdec);
int mouse_decode(struct MOUSE_DEC *mdec, UCHAR dat);
extern struct MINFO mf;

/* timer.c */
#define MAX_TIMER 500	///< gp\^C}̍ő吔
/// @brief ̃^C}f[^
struct TIMER {
	struct TIMER *next;		///< ̃^C}
	UINT32 timeout;			///< ^CAEgl
	char flags;				///< ^C}̏
	char flags2;			///< ^C}̏2
	struct FIFO32 *fifo;	///< f[^̑FIFO
	int data;				///< f[^
};
/// @brief ^C}̓
struct TIMERCTL {
	UINT32 count;		///< ^C}荞݃JE^
	UINT32 next;		///< ̃^C}
	struct TIMER *t0;	///< ݂̃^C}
	struct TIMER timers0[MAX_TIMER]; ///< SẴ^C}
};
extern struct TIMERCTL timerctl;
void init_pit(void);
struct TIMER *timer_alloc(void);
void timer_free(struct TIMER *timer);
void timer_init(struct TIMER *timer, struct FIFO32 *fifo, int data);
void timer_settime(struct TIMER *timer, UINT32 timeout);
void inthandler20(int *esp);
int timer_cancel(struct TIMER *timer);
void timer_cancelall(struct FIFO32 *fifo);
void kernel_sleep(UINT32 time);

/* mtask.c */
#define MAX_TASKS		1000	///< gp\^XN̍ő吔
#define TASK_GDT0		3		///< TSSGDT̉Ԃ犄蓖Ă̂
#define MAX_TASKS_LV	100
#define MAX_TASKLEVELS	10
/// @brief TSS32̃f[^
/// @note ϐ̏ԂςĂ͂Ȃ
struct TSS32 {
	int backlink; 	///< obNN̈
	int esp0;		///< x0pESP
	int ss0;		///< x0pSS
	int esp1;		///< x1pESP
	int ss1;		///< x1pSS
	int esp2;		///< x2pESP
	int ss2;		///< x2pSS
	int cr3;		///< CR3
	int eip;		///< EIP
	int eflags;		///< EFLAGS
	int eax;		///< EAX
	int ecx;		///< ECX
	int edx;		///< EDX
	int ebx;		///< EBX
	int esp;		///< ESP
	int ebp;		///< EBP
	int esi;		///< ESI
	int edi;		///< EDI
	int es;			///< ES
	int cs;			///< CS
	int ss;			///< SS
	int ds;			///< DS
	int fs;			///< FS
	int gs;			///< GS
	int ldtr;		///< LDTR
	int iomap;		///< IOMAP
};
/// @brief ̃^XNf[^
struct TASK {
	int sel;  							///< GDT̔ԍ
	int flags;							///< 
	int level; 							///< x
	int priority;						///< Dx	
	struct FIFO32 fifo;					///< FIFO
	struct TSS32 tss;					///< TSS
	int fpu[108 / 4];					///< FPŨf[^
	struct SEGMENT_DESCRIPTOR ldt[2];	///< ZOgfBXNv^
	struct CONSOLE *cons;				///< R\[p
	int ds_base;						///< x[XAhX
	int cons_stack;						///< R\[px[XAhX
	struct FILEHANDLE *fhandle;			///< t@Cnh
	char *cmdline;						///< R}hC
	UCHAR langmode;						///< ꃂ[h
	UCHAR langbyte1;					///< ꕶ̃f[^
	char taskname[64];					///< ^XN
	int id;								///< ^XNID
};
/// @brief ̃x̃^XN̓
struct TASKLEVEL {
	int running;						///< 삵Ă^XN̐
	int now; 							///< ݓ삵Ă^XN
	struct TASK *tasks[MAX_TASKS_LV];	///< ̃xɂ^XN
};
/// @brief Ŝ̃^XN̓
struct TASKCTL {
	int now_lv; 							///< ݓ쒆̃x
	struct TASK *task_fpu;					///< FPU
	char lv_change; 						///< ^XNXCb`̃xύXKvǂ
	struct TASKLEVEL level[MAX_TASKLEVELS]; ///< exTASKLEVEL
	struct TASK tasks0[MAX_TASKS]; 			///< Ŝ̃^XN
};
extern struct TASKCTL *taskctl;
extern struct TIMER *task_timer;
struct TASK *task_now(void);
struct TASK *task_init(void);
struct TASK *task_alloc(void);
void task_run(struct TASK *task, int level, int priority, char *taskname);
void task_switch(void);
void task_sleep(struct TASK *task);
int *inthandler07(int *esp);

/* window.c */
#define CONPACTED_YSIZE		25		///< RpNg̍
void draw_window8(UCHAR *buf, int xsize, int ysize, char *title, char act);
void putfonts8_asc_sht(struct SHEET *sht, int x, int y, int c, int b, char *s, int l);
void draw_textbox8(struct SHEET *sht, int x0, int y0, int sx, int sy, int c);
void draw_wtitle8(UCHAR *buf, int xsize, char *title, char act);
void change_wtitle8(struct SHEET *sht, char act);
struct SHEET *make_window(char *wname, int ww, int wh, int act, int col_inv);
void break_window(struct SHEET *sht);
void compacted_window(struct SHEET *sht, int sw);


/* console.c */
/// @brief R\[̃f[^
struct CONSOLE {
	struct SHEET *sht;		///< R\[̃V[g
	int cur_x; 				///< J[\X
	int cur_y; 				///< J[\Y
	int cur_c;				///< J[\ON/OFF
	struct TIMER *timer;	///< _ŗp^C}
	int ch;					///< ͂Ă镶
};
/// @brief t@Cnh
struct FILEHANDLE {
	char *fname;	///< t@C
	char *buf;		///< f[^
	int size;		///< t@CTCY
	int pos;		///< ǂ܂ꂽ|WV
};
void close_console(struct SHEET *sht);
void close_constask(struct TASK *task);
void console_task(struct SHEET *sheet);
struct TASK *open_constask(struct SHEET *sht);
struct SHEET *open_console(void);
void cons_putchar(struct CONSOLE *cons, int chr, char move);
void cons_newline(void);
void cons_putstr0(struct CONSOLE *cons, char *s);
void cputs0(char *s);
void cons_putstr1(struct CONSOLE *cons, char *s, int l);
void cputs1(char *s, int l);
void cprintf(char *f, ...);
int *inthandler0d(int *esp);
int *inthandler0c(int *esp);
void cons_runcmd(char *cmdline);

/* api.c */
/// @brief DATE\(APIp)
struct DATE {
	int year;		///< 
	int month; 		///< 
	int day;		///< 
	int hour;		///< 
	int minutes;	///< 
	int second;		///< b
};
int *hrb_api(int edi, int esi, int ebp, int esp, int ebx, int edx, int ecx, int eax);

/* command.c */
void cmd_mem(void);
void cmd_cls(void);
void cmd_dir(char *cmdline);
void cmd_exit(void);
void cmd_lmod(char *cmdline);
void cmd_reset(void);
int cmd_app(char *cmdline);
void cmd_tdev(void);
void cmd_ps(void);
void cmd_klog(char *cmdline);
void cmd_kill(char *cmdline);
void cmd_date(char *cmdline);
void cmd_help(void);
void cmd_test(void);
void cmd_tser(char *cmdline);
void cmd_ver(void);
void cmd_bootd(void);
void cmd_hists(void);
void cmd_fctl(char *cmdline);
void cmd_runp(char *cmdline);
void cmd_tpci(char *cmdline);

/* file.c */
#define FILENAME 11
/// @brief ̃t@Cf[^
struct FILEINFO {
	UCHAR name[8];		///< t@C
	UCHAR ext[3];		///< gq
	UCHAR type;			///< t@Cڍ
	char reserve[10];	///< (U[u)
	USHORT time;		///< 
	USHORT date; 		///< t
	USHORT clustno;		///< NX^ԍ
	UINT32 size;		///< t@CTCY
};

void file_readfat(int *fat, UCHAR *img);
void file_writefat(int no, int data);
struct FILEINFO *file_search(char *name, struct FILEINFO *finfo, int max);
char *file_loadfile2(int clustno, int *psize, int *fat);
USHORT file_getfat(int *fat);
void file_setname(struct FILEINFO *finfo, char *name);
int file_removefile(char *filename, int *fat);
struct FILEINFO *file_createfile(char *filename, int *fat);
void file_loadfile(int clustno, int size, char *buf);
void file_writefile(struct FILEINFO *finfo, char *buf, int dsize);
int file_readfont(char *filename, UCHAR *fontbuf);
void write_history(char *cmdline);

/* lock.c */
#define LOCKED_FILE_MAX	256 ///< ő働bNt@C
/// @brief bNĂt@Cf[^
struct LOCKED_FILE {
	UCHAR name[11];		///< t@C
	int flag;			///< ėptO
	int taskid;			///< bNĂ^XNID
	int type;			///< ށit@CA|[gAetcj
};
extern struct LOCKED_FILE locked_files[LOCKED_FILE_MAX];
void init_file_lock(void);
int file_lock(char *fname, int taskid);
int file_unlock(char *fname);
int file_islockedby(char *fname, int taskid);
int file_exist(char *fname);

/* bootpack.c */
#define KEYCMD_LED	0xed 
#define FONTFILE	"nihongo.fnt"
extern int *global_alloc_fat;
extern struct SHEET *global_sht_back;
extern int global_mouse_x, global_mouse_y;
void enable_PICs(void);
void init_run_system(struct TASK *task, struct FIFO32 *fifo);
void alloc_global_fat(void);
void keywin_off(struct SHEET *key_win);
void keywin_on(struct SHEET *key_win);

/* tek.c */
int tek_getsize(UCHAR *p);
int tek_decomp(UCHAR *p, char *q, int size);

/* bmp.nasm */
int info_BMP(struct DLL_STRPICENV *env, int *info, int size, char *fp);
int decode0_BMP(struct DLL_STRPICENV *env, int size, char *fp, int b_type, char *buf, int skip);

/* jpeg.c */
int info_JPEG(struct DLL_STRPICENV *env, int *info, int size, char *fp);
int decode0_JPEG(struct DLL_STRPICENV *env, int size, char *fp, int b_type, char *buf, int skip);

/* pcic.c */
void control_pcic_write(int sn, int reg, UCHAR data);
UCHAR control_pcic_read(int sn, int reg);
int control_pcic_get_maxsocks(void);

/* pci.c */
/// @brief PCĨRtBO[VWX^
typedef struct pci_info {
	int bus;		///< oXԍ
	int dev;		///< foCXԍ
	int reg;		///< WX^AhX
	int func;		///< @\ԍ
} PCI_INFO;
void control_pci_addr_write(PCI_INFO inf);
int control_pci_data_read(int n);
void control_pci_data_write(int n, int data);
char *conv_vendername(int id);
char *conv_devname(int vendid, int devid);

/* sound.c */
int detect_fmchip(void);
void senddata_adlib(int reg, int data);
int readdata_adlib(void);
void test_adlib(void);

/* serial.c */
int serial_getports(void);
int serial_getinfo(int comp, int n);
char *serial_typename(int n);
UINT32 serial_convdiv(int div);
void serial_setmode(int comp, int type, char on);
int init_serialports(int defdiv);
int send_char_serialport(int comp, char c);
int send_string_serialport(int comp, char *string);
int receive_stat_serialport(int comp);
int recv_char_serialport(int comp, char *buf);
void inthandler23(int *esp);
void inthandler24(int *esp);

/* parallel.c */
#define CAN_SEND 0
#define CAN_RECV 0
void set_mode(int pn, int type);
int is_ready(int pn);
void strobing(int pn, int flag);
int wait_busy(int pn, int flag);
char recv_char_parallel(int pn);
int send_char_parallel(int pn, char c);

/* fdc.c */
void fdc_getstat(void);
void fdc_comsend(int data);
char fdc_statread(void);
void run_fdc(void);
void stop_fdc(void);
void inthandler26(int *esp);

/* mpm.c */
extern int there_messagebox;
int scan_char(char *str, char s_str);
void run_mpm(void);
void stop_mpm(void);
void task_mpm(void);
void show_mesbox(char *caption, char *message);
void close_mesbox(void);

/* log.c */
#define DATA_TO_KERNEL	0
#define DATA_TO_DEBUG	1
#define LOG_KERNEL		1
#define LOG_DEBUG		2
void init_log(void);
void show_log(struct CONSOLE *cons, int id);
void logging(int type, char *data, ...);
void debugmsg(char *format, ...);

/* rtc.c */
int getdata_cmos(UCHAR addr);
void writedata_cmos(UCHAR addr, UCHAR dat);
void readdates(UCHAR *a);
void setdates(int year_high, int year_low, int month, 
			int dat, int hour, int mintute, int second);
UINT32 bcdconv(UINT32 in);			
void run_clock(void);
void stop_clock(void);
void clock_task(void);
void clock_refresh(void);

/* taskbar.c */
void init_taskbar(void);
void set_taskbar(int id, char *name);
void delete_taskbar(char *name);

/* bit.c */
int getBit(int n, int by);
void turnBitOn(int n, int by, int *out);
void turnBitOff(int n, int by, int *out);
