/* F֌W */

#include "bootpack.h"

void init_palette(void)
{
	static UCHAR table_rgb[16 * 3] = {
		0x00, 0x00, 0x00,	/*  0: */
		0xff, 0x00, 0x00,	/*  1:邢 */
		0x00, 0xff, 0x00,	/*  2:邢 */
		0xff, 0xff, 0x00,	/*  3:邢F */
		0x00, 0x00, 0xff,	/*  4:邢 */
		0xff, 0x00, 0xff,	/*  5:邢 */
		0x00, 0xff, 0xff,	/*  6:邢F */
		0xff, 0xff, 0xff,	/*  7: */
		0xc6, 0xc6, 0xc6,	/*  8:邢DF */
		0x84, 0x00, 0x00,	/*  9:Â */
		0x00, 0x84, 0x00,	/* 10:Â */
		0x84, 0x84, 0x00,	/* 11:ÂF */
		0x00, 0x00, 0x84,	/* 12:Â */
		0x84, 0x00, 0x84,	/* 13:Â */
		0x00, 0x84, 0x84,	/* 14:ÂF */
		0x84, 0x84, 0x84	/* 15:ÂDF */
	};
	UCHAR table2[216 * 3];
	int r, g, b;
	set_palette(0, 15, table_rgb);
	for (b = 0; b < 6; b++) {
		for (g = 0; g < 6; g++) {
			for (r = 0; r < 6; r++) {
				table2[(r + g * 6 + b * 36) * 3 + 0] = r * 51;
				table2[(r + g * 6 + b * 36) * 3 + 1] = g * 51;
				table2[(r + g * 6 + b * 36) * 3 + 2] = b * 51;
			}
		}
	}
	set_palette(16, 231, table2);
	
	debugmsg("Initialized Color Palette..");
	
	return;
}

void set_palette(int start, int end, UCHAR *rgb)
{
	int i, eflags;
	eflags = io_load_eflags();	/* 荞݋tO̒lL^ */
	io_cli(); 					/* tO0ɂĊ荞݋֎~ɂ */
	io_out8(0x03c8, start);
	for (i = start; i <= end; i++) {
		io_out8(0x03c9, rgb[0] / 4);
		io_out8(0x03c9, rgb[1] / 4);
		io_out8(0x03c9, rgb[2] / 4);
		rgb += 3;
	}
	io_store_eflags(eflags);	/* 荞݋tOɖ߂ */
	return;
}

UCHAR rgb2pal(int r, int g, int b, int x, int y)
{
	static int table[4] = { 3, 1, 0, 2 };
	int i;
	x &= 1; /*  */
	y &= 1;
	i = table[x + y * 2];	/* ԐF邽߂̒萔 */
	r = (r * 21) / 256;	/*  0`20 ɂȂ */
	g = (g * 21) / 256;
	b = (b * 21) / 256;
	r = (r + i) / 4;	/*  0`5 ɂȂ */
	g = (g + i) / 4;
	b = (b + i) / 4;
	return 16 + r + g * 6 + b * 36;
}

