/// @file command.c
/// @brief R\[R}h֌W
/// @author JsZ(is2os)
/// @since 2010-08-23(r41)

#include "bootpack.h"
unsigned long strtoul(const char *s, const char **endp, int base);	// #include <stdlib.h>

/// @brief Xy[Xǂݔ΂
/// @param p ǂݔ΂
/// @return ǂݔ΂ꂽ
char *skipspace(char *p)
{
	for (; *p == ' '; p++) ;
	return p;
}

/// @brief bootdR}h.
///
/// bootinfo̓e\
void cmd_bootd(void)
{
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	
	/* bootinfo */
	cprintf("Read Cyls: %d\nVideo Mode: %d\nDisp Width: %d\nDisp Height: %d\n",
		binfo->cyls, binfo->vmode, binfo->scrnx, binfo->scrny);
	
	/* apm */
	cprintf("APM Version: %d.%d\n", 
		(unsigned)*((int *)APM_VERSION) >> 8,
		(unsigned)*((int *)APM_VERSION) & 0xff);
	
	/* vbe */
	cprintf("VBE Version: %d.%d\n",
		(unsigned)*((int *)VBE_VERSION) >> 8,
		(unsigned)*((int *)VBE_VERSION) & 0xff);
	
	return;
}

/// @brief verR}h.
///
/// o[W\
void cmd_ver(void)
{	
	cprintf("%s\n%s\n", VERSIONDATA_TAG, COPYRIGHTDATA_TAG);
	return;
}

/// @brief testR}h.
///
/// 낢ȃeXgpȂ̂ŁAɌ܂͂ȂB
/// helpR}hłȂƁB
void cmd_test(void)
{
	struct FILEINFO *finfo;
	int j;
	
	/* t@Cďł݂eXg */
	file_createfile("test.txt", global_alloc_fat);
	finfo = file_search("test.txt", (struct FILEINFO *)(ADR_DISKIMG + 0x002600), 224);
	if (finfo) {
		cprintf("clustno = %d\n", finfo->clustno);
		
		/* 1NX^܂ŏ݂ł邩 */
		for (j = 0;j < 402;j++) {
			file_writefile(finfo, "Negitoro", 8);
		}

	}
	
	return;
}

/// @brief fctlR}h.
///
/// t@C̍쐬폜̃t@CɊ֘As
/// @param cmdline R}hC
/// @todo -rnIvV̎
void cmd_fctl(char *cmdline)
{
	int i;
	
	if (!cmdline[0]) {
		cputs0(" usage: >fctl <-new|-del|-rn|-lk|-unlk> ");
		cputs0("              [filename] (filename)");
		cputs0("              <lockedfiles>");
	} else {
		if (!strncmp(cmdline, "-new", 4)) {
			/* t@C쐬 */
			if (!file_createfile(cmdline + 5, global_alloc_fat)) {
				cputs0("Error happened.");
			}			
		} else if (!strncmp(cmdline, "-del", 4)) {
			/* t@C폜 */
			/* VXet@C͏Ȃ */
			if (strcmp(cmdline + 5, SYSTEMFILE_NAME)) {
				if (!file_removefile(cmdline + 5, global_alloc_fat)) ;
				else cputs0("Such file is not found.");
			} else {
				cputs0("You are not allowed to do so.");
			}			
		} else if (!strncmp(cmdline, "-rn", 3)) {
			/* t@C̃l[ */
		} else if (!strncmp(cmdline, "-lk", 3)) {
			/* t@C̃bN */
			if (file_lock(cmdline + 4, task_now()->id)) {
				cprintf("%s is locked.\n", cmdline + 4);
			} else {
				cprintf("%s cannot be locked or is not exist.\n", cmdline + 4);
			}
		} else if (!strncmp(cmdline, "-unlk", 5)) {
			/* t@C̃bN */
			if (file_unlock(cmdline + 6)) {
				cprintf("%s is unlocked.\n", cmdline + 6);
			} else {
				cprintf("%s cannot be unlocked or is not exist.\n", cmdline + 4);
			}
		} else if (!strncmp(cmdline, "lockedfiles", 11)) {
			/* bNꂽt@C̈ꗗ\ */
			for (i = 0;i < LOCKED_FILE_MAX;i++) {
				if (locked_files[i].flag) {
					cprintf("%s(%d)\n", locked_files[i].name,
								locked_files[i].taskid);
				}
			}
		} else {
			cputs0("option error.");
		}
	}
	
	return;
}

/// @brief histsR}h.
///
/// LinuxhistoryR}h݂Ȃ.
/// hists.logt@C\Ă邾.
void cmd_hists(void)
{
	struct FILEINFO *finfo;
	struct TASK *task = task_now();
	int size, j;
	UCHAR *buf;
	
	finfo = file_search(HISTORY_FILE, (struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224);	
	if (finfo) {
		size = finfo->size;
		buf = file_loadfile2(finfo->clustno, &size, global_alloc_fat);
		for (j = 0;j < size;j++) {
			cons_putchar(task->cons, buf[j], 1);
		}
		memman_free_4k(*((UCHAR *)buf), size);
	}
	
	return;
}

/// @brief helpR}h.
///
/// R}hꗗ\
void cmd_help(void)
{
	char help_data[] = "mem cls dir exit lmod klog ver ps runp tpci\n"
						"date kill help reset fctl bootd tser hists";
	
	cputs0(help_data);
	
	return;
}

/// @brief klogR}h.
///
/// J[l̃O\BftHgstdO\B
/// @param cmdline R}hC
void cmd_klog(char *cmdline)
{
	if (!cmdline[0]) {
		goto std_log;
	} else if (cmdline[0] == '?') {
		cputs0(" usage: >klog (opt)");
	} else if (!strcmp(cmdline, "dbg")) {
		cputs0("<< Debug Log >>");
		show_log(task_now()->cons, DATA_TO_DEBUG);
	} else if (!strcmp(cmdline, "std")) {
std_log:
		cputs0("<< Kernel Log >>");
		show_log(task_now()->cons, DATA_TO_KERNEL);
	} else {
		cputs0("option error.");
	}
	
	return;
}

/// @brief dateR}h.
///
/// ݂̓t̕\Ɛݒ
/// @param cmdline R}hC
void cmd_date(char *cmdline)
{
	UCHAR date[7];
	ULONG32 dat[6];
	int b;
	const char *p = cmdline, *q;
	int i;	
	
	if (!cmdline[0]) {
		readdates(date);
		cprintf("%02x%02x/%02x/%02x %02x:%02x:%02x\n", date[6],
				date[5], date[4], date[3], date[2], date[1], date[0]);
	} else if (cmdline[0] == '?') {
		cputs0(" usage: >date (YEAR-MONTH-DAY-HOUR-MINUTE-SECOND)");
	} else {
		/* rtcɏ */
		if (scan_char(cmdline, '-') != 5) {
			goto ferr;
		}
		for (i = 0; i < 6; i++) {
			dat[6-1-i] = strtoul(p, &q, 10);	// year, month, day, hour, minute, second
			if (q == p)
				goto ferr;
			if (i < 6-1) {
				if (*q != '-')
					goto ferr;
				q++;
			}
			p = q;
		}
		if (*p != '\0')
			goto ferr;
		b = dat[5] / 100;
		setdates(b, dat[5] - b * 100, dat[4], dat[3], dat[2], dat[1], dat[0]);
		cputs0("RTC is written.");
		clock_refresh();
	}
	
	goto fin;
ferr:
	cputs0("Format error.");
fin:
	return;
}

/// @brief killR}h.
///
/// w肳ꂽvZXI
/// @param cmdline R}hC
/// @todo R\[ƃAvȊOIł悤ɂ
void cmd_kill(char *cmdline)
{
	ULONG32 id;
	int i;
	
	if (!cmdline[0]) {
		cputs0(" usage: >kill [taskID]");
	} else {
		id = atoi(cmdline);
		if (!id) {
			cputs0("id number is unusual.");
		} else if (id > 32797) {
			cputs0("id number is too large.");
		} else {
			/* taskctl̒IDTċI */
			for (i = 0; i < MAX_TASKS; i++) {
				if (taskctl->tasks0[i].flags) {
					if (taskctl->tasks0[i].id == id) {
						if (taskctl->tasks0[i].cons->sht) {
							/* IiR\[j */
							io_cli();
							fifo32_put(&taskctl->tasks0[i].fifo, 4);
							io_sti();
						} else {
							/* IiAvOŁj */
							io_cli();
							taskctl->tasks0[i].tss.eax = (int)&(taskctl->tasks0[i].tss.esp0);
							taskctl->tasks0[i].tss.eip = (int)asm_end_app;
							io_sti();
							task_run(&taskctl->tasks0[i], -1, 0, taskctl->tasks0[i].taskname);						
						}
						cprintf("%s terminated (%d)\n",
							taskctl->tasks0[i].taskname, taskctl->tasks0[i].id);
						return;
					} 
				}
			}
			cputs0("Such ID is not found.");
		}
	}
	
	return;
}

/// @brief psR}h.
///
/// vZX\
void cmd_ps(void)
{
	int j, i, v;
	char s[128];
	
	cputs0("");
	cputs0("Name            Lv     Pry      ID");
	cputs0("----------------------------------");
	
	for (j = 0;j < MAX_TASKS;j++) {
		if (taskctl->tasks0[j].flags > 0) {

			/* VXe֘AIDB */
			if (!strcmp(taskctl->tasks0[j].taskname, "system") ||
				!strcmp(taskctl->tasks0[j].taskname, "mpm") ||
				!strcmp(taskctl->tasks0[j].taskname, "idle") ||
				!strcmp(taskctl->tasks0[j].taskname, "clock") ||
				!strcmp(taskctl->tasks0[j].taskname, "fdc")) {
				v = 0;
			} else { 
				v = taskctl->tasks0[j].id;
			}
			
			sprintf(s, "xxxxxxxxxx   %5d   %5d   %5d",
				taskctl->tasks0[j].level, taskctl->tasks0[j].priority, v);
			for (i = 0; i < 10; i++) {
				if (!taskctl->tasks0[j].taskname[i]) {
					s[i] = ' ';
				} else {
					s[i] = taskctl->tasks0[j].taskname[i];
				}
			}
			cputs0(s);
		
			/*
			cprintf("%s [%5d, %d, %d]\n",taskctl->tasks0[j].taskname, 
				taskctl->tasks0[j].level, taskctl->tasks0[j].priority, v);
			*/
		}
	}
	
	return;
}

/// @brief tdevR}h.
///
/// eXgpBfoCX֌Ŵ́B
void cmd_tdev(void)
{
	int j, r1, r2;
	
	/* SB16/Adlib */
	cprintf("SB16/Adlib install : ");
	if (detect_fmchip()) { 
		cputs0("Yes");
		cputs0("Sound testing..");
		test_adlib();
	} else {
		cputs0("No");
	}

	/* p|[gTĂ݂ */
	cprintf("\n");
	for (j = 0;j < 3;j++) {
		set_mode(j, CAN_RECV);
		r1 = is_ready(j);
		strobing(j, 0);
		set_mode(j, CAN_SEND);
		r2 = is_ready(j);
		strobing(j, 0);
		cprintf("LPT%d : RECV=%s SEND=%s\n", 
			j + 1, (r1 ? "NO" : "YES"), (r2 ? "NO" : "YES"));
	}
	
	return;
}

/// @brief tpciR}h.
///
/// PCIfoCXɊ֘As
void cmd_tpci(char *cmdline)
{
	int j, vend, devid, ret, flg = 0;
	PCI_INFO inf;
	
	/* 16-bit PCIC */
	cputs0("[16-bit PCIC]");
	for (j = 1;j <= control_pcic_get_maxsocks();j++) {
		cprintf(" Sock %d : ", j);
		switch (control_pcic_read(j, 0x00)) {
			case 0x83: case 0x82: case 0x84: case 0x88: 
			case 0x89: case 0x8a: case 0x8b: case 0x8c:
				cprintf("Exists\n");
				break;
			default:
				cprintf("Not exists\n");
				break;
		}
	}
	
	/* PCI */
	cputs0("[PCI]");
	for (j = 0;j < 0x0100;j++) {
		for (inf.dev = 0;inf.dev < 32;inf.dev++) {
			inf.bus = j;
			inf.reg = 0;
			inf.func = 0;
			control_pci_addr_write(inf);
			ret = control_pci_data_read(1);
			vend = ret & 0xffff;
			devid = (ret >> 16) & 0xffff;
			if (vend == 0xffff) continue;
			cprintf(" ( Bus=%d Dev=%d )\n  VenderName: %s\n  DeviceName: %s\n", j, inf.dev, 
						conv_vendername(vend), conv_devname(vend, devid));
			flg = 1;
		}
	}
	if (!flg) cputs0(" No PCI devices were found.");
	
	return;
}

/// @brief tserR}h.
///
/// gp\ȃVA|[g̈ꗗ\
/// @param cmdline R}hC
/// @todo ʐMxύX̃IvV@\
void cmd_tser(char *cmdline)
{
	int j;
	
	if (!cmdline[0]) {
		for (j = 1;j <= serial_getports();j++) {
			if (serial_getinfo(j, 7)) {
				cprintf("[COM%d] type=%s speed=%u\n    I/O=0x%X lctl=0x%X cpin=0x%X\n", serial_getinfo(j, 4), 
					serial_typename(serial_getinfo(j, 2)), serial_convdiv(serial_getinfo(j, 3)),
					serial_getinfo(j, 1), serial_getinfo(j, 5), serial_getinfo(j, 6));
				cprintf("    LowPowerMode=%d SleepMode=%d\n", serial_getinfo(j, 8), serial_getinfo(j, 9));
			}
		}
	} else if (cmdline[0] == '?') {
		cputs0(" usage: >tser <port> <speed>");
	} else {
		/* ʐMxA[hύX̃IvV@\ */
	}
	
	return;
}

/// @brief resetR}h.
///
/// Rs[^[Zbg
void cmd_reset(void)
{
	cputs0("\nNegitoro is being reseted...");
	kernel_sleep(200);
	
	/* ő̃^XNXgbv鏈Kv */
	
	wait_KBC_sendready();
	io_out8(PORT_KEYCMD, 0xfe);
	for (;;) io_hlt();
	return;
}

/// @brief memR}h.
///
/// gp\Ǝc胁\
void cmd_mem(void)
{
	cprintf("total   %dMB\nfree %dKB\n", 
			get_totalmem() / (1024 * 1024), 
			memman_total((struct MEMMAN *) MEMMAN_ADDR) / 1024);
	return;
}

/// @brief clsR}h.
///
/// ʂ
void cmd_cls(void)
{
	int x, y;
	struct SHEET *sheet = task_now()->cons->sht;
	
	for (y = 28; y < 28 + 343; y++) {
		for (x = 8; x < 8 + 524; x++) {
			sheet->buf[x + y * sheet->bxsize] = COL8_000000;
		}
	}
	sheet_refresh(sheet, 8, 28, 8 + 524, 28 + 343);
	task_now()->cons->cur_y = 28;
	
	return;
}

/// @brief dirR}h.
///
/// t@CT[`@\ځBChJ[hȂĂ͎̂g܂B
/// @param cmdline R}hC
void cmd_dir(char *cmdline)
{
	struct FILEINFO *finfo = (struct FILEINFO *) (ADR_DISKIMG + 0x002600);
	int i, j;
	char s[30];
	
	if (!cmdline[0]) {
		for (i = 0; i < 224; i++) {
			if (finfo[i].name[0] == 0x00) {
				break;
			}
			if (finfo[i].name[0] != 0xe5) {
				if ((finfo[i].type & 0x18) == 0) {
					sprintf(s, "filename.ext   %7d", finfo[i].size);
					for (j = 0; j < 8; j++) {
						s[j] = finfo[i].name[j];
					}
					s[ 9] = finfo[i].ext[0];
					s[10] = finfo[i].ext[1];
					s[11] = finfo[i].ext[2];
					cputs0(s);
				}
			}
		}
	} else if (cmdline[0] == '?') {
		cputs0(" usage: >dir (filename)");
	} else {
		finfo = file_search(cmdline, (struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224);
		if (finfo) {
			sprintf(s, "filename.ext   %7d", finfo->size);
			for (j = 0; j < 8; j++) {
				s[j] = finfo->name[j];
			}
			s[ 9] = finfo->ext[0];
			s[10] = finfo->ext[1];
			s[11] = finfo->ext[2];
			cputs0("The file is found.\n");
			cputs0(s);			
		} else {
			cputs0("Such file is not found.");
		}
	}
	
	return;
}

/// @brief exitR}h.
///
/// R\[
void cmd_exit(void)
{
	struct TASK *task = task_now();
	struct SHTCTL *shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
	struct FIFO32 *fifo = (struct FIFO32 *) *((int *) 0x0fec);
	struct CONSOLE *cons = task_now()->cons;
	
	/* R\[łȂΉȂ */
	if (!task_now()->cons) return;
	
	if (cons->sht != 0) {
		timer_cancel(cons->timer);
	}
	io_cli();
	if (cons->sht != 0) {
		fifo32_put(fifo, cons->sht - shtctl->sheets0 + 768);	/* 768`1023 */
	} else {
		fifo32_put(fifo, task - taskctl->tasks0 + 1024);	/* 1024`2023 */
	}
	io_sti();
	for (;;) {
		task_sleep(task);
	}
	
	return;
}

/// @brief runpR}h.
///
/// Av̎sɊ֘As
/// @param cmdline R}hC
void cmd_runp(char *cmdline)
{
	struct SHTCTL *shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
	struct TASK *task;
	struct SHEET *sht;
	struct FIFO32 *fifo;
	int i;

	if (!cmdline[0]) {
		cputs0(" usage: >runp <-nc> [appname]");
	} else {
		if (!strncmp(cmdline, "-nc", 3)) {
			/* R\[ŋN */
			task = open_constask(0);
			fifo = &task->fifo;
			if (!cmdline[4]) {
				cputs0("option error.");
				return;
			}
			for (i = 4; cmdline[i] != 0; i++) {
				fifo32_put(fifo, cmdline[i] + 256);
			}
			fifo32_put(fifo, 10 + 256);				
		} else {
			/* R\[LŋN */
			sht = open_console();
			fifo = &sht->task->fifo;
			sheet_slide(sht, 52, 74);
			sheet_updown(sht, shtctl->top);
			for (i = 0; cmdline[i] != 0; i++) {
				fifo32_put(fifo, cmdline[i] + 256);
			}
			fifo32_put(fifo, 10 + 256);	
			if(shtctl->active) {
				keywin_off(shtctl->active);
			}
			keywin_on(sht);
		}
	}
	
	return;
}

/// @brief lmodR}h.
///
/// ꃂ[hύX
/// @param cmdline R}hC
void cmd_lmod(char *cmdline)
{
	struct TASK *task = task_now();
	UCHAR mode;
	
	if (!cmdline[0]) {
		cputs0(" usage: >lmod [langmode]");
	} else {
		mode = atoi(cmdline);
		switch (mode) {
			case 0: cputs0("Set to English ASCII."); break;
			case 1: cputs0("Set to Japanese SHIFT JIS."); break;
			case 2: cputs0("Set to Japanee EUC."); break;
			default: cputs0("Mode number error."); return;
		}
		task->langmode = mode;
	}
	
	return;
}

/// @brief Avs
/// @param cmdline R}hC
/// @return Avł0AłȂ1
int cmd_app(char *cmdline)
{
	struct FILEINFO *finfo;
	char name[18], *p, *q, buf[64];
	struct TASK *task = task_now();
	int i, segsiz, datsiz, esp, dathrb, appsiz;
	struct SHTCTL *shtctl;
	struct SHEET *sht;

	/* R}hCt@C𐶐 */
	for (i = 0; i < 13; i++) {
		if (cmdline[i] <= ' ') {
			break;
		}
		name[i] = cmdline[i];
	}
	name[i] = 0;

	
	/* t@CT */
	finfo = file_search(name, (struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224);
	if (finfo == 0 && name[i - 1] != '.') {
		/* Ȃ̂Ō".nxe"ĂxTĂ݂ */
		name[i    ] = '.';
		name[i + 1] = 'N';
		name[i + 2] = 'X';
		name[i + 3] = 'E';
		name[i + 4] = 0;
		finfo = file_search(name, (struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224);
	}

	if (finfo != 0) {
		/* t@Cꍇ */
		appsiz = finfo->size;
		p = file_loadfile2(finfo->clustno, &appsiz, global_alloc_fat);
		if (appsiz >= 36 && strncmp(p + 4, "Negi", 4) == 0 && *p == 0x00) {
			segsiz = *((int *) (p + 0x0000));
			esp    = *((int *) (p + 0x000c));
			datsiz = *((int *) (p + 0x0010));
			dathrb = *((int *) (p + 0x0014));

			sprintf(buf, "%s is executed. (esp=%08X)", name, esp);
			logging(LOG_KERNEL, buf);
			
			q = (char *) memman_alloc_4k(segsiz);
			task->ds_base = (int) q;
			set_segmdesc(task->ldt + 0, appsiz - 1, (int) p, AR_CODE32_ER + 0x60);
			set_segmdesc(task->ldt + 1, segsiz - 1, (int) q, AR_DATA32_RW + 0x60);
			for (i = 0; i < datsiz; i++) {
				q[esp + i] = p[dathrb + i];
			}
			start_app(0x1b, 0 * 8 + 4, esp, 1 * 8 + 4, &(task->tss.esp0));
			shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
			for (i = 0; i < MAX_SHEETS; i++) {
				sht = &(shtctl->sheets0[i]);
				if ((sht->flags & 0x11) == 0x11 && sht->task == task) {
					/* AvJςȂɂ𔭌 */
					sheet_free(sht);	/*  */
				}
			}
			for (i = 0; i < 8; i++) {	/* N[YĂȂt@CN[Y */
				if (task->fhandle[i].buf != 0) {
					memman_free_4k((int) task->fhandle[i].buf, task->fhandle[i].size);
					task->fhandle[i].buf = 0;
				}
			}
			timer_cancelall(&task->fifo);
			memman_free_4k((int) q, segsiz);
			task->langbyte1 = 0;
		} else {
			cputs0(".nxe file format error.");
		}
		memman_free_4k((int) p, appsiz);
		return 1;
	}
	
	/* t@CȂꍇ */
	return 0;
}


