/// @file console.c
/// @brief R\[֌W
/// @author JsZ(is2os)

#include <stdarg.h>
#include "bootpack.h"

/// @brief R\[^XNN
///
/// R\[̃^XN݂̂NAEBhE͍Ȃ.
/// @param sht 蓖ĂV[g
/// @return NR\[̃^XN
struct TASK *open_constask(struct SHEET *sht)
{
	struct TASK *task = task_alloc();
	int *cons_fifo = (int *) memman_alloc_4k(128 * 4);
	
	task->cons_stack = memman_alloc_4k(64 * 1024);
	task->tss.esp = task->cons_stack + 64 * 1024 - 8;
	task->tss.eip = (int) &console_task;
	task->tss.es = 1 * 8;
	task->tss.cs = 2 * 8;
	task->tss.ss = 1 * 8;
	task->tss.ds = 1 * 8;
	task->tss.fs = 1 * 8;
	task->tss.gs = 1 * 8;
	*((int *) (task->tss.esp + 4)) = (int) sht;
	task_run(task, 2, 2, "shell"); /* level=2, priority=2 */
	fifo32_init(&task->fifo, 128, cons_fifo, task);
	
	return task;
}

/// @brief R\[̃EBhE쐬
///
///  ::open_constask Ăł̂
/// Ƀ^XNĂ
/// @return ꂽEBhẼV[g
struct SHEET *open_console(void)
{
	struct SHEET *sht;
	
	sht = make_window("System Shell", 540, 380, 0, -1);
	draw_textbox8(sht, 8, 28, 524, 343, COL8_000000);
	set_taskbar(sht->id, "System Shell");
	sht->task = open_constask(sht);
	sht->flags |= 0x20;	/* J[\ */
	sht->ktype = KERNELWINDOW_CONS;
	
	return sht;
}

/// @brief R\[̃^XNI
///
/// ::task->cons_stack ̊JsĂ
/// @param task R\[̃^XN
void close_constask(struct TASK *task)
{
	task_sleep(task);
	memman_free_4k(task->cons_stack, 64 * 1024);
	memman_free_4k((int) task->fifo.buf, 128 * 4);
	task->flags = 0; /* task_free(task); ̑ */
	
	return;
}

/// @brief R\[̃EBhE
/// 
///  ::close_constask Ăł̂
/// Ƀ^XNIĂ
/// @param sht R\[̃V[g
void close_console(struct SHEET *sht)
{	
	memman_free_4k((int)sht->buf, 540 * 380);
	sheet_free(sht);
	close_constask(sht->task);
	return;
}

/// @brief R\[{̂̃^XN
/// @param sheet R\[̃V[g
void console_task(struct SHEET *sheet)
{
	struct TASK *task = task_now();
	int i;
	struct CONSOLE cons;
	struct FILEHANDLE fhandle[8];
	struct FILEINFO *finfo;
	char cmdline[256];
	UCHAR *nihongo = (char *) *((int *) 0x0fe8);
	
	cons.sht = sheet;
	cons.cur_x =  8;
	cons.cur_y = 28;
	cons.cur_c = -1;
	task->cons = &cons;
	task->cmdline = cmdline;
	cons.ch = 0;
	
	if (cons.sht != 0) {
		cons.timer = timer_alloc();
		timer_init(cons.timer, &task->fifo, 1);
		timer_settime(cons.timer, 50);
	}

	for (i = 0; i < 8; i++) {
		fhandle[i].buf = 0;	/* gp}[N */
	}
	task->fhandle = fhandle;
	if (nihongo[4096] != 0xff) {	/* {tHgt@Cǂݍ߂H */
		task->langmode = 1;
	} else {
		task->langmode = 0;
	}
	task->langbyte1 = 0;
	
	/* EFJbZ[W\ */
	cputs0("<< Welcome to System Shell >>");
	cputs0("Tip: you can see command lists by executing \"help\"");
	cons_newline();
	
	/* vvg\ */
	cons_putchar(&cons, '>', 1);
	
	/* histsR}hp */
	finfo = file_search(HISTORY_FILE, (struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224);
	if (!finfo) {
		file_createfile(HISTORY_FILE, global_alloc_fat);
	}
	
	for (;;) {
		io_cli();
		if (fifo32_status(&task->fifo) == 0) {
			task_sleep(task);
			io_sti();
		} else {
			i = fifo32_get(&task->fifo);
			io_sti();
			if (i <= 1 && cons.sht != 0) { /* J[\p^C} */
				if (i != 0) {
					timer_init(cons.timer, &task->fifo, 0); /* 0 */
					if (cons.cur_c >= 0) {
						cons.cur_c = COL8_FFFFFF;
					}
				} else {
					timer_init(cons.timer, &task->fifo, 1); /* 1 */
					if (cons.cur_c >= 0) {
						cons.cur_c = COL8_000000;
					}
				}
				timer_settime(cons.timer, 50);
			}
			if (i == 2) {	/* J[\ON */
				cons.cur_c = COL8_FFFFFF;
			}
			if (i == 3) {	/* J[\OFF */
				if (cons.sht != 0) {
					boxfill8(cons.sht->buf, cons.sht->bxsize, COL8_000000,
						cons.cur_x, cons.cur_y, cons.cur_x + 7, cons.cur_y + 15);
				}
				cons.cur_c = -1;
			}
			if (i == 4) {	/* R\[́u~v{^NbN */
				cmd_exit();
			}
			if (256 <= i && i <= 511) { /* L[{[hf[^i^XNAoRj */
				if (i == 8 + 256) {
					/* obNXy[X */
					if (cons.ch > 0) {
						if (cons.cur_y >= 16 && cons.cur_x <= 8) {
							cons_putchar(&cons, ' ', 0);
							cons.cur_y -= 16;
							cons.cur_x = 524 - 4;
						} else {
							cons_putchar(&cons, ' ', 0);
							cons.cur_x -= 8;
						}	
						cons.ch--;
					}
				} else if (i == 10 + 256) {
					/* Enter */			
					cons_putchar(&cons, ' ', 0);
					cmdline[cons.ch] = 0;
					cons_newline();
					cons_runcmd(cmdline);
					if (cons.sht == 0) {
						cmd_exit();
					}
					
					/* R}hCobt@͏Ă */
					memset(cmdline, 0, 256);
					
					cons_putchar(&cons, '>', 1);
					cons.ch = 0;
				} else {
					/* ʕ */
					if (cons.cur_x < 520 + 8) {
						/* ꕶ\ĂAJ[\1i߂ */
						/* 256𒴂Ȃ */
						if (cons.ch <= 256) {
							cmdline[cons.ch] = i - 256;
							cons_putchar(&cons, i - 256, 1);
							cons.ch++;
						}
					} else if (cons.cur_x <= 520) {
						if (cons.cur_y >= 320) {
							cons_newline();
						}  else {
							cons.cur_x = 8;
							cons.cur_y += 16;	
						}
					}
				}
			}
			/* J[\ĕ\ */
			if (cons.sht != 0) {
				if (cons.cur_c >= 0) {
					boxfill8(cons.sht->buf, cons.sht->bxsize, cons.cur_c, 
						cons.cur_x, cons.cur_y, cons.cur_x + 7, cons.cur_y + 15);
				}
				sheet_refresh(cons.sht, cons.cur_x, cons.cur_y, cons.cur_x + 8, cons.cur_y + 16);
			}
		}
	}
}

/// @brief o
/// @param cons o͂R\[
/// @param chr o͂镶
/// @param move J[\̓
void cons_putchar(struct CONSOLE *cons, int chr, char move)
{
	char s[2];
	s[0] = chr;
	s[1] = 0;
	
	if (s[0] == 0x09) {	/* ^u */
		for (;;) {
			if (cons->sht != 0) {
				putfonts8_asc_sht(cons->sht, cons->cur_x, cons->cur_y, COL8_FFFFFF, COL8_000000, " ", 1);
			}
			cons->cur_x += 8;
			if (cons->cur_x == 8 + /*240*/524) {
				cons_newline();
			}
			if (((cons->cur_x - 8) & 0x1f) == 0) {
				break;	/* 32Ŋ؂ꂽbreak */
			}
		}
	} else if (s[0] == 0x0a || s[0] == '\n') {	/* s */
		cons_newline();
	} else if (s[0] == 0x0d) {	/* A */
		/* Ƃ肠ȂɂȂ */
	} else {	/* ʂ̕ */
		if (cons->sht != 0) {
			putfonts8_asc_sht(cons->sht, cons->cur_x, cons->cur_y, COL8_FFFFFF, COL8_000000, s, 1);
		}
		if (move != 0) {
			/* move0̂Ƃ̓J[\i߂Ȃ */
			cons->cur_x += 8;
			if (cons->cur_x == 520 + 8/*8 + 240*/) {
				if (cons->cur_y >= 320) {
					cons_newline();
				} else {
					cons->cur_x = 8;
					cons->cur_y += 16;					
				}
			}
		}
	}
	
	return;
}

/// @brief s
/// @param cons sR\[
void cons_newline(void)
{
	int x, y;
	struct SHEET *sheet;
	struct TASK *task = task_now();
	struct CONSOLE *cons;
	
	if (!task->cons) return;
	sheet = task->cons->sht;
	cons = task->cons;
	
	if (cons->cur_y < 28 + 320) {
		cons->cur_y += 16; /* ̍s */
	} else {
		/* XN[ */
		if (sheet != 0) {
			for (y = 28; y < 28 + 320; y++) {
				for (x = 8; x < 8 + 524; x++) {
					sheet->buf[x + y * sheet->bxsize] = sheet->buf[x + (y + 16) * sheet->bxsize];
				}
			}
			for (y = 28 + 320; y < 28 + 343; y++) {
				for (x = 8; x < 8 + 524; x++) {
					sheet->buf[x + y * sheet->bxsize] = COL8_000000;
				}
			}
			sheet_refresh(sheet, 8, 28, 8 + 524, 28 + 343);
		}
	}
	cons->cur_x = 8;
	if (task->langmode == 1 && task->langbyte1 != 0) {
		cons->cur_x = 16;
	}
	
	return;
}

/// @brief R\[ɕo
/// @param cons o͂R\[
/// @param s o͂镶
void cons_putstr0(struct CONSOLE *cons, char *s)
{
	for (; *s != 0; s++) {
		cons_putchar(cons, *s, 1);
	}
	return;
}

/// @brief ݂̃^XNR\[̂Ƃɕo͂ĉs
/// @param s o͂镶
/// @note R\[łȂΉȂ
void cputs0(char *s)
{
	struct TASK *task = task_now();
	
	if (!task->cons) return;
	cons_putstr0(task->cons, s);
	cons_putstr0(task->cons, "\n");
	
	return;
}

/// @brief ݂̃^XNR\[̂ƂɃtH[}bgwq܂ޕo
/// @param f tH[}bgwq܂ޕ
/// @note R\[łȂΉȂ
void cprintf(char *f, ...)
{
	va_list ap;
	char s[256];
	struct TASK *task = task_now();
	
	if (!task->cons) return;
	va_start(ap, f);
	vsprintf(s, f, ap);
	cons_putstr0(task->cons, s);
	va_end(ap);
	
	return;
}

/// @brief w肵ăR\[ɕo
/// @param cons o͂R\[
/// @param s o͂镶
/// @param l o͂镶
void cons_putstr1(struct CONSOLE *cons, char *s, int l)
{
	int i;
	
	for (i = 0; i < l; i++) {
		cons_putchar(cons, s[i], 1);
	}
	
	return;
}

/// @brief ݂̃^XNR\[̂Ƃɕw肵ďo͂ĉs
/// @param s o͂镶
/// @param l o͂镶
/// @note R\[łȂΉȂ
void cputs1(char *s, int l)
{
	struct TASK *task = task_now();
	
	if (!task->cons) return;
	cons_putstr1(task->cons, s, l);
	cons_putstr0(task->cons, "\n");
	
	return;	
}

/// @brief X^bNO̊荞݃nh
/// @param esp ESP
/// @return esp0ւ̃AhX?
int *inthandler0c(int *esp)
{
	struct TASK *task = task_now();
	char s[256];

	sprintf(s, "This application makes Stack exception!(INT 0x0C)\n[ EIP Address = %08X ]", esp[11]);
	show_mesbox("Error", s);
	logging(LOG_KERNEL, "%s : Stack exception (%08X)", task->taskname, esp[11]);
	
	return &(task->tss.esp0);	/* ُI */
}

/// @brief ʕیO̊荞݃nh
/// @param esp ESP
/// @return esp0ւ̃AhX?
int *inthandler0d(int *esp)
{
	struct TASK *task = task_now();
	char s[256];
	
	sprintf(s, "This application makes General Protected Exception!(INT 0x0D)\n[ EIP Address = %08X ]", esp[11]);
	show_mesbox("Error", s);
	logging(LOG_KERNEL, "%s : General protected exception (%08X)", task->taskname, esp[11]);
	
	return &(task->tss.esp0);	/* ُI */
}

/// @brief R}hC
/// @param cmdline R}hC
/// @param cons ̃R\[
void cons_runcmd(char *cmdline)
{
	int i;
	char name[256], *argw;
	struct CONSOLE *cons;
	struct TASK *task = task_now();
	
	/* R}hCR}h𐶐 */
	for (;*cmdline == ' ';cmdline++);
	for (i = 0; i < 256; i++) {
		if (cmdline[i] <= ' ') {
			name[i] = 0;
			break;
		} else if (cmdline[i] == 0) {
			break;
		}
		name[i] = cmdline[i];
	}
	
	/*  */
	argw = (char *)(cmdline + i);
	for (;*argw == ' ';argw++);
	
	/* ^XNR\[łȂ΃_ */
	if (!task->cons) return;
	cons = task->cons;

	/* R}hCɑ݂ */
	if (cmdline[0]) write_history(cmdline);
	
	/* R}h */
	if (!strcmp(name, "mem") && cons->sht) cmd_mem();
	else if (!strcmp(name, "cls") && cons->sht) cmd_cls();
	else if (!strcmp(name, "dir") && cons->sht) cmd_dir(argw);
	else if (!strcmp(name, "exit") && cons->sht) cmd_exit();
	else if (!strcmp(name, "lmod") && cons->sht) cmd_lmod(argw);
	else if (!strcmp(name, "reset") && cons->sht) cmd_reset();
	else if (!strcmp(name, "tdev") && cons->sht) cmd_tdev();
	else if (!strcmp(name, "ps") && cons->sht) cmd_ps();
	else if (!strcmp(name, "klog") && cons->sht) cmd_klog(argw);
	else if (!strcmp(name, "date") && cons->sht) cmd_date(argw);
	else if (!strcmp(name, "tser") && cons->sht) cmd_tser(argw);
	else if (!strcmp(name, "kill") && cons->sht) cmd_kill(argw);
	else if (!strcmp(name, "help") && cons->sht) cmd_help();
	else if (!strcmp(name, "test") && cons->sht) cmd_test();
	else if (!strcmp(name, "ver") && cons->sht) cmd_ver();
	else if (!strcmp(name, "bootd") && cons->sht) cmd_bootd();
	else if (!strcmp(name, "hists") && cons->sht) cmd_hists();
	else if (!strcmp(name, "fctl") && cons->sht) cmd_fctl(argw);
	else if (!strcmp(name, "runp") && cons->sht) cmd_runp(argw);
	else if (!strcmp(name, "tpci") && cons->sht) cmd_tpci(argw);
	else if (cmdline[0]) {
		if (cmd_app(cmdline) == 0) { 
			/* R}hł͂ȂAAvłȂAɋsłȂ */
			cputs0("It may be wrong command or an unexisting file.");
		}
	}
	
	if (cmdline[0]) cons_newline();
	return;
}

