/// @file fifo.c
/// @brief FIFO֘A.
///
/// FIFOւ̃f[^MȂǂs
/// @author JsZ
/// @since 2010-08-23(r41)

#include "bootpack.h"

#define FLAGS_OVERRUN 0x0001 ///< obt@I[o[

/// @brief FIFOobt@̏
/// @param fifo FIFO
/// @param size TCY
/// @param buf f[^ۑ
/// @param task 蓖Ă^XN
void fifo32_init(struct FIFO32 *fifo, int size, int *buf, struct TASK *task)
{
	fifo->size = size;
	fifo->buf = buf;
	fifo->free = size; /*  */
	fifo->flags = 0;
	fifo->sw = TRUE; /* Mɐݒ */
	fifo->p = 0; /* ݈ʒu */
	fifo->q = 0; /* ǂݍ݈ʒu */
	fifo->task = task; /* f[^ƂɋN^XN */
	return;
}

/// @brief FIFOփf[^𑗂荞Œ~
/// @param fifo FIFO
/// @param data f[^
/// @return I[o[̏ꍇɂ-1Ԃ
int fifo32_put(struct FIFO32 *fifo, int data)
{
	if (!fifo->sw) {
		/* Msɐݒ肳Ă */
		return 0;
	}
	if (fifo->free == 0) {
		/* 󂫂ȂĂӂꂽ */
		fifo->flags |= FLAGS_OVERRUN;
		return -1;
	}
	fifo->buf[fifo->p] = data;
	fifo->p++;
	if (fifo->p == fifo->size) {
		fifo->p = 0;
	}
	fifo->free--;
	if (fifo->task != 0) {
		/* ^XNQĂN */
		if (fifo->task->flags != 2) {
			task_run(fifo->task, -1, 0, fifo->task->taskname);
		}
	}
	return 0;
}

/// @brief FIFOf[^ƂĂ
/// @param fifo ɍsFIFO
/// @return ̏ꍇ-1Ԃ
int fifo32_get(struct FIFO32 *fifo)
{
	int data;
	if (fifo->free == fifo->size) {
		/* obt@ۂ̂Ƃ́AƂ肠-1Ԃ */
		return -1;
	}
	data = fifo->buf[fifo->q];
	fifo->q++;
	if (fifo->q == fifo->size) {
		fifo->q = 0;
	}
	fifo->free++;
	return data;
}

/// @brief ǂ̂炢f[^܂Ă邩mF
/// @param fifo mFFIFO
/// @return ܂Ăf[^
int fifo32_status(struct FIFO32 *fifo)
{
	return fifo->size - fifo->free;
}

/// @brief FIFOւ̃f[^Mۂ𑀍
/// @param fifo ΏFIFO
/// @param sw MON/OFF
void fifo32_switch(struct FIFO32 *fifo, int sw)
{
	if (sw) fifo->sw = TRUE;
	else fifo->sw = FALSE;
	return;
}
