/// @file file.c
/// @brief t@C֌W
/// @author JsZ(is2os)
/// @since 2010-08-23(r41)
/// @todo file_writefile by JsZ

#include "bootpack.h"

/// @brief fBXNC[WFAT̈kƂ
/// @param fat kƂFAT
/// @param img fBXNC[W̃AhX
void file_readfat(int *fat, UCHAR *img)
{
	int i, j = 0;
	
	for (i = 0; i < 2880; i += 2) {
		fat[i + 0] = (img[j + 0]      | img[j + 1] << 8) & 0xfff;
		fat[i + 1] = (img[j + 1] >> 4 | img[j + 2] << 4) & 0xfff;
		j += 3;
	}
	
	return;
}

/// @brief FATɃf[^.
///
/// TbitOS痬pBdg݂͗ǂȂB
/// @param no FAT̂ǂ
/// @param data ރf[^
void file_writefat(int no, int data)
{
	UCHAR *img = (UCHAR *)(ADR_DISKIMG + FAT_ADDR);
	int i = no / 2, j, k;

	/* C[WɃf[^ */
	global_alloc_fat[no] = data;

	if((no & 1) == 0) {	/* noȂÔ̂ƈꏏɍXV */
		j = global_alloc_fat[no - 1];
		k = global_alloc_fat[no];
	} else {	/* noȂ̂̂ƈꏏɍXV */
		j = global_alloc_fat[no];
		k = global_alloc_fat[no + 1];
	}

	/* }X^XV */
	img[i * 3] = (UCHAR) (j & 0x0ff);
	img[i * 3 + 1] = (UCHAR) ((k & 0x00f) << 4 | (j & 0xf00) >> 8);
	img[i * 3 + 2] = (UCHAR) ((k & 0xff0) >> 4);

	/* X[uXV */
	img[2880 + i * 3] = img[i * 3];
	img[2880 + i * 3 + 1] = img[i * 3 + 1];
	img[2880 + i * 3 + 2] = img[i * 3 + 1];
	
	return;
}

/// @brief FAT擾
/// @param fat 擾FAT
/// @return 擾łȂ0Ał炻ȊO
USHORT file_getfat(int *fat)
{
	int i;

	for (i = 0; i < 2880; i++) {
		if (fat[i] == 0) {
			fat[i] = 0x1000;
			return i;
		}
	}

	return 0;
}

/// @brief t@Cݒ
/// @param finfo ݒ肷t@C
/// @param name t@C
void file_setname(struct FILEINFO *finfo, char *name)
{
	int i, j;
	UCHAR s[12];
	
	for (i = 0; i < 11; i++) { s[i] = ' '; }
	i = 0;
	for (j = 0; name[j] != 0; j++) {
		if (i >= 11) { return; }
		if (name[j] == '.' && j <= 8) {
			i = 8;
		} else {
			s[i] = name[j];
			if ('a' <= s[i] && s[i] <= 'z') { s[i] -= 0x20; }
			i++;
		}
	}
	for (i = 0; i < 11; i++) { finfo->name[i] = s[i]; }
	
	return;
}

/// @brief w肵t@C폜
/// @param filename t@C
/// @param fat FAT
/// @return 폜ł0AłȂ1
int file_removefile(char *filename, int *fat)
{
	struct FILEINFO *finfo;

	if (!file_islockedby(filename, task_now()->id)) {
		return 1;
	}
	
	finfo = file_search(filename, (struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224);
	if (finfo != 0) {
		if ((finfo->type & 0x18) == 0) {
			io_cli();
			finfo->name[0] = 0xe5;	/* 폜 */
			file_writefat(finfo->clustno, 0x0000);
			io_sti();
		}
		return 0;
	}
	
	return 1;
}

/// @brief t@C쐬
/// @param filename t@C
/// @param fat FAT
/// @return 쐬łȂ0Ał炻ȊO
struct FILEINFO *file_createfile(char *filename, int *fat)
{
	struct FILEINFO *finfo = (struct FILEINFO *) (ADR_DISKIMG + 0x002600);
	int i;
	
	/* t@C̖ꏊT */
	for (i = 0;i < 224;i++) {
		if (finfo[i].type == 0x00 || finfo[i].name[0] == 0xe5) {
			/* t@C쐬 */
			io_cli();
			file_setname(finfo + i, filename);
			finfo[i].size = 0;
			finfo[i].type = 0x20;
			finfo[i].clustno = file_getfat(fat);
			file_writefat(finfo[i].clustno, 0x0fff);
			io_sti();
			return finfo + i;
		}
	}
	
	return 0;	
}

/// @brief t@C֏
/// @param finfo ރt@C
/// @param buf ރf[^
/// @param dsize ރTCY
/// @todo ƌՂR[hɂ
/// @attention KĂяoOŃt@CbNƃAbN邱
void file_writefile(struct FILEINFO *finfo, char *buf, int dsize)
{
	int i, j = 0, l, ncno = 0, nsize, cn = finfo->clustno;
	char *img = (char *)(ADR_DISKIMG + 0x003e00);
	
	/* Ƃ肠̂Ƃ̓AbvGh */
	
	for (;;) {
		/* 512oCgȏ̂ƂfatHȂ */
		/* ȉɂȂ甲 */
		nsize = finfo->size;
		if (dsize <= 512) {
			for (i = 0, j = 0;i < dsize;i++, j++) {
				if (nsize + i >= 512) {
					for (l = 0;nsize >= 512;nsize -= 512, l++) ;
					for (;l > 0;l--) {
						if (global_alloc_fat[cn] >= 0x0ff8) {
							file_writefat(cn, 0x0fff);
							ncno = file_getfat(global_alloc_fat);
							file_writefat(cn, ncno);
						} 
						cn = global_alloc_fat[cn];
					}
					j = 0;
				}
				img[cn * 512 + j + nsize] = buf[i];
			}
			finfo->size += dsize;
			if (global_alloc_fat[cn] == 0x1000) {
				file_writefat(cn, 0x0fff);
			}
			break;
		}
		
		for (i = 0;i < 512;i++) {
			img[cn * 512 + i + finfo->size] = buf[i];
		}
		dsize -= 512;
		buf += 512;	
		finfo->size += 512;
		cn = global_alloc_fat[cn];
	}
		
	return;
}

/// @brief t@Cǂ
/// @param clustno NX^io[
/// @param size ǂރTCY
/// @param buf ǂ񂾃f[^̕ۑ
/// @attention KĂяoOŃt@CbNƃAbN邱
void file_loadfile(int clustno, int size, char *buf)
{
	int i;
	char *img = (char *)(ADR_DISKIMG + 0x003e00);
	
	for (;;) {
		if (size <= 512) {
			for (i = 0; i < size; i++) {
				buf[i] = img[clustno * 512 + i];
			}
			break;
		}
		for (i = 0; i < 512; i++) {
			buf[i] = img[clustno * 512 + i];
		}
		size -= 512;
		buf += 512;
		clustno = global_alloc_fat[clustno];
	}
	
	return;
}

/// @brief hists.logt@CɋL^
///
/// histsR}hp.
/// ȊOł͎gȂ.
/// @param com ރR}hC
/// @note t@C΁Aɍ쐬.
void write_history(char *cmdline)
{
	struct FILEINFO *finfo;
	char s[256];
	
	if (!file_exist(HISTORY_FILE)) {
		file_createfile(HISTORY_FILE, global_alloc_fat);
	}
	finfo = file_search(HISTORY_FILE, (struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224);
	sprintf(s, "%s\n", cmdline);
	
	if (file_lock(HISTORY_FILE, task_now()->id)) {
		file_writefile(finfo, s, strlen(s));
		file_unlock(HISTORY_FILE);
	}
	
	return;
}

/// @brief t@CT
/// @param name t@C
/// @param finfo t@Cf[^
/// @param max őt@C
/// @return Ȃ0A݂΂ȊO
struct FILEINFO *file_search(char *name, struct FILEINFO *finfo, int max)
{
	int i, j;
	char s[12];
	
	for (j = 0; j < 11; j++) {
		s[j] = ' ';
	}
	j = 0;
	for (i = 0; name[i] != 0; i++) {
		if (j >= 11) { return 0; /* Ȃ */ }
		if (name[i] == '.' && j <= 8) {
			j = 8;
		} else {
			s[j] = name[i];
			if ('a' <= s[j] && s[j] <= 'z') {
				/* ͑啶ɒ */
				s[j] -= 0x20;
			} 
			j++;
		}
	}
	for (i = 0; i < max; ) {
		if (finfo->name[0] == 0x00) {
			break;
		}
		if ((finfo[i].type & 0x18) == 0) {
			for (j = 0; j < 11; j++) {
				if (finfo[i].name[j] != s[j]) {
					goto next;
				}
			}
			return finfo + i; /* t@C */
		}
next:
		i++;
	}
	
	return 0; /* Ȃ */
}

/// @brief tekƂăt@Cǂ
/// @param clustno NX^io[
/// @param psize ǂރTCY
/// @param fat FAT
/// @return ǂ񂾃f[^
char *file_loadfile2(int clustno, int *psize, int *fat)
{
	int size = *psize, size2;
	char *buf, *buf2;
	
	buf = (char *) memman_alloc_4k(size);
	file_loadfile(clustno, size, buf);
	
	if (size >= 17) {
		size2 = tek_getsize(buf);
		if (size2 > 0) {	/* tekkĂ */
			buf2 = (char *) memman_alloc_4k(size2);
			tek_decomp(buf, buf2, size2);
			memman_free_4k((int) buf, size);
			buf = buf2;
			*psize = size2;
		}
	}
	
	return buf;
}

/// @brief tHgt@C̓ǂݍ
/// @param filename t@C
/// @param fontbuf tHgf[^
int file_readfont(char *filename, UCHAR *fontbuf)
{
	struct FILEINFO *finfo;
	int size, ret = 1;
	extern char hankaku[4096];
	
	finfo = file_search(filename, (struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224);
	if (file_lock(filename, task_now()->id)) {
		if (finfo) {
			size = finfo->size;
			fontbuf = file_loadfile2(finfo->clustno, &size, global_alloc_fat);
			ret = 1;
		} else {
			fontbuf = (UCHAR *) memman_alloc_4k(16 * 256 + 32 * 94 * 47);
			for (size = 0; size < 16 * 256; size++) {
				fontbuf[size] = hankaku[size]; /* tHgȂ̂ŔpRs[ */
			}
			for (size = 16 * 256; size < 16 * 256 + 32 * 94 * 47; size++) {
				fontbuf[size] = 0xff; /* tHgȂ̂őSp0xffŖߐs */
			}
			ret = 0;
		}
	}
	file_unlock(filename);
	
	*((int *) 0x0fe8) = (int)fontbuf;
	
	return ret;
}
