/// @file graphic.c
/// @brief OtBbN֌W.
///
/// OtBbN`ʂɊւ鏈s
/// @author JsZ(is2os), narata196
/// @since 2010-08-23(r41)

#include "bootpack.h"

void boxfill8(UCHAR *vram, int xsize, UCHAR c, int x0, int y0, int x1, int y1)
{
	int x, y;
	for (y = y0; y <= y1; y++) {
		for (x = x0; x <= x1; x++)
			vram[y * xsize + x] = c;
	}
	return;
}

/* w肳ꂽWjpegt@C\ */
int draw_picture(struct SHEET *sht, char *fname, int posx, int posy)
{
	UCHAR *filebuf, r, g, b;
	struct DLL_STRPICENV env;
	struct RGB *picbuf;
	int info[4], fsize, xx, yy;
	struct FILEINFO *finfo;

	if (is_window_compacted(sht)) {
		return 1;
	}
	
	finfo = file_search(fname, (struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224);
	if (finfo) {
		fsize   = finfo->size;
		filebuf = (UCHAR *)memman_alloc_4k(fsize);
		filebuf = file_loadfile2(finfo->clustno, &fsize, global_alloc_fat);
		info_JPEG(&env, info, fsize, filebuf);
		picbuf  = (struct RGB *) memman_alloc_4k(info[2] * info[3] * sizeof(struct RGB));
		decode0_JPEG(&env, fsize, filebuf, 4, (UCHAR *) picbuf, 0);
		for (yy = 0; yy < info[3]; yy++) {
			for (xx = 0; xx < info[2]; xx++) {
				r = picbuf[yy * info[2] + xx].r;
				g = picbuf[yy * info[2] + xx].g;
				b = picbuf[yy * info[2] + xx].b;
				sht->buf[(yy + posy) * sht->bxsize + (xx + posx)] = (16 + (r / 43) + (g / 43) * 6 + (b / 43) * 36) & 0xff;
			}
		}
		memman_free_4k((UINT32)filebuf, fsize);
	} else {
		return 1;
	}
	
	return 0;
}
 
/* wȉ */
/* OɃt@CƂ̔wi`ʂij */
void set_backscreen(char *wallname)
{
	int px1, px2;
	
	/* wi */
	boxfill8(global_sht_back->buf, global_sht_back->bxsize, 
		rgb2pal(102, 153, 255, 0, 0), 0, 0, global_sht_back->bxsize, global_sht_back->bysize);
	draw_picture(global_sht_back, wallname, 0, 0);
	init_screen8(global_sht_back->buf);
	
	/* o[W\ */
	px1 = global_sht_back->bxsize - (strlen(VERSIONDATA_TAG) * 8 + 10);
	putfonts8_asc(global_sht_back->buf, global_sht_back->bxsize, px1 + 1, 31, COL8_C6C6C6, VERSIONDATA_TAG);
	putfonts8_asc(global_sht_back->buf, global_sht_back->bxsize, px1, 30, COL8_FFFFFF, VERSIONDATA_TAG);
	px2 = global_sht_back->bxsize - (strlen(COPYRIGHTDATA_TAG) * 8 + 10);
	putfonts8_asc(global_sht_back->buf, global_sht_back->bxsize, px2 + 1, 48, COL8_C6C6C6, COPYRIGHTDATA_TAG);
	putfonts8_asc(global_sht_back->buf, global_sht_back->bxsize, px2, 47, COL8_FFFFFF, COPYRIGHTDATA_TAG);

	sheet_refresh(global_sht_back, 0, 0, global_sht_back->bxsize, global_sht_back->bysize);		
	
	return;
}

/* Nʂ\ */
void loading_screen(void)
{
	struct SHEET *sht = global_sht_back;

	boxfill8(sht->buf, sht->bxsize, COL8_FFFFFF, 0, 0, sht->bxsize, sht->bysize);	
	draw_picture(global_sht_back, "op.jpg", 0, 0);
	
	/* Kȕ\ */
	/* Ӗ͖ */
	putfonts8_asc(sht->buf, sht->bxsize, 2, 210, COL8_848484, "<< WELCOME TO NEGITORO!! >>");
	putfonts8_asc(sht->buf, sht->bxsize, 2, 230, COL8_848484, VERSIONDATA_TAG);
	putfonts8_asc(sht->buf, sht->bxsize, 2, 250, COL8_848484, COPYRIGHTDATA_TAG);
	putfonts8_asc(sht->buf, sht->bxsize, 2, 270, COL8_848484, "Negitoro is oprating system completely made in Japan.");
	putfonts8_asc(sht->buf, sht->bxsize, 2, 290, COL8_848484, "We hope you enjoy your own Negitoro Life ;-)");
	putfonts8_asc(sht->buf, sht->bxsize, 2, 330, COL8_848484, "Please wait while kernel is working to start...");
	sheet_refresh(global_sht_back, 0, 0, sht->bxsize, sht->bysize);
	kernel_sleep(200);
	putfonts8_asc(sht->buf, sht->bxsize, 2, 350, COL8_848484, "Complete!");
	sheet_refresh(global_sht_back, 2, 350, 200, 400);
	kernel_sleep(100);
	
	return;
}

void showmemory_screen(void)
{
	char s[64];
	struct MEMMAN *memman = (struct MEMMAN *) MEMMAN_ADDR;
	int col;
	
	/* _999GB܂ŕ\ł */
	/* e͂mBNbV邩 */
	if ((memman_total(memman) / (1024 * 1024)) > 999) {
		sprintf(s, "%dGB", memman_total(memman) / (1024 * 1024 * 1024));
	} else {
		sprintf(s, "%dMB", memman_total(memman) / (1024 * 1024));
	}
	
	/* 10MBȉɂȂ\ԂȂ */
	if ((memman_total(memman) / (1024 * 1024)) <= 10) col = COL8_FF0000;
	else col = COL8_000000;
	
	boxfill8(global_sht_back->buf, global_sht_back->bxsize, COL8_FFFFFF, 
		global_sht_back->bxsize - 106, 2, global_sht_back->bxsize - 63, 21);
	putfonts8_asc(global_sht_back->buf, global_sht_back->bxsize, 
		global_sht_back->bxsize - 104, 4, col, s);
	sheet_refresh(global_sht_back, global_sht_back->bxsize - 106, 2, global_sht_back->bxsize - 63, 21);
	
	return;
}

void init_screen8(char *vram)
{
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	
	/* x[X̃o[ */
	boxfill8(vram, binfo->scrnx, COL8_C6C6C6, 0, 0, binfo->scrnx, 25);
	boxfill8(vram, binfo->scrnx, COL8_848484, 0, 25, binfo->scrnx, 25);
	
	/* Ǝv */
	boxfill8(vram, binfo->scrnx, COL8_FFFFFF, binfo->scrnx - 60, 2, binfo->scrnx - 3, 21);
	boxfill8(vram, binfo->scrnx, COL8_FFFFFF, binfo->scrnx - 106, 2, binfo->scrnx - 63, 21);
	
	/*  */
	putfonts8_asc(vram, binfo->scrnx, 5, 5, COL8_000000, "Negitoro");
	putfonts8_asc(vram, binfo->scrnx, 78, 5, COL8_000000, "Shell");
	
	return;
}

void effect_screen(int id, int act)
{
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	int c, tc;

	if (act) {
		c = COL8_848484;
		tc = COL8_FFFFFF;
	} else {
		c = COL8_C6C6C6;
		tc = COL8_000000;
	}	
	
	if (id == 1) {
		/* X^[g{^ */
		boxfill8(global_sht_back->buf, binfo->scrnx, c, 2, 3, 70, 21);
		putfonts8_asc(global_sht_back->buf, binfo->scrnx, 5, 5, tc, "Negitoro");
	} else if (id == 2) {
		/* VF{^ */
		boxfill8(global_sht_back->buf, binfo->scrnx, c, 73, 3, 121, 21);		
		putfonts8_asc(global_sht_back->buf, binfo->scrnx, 78, 5, tc, "Shell");
	}
	
	sheet_refresh(global_sht_back, 0, 0, binfo->scrnx, 25);
	
	return;
}

void putfont8(char *vram, int xsize, int x, int y, char c, char *font)
{
	int i;
	char *p, d /* data */;
	for (i = 0; i < 16; i++) {
		p = vram + (y + i) * xsize + x;
		d = font[i];
		if ((d & 0x80) != 0) { p[0] = c; }
		if ((d & 0x40) != 0) { p[1] = c; }
		if ((d & 0x20) != 0) { p[2] = c; }
		if ((d & 0x10) != 0) { p[3] = c; }
		if ((d & 0x08) != 0) { p[4] = c; }
		if ((d & 0x04) != 0) { p[5] = c; }
		if ((d & 0x02) != 0) { p[6] = c; }
		if ((d & 0x01) != 0) { p[7] = c; }
	}
	return;
}

void putfonts8_asc(char *vram, int xsize, int x, int y, char c, UCHAR *s)
{
	extern char hankaku[4096];
	struct TASK *task = task_now();
	char *nihongo = (char *) *((int *) 0x0fe8), *font;
	int k, t;

	if (task->langmode == 0) {
		for (; *s != 0x00; s++) {
			putfont8(vram, xsize, x, y, c, hankaku + *s * 16);
			x += 8;
		}
	}
	if (task->langmode == 1) {
		for (; *s != 0x00; s++) {
			if (task->langbyte1 == 0) {
				if ((0x81 <= *s && *s <= 0x9f) || (0xe0 <= *s && *s <= 0xfc)) {
					task->langbyte1 = *s;
				} else {
					putfont8(vram, xsize, x, y, c, nihongo + *s * 16);
				}
			} else {
				if (0x81 <= task->langbyte1 && task->langbyte1 <= 0x9f) {
					k = (task->langbyte1 - 0x81) * 2;
				} else {
					k = (task->langbyte1 - 0xe0) * 2 + 62;
				}
				if (0x40 <= *s && *s <= 0x7e) {
					t = *s - 0x40;
				} else if (0x80 <= *s && *s <= 0x9e) {
					t = *s - 0x80 + 63;
				} else {
					t = *s - 0x9f;
					k++;
				}
				task->langbyte1 = 0;
				font = nihongo + 256 * 16 + (k * 94 + t) * 32;
				putfont8(vram, xsize, x - 8, y, c, font     );	/*  */
				putfont8(vram, xsize, x    , y, c, font + 16);	/* E */
			}
			x += 8;
		}
	}
	if (task->langmode == 2) {
		for (; *s != 0x00; s++) {
			if (task->langbyte1 == 0) {
				if (0x81 <= *s && *s <= 0xfe) {
					task->langbyte1 = *s;
				} else {
					putfont8(vram, xsize, x, y, c, nihongo + *s * 16);
				}
			} else {
				k = task->langbyte1 - 0xa1;
				t = *s - 0xa1;
				task->langbyte1 = 0;
				font = nihongo + 256 * 16 + (k * 94 + t) * 32;
				putfont8(vram, xsize, x - 8, y, c, font     );	/*  */
				putfont8(vram, xsize, x    , y, c, font + 16);	/* E */
			}
			x += 8;
		}
	}
	return;
}

void init_mouse_cursor8(char *mouse, char bc)
/* }EXJ[\i16x16j */
{
	static char cursor[16][16] = {
		"*...............",
		"**..............",
		"*O*.............",
		"*OO*............",
		"*OOO*...........",
		"*OOOO*..........",
		"*OOOOO*.........",
		"*OOOOOO*........",
		"*OOOOOOO*.......",
		"*OOOOOOOO*......",
		"*OOOOO*****.....",
		"*O**OO*.........",
		"**..*OO*........",
		"*...*OO*........",
		".....*O*........",
		"......**........"
	};
	int x, y;

	for (y = 0; y < 16; y++) {
		for (x = 0; x < 16; x++) {
			if (cursor[y][x] == '*') {
				mouse[y * 16 + x] = COL8_FFFFFF;
			}
			if (cursor[y][x] == 'O') {
				mouse[y * 16 + x] = COL8_000000;
			}
			if (cursor[y][x] == '.') {
				mouse[y * 16 + x] = bc;
			}
		}
	}
	return;
}

void putblock8_8(char *vram, int vxsize, int pxsize,
	int pysize, int px0, int py0, char *buf, int bxsize)
{
	int x, y;
	for (y = 0; y < pysize; y++) {
		for (x = 0; x < pxsize; x++) {
			vram[(py0 + y) * vxsize + (px0 + x)] = buf[y * bxsize + x];
		}
	}
	return;
}

void hrb_api_linewin(struct SHEET *sht, int x0, int y0, int x1, int y1, int col)
{
	int i, x, y, len, dx, dy;

	if (is_window_compacted(sht)) {
		return;
	}
	
	dx = x1 - x0;
	dy = y1 - y0;
	x = x0 << 10;
	y = y0 << 10;
	if (dx < 0) {
		dx = - dx;
	}
	if (dy < 0) {
		dy = - dy;
	}
	if (dx >= dy) {
		len = dx + 1;
		if (x0 > x1) {
			dx = -1024;
		} else {
			dx =  1024;
		}
		if (y0 <= y1) {
			dy = ((y1 - y0 + 1) << 10) / len;
		} else {
			dy = ((y1 - y0 - 1) << 10) / len;
		}
	} else {
		len = dy + 1;
		if (y0 > y1) {
			dy = -1024;
		} else {
			dy =  1024;
		}
		if (x0 <= x1) {
			dx = ((x1 - x0 + 1) << 10) / len;
		} else {
			dx = ((x1 - x0 - 1) << 10) / len;
		}
	}

	for (i = 0; i < len; i++) {
		sht->buf[(y >> 10) * sht->bxsize + (x >> 10)] = col;
		x += dx;
		y += dy;
	}

	return;
}


