/// @file lock.c
/// @brief t@CbN֌W.
///
/// t@CbNɊ֘As
/// @author JsZ

#include "bootpack.h"

/// @brief bNꂽt@CXg
struct LOCKED_FILE locked_files[LOCKED_FILE_MAX];

/// @brief bNꂽt@CXg
void init_file_lock(void)
{
	int i;
	
	for (i = 0;i < LOCKED_FILE_MAX;i++) {
		memset(locked_files[i].name, 0, FILENAME);
		locked_files[i].flag = 0;
		locked_files[i].taskid = 0;
		locked_files[i].type = 0;
	}
	
	return;
}

/// @brief ̃t@Cw肳ꂽIDɃbNĂ邩ǂ
/// @param fname t@C
/// @param taskid ^XNID
/// @return bNĂ1AĂȂ0
/// @note taskid == 0 Ȃt@Cł̊mF
int file_islockedby(char *fname, int taskid)
{
	int i;

	if (taskid == 0) {
		for (i = 0;i < LOCKED_FILE_MAX;i++) {
			if (!strcmp(locked_files[i].name, fname) &&
				 locked_files[i].flag == 1) {
				return 1;
			}
		}
	} else {	
		for (i = 0;i < LOCKED_FILE_MAX;i++) {
			if (!strcmp(locked_files[i].name, fname) &&
				 locked_files[i].taskid == taskid &&
				 locked_files[i].flag == 1) {
				return 1;
			}
		}
	}
	
	return 0;
}

/// @brief t@Cw肵IDŃbN
/// @param fname bNt@C
/// @param taskid ^XNID
/// @return bNł1AłȂ0
int file_lock(char *fname, int taskid)
{
	int i;
	
	if (!file_exist(fname)) return 0;
	if (file_islockedby(fname, taskid)) return 1;
	if (!file_islockedby(fname, 0)) {
		for (i = 0;i < LOCKED_FILE_MAX;i++) {
			if (!locked_files[i].flag) {
				strcpy(locked_files[i].name, fname);
				locked_files[i].flag = 1;
				locked_files[i].taskid = taskid;
				return 1;
			}
		}
	}
	
	return 0;
}

/// @brief t@C̃bN
/// @param fname bNt@C
/// @return bN1AłȂ0
int file_unlock(char *fname)
{
	int i;
	
	if (!file_exist(fname)) return 0;
	
	for (i = 0;i < LOCKED_FILE_MAX;i++) {
		if (!strcmp(locked_files[i].name, fname)) {
			locked_files[i].flag = 0;
			return 1;
		}
	}

	return 0;
}

/// @brief t@C݂邩ǂ
/// @param fname t@C
/// @return 1A0
int file_exist(char *fname)
{
	if (file_search(fname, (struct FILEINFO *) (ADR_DISKIMG + 0x002600), 224)) {
		return 1;
	}
	return 0;
}

