/// @file log.c
/// @brief O֌W
/// @author JsZ(is2os)
/// @note
/// - ::logging ͂ł邾A[U[ւ̒ʒmȂǂ̕ŎgꂽB
/// - JȂǂŎgȂ ::debugmsg ̗p𐄏B
/// - qemuł̃VAR\[؂ւCtrl+Alt+2
/// @todo t@Cւ̏o

#include <stdarg.h>
#include "bootpack.h"

/// \̂߂ɕێf[^̍ő吔
#define LOG_DATA_MAX 64

/// @brief ̃Of[^
struct LOG_DATAS {
	char log[256];			///< O
	int flag;				///< O̗L
};

struct LOG_DATAS logd_ker[LOG_DATA_MAX];	///< klogp
struct LOG_DATAS logd_dbg[LOG_DATA_MAX];	///< dlogp
struct LOG_DATAS logd_copy[LOG_DATA_MAX];	///< ۑp

int current1;								///< klogp݂̌̕ێf[^
int current2;								///< dlogp݂̌̕ێf[^

/// @brief O̕ۑf[^
void init_log(void)
{
	int j;
	
	for (j = 0;j < LOG_DATA_MAX;j++) {		
		memset(logd_ker[j].log, 0, 128);
		logd_ker[j].flag = 0;	
		memset(logd_dbg[j].log, 0, 128);
		logd_ker[j].flag = 0;		
	}
	current1 = 0;
	current2 = 0;
	
	debugmsg("Initialized Log..");
	
	return;
}

/// @brief Rs[pOf[^̕ۑ
void init_logcopy(void)
{
	int j;

	for (j = 0;j < LOG_DATA_MAX;j++) {
		memset(logd_copy[j].log, 0, 128);
		logd_copy[j].flag = 0;
	}

	return;
}

/// @brief w肵R\[ɃO\
/// @param cons \R\[
/// @param id \郍O̎
void show_log(struct CONSOLE *cons, int id)
{
	int j;
	
	if (!id) {
		for (j = 0;j < LOG_DATA_MAX;j++) {
			if (logd_ker[j].flag) {
				cons_putstr0(cons, logd_ker[j].log);
			}
		}
	} else {
		for (j = 0;j < LOG_DATA_MAX;j++) {
			if (logd_dbg[j].flag) {
				cons_putstr0(cons, logd_dbg[j].log);
			}
		}	
	}
	
	return;
}

/// @brief O𑗂
/// @param type 郍O̎
/// @param data O
void logging(int type, char *data, ...)
{
	int j;
	UCHAR d[7];
	char s1[256], s2[256];
	char base[] = "[%02x:%02x:%02x] ";	
	va_list ap;
	
	va_start(ap, data);
	readdates(d);
	sprintf(s1, base, d[2], d[1], d[0]);
	vsprintf(s2, data, ap);
	strcat(s1, s2);
	strcat(s1, "\n");
	
	/* fobOpJ[lp */
	if (type == LOG_KERNEL) {
		strcpy(logd_ker[current1].log, s1);
		logd_ker[current1].flag = 1;
		if (current1 == LOG_DATA_MAX) {
			init_logcopy();
			for (j = 0;j < 32;j++) {
				logd_copy[j] = logd_ker[32 + j];
				logd_ker[j] = logd_copy[j];
			}
			current1 = 32;
		} else {
			current1++;
		}
	} else if (type == LOG_DEBUG) {
		strcpy(logd_dbg[current2].log, s1);
		logd_dbg[current2].flag = 1;
		if (current2 == LOG_DATA_MAX) {
			init_logcopy();
			for (j = 0;j < 32;j++) {
				logd_copy[j] = logd_dbg[32 + j];
				logd_dbg[j] = logd_copy[j];
			}
			current2 = 32;
		} else {
			current2++;
		}		
	}
	va_end(ap);
	
	return;
}

/// @brief VA|[gɃO𑗂.
///
/// قƂqemũVAR\[pB
/// com1֑MB
/// @param format O
void debugmsg(char *format, ...)
{
	va_list ap;
	char s[256];
	char base[] = "DBG : "; /* fobOłI */
	
	/* COM1֑ */
	va_start(ap, format);
	vsprintf(s, format, ap);
	strcat(base, s);	
	send_string_serialport(1, base);
	send_string_serialport(1, "\n\r");
	va_end(ap);

	return;
}

