/* bZ[W{bNX}l[W */

/* 0x41Ŋ荞݂N\ by JsZ */

#include "bootpack.h"

struct TASK *mpmtask;
struct SHEET *mpmsht;

/* bZ[W{bNX݂̗L */
/* bootpack.c炱̃tOmF */
/* EBhEւ̃tH[JXۂ𐧌䂷 */
int there_messagebox;

void run_mpm(void)
{	
	int *keyfifo = (int *)memman_alloc_4k(128 * 4);

	mpmtask = task_alloc();
	mpmtask->tss.esp = memman_alloc_4k(64 * 1024) + 64 * 1024;
	mpmtask->tss.eip = (int)&task_mpm;
	mpmtask->tss.es = 1 * 8;
	mpmtask->tss.cs = 2 * 8;
	mpmtask->tss.ss = 1 * 8;
	mpmtask->tss.ds = 1 * 8;
	mpmtask->tss.fs = 1 * 8;
	mpmtask->tss.gs = 1 * 8;
	task_run(mpmtask, 2, 2, "mpm");
	fifo32_init(&mpmtask->fifo, 128, keyfifo, mpmtask);

	debugmsg("Running mpm..");
	there_messagebox = 0;
	
	return;
}

void stop_mpm(void)
{
	task_sleep(mpmtask);
	memman_free_4k(mpmtask->tss.esp, 64 * 1024);
	memman_free_4k((int)mpmtask->fifo.buf, 128 * 4);
	mpmtask->flags = 0;
	return;
}

void task_mpm(void)
{
	struct TASK *task = task_now();
	int i;
	
	for (;;) {
		io_cli();
		if (fifo32_status(&task->fifo) == 0) {
			task_sleep(task);
			io_sti();
		} else {
			i = fifo32_get(&task->fifo);
			io_sti();
			if (i == 4) {	/* EBhEj */
				close_mesbox();
			}
			if (256 <= i && i <= 511) { /* L[{[hf[^i^XNAoRj */
				io_cli();
				fifo32_put(&task->fifo, 4);
				io_sti();
			}			
		}
	}
}

void close_mesbox(void)
{
	memman_free_4k((int)mpmsht->buf, mpmsht->bxsize * mpmsht->bysize);
	sheet_free(mpmsht);	
	there_messagebox = 0;
	return;
}

/* str̒̎w肳ꂽs_strJEg */
int scan_char(char *str, char s_str)
{
	int j;
	char *p;
	
	for (p = str, j = 0;*p != 0;p++) 
		if (*p == s_str) j++;
	
	return j;
}

void show_mesbox(char *caption, char *message)
{
	const int base_wy = 30;
	const int base_sposy = 30;
	int posx, posy, wx, wy = base_wy, sposx, sposy = base_sposy, i, j, c;
	char *p, strbuf[1048], *split;
	UCHAR *buf;
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	struct SHTCTL *shtctl = (struct SHTCTL *) *((int *) 0x0fe4);
	
	mpmsht = sheet_alloc();
	mpmsht->task = mpmtask;
	mpmsht->flags |= 0x20;
	mpmsht->ktype = KERNELWINDOW_MPM;
	
	/* sJEg */
	i = scan_char(message, '\n');
	wy += (i + 1) * 30 + 13;

	/* łsT */
	/* ̕_CAȎ傫vZ */
	j = 0;
	c = 0;
	for (p = message;;p++) {
		if (*p == '\n' || *p == 0) {
			if (c <= j) {
				c = j - 1; /* \n\0̓JEgO */
				j = 0;
			}
			if (*p == 0) break;
		}
		j++;
	}
	if (c > strlen(caption)) {
		wx = c * 8 + 25;
		sposx = 10;
	} else {
		wx = strlen(caption) * 8 + 70;
		sposx = wx / 2 - (c * 8 / 2);
	}	
	
	/* Œ̑傫ɂ͂Ă */
	if (wx < 150) {
		wx = 150;
		sposx = wx / 2 - (c * 8 / 2);
	}
	if (wy < 100) {
		wy = 100;
	}
	
	buf = (UCHAR *)memman_alloc_4k(wx * wy);
	sheet_setbuf(mpmsht, buf, wx, wy, -1);
	draw_window8(buf, wx, wy, caption, 0);
	
	/* `ʂ */
	/* \nőiɂȂ	*/
	/* j+1+1\0̂ */
	c = 0;
	strcpy(strbuf, message);
	for (j = 0;j < i + 1;j++) {
		if (c) split = strtok(NULL, "\n");
		else split = strtok(strbuf, "\n");
		putfonts8_asc(mpmsht->buf, mpmsht->bxsize, sposx, sposy, COL8_000000, split);
		sposy += 20;
		c = 1;
	}
	
	/* >Push any key<ƕ\ */
	boxfill8(mpmsht->buf, mpmsht->bxsize, COL8_848484,
				wx / 2 - 60, wy - 28, wx / 2 + 60, wy - 6);
	putfonts8_asc(mpmsht->buf, mpmsht->bxsize, wx / 2 - 55, 
				wy - 24, COL8_FFFFFF, ">Push any key<");
	
	/* ʒɕ\ */
	posx = (binfo->scrnx - wx) / 2;
	posy = (binfo->scrny - wy) / 2;
	sheet_slide(mpmsht, posx, posy);
	sheet_updown(mpmsht, shtctl->top);
	if(shtctl->active) {
		keywin_off(shtctl->active);
	}
	keywin_on(mpmsht);
	
	there_messagebox = 1;
	
	return;
}

