/// @file parallel.c
/// @brief p|[g֌W
/// @author JsZ(is2os)
/// @since 2010-08-23(r41)
/// @attention qemuł͓mFς݁BpR\[ł̓S~MĂ̂mFłB
/// 炭ȂɂB
/// @todo mȓƊ荞

#include "bootpack.h"

#define PARA_LPT1 0x378 ///< LPT1
#define PARA_LPT2 0x278 ///< LPT2
#define PARA_LPT3 0x3bc ///< LPT3

/// @brief p|[gWX^I/O
struct parallel_regs {
	int data;	///< +0 Data Register
	int stat;	///< +1 Status Regster
	int com;	///< +2 Command Register
};

static struct parallel_regs lpt[3] = {
	{ PARA_LPT1 + 0, PARA_LPT1 + 1, PARA_LPT1 + 2 },
	{ PARA_LPT2 + 0, PARA_LPT2 + 1, PARA_LPT2 + 2 },
	{ PARA_LPT3 + 0, PARA_LPT3 + 1, PARA_LPT3 + 2 },
};

/**
* @brief Xg[u̐؂ւ
* @param pn |[gԍ
* @param flag Xg[u
*/
void strobing(int pn, int flag)
{
	int ind, outd;
	
	ind = io_in8(lpt[pn].com);
	if (flag) outd = ind | 1; /* Xg[u1 */
	else outd = ind & 254; /* Xg[u0 */
	io_out8(lpt[pn].com, outd);
	
	return;
}

/**
* @brief rW[҂
* @param pn |[gԍ
* @param flag rW[̃^Cv
* @return 0ȂΐA1ȂΉ炩̃G[
*/
int wait_busy(int pn, int flag)
{
	int cmp;
	
	if (flag) cmp = 0;
	else cmp = 128;
	
	while ((io_in8(lpt[pn].stat) & 128) == cmp) {
		if (io_in8(0x60) == 1) return 1; /* ̃G[? */
	}	
	
	return 0;
}

/**
* @brief p|[g̑M/M[hZbg
* @param pn |[gԍ
* @param type ݒ肷郂[h
*/
void set_mode(int pn, int type)
{
	int ind, outd = 0;
	
	ind = io_in8(lpt[pn].com);
	if (type == CAN_SEND) outd = ind | 223;
	else if (type == CAN_RECV) outd = ind | 32;
	io_out8(lpt[pn].com, outd);
	
	return;
}

/**
* @brief p|[gp\ǂ̊mF
* @param pn |[gԍ
* @return 1łΉ\A0łΕs\
*/
int is_ready(int pn)
{
	/* data֓񐔒l𑗂 */
	/* ωȂ牽 */
	
	io_out8(lpt[pn].data, 255);
	if (io_in8(lpt[pn].data) == 255) 
		return 1;
	
	io_out8(lpt[pn].data, 0);
	if (io_in8(lpt[pn].data) == 0)
		return 1;

	return 0;
}

/**
* @brief p|[gLN^M
* @param pn |[gԍ
* @return ȂΎMf[^AsȂ-1
*/
char recv_char_parallel(int pn)
{
	int retd;
	
	if (wait_busy(pn, 0)) return -1;
	strobing(pn, 1);

	/* f[^M */
	retd = io_in8(lpt[pn].data);
	
	if (wait_busy(pn, 1)) return -1;
	strobing(pn, 0);
	
	return retd;
}

/**
* @brief p|[gփLN^M
* @param pn |[gԍ
* @param c Mf[^
* @return Ȃ0AsȂ-1
*/
int send_char_parallel(int pn, char c)
{
	if (wait_busy(pn, 0)) return -1;
	
	/* f[^𑗐M */
	io_out8(lpt[pn].data, c);
	
	strobing(pn, 1);
	if (wait_busy(pn, 1)) return -1;
	strobing(pn, 0);
	
	return 0;
}
