/// @file pci.c
/// @brief PCI֘A
/// @author JsZ(is2os)

#include "bootpack.h"

#define PCI_REG_ADDRESS	0xcf8	///< AhXRtBO[VWX^
#define PCI_REG_DATA1	0xcfc	///< f[^RtBO[VWX^1
#define PCI_REG_DATA2	0xcfd 	///< f[^RtBO[VWX^2
#define PCI_REG_DATA3	0xcfe	///< f[^RtBO[VWX^3
#define PCI_REG_DATA4	0xcff	///< f[^RtBO[VWX^4

/// @brief AhXRtBO[VWX^ɏ
/// @param inf PCĨRtBO[VWX^
/// @note
/// - Ql http://kurohuku.blogspot.com/2010/03/pci.html
void control_pci_addr_write(PCI_INFO inf)
{
	int out = 0x80000000 |
			((inf.bus << 16) & 0xFF0000) |
			((inf.dev << 11) & 0xF800) |
			((inf.func << 8) & 0x700) |
			(((inf.reg / 4) << 2) & 0xFC);
	io_out32(PCI_REG_ADDRESS, out);
	return;
}

/// @brief w肳ꂽf[^RtBO[VWX^̃f[^擾
/// @param n WX^̔ԍ
/// @return f[^RtBO[VWX^̃f[^
int control_pci_data_read(int n)
{
	switch (n) {
		case 1: return io_in32(PCI_REG_DATA1);
		case 2: return io_in32(PCI_REG_DATA2);
		case 3: return io_in32(PCI_REG_DATA3);
		case 4: return io_in32(PCI_REG_DATA4);
	}
	return -1;
}

/// @brief w肳ꂽf[^RtBO[VWX^փf[^
/// @param n WX^̔ԍ
void control_pci_data_write(int n, int data)
{
	int p;
	
	switch (n) {
		case 1: p = PCI_REG_DATA1;
		case 2: p = PCI_REG_DATA2;
		case 3: p = PCI_REG_DATA3;
		case 4: p = PCI_REG_DATA4;
		default: return;
	}
	io_out32(p, data);
	
	return;
}

/// @brief x_IDЖԂ
/// @return ID̉Ж
/// @param id x_ID
/// @note
/// - Ql http://pci-ids.ucw.cz/read/PC/
char *conv_vendername(int id)
{
	switch (id) {
		case 0x8086: return "Intel Corporation";
		case 0x1013: return "Cirrus Logic";
		default: return "Unknown Vender";
	}
}

/// @brief x_IDƃfoCXIDfoCXԂ
/// @return ID̃foCX
/// @param vendid x_ID
/// @param devid foCXID
/// @note
/// - Ql http://pci-ids.ucw.cz/read/PC/
char *conv_devname(int vendid, int devid)
{
	switch (vendid)
	{
		case 0x8086:
			switch (devid) {
				case 0x1237: return "440FX - 82441FX PMC";
				case 0x7000: return "82371SB PIIX3 ISA";
				case 0x100e: return "82540EM Gigabit Ethernet Controller";
			}
		case 0x1013:
			switch (devid) {
				case 0xb8: return "GD 5446";
			}
	}
	return "Unknown Device";
}
