/// @file pcic.c
/// @brief 16bit-PCIC֘A
/// @author JsZ(is2os)
/// @note
/// - ȂƂA16bit-PCICǂ̂悤Ȃ̂Ȃ̂Ƃ̂͗ǂȂ
/// - W[炵i82365ɂĂׂǂȂ

#include "bootpack.h"

#define PCIC_REG_INDEX	0x03e0  ///< PCICCfbNXWX^
#define PCIC_REG_DATA	0x03e1  ///< PCICf[^WX^

#define MAX_SOCKETS		3		///< ő\Pbg
#define MAX_REGS		64		///< ő僌WX^

/// @brief PCICփf[^
/// @param sn \Pbgԍ
/// @param reg WX^ԍ
/// @param data f[^
void control_pcic_write(int sn, int reg, UCHAR data)
{
	if (sn > MAX_SOCKETS || reg > MAX_REGS) return;	
	io_out8(PCIC_REG_INDEX, reg + (sn << 6));
	io_out8(PCIC_REG_DATA, data);
	return;
}

/// @brief PCICf[^ǂ
/// @param sn \Pbgԍ
/// @param reg WX^ԍ
/// @return ǂ񂾃f[^
UCHAR control_pcic_read(int sn, int reg)
{
	if (sn > MAX_SOCKETS || reg > MAX_REGS) return 0;
	io_out8(PCIC_REG_INDEX, reg + (sn << 6));
	return (UCHAR)io_in8(PCIC_REG_DATA);
}

/// @brief MAX_SOCKETSԂ
/// @return ::MAX_SOCKETS ̒l
int control_pcic_get_maxsocks(void)
{
	return MAX_SOCKETS;
}
