/// @file rtc.c
/// @brief RTC֌W.
///
/// RTCƎv^XN
/// @author JsZ(is2os)
/// @since 2010-08-23(r41)

#include "bootpack.h"

#define RTCIO_ADDR 0x70		///< RTCI/ÕAhX
#define RTCIO_DATA 0x71		///< RTCI/Õf[^

#define SECOND	0x00		///< b
#define MINUTE	0x02		///< 
#define HOUR	0x04		///< 
#define DAY		0x07		///< 
#define MONTH	0x08		///< 
#define YER_LO	0x09		///< 
#define	YER_HI	0x32		///< 

#define SECOND_MAX	60		///< ő b
#define MINUTE_MAX	59		///< ő 
#define HOUR_MAX	23		///< ő 
#define DAY_MAX		31		///< ő 
#define MONTH_MAX	12		///< ő 
#define YER_LO_MAX	99		///< ő 
#define YER_HI_MAX	99		///< ő 

static UCHAR rtcadr[7] = { SECOND, MINUTE, HOUR, DAY, MONTH, YER_LO, YER_HI };
static UCHAR rtcmax[7] = { SECOND_MAX, MINUTE_MAX, HOUR_MAX, DAY_MAX, 
									MONTH_MAX, YER_HI_MAX, YER_LO_MAX };

/// @brief CMOSf[^擾
/// @param addr RTCI/ÕAhX
int getdata_cmos(UCHAR addr)
{
    io_out8(RTCIO_ADDR, addr);
    return io_in8(RTCIO_DATA);
}

/// @brief CMOSf[^
/// @param addr RTCI/ÕAhX
/// @param dat Mf[^
void writedata_cmos(UCHAR addr, UCHAR dat)
{
    io_out8(RTCIO_ADDR, addr);
    io_out8(RTCIO_DATA, dat);	
	return;
}

/// @brief tf[^擾
/// @param a QƓnf[^̃|C^
void readdates(UCHAR *a)
{
	int i, r;
	char ef;

	/* xǂ݂܂ł̃[v */
	for (;;) {
		ef = 0;
		for (i = 0;i < 7;i++) {
			a[i] = getdata_cmos(rtcadr[i]);
		}
		for (i = 0;i < 7;i++) {
			r = getdata_cmos(rtcadr[i]);
			if (a[i] != r || (a[i] & 0x0f) > 9 || a[i] > bcdconv(rtcmax[i])) {
				ef = 1;
			}
		}
		if (ef == 0) {
			return;
		}
	}
}

/// @brief tf[^.
/// łsȂ牽Ȃ.
/// @param year_high 
/// @param year_low 
/// @param month 
/// @param day 
/// @param hour 
/// @param minute 
/// @param second b
/// @todo 񂾌, ǂmF.
/// @todo Nƌɂē͈̔͂ς邱Ƃւ̑Ώ.
/// @todo sŏ܂ȂƂĂяo֒ʒm͕Kv.
/// @todo N̗L͈͂09999܂łł悢̂.
void setdates(int year_high, int year_low, int month, 
			int day, int hour, int minute, int second)
{
	static const int rtcmin[] = { 0, 0, 0, 1, 1, 0, 0 };
	const int date[] = { second, minute, hour, day, month, year_low, year_high };
	int i;

	// ǂꂩłُȂ珑܂ɏI.
	for (i = 0; i < sizeof(date)/sizeof(*date); i++) {
		if (date[i] < rtcmin[i] || rtcmax[i] < date[i])
			return;
	}

	/* b珑 */
	for (i = 0; i < sizeof(date)/sizeof(*date); i++) {
		writedata_cmos(rtcadr[i], bcdconv(date[i]));
	}
}

/// @brief BCD֕ϊ
/// @param in ϊ\i
/// @return ϊꂽ\Zi
UINT32 bcdconv(UINT32 in)
{
	int i, m = 0, n = (int)in;

	/* in10000ȏ͖̎ */
	if (in > 10000) {
		return 0;
	}
	
	for(i = 1000; i > 0; i /= 10) {
		m += n / i;
		n -= m * i;
		m *= 16;
	}

	return (UINT32)(m / 16);
}

struct TASK *clktask;		///< ṽ^XN
struct TIMER *clktimer;		///< vXVp̃^C}

/// @brief vN
void run_clock(void)
{
	int *clockbuf = (int *)memman_alloc_4k(128 * 4);
	
	clktask = task_alloc();
	clktask->tss.esp = memman_alloc_4k(64 * 1024) + 64 * 1024;
	clktask->tss.eip = (int) &clock_task;
	clktask->tss.es = 1 * 8;
	clktask->tss.cs = 2 * 8;
	clktask->tss.ss = 1 * 8;
	clktask->tss.ds = 1 * 8;
	clktask->tss.fs = 1 * 8;
	clktask->tss.gs = 1 * 8;
	task_run(clktask, 2, 2, "clock");
	fifo32_init(&clktask->fifo, 128, clockbuf, clktask);
	
	debugmsg("Running clock..");
	clktimer = timer_alloc();
	
	return;
}

/// @brief vI
void stop_clock(void)
{
	timer_free(clktimer);
	task_sleep(clktask);
	memman_free_4k(clktask->tss.esp, 64 * 1024);
	memman_free_4k((int)clktask->fifo.buf, 128 * 4);
	clktask->flags = 0;
	return;
}

/// @brief XV̗v
const int mark = 10;

/// @brief v\̍XV𖾎Iɗv.
void clock_refresh(void)
{
	fifo32_put(&clktask->fifo, mark + 1);
	return;
}

/// @brief v^XÑC.
void clock_task(void)
{
	int sig, prev = -1;
	unsigned char date[7];
	char s[64];
	int col;
	
	/* ꕪɍXV */
	timer_init(clktimer, &clktask->fifo, mark);
	
	/* ŏ̋Nł͕\ */
	fifo32_put(&clktask->fifo, mark);
	
	for (;;) {
		io_cli();
		if (fifo32_status(&clktask->fifo) == 0) {
			task_sleep(clktask);
			io_sti();
		} else {
			sig = fifo32_get(&clktask->fifo);
			io_sti();
			if (sig == mark) {
				timer_settime(clktimer, 6000);
				readdates(date);
				sprintf(s, "%02x:%02x", date[2], date[1]);
				boxfill8(global_sht_back->buf, global_sht_back->bxsize, COL8_FFFFFF, 
						global_sht_back->bxsize - 60, 2, global_sht_back->bxsize - 3, 21);
				putfonts8_asc(global_sht_back->buf, global_sht_back->bxsize, 
						global_sht_back->bxsize - 53, 4, COL8_000000, s);
				sheet_refresh(global_sht_back, global_sht_back->bxsize - 60, 2, global_sht_back->bxsize - 3, 21);
				prev = (date[2] << 8) | date[1];
			} else if (sig == mark + 1) {
				timer_cancel(clktimer);
				timer_settime(clktimer, 10);
				readdates(date);
				col = (((date[2] << 8) | date[1]) == prev) ? COL8_C6C6C6 : COL8_00FF00;
				boxfill8(global_sht_back->buf, global_sht_back->bxsize, col, 
						global_sht_back->bxsize-60 + 1, 2 + 1, global_sht_back->bxsize - 3 - 1, 21 - 1);
				sheet_refresh(global_sht_back, global_sht_back->bxsize - 60, 2, global_sht_back->bxsize - 3, 21);
			}
		}
	}
}

