/// @file serial.c
/// @brief VA|[g֌W
/// @author JsZ(is2os)
/// @since 2010-08-23(r41)
/// @note
/// - Linux̃\[XQlɂĂ邪AƂ܂悭Ȃ
/// - IRQ̊荞ݔԍCOM1=irq4, COM2=irq3, COM3=irq4, COM4=irq3炵
/// - qemũVAR\[ł͓mFĂ
/// @attention
/// Ƃ肠̂Ƃ̓R[ĥʓ|Ȃ̂
/// 荞݂g^Cv̏͌񂵂ɂ
/// - for (j = 0;j < SER_PORTS;j++) {c} ƂƂYꂸ
/// - comp̏ꍇ1Acom̏ꍇ0|[gw肷

#include "bootpack.h"

#define SERIAL_COM1	0x3f8	///< COM1
#define	SERIAL_COM2	0x2f8	///< COM2
#define SERIAL_COM3	0x3e8	///< COM3
#define	SERIAL_COM4	0x2e8	///< COM4

#define SER_PORTS	4		///< |[g̐

/// @brief VA|[gWX^I/O
typedef struct serialport_registers {
	int thr;	///< +0 Transmitter Holding Buffer (W)
	int rbr;	///< +0 Receiver Buffer (R)
	int dll;	///< +0 Divisor Latch Low Byte (R/W)
	int ier;	///< +1 Interrupt Enable Registe (R/W)
	int dlm;	///< +1 Divisor Latch High Byte (R/W)
	int iir;	///< +1 Interrupt Identif.. Register (R)
	int fcr;	///< +2 FIFO Control Register (W)
	int lcr;	///< +3 Line Control Register (R/W)
	int mcr;	///< +4 Modem Control Register (R/W)
	int lsr;	///< +5 Line Status Register (R)
	int msr;	///< +6 Modem Status Register (R)
	int scr;	///< +7 Scratch Register (R/W)
} SP_REGS;

static SP_REGS reg[SER_PORTS] = {
	{SERIAL_COM1+0,SERIAL_COM1+0,SERIAL_COM1+0,SERIAL_COM1+1,SERIAL_COM1+1,SERIAL_COM1+2,
	SERIAL_COM1+2,SERIAL_COM1+3,SERIAL_COM1+4,SERIAL_COM1+5,SERIAL_COM1+6,SERIAL_COM1+7},
	{SERIAL_COM2+0,SERIAL_COM2+0,SERIAL_COM2+0,SERIAL_COM2+1,SERIAL_COM2+1,SERIAL_COM2+2,
	SERIAL_COM2+2,SERIAL_COM2+3,SERIAL_COM2+4,SERIAL_COM2+5,SERIAL_COM2+6,SERIAL_COM2+7},
	{SERIAL_COM3+0,SERIAL_COM3+0,SERIAL_COM3+0,SERIAL_COM3+1,SERIAL_COM3+1,SERIAL_COM3+2,
	SERIAL_COM3+2,SERIAL_COM3+3,SERIAL_COM3+4,SERIAL_COM3+5,SERIAL_COM3+6,SERIAL_COM3+7},
	{SERIAL_COM4+0,SERIAL_COM4+0,SERIAL_COM4+0,SERIAL_COM4+1,SERIAL_COM4+1,SERIAL_COM4+2,
	SERIAL_COM4+2,SERIAL_COM4+3,SERIAL_COM4+4,SERIAL_COM4+5,SERIAL_COM4+6,SERIAL_COM4+7},	
};

/// @brief VA|[g̃f[^
typedef struct serialport {
	int base;		///< x[XI/OAhX
	SP_REGS reg;	///< WX^f[^
	int type;		///< ^
	int div;		///< ʐMx
	int com;		///< |[gԍ
	int lctl;		///< CRg[
	int cpin;		///< pin
	int flag;		///< ėptO
	int lowpmode;	///< Ep[[h
	int slpmode;	///< X[v[h
} SP_DAT;

static SP_DAT sp[SER_PORTS];

void init_serialport(int com, int div, int lctl, int cpin);
int detect_serialport(int com);

/// @brief VA|[g̗LƔ
/// @param com |[gԍ
/// @retval 0 None
/// @retval 1 8250
/// @retval 2 16450
/// @retval 3 16550A
/// @retval 4 16750
int detect_serialport(int com)
{
	int value;
	
	io_out8(reg[com].mcr, 0x10);
	if((io_in8(reg[com].msr) & 0xf0) != 0) return 0;
	io_out8(reg[com].mcr, 0x1f);
	if((io_in8(reg[com].msr) & 0xf0) != 0xf0) return 0;

	io_out8(reg[com].scr, 0x55);
	if(io_in8(reg[com].scr) != 0x55) return 1;
	io_out8(reg[com].scr, 0xaa);
	if(io_in8(reg[com].scr) != 0xaa) return 1;

	io_out8(reg[com].fcr, 0x21);
	value = io_in8(reg[com].iir);
	if ((value & 0xc0) != 0xc0) return 2;
	if ((value & 0x20) != 0x20) return 3;
	return 4;
}

/// @brief VA|[g̏
/// @param com |[gԍ
/// @param div ʐMx
/// - 0x30 : 2400
/// - 0x18 : 4800
/// - 0x0c : 9600
/// - 0x06 : 19200
/// - 0x03 : 38400
/// - 0x02 : 57600 
/// - 0x01 : 115200
/// @param lctl CRg[
/// @param cpin s
void init_serialport(int com, int div, int lctl, int cpin)
{	
	io_out8(reg[com].lcr, 0x80);
	io_out8(reg[com].dll, div);
	io_out8(reg[com].lcr, lctl);	/* CRg[ 8bit */
	io_out8(reg[com].mcr, cpin);	/* pin */
	io_out8(reg[com].ier, 0);		/* 荞ݖ */
	return;
}

/// @brief SER_PORTSԂ
/// @return ::SER_PORTS ̒l
int serial_getports(void)
{
	return (int)SER_PORTS;
}

/// @brief VA|[g̏Ԃ.
///
/// NULLԂꍇ͉
/// @param comp |[gԍ
/// @param n Ԃ̔ԍ
/// - 1 : x[XI/OAhX
/// - 2 : ^
/// - 3 : ʐMx
/// - 4 : |[gԍ
/// - 5 : CRg[
/// - 6 : s
/// - 7 : ėptO
/// - 8 : Ep[[h
/// - 9 : X[v[h
/// @return n̏
int serial_getinfo(int comp, int n)
{
	int j;

	for (j = 0;j < SER_PORTS;j++) {
		if (sp[j].com == comp && sp[j].flag) {
			switch (n) {
				case 1: return sp[j].base;
				case 2: return sp[j].type;
				case 3: return sp[j].div;
				case 4: return sp[j].com;
				case 5: return sp[j].lctl;
				case 6: return sp[j].cpin;
				case 7: return sp[j].flag;
				case 8: return sp[j].lowpmode;
				case 9: return sp[j].slpmode;
			}		
		}
	}

	return (int)NULL;
}

/// @brief VA|[g̃[hݒ肷.
/// 
/// X[v[hEp[[hݒ肷
/// @param comp |[gԍ
/// @param type ݒ^Cv
/// - 1 : Ep[[h
/// - 2 : X[v[h
/// @param on On/Off
/// - 1 : On
/// - 0 : Off
void serial_setmode(int comp, int type, char on)
{
	int j;

	for (j = 0;j < SER_PORTS;j++) {
		if (sp[j].flag && sp[j].com == comp) {
			if (type == 1) {
				if (on) {
					turnBitOn(5, sp[j].reg.ier, &sp[j].reg.ier);
					sp[j].lowpmode = 1;
				} else {
					turnBitOff(5, sp[j].reg.ier, &sp[j].reg.ier);
					sp[j].lowpmode = 0;
				}
			} else if (type == 2) {
				if (on) {
					turnBitOn(4, sp[j].reg.ier, &sp[j].reg.ier);
					sp[j].slpmode = 1;
				} else {
					turnBitOff(4, sp[j].reg.ier, &sp[j].reg.ier);
					sp[j].slpmode = 0;
				}
			} else {
				/* Ȃ */
				return;
			}
		}
	}
	
	return;
}

/// @brief VA|[ǧ^Ԃ.
///
/// {Iɂ ::detect_serialport ŕԂꂽlnɓnׂ
/// @param n ԍ
/// @return ñ|[g^
char *serial_typename(int n)
{
	char *uart_name[5]={
		"None",
		"UART8250",
		"UART16450",
		"UART16550A",
		"UART16750"
	};
	return uart_name[n];
}

/// @brief ʐMxf[^ƂĂ̒lɕϊ
/// @param div ƂĂ̒ʐMx
/// @return divɉl
UINT32 serial_convdiv(int div)
{
	switch (div) {
		case 0x30: return 2400;
		case 0x18: return 4800;
		case 0x0c: return 9600;
		case 0x06: return 19200;
		case 0x03: return 38400;
		case 0x02: return 67600;
		case 0x01: return 115200;
		default: return 0;
	}
}

/// @brief p\ȃVA|[g
/// @param defdiv ftHg̒ʐMx
/// @return ꂽ|[g̐
/// @note KŏɂĂяoȂ΂ȂȂ
int init_serialports(int defdiv)
{
	int j, c = 0, ret;
	
	for (j = 0;j < SER_PORTS;j++) {
		sp[j].flag = 0;
		sp[j].com = 0;
	}
	
	for (j = 0;j < SER_PORTS;j++) {
		ret = detect_serialport(j);
		if (ret) {
			sp[j].base = reg[j].thr; 	/* base+0Ȃ̂baseƓ */
			sp[j].com = j + 1;			/* com0->com1, com1->com2ƕ␳邽 */
			sp[j].type = ret;
			sp[j].reg = reg[j];
			sp[j].div = defdiv;
			sp[j].lctl = 0x03;
			sp[j].cpin = 0x0b;
			init_serialport(j, sp[j].div, sp[j].lctl, sp[j].cpin);
			sp[j].flag = 1;
			serial_setmode(sp[j].com, 1, 0);
			serial_setmode(sp[j].com, 2, 0);
			c++;
		}
	}
	
	return c;
}

/// @brief VA|[gɃLN^M
/// @param comp |[gԍ
/// @param c Mf[^
/// @retval 0 ɑMꂽ
/// @retval -1 炩̃G[
int send_char_serialport(int comp, char c)
{
	int j, r = 0;

	for (j = 0;j < SER_PORTS;j++) {
		if (sp[j].flag && sp[j].com == comp) {
			io_out8(sp[j].reg.thr, (int)c);
			r = receive_stat_serialport(sp[j].com);
			if (getBit(6, r)) return 0;
			else return -1;
		}
	}
	
	return -1;
}

/// @brief VA|[gɕ񑗐M
/// @param comp |[gԍ
/// @param string M镶
/// @return 0łȂ΁A̐l̕Ԗڂŉ炩̑MG[NӖ
int send_string_serialport(int comp, char *string)
{
	int j, r = 0;
	
	for (j = 0;string[j] != 0;j++) {
		r = send_char_serialport(comp, string[j]);
		if (r == -1) return j;
	}
	
	return 0;
}

/// @brief VA|[g̃Xe[^Xǂ
/// @param comp |[gԍ
/// @return ȉ̂悤Ȓl.
/// - bit0 = 1 : LN^M
/// - bit6 = 1 : LN^𑗐M
/// - bit1 = 1 : Overrun error
/// - bit2 = 1 : Parity error
/// - bit3 = 1 : Framing error
int receive_stat_serialport(int comp)
{
	int j;

	for (j = 0;j < SER_PORTS;j++) {
		if (sp[j].flag && sp[j].com == comp) {
			return io_in8(sp[j].reg.lsr);
		}
	}

	return -1;
}

/// @brief VA|[gLN^M
/// @param comp |[gԍ
/// @param buf Mf[^̓nϐ|C^
/// @return Mf[^
/// @retval 0 ɎMꂽ
/// @retval -1 炩̃G[
int recv_char_serialport(int comp, char *buf)
{
	int j, r = 0;
	
	for (j = 0;j < SER_PORTS;j++) {
		if (sp[j].flag && sp[j].com == comp) {
			*buf = io_in8(sp[j].reg.rbr);
			r = receive_stat_serialport(sp[j].com);
			if (getBit(0, r)) return 0;
			else return -1;			
		}
	}
	
	return -1;
}

/// @brief COM2̊荞
/// @todo ̎
void inthandler23(int *esp)
{
	return;
}

/// @brief COM1̊荞
/// @todo ̎
void inthandler24(int *esp)
{
	return;
}
