/// @file sheet.c
/// @brief V[g֘A.
///
/// }EXEBhȄdˍ킹s
/// @author JsZ(is2os)
/// @since 2010-08-23(r41)

#include "bootpack.h"

/// @brief ::SHTCTL 
/// @param vram VRAMAhX
/// @return ꂽ ::SHTCTL
struct SHTCTL *shtctl_init(UCHAR *vram)
{
	struct SHTCTL *ctl;
	int i;
	struct BOOTINFO *binfo = (struct BOOTINFO *) ADR_BOOTINFO;
	
	ctl = (struct SHTCTL *) memman_alloc_4k(sizeof (struct SHTCTL));
	if (ctl == 0) {
		goto err;
	}
	
	ctl->map = (UCHAR *) memman_alloc_4k(binfo->scrnx * binfo->scrny);
	if (ctl->map == 0) {
		memman_free_4k((int) ctl, sizeof (struct SHTCTL));
		goto err;
	}
	
	ctl->vram = vram;
	ctl->xsize = binfo->scrnx;
	ctl->ysize = binfo->scrny;
	ctl->top = -1; /* V[g͈ꖇȂ */
	for (i = 0; i < MAX_SHEETS; i++) {
		ctl->sheets0[i].flags = 0; /* gp}[N */
		ctl->sheets0[i].ctl = ctl; /* L^ */
	}
	ctl->active = 0;
	
	debugmsg("Initialized SHTCTL...");
	
err:
	return ctl;
}

/// @brief V[gm
/// @return mۂꂽV[g
struct SHEET *sheet_alloc(void)
{
	struct SHEET *sht;
	int i;
	struct SHTCTL *ctl = (struct SHTCTL *) *((int *) 0x0fe4);
	
	for (i = 0; i < MAX_SHEETS; i++) {
		if (ctl->sheets0[i].flags == 0) {
			sht = &ctl->sheets0[i];
			sht->flags = SHEET_USE; /* gp}[N */
			sht->height = -1; /* \ */
			sht->task = 0;	/* ŕ@\gȂ */
			sht->title = 0;
			sht->mode = SHT_MODE_USUAL;
			sht->saved = 0;
			sht->id = rand(); /* ID */
			logging(LOG_DEBUG, "Sheet allocated (%d)", sht->id);
			return sht;
		}
	}
	
	return 0;	/* SẴV[ggp */
}

/// @brief V[gɃobt@ݒ肷
/// @param sht ݒ肷V[g
/// @param buf obt@
/// @param xsize cTCY
/// @param ysize TCY
/// @param col_inv ߂邩ۂ
void sheet_setbuf(struct SHEET *sht, UCHAR *buf, int xsize, int ysize, int col_inv)
{
	sht->buf = buf;
	sht->bxsize = xsize;
	sht->bysize = ysize;
	sht->col_inv = col_inv;
	return;
}

void sheet_refreshmap(int vx0, int vy0, int vx1, int vy1, int h0)
{
	int h, bx, by, vx, vy, bx0, by0, bx1, by1, sid4, *p;
	struct SHTCTL *ctl = (struct SHTCTL *) *((int *) 0x0fe4);
	UCHAR *buf, sid, *map = ctl->map;
	struct SHEET *sht;
	
	if (vx0 < 0) { vx0 = 0; }
	if (vy0 < 0) { vy0 = 0; }
	if (vx1 > ctl->xsize) { vx1 = ctl->xsize; }
	if (vy1 > ctl->ysize) { vy1 = ctl->ysize; }
	for (h = h0; h <= ctl->top; h++) {
		sht = ctl->sheets[h];
		sid = sht - ctl->sheets0; /* ԒnZĂԍƂėp */
		buf = sht->buf;
		bx0 = vx0 - sht->vx0;
		by0 = vy0 - sht->vy0;
		bx1 = vx1 - sht->vx0;
		by1 = vy1 - sht->vy0;
		if (bx0 < 0) { bx0 = 0; }
		if (by0 < 0) { by0 = 0; }
		if (bx1 > sht->bxsize) { bx1 = sht->bxsize; }
		if (by1 > sht->bysize) { by1 = sht->bysize; }
		if (sht->col_inv == -1) {
			if ((sht->vx0 & 3) == 0 && (bx0 & 3) == 0 && (bx1 & 3) == 0) {
				/* FȂp̍Łi4oCg^j */
				bx1 = (bx1 - bx0) / 4; /* MOV */
				sid4 = sid | sid << 8 | sid << 16 | sid << 24;
				for (by = by0; by < by1; by++) {
					vy = sht->vy0 + by;
					vx = sht->vx0 + bx0;
					p = (int *) &map[vy * ctl->xsize + vx];
					for (bx = 0; bx < bx1; bx++) {
						p[bx] = sid4;
					}
				}
			} else {
				/* FȂp̍Łi1oCg^j */
				for (by = by0; by < by1; by++) {
					vy = sht->vy0 + by;
					for (bx = bx0; bx < bx1; bx++) {
						vx = sht->vx0 + bx;
						map[vy * ctl->xsize + vx] = sid;
					}
				}
			}
		} else {
			/* F̈ʔ */
			for (by = by0; by < by1; by++) {
				vy = sht->vy0 + by;
				for (bx = bx0; bx < bx1; bx++) {
					vx = sht->vx0 + bx;
					if (buf[by * sht->bxsize + bx] != sht->col_inv) {
						map[vy * ctl->xsize + vx] = sid;
					}
				}
			}
		}
	}
	
	return;
}

void sheet_refreshsub(int vx0, int vy0, int vx1, int vy1, int h0, int h1)
{
	int h, bx, by, vx, vy, bx0, by0, bx1, by1, bx2, sid4, i, i1, *p, *q, *r;
	struct SHTCTL *ctl = (struct SHTCTL *) *((int *) 0x0fe4);
	UCHAR *buf, *vram = ctl->vram, *map = ctl->map, sid;
	struct SHEET *sht;
	
	/* refresh͈͂ʊOɂ͂ݏoĂ␳ */
	if (vx0 < 0) { vx0 = 0; }
	if (vy0 < 0) { vy0 = 0; }
	if (vx1 > ctl->xsize) { vx1 = ctl->xsize; }
	if (vy1 > ctl->ysize) { vy1 = ctl->ysize; }
	for (h = h0; h <= h1; h++) {
		sht = ctl->sheets[h];
		buf = sht->buf;
		sid = sht - ctl->sheets0;
		/* vx0`vy1gāAbx0`by1tZ */
		bx0 = vx0 - sht->vx0;
		by0 = vy0 - sht->vy0;
		bx1 = vx1 - sht->vx0;
		by1 = vy1 - sht->vy0;
		if (bx0 < 0) { bx0 = 0; }
		if (by0 < 0) { by0 = 0; }
		if (bx1 > sht->bxsize) { bx1 = sht->bxsize; }
		if (by1 > sht->bysize) { by1 = sht->bysize; }
		if ((sht->vx0 & 3) == 0) {
			/* 4oCg^ */
			i  = (bx0 + 3) / 4; /* bx04Ŋ́i[؂グj */
			i1 =  bx1      / 4; /* bx14Ŋ́i[؂̂āj */
			i1 = i1 - i;
			sid4 = sid | sid << 8 | sid << 16 | sid << 24;
			for (by = by0; by < by1; by++) {
				vy = sht->vy0 + by;
				for (bx = bx0; bx < bx1 && (bx & 3) != 0; bx++) {	/* O̒[1oCg */
					vx = sht->vx0 + bx;
					if (map[vy * ctl->xsize + vx] == sid) {
						vram[vy * ctl->xsize + vx] = buf[by * sht->bxsize + bx];
					}
				}
				vx = sht->vx0 + bx;
				p = (int *) &map[vy * ctl->xsize + vx];
				q = (int *) &vram[vy * ctl->xsize + vx];
				r = (int *) &buf[by * sht->bxsize + bx];
				for (i = 0; i < i1; i++) {							/* 4̔{ */
					if (p[i] == sid4) {
						q[i] = r[i];
					} else {
						bx2 = bx + i * 4;
						vx = sht->vx0 + bx2;
						if (map[vy * ctl->xsize + vx + 0] == sid) {
							vram[vy * ctl->xsize + vx + 0] = buf[by * sht->bxsize + bx2 + 0];
						}
						if (map[vy * ctl->xsize + vx + 1] == sid) {
							vram[vy * ctl->xsize + vx + 1] = buf[by * sht->bxsize + bx2 + 1];
						}
						if (map[vy * ctl->xsize + vx + 2] == sid) {
							vram[vy * ctl->xsize + vx + 2] = buf[by * sht->bxsize + bx2 + 2];
						}
						if (map[vy * ctl->xsize + vx + 3] == sid) {
							vram[vy * ctl->xsize + vx + 3] = buf[by * sht->bxsize + bx2 + 3];
						}
					}
				}
				for (bx += i1 * 4; bx < bx1; bx++) {				/* ̒[1oCg */
					vx = sht->vx0 + bx;
					if (map[vy * ctl->xsize + vx] == sid) {
						vram[vy * ctl->xsize + vx] = buf[by * sht->bxsize + bx];
					}
				}
			}
		} else {
			/* 1oCg^ */
			for (by = by0; by < by1; by++) {
				vy = sht->vy0 + by;
				for (bx = bx0; bx < bx1; bx++) {
					vx = sht->vx0 + bx;
					if (map[vy * ctl->xsize + vx] == sid) {
						vram[vy * ctl->xsize + vx] = buf[by * sht->bxsize + bx];
					}
				}
			}
		}
	}
	
	return;
}

/// @brief V[g̍ݒ肷
///
/// YW̍ł͂ȂAd˂킹ɂ鍂
/// @param sht ݒ肷V[g
/// @param height 
void sheet_updown(struct SHEET *sht, int height)
{
	struct SHTCTL *ctl = sht->ctl;
	int h, old = sht->height; /* ݒO̍L */

	/* w肪Ⴗ⍂AC */
	if (height > ctl->top + 1) {
		height = ctl->top + 1;
	}
	if (height < -1) {
		height = -1;
	}
	sht->height = height; /* ݒ */

	/* ȉ͎sheets[]̕בւ */
	if (old > height) {	/* ȑOႭȂ */
		if (height >= 0) {
			/* Ԃ̂̂グ */
			for (h = old; h > height; h--) {
				ctl->sheets[h] = ctl->sheets[h - 1];
				ctl->sheets[h]->height = h;
			}
			ctl->sheets[height] = sht;
			sheet_refreshmap(sht->vx0, sht->vy0, sht->vx0 + sht->bxsize, sht->vy0 + sht->bysize, height + 1);
			sheet_refreshsub(sht->vx0, sht->vy0, sht->vx0 + sht->bxsize, sht->vy0 + sht->bysize, height + 1, old);
		} else {	/* \ */
			if (ctl->top > old) {
				/* ɂȂĂ̂낷 */
				for (h = old; h < ctl->top; h++) {
					ctl->sheets[h] = ctl->sheets[h + 1];
					ctl->sheets[h]->height = h;
				}
			}
			ctl->top--; /* \̉̂ŁAԏ̍ */
			sheet_refreshmap(sht->vx0, sht->vy0, sht->vx0 + sht->bxsize, sht->vy0 + sht->bysize, 0);
			sheet_refreshsub(sht->vx0, sht->vy0, sht->vx0 + sht->bxsize, sht->vy0 + sht->bysize, 0, old - 1);
		}
	} else if (old < height) {	/* ȑOȂ */
		if (old >= 0) {
			/* Ԃ̂̂ */
			for (h = old; h < height; h++) {
				ctl->sheets[h] = ctl->sheets[h + 1];
				ctl->sheets[h]->height = h;
			}
			ctl->sheets[height] = sht;
		} else {	/* \Ԃ\Ԃ */
			/* ɂȂ̂グ */
			for (h = ctl->top; h >= height; h--) {
				ctl->sheets[h + 1] = ctl->sheets[h];
				ctl->sheets[h + 1]->height = h + 1;
			}
			ctl->sheets[height] = sht;
			ctl->top++; /* \̉̂ŁAԏ̍ */
		}
		sheet_refreshmap(sht->vx0, sht->vy0, sht->vx0 + sht->bxsize, sht->vy0 + sht->bysize, height);
		sheet_refreshsub(sht->vx0, sht->vy0, sht->vx0 + sht->bxsize, sht->vy0 + sht->bysize, height, height);
	}
	return;
}

/// @brief V[g
/// @param sht V[g
/// @param bx0 XW
/// @param by0 YW
/// @param bx1 EXW
/// @param by1 EYW
void sheet_refresh(struct SHEET *sht, int bx0, int by0, int bx1, int by1)
{
	if (sht->height >= 0) { /* \ȂAV̏ɉĉʂ` */
		sheet_refreshsub(sht->vx0 + bx0, sht->vy0 + by0, sht->vx0 + bx1, sht->vy0 + by1, sht->height, sht->height);
	}
	return;
}

/// @brief V[g̍Wݒ
/// @param sht ݒ肷V[g
/// @param vx0 XW
/// @param vy0 YW
void sheet_slide(struct SHEET *sht, int vx0, int vy0)
{
	int old_vx0 = sht->vx0, old_vy0 = sht->vy0;
	sht->vx0 = vx0;
	sht->vy0 = vy0;
	if (sht->height >= 0) { /* \ȂAV̏ɉĉʂ` */
		sheet_refreshmap(old_vx0, old_vy0, old_vx0 + sht->bxsize, old_vy0 + sht->bysize, 0);
		sheet_refreshmap(vx0, vy0, vx0 + sht->bxsize, vy0 + sht->bysize, sht->height);
		sheet_refreshsub(old_vx0, old_vy0, old_vx0 + sht->bxsize, old_vy0 + sht->bysize, 0, sht->height - 1);
		sheet_refreshsub(vx0, vy0, vx0 + sht->bxsize, vy0 + sht->bysize, sht->height, sht->height);
	}
	return;
}

/// @brief V[gJ
/// @param sht JV[g
void sheet_free(struct SHEET *sht)
{
	if (sht->height >= 0) {
		sheet_updown(sht, -1); /* \Ȃ܂\ɂ */
	}
	sht->flags = 0; /* gp}[N */
	
	logging(LOG_DEBUG, "Sheet released (%d)", sht->id);
	
	return;
}

/// @brief V[gANeBuɂ
/// @param sht ANeBuɂV[g
/// @param x XW
/// @param y YW
void sheet_active_top(struct SHEET *sht, int x, int y)
{
	struct SHTCTL *shtctl = (struct SHTCTL *) *((int *) 0x0fe4);

	sheet_slide(sht, x, y);
	sheet_updown(sht, shtctl->top);
	keywin_on(sht);
	
	return;
}

/// @brief V[g̃f[^ۑ
/// @param sht ۑV[g
void sheet_save_svdat(struct SHEET *sht)
{
	sht->buf_sv = (UCHAR *)memman_alloc_4k(sht->bxsize * sht->bysize);
	memcpy(sht->buf_sv, sht->buf, sht->bxsize * sht->bysize);
	sht->bxsize_sv = sht->bxsize;
	sht->bysize_sv = sht->bysize;
	sht->vx0_sv = sht->vx0;
	sht->vy0_sv = sht->vy0;
	sht->saved = TRUE;
	return;
}

/// @brief V[g̕ۑꂽf[^폜
/// @param sht 폜V[g
void sheet_free_svdat(struct SHEET *sht)
{
	memman_free_4k((int)sht->buf_sv, sht->bxsize * sht->bysize);
	sht->saved = FALSE;
	return;
}

/// @brief ۑꂽV[g̃f[^XgA
/// @param sht XgAV[g
void sheet_restore_svdat(struct SHEET *sht)
{	
	memcpy(sht->buf, sht->buf_sv, sht->bxsize_sv * sht->bysize_sv);
	return;
}

/// @brief V[gRpNgĂ邩ǂ
/// @brief sht mFV[g
int is_window_compacted(struct SHEET *sht)
{
	if (sht->mode == SHT_MODE_COMPACTED) return TRUE;
	else return FALSE;
}
