/// @file sound.c
/// @brief TEh֌W
/// @author JsZ(is2os)
/// @since 2010-08-23(r41)

#include "bootpack.h"

#define	LEFT_SPEKER_D	0x0220	///< Left Data (W)
#define LEFT_SPEKER_A	0x0221	///< Left Addresss (R/W)
#define RIGHT_SPEKER_D	0x0222	///< Right Data (W)
#define RIGHT_SPEKER_A	0x0223	///< Right Address (R/W)
#define DATA_PORT		0x0389	///< Both Data (W)
#define ADDRESS_PORT	0x0388	///< Both Address (R/W)

/// @brief AdlibɃf[^
/// @param reg WX^[
/// @param data f[^
void senddata_adlib(int reg, int data)
{
	int i;

	io_out8(ADDRESS_PORT, reg);
	for (i = 0;i < 6;i++) {
		io_in8(ADDRESS_PORT);
	}
	io_out8(DATA_PORT, data);
	for (i = 0;i < 25;i++) {
		io_in8(DATA_PORT);
	}
	
	return;
}

/// @brief Adlib̃f[^ǂ
/// @return ǂ񂾃f[^
int readdata_adlib(void)
{
	return io_in8(ADDRESS_PORT);
}

/// @brief Adlib̃eXg
/// @brief Do͂
void test_adlib(void)
{
	senddata_adlib(20, 1);
	senddata_adlib(40, 10);
	senddata_adlib(60, 0xf0);
	senddata_adlib(80, 77);
	senddata_adlib(0xa0, 98);
	senddata_adlib(23, 1);
	senddata_adlib(43, 0);
	senddata_adlib(63, 0xf0);
	senddata_adlib(83, 77);
	senddata_adlib(0xb0, 31);
	kernel_sleep(200);
	senddata_adlib(0xb0, 11);
	return;
}

/// @brief Adlib݂̑mF
/// @return ݂1AȂ0
int detect_fmchip(void)
{
	int exist1 = 0, exist2 = 0;

	/* step1 */
	senddata_adlib(4, 0x60);
	senddata_adlib(4, 0x80);
	exist1 = readdata_adlib();
	
	/* step2 */
	senddata_adlib(2, 0xff);
	senddata_adlib(4, 0x21);
	kernel_sleep(100);
	exist2 = readdata_adlib();
	
	/* step3 */
	senddata_adlib(4, 0x60);
	senddata_adlib(4, 0x80);
	exist1 &= 0xe0;
	exist2 &= 0xe0;
	
	if (exist1 == 0x00 && exist2 == 0xc0) return 1;
	else return 0;
}
