/// @file strtok.c
/// @brief strtok̂
/// @since 2010-10-10(r85)
/// @author JsZ
/// @note NULLׂ0ɒu

/*
* (c) copyright 1987 by the Vrije Universiteit, Amsterdam, The Netherlands.
* See the copyright notice in the ACK home directory, in the file "Copyright".
*/
/* $Header: strspn.c,v 1.1 89/05/11 10:09:09 eck Exp $ */

#include <string.h>

/// @brief w肳ꂽŋ؂Ԃ
char *strtok(register char *string, const char *separators)
{
	register char *s1, *s2;
	static char *savestring;

	if (string == 0) {
		string = savestring;
		if (string == 0) return 0;
	}

	s1 = string + strspn(string, separators);
	if (*s1 == '\0') {
		savestring = 0;
		return 0;
	}

	s2 = strpbrk(s1, separators);
	if (s2 != 0) *s2++ = '\0';
	savestring = s2;

	return s1;
}

