/// @file timer.c
/// @brief ^C}֘A.
///
/// ^C}̓s
/// @brief JsZ(is2os)
/// @since 2010-08-23(r41)

/* ^C}֌W */

#include "bootpack.h"

#define PIT_CTRL	0x0043	///< PITRg[WX^
#define PIT_CNT0	0x0040	///< JE^0

struct TIMERCTL timerctl;	///< ^C}Rg[{

#define TIMER_FLAGS_ALLOC 1	///< mۂ
#define TIMER_FLAGS_USING 2	///< ^C}쓮

/// @brief PIT̏
void init_pit(void)
{
	int i;
	struct TIMER *t;
	io_out8(PIT_CTRL, 0x34);
	io_out8(PIT_CNT0, 0x9c);
	io_out8(PIT_CNT0, 0x2e);
	timerctl.count = 0;
	for (i = 0; i < MAX_TIMER; i++) {
		timerctl.timers0[i].flags = 0; /* gp */
	}
	t = timer_alloc(); /* Ă */
	t->timeout = 0xffffffff;
	t->flags = TIMER_FLAGS_USING;
	t->next = 0; /* Ԃ */
	timerctl.t0 = t; /* ͔ԕȂ̂Ő擪ł */
	timerctl.next = 0xffffffff; /* ԕȂ̂Ŕԕ̎ */
	
	debugmsg("Initialized PIT..");
	
	return;
}

/// @brief 󂫃^C}̎擾
/// @return 擾^C}
struct TIMER *timer_alloc(void)
{
	int i;
	for (i = 0; i < MAX_TIMER; i++) {
		if (timerctl.timers0[i].flags == 0) {
			timerctl.timers0[i].flags = TIMER_FLAGS_ALLOC;
			timerctl.timers0[i].flags2 = 0;
			return &timerctl.timers0[i];
		}
	}
	return 0; /* Ȃ */
}

/// @brief ^C}̊J
/// @param timer J^C}
void timer_free(struct TIMER *timer)
{
	timer->flags = 0; /* gp */
	return;
}

/// @brief ^C}̏
/// @param timer ^C}
/// @param fifo 蓖ĂFIFO
/// @param data Mf[^
void timer_init(struct TIMER *timer, struct FIFO32 *fifo, int data)
{
	timer->fifo = fifo;
	timer->data = data;
	return;
}

/// @brief ^CAEgݒ肷
/// @param timer ݒ肷^C}
/// @param timeout ^CAEg̒l
void timer_settime(struct TIMER *timer, UINT32 timeout)
{
	int e;
	struct TIMER *t, *s;
	timer->timeout = timeout + timerctl.count;
	timer->flags = TIMER_FLAGS_USING;
	e = io_load_eflags();
	io_cli();
	t = timerctl.t0;
	if (timer->timeout <= t->timeout) {
		/* 擪ɓꍇ */
		timerctl.t0 = timer;
		timer->next = t; /* t */
		timerctl.next = timer->timeout;
		io_store_eflags(e);
		return;
	}
	/* ǂɓ΂T */
	for (;;) {
		s = t;
		t = t->next;
		if (timer->timeout <= t->timeout) {
			/* st̊Ԃɓꍇ */
			s->next = timer; /* s̎timer */
			timer->next = t; /* timer̎t */
			io_store_eflags(e);
			return;
		}
	}
}

/// @brief ^C}̊荞݃nh
void inthandler20(int *esp)
{
	struct TIMER *timer;
	char ts = 0;
	io_out8(PIC0_OCW2, 0x60);	/* IRQ-00tPICɒʒm */
	timerctl.count++;
	if (timerctl.next > timerctl.count) {
		return;
	}
	timer = timerctl.t0; /* Ƃ肠擪̔Ԓntimerɑ */
	for (;;) {
		/* timers̃^C}͑Sē쒆̂̂Ȃ̂ŁAflagsmFȂ */
		if (timer->timeout > timerctl.count) {
			break;
		}
		/* ^CAEg */
		timer->flags = TIMER_FLAGS_ALLOC;
		if (timer != task_timer) {
			fifo32_put(timer->fifo, timer->data);
		} else {
			ts = 1; /* task_timer^CAEg */
		}
		timer = timer->next; /* ̃^C}̔Ԓntimerɑ */
	}
	timerctl.t0 = timer;
	timerctl.next = timer->timeout;
	if (ts != 0) {
		task_switch();
	}
	return;
}

/// @brief ^C}̎
/// @param timer ^C}
int timer_cancel(struct TIMER *timer)
{
	int e;
	struct TIMER *t;
	e = io_load_eflags();
	io_cli();	/* ݒ蒆Ƀ^C}̏ԂωȂ悤ɂ邽 */
	if (timer->flags == TIMER_FLAGS_USING) {	/* ͕KvH */
		if (timer == timerctl.t0) {
			/* 擪ꍇ̎ */
			t = timer->next;
			timerctl.t0 = t;
			timerctl.next = t->timeout;
		} else {
			/* 擪ȊȌꍇ̎ */
			/* timer̈OT */
			t = timerctl.t0;
			for (;;) {
				if (t->next == timer) {
					break;
				}
				t = t->next;
			}
			t->next = timer->next; /* utimer̒Ov̎Autimer̎vw悤ɂ */
		}
		timer->flags = TIMER_FLAGS_ALLOC;
		io_store_eflags(e);
		return 1;	/* LZ */
	}
	io_store_eflags(e);
	return 0; /* LZ͕sv */
}

/// @brief SẴ^C}
/// @param fifo 蓖ĂĂFIFO
void timer_cancelall(struct FIFO32 *fifo)
{
	int e, i;
	struct TIMER *t;
	e = io_load_eflags();
	io_cli();	/* ݒ蒆Ƀ^C}̏ԂωȂ悤ɂ邽 */
	for (i = 0; i < MAX_TIMER; i++) {
		t = &timerctl.timers0[i];
		if (t->flags != 0 && t->flags2 != 0 && t->fifo == fifo) {
			timer_cancel(t);
			timer_free(t);
		}
	}
	io_store_eflags(e);
	return;
}

/// @brief J[lxŃX[v
/// @param time X[vl
void kernel_sleep(UINT32 time)
{
	struct FIFO32 timer_fifo;
	int timerbuf[32];
	struct TIMER *timer;
	int val = rand(); /* d */
	int sig;
	
	fifo32_init(&timer_fifo, 32, timerbuf, 0);
	timer = timer_alloc();
	timer_init(timer, &timer_fifo, val);
	timer_settime(timer, time);
	
	for (;;) {
		io_cli();
		if (fifo32_status(&timer_fifo)) {
			sig = fifo32_get(&timer_fifo);
			io_sti();
			if (sig == val) {
				break;
			}
		} else {
			io_stihlt();
			
		}
	}
	
	timer_free(timer);	
	return;
}
