/// @file window.c
/// @brief EBhE֌W.
///
/// EBhE̕`s
/// @author JsZ(is2os), Sero_S
/// @since 2010-08-23(r41)

#include "bootpack.h"

/// @brief EBhE`
/// @param buf `ʂrfI
/// @param xsize EBhẺ
/// @param ysize EBhE̍
/// @param title ^Cg
/// @param act EBhȄ
void draw_window8(UCHAR *buf, int xsize, int ysize, char *title, char act)
{
	boxfill8(buf, xsize, COL8_C6C6C6, 0,         0,         xsize - 1, 0        );
	boxfill8(buf, xsize, COL8_FFFFFF, 1,         1,         xsize - 2, 1        );
	boxfill8(buf, xsize, COL8_C6C6C6, 0,         0,         0,         ysize - 1);
	boxfill8(buf, xsize, COL8_FFFFFF, 1,         1,         1,         ysize - 2);
	boxfill8(buf, xsize, COL8_848484, xsize - 2, 1,         xsize - 2, ysize - 2);
	boxfill8(buf, xsize, COL8_000000, xsize - 1, 0,         xsize - 1, ysize - 1);
	boxfill8(buf, xsize, COL8_C6C6C6, 2,         2,         xsize - 3, ysize - 3);
	boxfill8(buf, xsize, COL8_848484, 1,         ysize - 2, xsize - 2, ysize - 2);
	boxfill8(buf, xsize, COL8_000000, 0,         ysize - 1, xsize - 1, ysize - 1);
	draw_wtitle8(buf, xsize, title, act);
	return;
}

/// @brief EBhẼ^CgɃ{^`
/// @param buf `ʂrfI
/// @param xsize ␳TCY
void draw_button(UCHAR *buf, int xsize)
{
	int x, y, c;
	
	static char stnbtn[14][16] = {
		"QQQQQQQQQQQQQQQQ",
		"QQQQQQQQQQQQQQ$Q",
		"QQQQQQQQQQQQQQ$Q",
		"QQQQQQQQQQQQQQ$Q",
		"QQQQQQQQQQQQQQ$Q",
		"QQQQQQQQQQQQQQ$Q",
		"QQQQQQQQQQQQQQ$Q",
		"QQQQQQQQQQQQQQ$Q",
		"QQQQQQQQQQQQQQ$Q",
		"QQQQQQQQQQQQQQ$Q",
		"QQQQQQQQQQQQQQ$Q",
		"QQQQQQQQQQQQQQ$Q",
		"Q$$$$$$$$$$$$$$Q",
		"QQQQQQQQQQQQQQQQ"
	};

	/* {^` */
	for (y = 0; y < 14; y++) {
		for (x = 0; x < 16; x++) {
			c = stnbtn[y][x];
			if (c == '@') {
				c = COL8_000000;
			} else if (c == '$') {
				c = COL8_848484;
			} else if (c == 'Q') {
				c = COL8_C6C6C6;
			} else {
				c = COL8_FFFFFF;
			}
			/* ŏ{^ */
			buf[(5 + y) * xsize + (5 + x)] = c;
			/* I{^ */
			buf[(5 + y) * xsize + (xsize - 21 + x)] = c;
			/* RpNg{^ */
			buf[(5 + y) * xsize + (xsize - 38 + x)] = c;	
		}
	}
	
	return;
} 

/// @brief EBhEɃ^Cg̕`
/// @param buf `ʂrfI
/// @param xsize ␳TCY
/// @param title ^Cg
/// @param act EBhȄ
void draw_wtitle8(UCHAR *buf, int xsize, char *title, char act)
{
	const int TITLEW_LEN = 128;
	const int CHAR_WIDTH = 8;
	const int BTN_WIDTH = 18;
	const int BTNS = 4;
	int len, ws, i;
	char tc, tbc, title0[TITLEW_LEN];
	
	if (act != 0) tc = COL8_000000;
	else tc = COL8_C6C6C6;
	
	tbc = rgb2pal(153, 255, 204, 0, 0);
	boxfill8(buf, xsize, tbc, 3, 3, xsize - 4, 20);
	draw_button(buf, xsize);
	
	/* ^Cg̍WvZ */
	/* ^Cg悤Ȃu */
	/* ő啶TITLEW_LENŎw肷 */
	ws = strlen(title);
	if (ws > TITLEW_LEN) ws = TITLEW_LEN;
	memset(title0, 0, TITLEW_LEN);
	strncpy(title0, title, ws);
	if ((strlen(title) * CHAR_WIDTH) + (BTN_WIDTH * BTNS) > xsize - 2) {
		ws = ((xsize - 2) - (BTN_WIDTH * BTNS)) / CHAR_WIDTH;
		memset(title0, 0, TITLEW_LEN);
		for (i = 0;i < ws;i++) strcat(title0, ".");
		strncpy(title0, title, strlen(title0) - 3);
		putfonts8_asc(buf, xsize, 2 + (BTN_WIDTH * (BTNS / 2)), 4, tc, title0);
	} else {
		len = strlen(title0) * CHAR_WIDTH / 2;
		putfonts8_asc(buf, xsize, xsize / 2 - len, 4, tc, title0);
	}
	
	return;
}

/// @brief V[gɕ`
/// @param sht `ʂV[g
/// @param x xW
/// @param y yW
/// @param c ̐F
/// @param b `ʂ镶̔wi̐F
/// @param s `ʂ镶
/// @param l ̒
void putfonts8_asc_sht(struct SHEET *sht, int x, int y, int c, int b, char *s, int l)
{
	struct TASK *task = task_now();
	
	if (is_window_compacted(sht)) {
		return;
	}
	
	boxfill8(sht->buf, sht->bxsize, b, x, y, x + l * 8 - 1, y + 15);
	if (task->langmode != 0 && task->langbyte1 != 0) {
		putfonts8_asc(sht->buf, sht->bxsize, x, y, c, s);
		sheet_refresh(sht, x - 8, y, x + l * 8, y + 16);
	} else {
		putfonts8_asc(sht->buf, sht->bxsize, x, y, c, s);
		sheet_refresh(sht, x, y, x + l * 8, y + 16);
	}
	
	return;
}

/// @brief V[gɃeLXg{bNX`
/// @param sht `ʂV[g
/// @param x0 xW
/// @param y0 yW
/// @param sx ExW
/// @param sy EyW
/// @param c {bNX̐F
void draw_textbox8(struct SHEET *sht, int x0, int y0, int sx, int sy, int c)
{
	int x1 = x0 + sx, y1 = y0 + sy;
	
	if (sht->mode == SHT_MODE_COMPACTED) {
		return;
	}
	
	boxfill8(sht->buf, sht->bxsize, COL8_848484, x0 - 2, y0 - 3, x1 + 1, y0 - 3);
	boxfill8(sht->buf, sht->bxsize, COL8_848484, x0 - 3, y0 - 3, x0 - 3, y1 + 1);
	boxfill8(sht->buf, sht->bxsize, COL8_FFFFFF, x0 - 3, y1 + 2, x1 + 1, y1 + 2);
	boxfill8(sht->buf, sht->bxsize, COL8_FFFFFF, x1 + 2, y0 - 3, x1 + 2, y1 + 2);
	boxfill8(sht->buf, sht->bxsize, COL8_000000, x0 - 1, y0 - 2, x1 + 0, y0 - 2);
	boxfill8(sht->buf, sht->bxsize, COL8_000000, x0 - 2, y0 - 2, x0 - 2, y1 + 0);
	boxfill8(sht->buf, sht->bxsize, COL8_C6C6C6, x0 - 2, y1 + 1, x1 + 0, y1 + 1);
	boxfill8(sht->buf, sht->bxsize, COL8_C6C6C6, x1 + 1, y0 - 2, x1 + 1, y1 + 1);
	boxfill8(sht->buf, sht->bxsize, c,           x0 - 1, y0 - 1, x1 + 0, y1 + 0);
	
	return;
}

/// @brief EBhẼ^Cg̐Fς
/// @param sht V[g
/// @param act EBhȄ
void change_wtitle8(struct SHEET *sht, char act)
{
	int x, y, xsize = sht->bxsize;
	char c, tc_new, tbc_new, tc_old, tbc_old, *buf = sht->buf;
	
	if (act != 0) {
		tc_new  = COL8_000000;
		tbc_new = rgb2pal(153, 255, 204, 0, 0);
		tc_old  = COL8_C6C6C6;
		tbc_old = rgb2pal(153, 255, 204, 0, 0);
	} else {
		tc_new  = COL8_C6C6C6;
		tbc_new = rgb2pal(153, 255, 204, 0, 0);
		tc_old  = COL8_000000;
		tbc_old = rgb2pal(153, 255, 204, 0, 0);
	}
	for (y = 3; y <= 20; y++) {
		for (x = 3; x <= xsize - 4; x++) {
			c = buf[y * xsize + x];
			if (c == tc_old) c = tc_new;
			else if (c == tbc_old) c = tbc_new;
			buf[y * xsize + x] = c;
		}
	}
	draw_button(buf, xsize);
	sheet_refresh(sht, 0, 0, xsize, 25);
	
	return;
}

/// @brief EBhE
/// @param wname EBhẼ^Cg
/// @param ww EBhE̍
/// @param wh EBhẺ
/// @param act EBhȄ
/// @param col_inv ߂邩ǂ
/// @return ꂽEBhẼV[g
struct SHEET *make_window(char *wname, int ww, int wh, int act, int col_inv)
{
	struct SHEET *sht;
	UCHAR *buf;
	
	sht = sheet_alloc();
	buf = (UCHAR *)memman_alloc_4k(ww * wh);
	sheet_setbuf(sht, buf, ww, wh, col_inv);
	draw_window8(buf, ww, wh, wname, act);
	strcpy(sht->title, wname);
	
	return sht;
}


/// @brief EBhE
/// @param sht V[g
void break_window(struct SHEET *sht)
{
	memman_free_4k((int)sht->buf, sht->bxsize * sht->bysize);
	sheet_free(sht);
	return;
}

/// @brief EBhERpNg
/// @param sht RpNgV[g
/// @param sw RpNgON/OFF
/// @note 炩߃V[g̃f[^ۑĂKv
void compacted_window(struct SHEET *sht, int sw)
{
	UCHAR *buf0, s[64];
	int ysize = 0, ysize0 = 0;

	sheet_updown(sht, -1);
	if (sw) {
		sprintf(s, "%s (compacted)", sht->title);
		ysize = ysize0 = (int)CONPACTED_YSIZE;
	} else {
		sprintf(s, "%s", sht->title);
		ysize = sht->bysize_sv;
		ysize0 = sht->bysize;
	}
	memman_free_4k((int)sht->buf, sht->bxsize * sht->bysize);
	buf0 = (UCHAR *)memman_alloc_4k(sht->bxsize_sv * ysize);
	sheet_setbuf(sht, buf0, sht->bxsize_sv, ysize, -1);
	draw_window8(buf0, sht->bxsize_sv, ysize, s, 0);
	
	return;
}
