////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Copyright (c) Microsoft Corporation.  All rights reserved.
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////#include <tinyhal.h>
#include <tinyhal.h>
#include "RX62N_EDMAC_Adapter.h"

RX62N_EDMAC_Driver g_RX62N_EDMAC_Driver;


// extern RX62N_EDMAC_DRIVER_CONFIG g_RX62N_EDMAC_Config;

extern void RX62N_EDMAC_interrupt(void *param);
// -- //

BOOL Network_Interface_Bind(int index)
{
    return RX62N_EDMAC_Driver::Bind();
}
int  Network_Interface_Open(int index)
{
    return RX62N_EDMAC_Driver::Open();
}
BOOL Network_Interface_Close(int index)
{
    return RX62N_EDMAC_Driver::Close();
}

int RX62N_EDMAC_Driver::Open()
{
    int use_default_multicast;

    memset(&g_RX62N_EDMAC_Driver.m_currentDhcpSession, 0, sizeof(g_RX62N_EDMAC_Driver.m_currentDhcpSession));

    // PHY Power Up
    // CPU_GPIO_EnableOutputPin(g_RX62N_EDMAC_Config.PHY_PD_GPIO_Pin, FALSE);

     /* Open the interface first */
    g_RX62N_EDMAC_Driver.m_interfaceNumber = xn_interface_open_config(RX62N_EDMAC_DEVICE, 
                                                    0,              /*  minor_number        */
                                                    0,              /*  ioaddress           */
                                                    0,              /*  irq value           */
                                                    0               /*  mem_address)        */
                                                    );

    if (g_RX62N_EDMAC_Driver.m_interfaceNumber == -1)
    {
        return -1;    
    }
    
    use_default_multicast = 1;
    if (xn_interface_opt(g_RX62N_EDMAC_Driver.m_interfaceNumber, 
                        IO_DEFAULT_MCAST,
                        (RTP_PFCCHAR)&use_default_multicast,
                        sizeof(int)) == -1)
    {
        /* Failed to set the default multicast interface */
        hal_printf("EDMAC: Failed to set the default multicast interface\r\n");
    }

    //CPU_INTC_ActivateInterrupt(RX62NC_ID_EDMAC, RX62N_EDMAC_interrupt, NULL);
	//CPU_INTC_ActivateInterrupt(81, RX62N_EDMAC_interrupt, NULL);
	
    return g_RX62N_EDMAC_Driver.m_interfaceNumber;
}

// -- //

BOOL RX62N_EDMAC_Driver::Close(void)
{
    int retVal = -1;

    //CPU_INTC_DeactivateInterrupt(RX62NC_ID_EDMAC);
	CPU_INTC_DeactivateInterrupt(81);

    /* JRT - changed interface number from 0 */
    retVal = xn_interface_close(g_RX62N_EDMAC_Driver.m_interfaceNumber);
    
    
    if (retVal == 0)
    {
        /* JRT - Wait not necessary since just did a HARD_CLOSE above
        xn_wait_pkts_output(RTP_TRUE, 60);
        */
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

BOOL RX62N_EDMAC_Driver::Bind(void)
{
    int retVal;
    
    retVal = xn_bind_rx62n_mac(0);

    if (retVal != -1)
    {
        return TRUE;
    }
    else
    {
        return FALSE;
    }
}

