////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
// 
// This file is part of the Microsoft .NET Micro Framework Porting Kit Code Samples and is unsupported. 
// Copyright (C) Microsoft Corporation. All rights reserved. Use of this sample source code is subject to 
// the terms of the Microsoft license agreement under which you licensed this sample source code. 
// 
// THIS SAMPLE CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, 
// INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR PURPOSE.
// 
// 
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <tinyhal.h>

#include "vect.h"
#include "..\iodefine.h"
//#include "..\Ethernet\RX62N_Ethernet.h"
#include "..\GPIO\RX62N_GPIO.h"

//--//

#pragma section INTTBL
extern void *INT_Vectors[] = {
// BRK
	(void*) Excep_BRK,
// vector  1 reserved
    (void*) Dummy,
// vector  2 reserved
    (void*) Dummy,
// vector  3 reserved
    (void*) Dummy,
// vector  4 reserved
    (void*) Dummy,
// vector  5 reserved
    (void*) Dummy,
// vector  6 reserved
    (void*) Dummy,
// vector  7 reserved
    (void*) Dummy,
// vector  8 reserved
    (void*) Dummy,
// vector  9 reserved
    (void*) Dummy,
// vector 10 reserved
    (void*) Dummy,
// vector 11 reserved
    (void*) Dummy,
// vector 12 reserved
    (void*) Dummy,
// vector 13 reserved
    (void*) Dummy,
// vector 14 reserved
    (void*) Dummy,
// vector 15 reserved
    (void*) Dummy,
// BUSERR
	(void*) Excep_BUSERR,
// vector 17 reserved
    (void*) Dummy,
// vector 18 reserved
    (void*) Dummy,
// vector 19 reserved
    (void*) Dummy,
// vector 20 reserved
    (void*) Dummy,
// FCU_FCUERR
	(void*) Excep_FCU_FCUERR,
// vector 22 reserved
    (void*) Dummy,
// FCU_FRDYI
	(void*) Excep_FCU_FRDYI,
// vector 24 reserved
    (void*) Dummy,
// vector 25 reserved
    (void*) Dummy,
// vector 26 reserved
    (void*) Dummy,
// ICU SWINT
	(void*) Excep_ICU_SWINT,
// CMTU0_CMT0
	(void*) Excep_CMTU0_CMT0,
// CMTU0_CMT1
	(void*) Excep_CMTU0_CMT1,
// CMTU1_CMT2
	(void*) Excep_CMTU1_CMT2,
// CMTU1_CMT3
	(void*) Excep_CMTU1_CMT3,
// ETHER EINT
	(void*) Excep_ETHER_EINT,
// vector 33 reserved
    (void*) Dummy,
// vector 34 reserved
    (void*) Dummy,
// vector 35 reserved
    (void*) Dummy,
// USB0 D0FIFO0
	(void*) Excep_USB0_D0FIFO0,
// USB0 D1FIFO0
	(void*) Excep_USB0_D1FIFO0,
// USB0 USBI0
	(void*) Excep_USB0_USBI0,
// vector 39 reserved
    (void*) Dummy,
// USB1 D0FIFO1
	(void*) Excep_USB1_D0FIFO1,
// USB1 D1FIFO1
	(void*) Excep_USB1_D1FIFO1,
// USB1 USBI1
	(void*) Excep_USB1_USBI1,
// vector 43 reserved
    (void*) Dummy,
// RSPI0 SPEI0
	(void*) Excep_RSPI0_SPEI0,
// RSPI0 SPRI0
	(void*) Excep_RSPI0_SPRI0,
// RSPI0 SPTI0
	(void*) Excep_RSPI0_SPTI0,
// RSPI0 SPII0
	(void*) Excep_RSPI0_SPII0,
// RSPI1 SPEI1
	(void*) Excep_RSPI1_SPEI1,
// RSPI1 SPRI1
	(void*) Excep_RSPI1_SPRI1,
// RSPI1 SPTI1
	(void*) Excep_RSPI1_SPTI1,
// RSPI1 SPII1
	(void*) Excep_RSPI1_SPII1,
// vector 52 reserved
    (void*) Dummy,
// vector 53 reserved
    (void*) Dummy,
// vector 54 reserved
    (void*) Dummy,
// vector 55 reserved
    (void*) Dummy,
// CAN0 ERS0
	(void*) Excep_CAN0_ERS0,
// CAN0 RXF0
	(void*) Excep_CAN0_RXF0,
// CAN0 TXF0
	(void*) Excep_CAN0_TXF0,
// CAN0 RXM0
	(void*) Excep_CAN0_RXM0,
// CAN0 TXM0
	(void*) Excep_CAN0_TXM0,
// vector 61 reserved
    (void*) Dummy,
// RTC PRD
	(void*) Excep_RTC_PRD,
// RTC CUP
	(void*) Excep_RTC_CUP,
// IRQ0
	(void*) Excep_IRQ0,
// IRQ1
	(void*) Excep_IRQ1,
// IRQ2
	(void*) Excep_IRQ2,
// IRQ3
	(void*) Excep_IRQ3,
// IRQ4
	(void*) Excep_IRQ4,
// IRQ5
	(void*) Excep_IRQ5,
// IRQ6
	(void*) Excep_IRQ6,
// IRQ7
	(void*) Excep_IRQ7,
// IRQ8
	(void*) Excep_IRQ8,
// IRQ9
	(void*) Excep_IRQ9,
// IRQ10
	(void*) Excep_IRQ10,
// IRQ11
	(void*) Excep_IRQ11,
// IRQ12
	(void*) Excep_IRQ12,
// IRQ13
	(void*) Excep_IRQ13,
// IRQ14
	(void*) Excep_IRQ14,
// IRQ15
	(void*) Excep_IRQ15,
// vector 80 reserved
    (void*) Dummy,
// vector 81 reserved
    (void*) Dummy,
// vector 82 reserved
    (void*) Dummy,
// vector 83 reserved
    (void*) Dummy,
// vector 84 reserved
    (void*) Dummy,
// vector 85 reserved
    (void*) Dummy,
// vector 86 reserved
    (void*) Dummy,
// vector 87 reserved
    (void*) Dummy,
// vector 88 reserved
    (void*) Dummy,
// vector 89 reserved
    (void*) Dummy,
// USB RESUME USBR0
	(void*) Excep_USB_USBR0,
// USB RESUME USBR1
	(void*) Excep_USB_USBR1,
// RTC ALM
	(void*) Excep_RTC_ALM,
// vector 93 reserved
    (void*) Dummy,
// vector 94 reserved
    (void*) Dummy,
// vector 95 reserved
// WDT_WOVI
	(void*) Excep_WDT_WOVI,
// vector 97 reserved
    (void*) Dummy,
// AD0_ADI0
	(void*) Excep_AD0_ADI0,
// AD1_ADI1
	(void*) Excep_AD1_ADI1,
// vector 100 reserved
    (void*) Dummy,
// vector 101 reserved
    (void*) Dummy,
// S12AD ADI12
	(void*) Excep_S12AD_ADI12,
// vector 103 reserved
    (void*) Dummy,
// vector 104 reserved
    (void*) Dummy,
// vector 105 reserved
    (void*) Dummy,
// vector 106 reserved
    (void*) Dummy,
// vector 107 reserved
    (void*) Dummy,
// vector 108 reserved
    (void*) Dummy,
// vector 109 reserved
    (void*) Dummy,
// vector 110 reserved
    (void*) Dummy,
// vector 111 reserved
    (void*) Dummy,
// vector 112 reserved
    (void*) Dummy,
// vector 113 reserved
    (void*) Dummy,
// MTU0 TGIA0
	(void*) Excep_MTU0_TGIA0,
// MTU0 TGIB0
	(void*) Excep_MTU0_TGIB0,
// MTU0 TGIC0
	(void*) Excep_MTU0_TGIC0,
// MTU0 TGID0
	(void*) Excep_MTU0_TGID0,
// MTU0 TCIV0
	(void*) Excep_MTU0_TCIV0,
// MTU0 TGIE0
	(void*) Excep_MTU0_TGIE0,
// MTU0 TGIF0
	(void*) Excep_MTU0_TGIF0,
// MTU1 TGIA1
	(void*) Excep_MTU1_TGIA1,
// MTU1 TGIB1
	(void*) Excep_MTU1_TGIB1,
// MTU1 TCIV1
	(void*) Excep_MTU1_TCIV1,
// MTU1 TCIU1
	(void*) Excep_MTU1_TCIU1,
// MTU2 TGIA2
	(void*) Excep_MTU2_TGIA2,
// MTU2 TGIB2
	(void*) Excep_MTU2_TGIB2,
// MTU2 TCIV2
	(void*) Excep_MTU2_TCIV2,
// MTU2 TCIU2
	(void*) Excep_MTU2_TCIU2,
// MTU3 TGIA3
	(void*) Excep_MTU3_TGIA3,
// MTU3 TGIB3
	(void*) Excep_MTU3_TGIB3,
// MTU3 TGIC3
	(void*) Excep_MTU3_TGIC3,
// MTU3 TGID3
	(void*) Excep_MTU3_TGID3,
// MTU3 TCIV3
	(void*) Excep_MTU3_TCIV3,
// MTU4 TGIA4
	(void*) Excep_MTU4_TGIA4,
// MTU4 TGIB4
	(void*) Excep_MTU4_TGIB4,
// MTU4 TGIC4
	(void*) Excep_MTU4_TGIC4,
// MTU4 TGID4
	(void*) Excep_MTU4_TGID4,
// MTU4 TCIV4
	(void*) Excep_MTU4_TCIV4,
// MTU5 TCIU5
	(void*) Excep_MTU5_TCIU5,
// MTU5 TCIV5
	(void*) Excep_MTU5_TCIV5,
// MTU5 TCIW5
	(void*) Excep_MTU5_TCIW5,
// MTU6 TGIA6
	(void*) Excep_MTU6_TGIA6,
// MTU6 TGIB6
	(void*) Excep_MTU6_TGIB6,
// MTU6 TGIC6
	(void*) Excep_MTU6_TGIC6,
// MTU6 TGID6
	(void*) Excep_MTU6_TGID6,
// MTU6 TCIV6
	(void*) Excep_MTU6_TCIV6,
// MTU6 TGIE6
	(void*) Excep_MTU6_TGIE6,
// MTU6 TGIF6
	(void*) Excep_MTU6_TGIF6,
// MTU7 TGIA7
	(void*) Excep_MTU7_TGIA7,
// MTU7 TGIB7
	(void*) Excep_MTU7_TGIB7,
// MTU7 TCIV7
	(void*) Excep_MTU7_TCIV7,
// MTU7 TCIU7
	(void*) Excep_MTU7_TCIU7,
// MTU8 TGIA8
	(void*) Excep_MTU8_TGIA8,
// MTU8 TGIB8
	(void*) Excep_MTU8_TGIB8,
// MTU8 TCIV8
	(void*) Excep_MTU8_TCIV8,
// MTU8 TCIU8
	(void*) Excep_MTU8_TCIU8,
// MTU9 TGIA9
	(void*) Excep_MTU9_TGIA9,
// MTU9 TGIB9
	(void*) Excep_MTU9_TGIB9,
// MTU9 TGIC9
	(void*) Excep_MTU9_TGIC9,
// MTU9 TGID9
	(void*) Excep_MTU9_TGID9,
// MTU9 TCIV9
	(void*) Excep_MTU9_TCIV9,
// MTU10 TGIA10
	(void*) Excep_MTU10_TGIA10,
// MTU10 TGIB10
	(void*) Excep_MTU10_TGIB10,
// MTU10 TGIC10
	(void*) Excep_MTU10_TGIC10,
// MTU10 TGID10
	(void*) Excep_MTU10_TGID10,
// MTU10 TCIV10
	(void*) Excep_MTU10_TCIV10,
// MTU11 TCIU11
	(void*) Excep_MTU11_TCIU11,
// MTU11 TCIV11
	(void*) Excep_MTU11_TCIV11,
// MTU11 TCIW11
	(void*) Excep_MTU11_TCIW11,
// POE OEI1
	(void*) Excep_POE_OEI1,
// POE OEI1
	(void*) Excep_POE_OEI2,
// POE OEI1
	(void*) Excep_POE_OEI3,
// POE OEI1
	(void*) Excep_POE_OEI4,
// TMR0_CMI0A
	(void*) Excep_TMR0_CMI0A,
// TMR0_CMI0B
	(void*) Excep_TMR0_CMI0B,
// TMR0_OV0I
	(void*) Excep_TMR0_OV0I,
// TMR1_CMI1A
	(void*) Excep_TMR1_CMI1A,
// TMR1_CMI1B
	(void*) Excep_TMR1_CMI1B,
// TMR1_OV1I
	(void*) Excep_TMR1_OV1I,
// TMR2_CMI2A
	(void*) Excep_TMR2_CMI2A,
// TMR2_CMI2B
	(void*) Excep_TMR2_CMI2B,
// TMR2_OV2I
	(void*) Excep_TMR2_OV2I,
// TMR3_CMI3A
	(void*) Excep_TMR3_CMI3A,
// TMR3_CMI3B
	(void*) Excep_TMR3_CMI3B,
// TMR3_OV3I
	(void*) Excep_TMR3_OV3I,
// vector 186 reserved
    (void*) Dummy,
// vector 187 reserved
    (void*) Dummy,
// vector 188 reserved
    (void*) Dummy,
// vector 189 reserved
    (void*) Dummy,
// vector 190 reserved
    (void*) Dummy,
// vector 191 reserved
    (void*) Dummy,
// vector 192 reserved
    (void*) Dummy,
// vector 193 reserved
    (void*) Dummy,
// vector 194 reserved
    (void*) Dummy,
// vector 195 reserved
    (void*) Dummy,
// vector 196 reserved
    (void*) Dummy,
// vector 197 reserved
    (void*) Dummy,
// DMACA DMAC0
	(void*) Excep_DMACA_DMAC0,
// DMAC DMAC1
	(void*) Excep_DMACA_DMAC1,
// DMAC DMAC2
	(void*) Excep_DMACA_DMAC2,
// DMAC DMAC3
	(void*) Excep_DMACA_DMAC3,
// EXDMAC DMAC0
	(void*) Excep_EXDMAC_DMAC0,
// EXDMAC DMAC1
	(void*) Excep_EXDMAC_DMAC1,
// vector 203 reserved
    (void*) Dummy,
// vector 204 reserved
    (void*) Dummy,
// vector 205 reserved
    (void*) Dummy,
// vector 206 reserved
    (void*) Dummy,
// vector 207 reserved
    (void*) Dummy,
// vector 208 reserved
    (void*) Dummy,
// vector 209 reserved
    (void*) Dummy,
// vector 210 reserved
    (void*) Dummy,
// vector 211 reserved
    (void*) Dummy,
// vector 212 reserved
    (void*) Dummy,
// vector 213 reserved
    (void*) Dummy,
// SCI0_ERI0
	(void*) Excep_SCI0_ERI0,
// SCI0_RXI0
	(void*) Excep_SCI0_RXI0,
// SCI0_TXI0
	(void*) Excep_SCI0_TXI0,
// SCI0_TEI0
	(void*) Excep_SCI0_TEI0,
// SCI1_ERI1
	(void*) Excep_SCI1_ERI1,
// SCI1_RXI1
	(void*) Excep_SCI1_RXI1,
// SCI1_TXI1
	(void*) Excep_SCI1_TXI1,
// SCI1_TEI1
	(void*) Excep_SCI1_TEI1,
// SCI2_ERI2
	(void*) Excep_SCI2_ERI2,
// SCI2_RXI2
	(void*) Excep_SCI2_RXI2,
// SCI2_TXI2
	(void*) Excep_SCI2_TXI2,
// SCI2_TEI2
	(void*) Excep_SCI2_TEI2,
// SCI3_ERI3
	(void*) Excep_SCI3_ERI3,
// SCI3_RXI3
	(void*) Excep_SCI3_RXI3,
// SCI3_TXI3
	(void*) Excep_SCI3_TXI3,
// SCI3_TEI3
	(void*) Excep_SCI3_TEI3,
// vector 230 reserved
    (void*) Dummy,
// vector 231 reserved
    (void*) Dummy,
// vector 232 reserved
    (void*) Dummy,
// vector 233 reserved
    (void*) Dummy,
// SCI5_ERI5
	(void*) Excep_SCI5_ERI5,
// SCI5_RXI5
	(void*) Excep_SCI5_RXI5,
// SCI5_TXI5
	(void*) Excep_SCI5_TXI5,
// SCI5_TEI5
	(void*) Excep_SCI5_TEI5,
// SCI6_ERI6
	(void*) Excep_SCI6_ERI6,
// SCI6_RXI6
	(void*) Excep_SCI6_RXI6,
// SCI6_TXI6
	(void*) Excep_SCI6_TXI6,
// SCI6_TEI6
	(void*) Excep_SCI6_TEI6,
// vector 242 reserved
    (void*) Dummy,
// vector 243 reserved
    (void*) Dummy,
// vector 244 reserved
    (void*) Dummy,
// vector 245 reserved
    (void*) Dummy,
// RIIC0_EEI0
	(void*) Excep_RIIC0_EEI0,
// RIIC0_RXI0
	(void*) Excep_RIIC0_RXI0,
// RIIC0_TXI0
	(void*) Excep_RIIC0_TXI0,
// RIIC0_TEI0
	(void*) Excep_RIIC0_TEI0,
// RIIC1_EEI1
	(void*) Excep_RIIC1_EEI1,
// RIIC1_RXI1
	(void*) Excep_RIIC1_RXI1,
// RIIC1_TXI1
	(void*) Excep_RIIC1_TXI1,
// RIIC1_TEI1
	(void*) Excep_RIIC1_TEI1,
// vector 254 reserved
    (void*) Dummy,
// vector 255 reserved
    (void*) Dummy,
};

#pragma section

void CPU_INTC_Initialize()
{
}

BOOL CPU_INTC_ActivateInterrupt( UINT32 Irq_Index, HAL_CALLBACK_FPN ISR, void* ISR_Param )
{
    // figure out the interrupt
    HAL_CALLBACK* IsrVector;
    
    IsrVector = (HAL_CALLBACK *)INT_Vectors[Irq_Index];

    if(!IsrVector) 
        return FALSE;
        
    {
        // set the vector
        IsrVector->Initialize( ISR, ISR_Param ); 
    }

    return TRUE;
}

BOOL CPU_INTC_DeactivateInterrupt( UINT32 Irq_Index )
{
    return FALSE;
}

BOOL CPU_INTC_InterruptEnable( UINT32 Irq_Index )
{
    return FALSE;
}

BOOL CPU_INTC_InterruptDisable( UINT32 Irq_Index )
{
    return FALSE;
}

BOOL CPU_INTC_InterruptEnableState( UINT32 Irq_Index )
{
    return FALSE;
}

BOOL CPU_INTC_InterruptState( UINT32 Irq_Index )
{
    return FALSE;
}
