﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
//using System.Reflection;

using SystemCommon;
using ClientCommon;


namespace 顧客分析君
{
    public partial class _402お勧め商品一覧 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

        public int bitMode = 1;     // 1：お勧め商品　２：売筋商品

		//private enum enm画面モード
		//{
		//    お勧め商品 = 1,
		//    売筋商品 = 2
		//}
		private static class 画面モード
		{
            public const byte bytお勧め商品 = 1;
			public const byte byt売筋商品 = 2;
		}

		//private enum enm商品一覧Cell
		//{
		//    商品No = 0,
		//    R = 1,
		//    F = 2,
		//    M = 3,
		//    ランク = 4,
		//    商品ID = 5,
		//    商品名 = 6,
		//    商品単価 = 7,
		//    類似度 = 8
		//}
		private static class 商品一覧Cell
		{
            public const byte byt商品No = 0;
            public const byte bytR = 1;
            public const byte bytF = 2;
            public const byte bytM = 3;
            public const byte bytランク = 4;
            public const byte byt商品ID = 5;
            public const byte byt商品名 = 6;
            public const byte byt商品単価 = 7;
			public const byte byt類似度 = 8;
		}

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド 
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _402お勧め商品一覧()
        {
            InitializeComponent();
        }

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 共通メソッド

        private void Set列幅()
        {
            dgv商品一覧.Columns[商品一覧Cell.byt商品No].Visible = false;
            dgv商品一覧.Columns[商品一覧Cell.bytR].Width = C_列幅.お勧めRFMランク;
            dgv商品一覧.Columns[商品一覧Cell.bytF].Width = C_列幅.お勧めRFMランク;
            dgv商品一覧.Columns[商品一覧Cell.bytM].Width = C_列幅.お勧めRFMランク;
            dgv商品一覧.Columns[商品一覧Cell.bytランク].Width = C_列幅.ランク;
            dgv商品一覧.Columns[商品一覧Cell.byt商品ID].Width = C_列幅.商品ID;
            dgv商品一覧.Columns[商品一覧Cell.byt商品名].Width = C_列幅.商品名;
            dgv商品一覧.Columns[商品一覧Cell.byt商品単価].Width = C_列幅.商品単価;

            if (bitMode == 画面モード.byt売筋商品)
                dgv商品一覧.Columns[商品一覧Cell.byt類似度].Width = C_列幅.販売個数;
        }


        //商品一覧グリッドにデータを表示
        //private void SetDGV商品一覧(D06商品一覧.D06商品一覧DataTable dt)
        //{
        //    ///////////////////////////////////////////////////
        //    // R/F/M値が同じ商品は、横軸に展開するコードは未完成
        //    for (int iRow = 0; iRow < dt.Count; iRow++)
        //    {
        //        dgv商品一覧.RowCount = iRow;

        //        dgv商品一覧.Rows[iRow].Cells[商品一覧Cell.bytR].Value = dt[iRow].R;
        //        dgv商品一覧.Rows[iRow].Cells[商品一覧Cell.bytF].Value = dt[iRow].F;
        //        dgv商品一覧.Rows[iRow].Cells[商品一覧Cell.bytM].Value = dt[iRow].M;
        //        dgv商品一覧.Rows[iRow].Cells[商品一覧Cell.byt商品].Value = dt[iRow].商品ID + "：" + dt[iRow].商品名;
        //    }
        //}


        #endregion

        
        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ

        private void _402お勧め商品一覧_Load(object sender, EventArgs e)
        {
            bool b正常終了 = true;

            try
            {

                //計算済みチェック
                if (C02業務共通処理.最後に計算した日時() == "")
                {
                    b正常終了 = false;
                    MessageBox.Show(Properties.Resources.MSG_W_計算が完了していない為_分析結果を表示できません, this.Text, 
						MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    this.Close();
                    return;
                }

                Cursor.Current = Cursors.WaitCursor;
                //dgv商品一覧.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.None;

                if (bitMode == 画面モード.bytお勧め商品)
                {
                    this.Text = "お勧め商品一覧";

                    //検索実行
                    d06商品一覧ta.FillByお勧め商品(d06商品一覧._D06商品一覧);
					lbl件数.Text = "検索結果：" + d06商品一覧._D06商品一覧.Count.ToString() + " 件";

                    dgv商品一覧.Columns[商品一覧Cell.bytランク].HeaderText = "お勧め商品ランク";
                    //dgv商品一覧.Columns[商品一覧Cell.byt類似度].HeaderText = "相関値";
                    dgv商品一覧.Columns.RemoveAt(商品一覧Cell.byt類似度);

                    //商品一覧グリッドにデータを表示
                    //SetDGV商品一覧(dt);
                }
                else if (bitMode == 画面モード.byt売筋商品)
                {
                    this.Text = "売れ筋商品一覧";

                    //検索実行
                    d06商品一覧ta.FillBy売れ筋商品(d06商品一覧._D06商品一覧);
					lbl件数.Text = "検索結果：" + d06商品一覧._D06商品一覧.Count.ToString() + " 件";

                    dgv商品一覧.Columns[商品一覧Cell.bytランク].HeaderText = "売れ筋商品ランク";
                    dgv商品一覧.Columns[商品一覧Cell.byt類似度].HeaderText = "販売数";

                    //商品一覧グリッドにデータを表示
                    //SetDGV商品一覧(dt);
                }

                //列サイズ調整
                //dgv商品一覧.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.None;
                //dgv商品一覧.Columns[商品一覧Cell.bytR].MinimumWidth = (int)enmグリッド列最小サイズ.RFMタイトル;
                //dgv商品一覧.Columns[商品一覧Cell.bytF].MinimumWidth = (int)enmグリッド列最小サイズ.RFMタイトル;
                //dgv商品一覧.Columns[商品一覧Cell.bytM].MinimumWidth = (int)enmグリッド列最小サイズ.RFMタイトル;
                //dgv商品一覧.Columns[商品一覧Cell.byt商品ID].MinimumWidth = (int)enmグリッド列最小サイズ.商品ID;
                //dgv商品一覧.Columns[商品一覧Cell.byt商品名].MinimumWidth = (int)enmグリッド列最小サイズ.商品名;
                //dgv商品一覧.Columns[商品一覧Cell.byt商品単価].MinimumWidth = (int)enmグリッド列最小サイズ.商品単価;

            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_402お勧め商品一覧", "_402お勧め商品一覧_Load", ex);
            }
            finally
            {
                //dgv商品一覧.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.AllCells;
                if (b正常終了 == true)
                    Set列幅();

                Cursor.Current = Cursors.Arrow;
            }

        }

        private void _402お勧め商品一覧_Resize(object sender, EventArgs e)
        {
            try
            {
				C01FormCommon.画面最小サイズに変更(this, true);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_402お勧め商品一覧", "_402お勧め商品一覧_Resize", ex);
            }
        }

        //private void dgv商品一覧_CellFormatting(object sender, DataGridViewCellFormattingEventArgs e)
        //{
        //    try
        //    {
        //        switch (e.ColumnIndex)
        //        {
        //            case 商品一覧Cell.byt商品単価:
        //                if (dgv商品一覧.Rows[e.RowIndex].Cells[e.ColumnIndex].Value != null)
        //                {
        //                    DataGridViewCellStyle style = new DataGridViewCellStyle();
        //                    style.Alignment = DataGridViewContentAlignment.MiddleRight;
        //                    style.Format = "#,##0";
        //                    dgv商品一覧.Rows[e.RowIndex].Cells[e.ColumnIndex].Style = style;
        //                }
        //                break;
        //                //decRes = Get購入金額(e.Value.RowIndex);
        //                //e.Value = string.Format("{0:#,0}", e.Value);
        //                //dgv販売履歴.Rows[iRow].Cells[販売履歴Cell.byt商品単価].Value = str;
        //                //break;
        //        }
        //    }
        //    catch (Exception ex)
        //    {
        //        C04システム共通.ErrorLog("_402お勧め商品一覧", "dgv商品一覧_CellFormatting", ex);
        //    }
        //}

        private void btn戻る_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_402お勧め商品一覧", "btn戻る_Click", ex);
            }
        }

        private void dgv商品一覧_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgv商品一覧.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgv商品一覧.RowHeadersDefaultCellStyle.Font,
                                              dgv商品一覧.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_402お勧め商品一覧", "dgv商品一覧_RowPostPaint", ex);
            }
        }

        private void btnCSVファイル出力_Click(object sender, EventArgs e)
        {
            try
            {
                //ファイル参照ダイアログを表示する
                SaveFileDialog sfd = new SaveFileDialog();
                sfd.Filter = "CSV " + Properties.Resources.MSG_I_ファイル + "(*.csv)|*.csv";

                if (sfd.ShowDialog() != DialogResult.OK)
                    return;

                //グリッドの内容をCSV形式で出力する
				C06CSV.CreateCSVファイル(dgv商品一覧, sfd.FileName, true, 1, false, "");

                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_007);

                MessageBox.Show(Properties.Resources.MSG_I_ファイル出力が完了しました, this.Text, MessageBoxButtons.OK,
                    MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_402お勧め商品一覧", "btnCSVファイル出力_Click", ex);
            }
        }

        #endregion


    }
}
