﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using SystemCommon;


namespace 顧客分析君
{
    public partial class _104各種システム設定 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _104各種システム設定()
        {
            InitializeComponent();
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 共通メソッド

        private void ChangSMTPサーバー()
        {
            if (chk顧客へのメール送信を行う.Checked == true)
            {
                txtSMTPサーバー.Enabled = true;
                txtSMTPサーバーのポート番号.Enabled = true;
                txtユーザーID.Enabled = true;
                txtパスワード.Enabled = true;

                txtSMTPサーバー.Text = Properties.Settings.Default.SMTPサーバー;
                txtSMTPサーバーのポート番号.Text = Properties.Settings.Default.SMTPサーバーのポート番号;
                txtユーザーID.Text = Properties.Settings.Default.ユーザーID;
                txtパスワード.Text = Properties.Settings.Default.パスワード;
            }
            else
            {
                txtSMTPサーバー.Enabled = false;
                txtSMTPサーバーのポート番号.Enabled = false;
                txtユーザーID.Enabled = false;
                txtパスワード.Enabled = false;

                txtSMTPサーバー.Text = "";
                txtSMTPサーバーのポート番号.Text = "";
                txtユーザーID.Text = "";
                txtパスワード.Text = "";
            }
        }

        private void Update休眠顧客設定()
        {
            顧客分析君.D01業務共通TableAdapters.D01属性ta d01属性ta;
            d01属性ta = new 顧客分析君.D01業務共通TableAdapters.D01属性ta();
            //d01属性ta.Update(txt休眠顧客の無購買期間.Text, C02業務共通処理.miログインスタッフNo, 84);
			d01属性ta.Update(txt休眠顧客の無購買期間.Text, C02業務共通処理.miログインスタッフNo, 84);
		}

        private void Updateメールサーバー設定()
        {
            if (chk顧客へのメール送信を行う.Checked == true)
            {
                // エラーチェック
                if (txtSMTPサーバー.Text == "")
                {
                    MessageBox.Show(Properties.Resources.MSG_W_SMTPサーバーが入力されていません, Properties.Resources.MSG_TTL_入力エラー
                        , MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (txtSMTPサーバーのポート番号.Text == "")
                {
                    MessageBox.Show(Properties.Resources.MSG_W_ポート番号が入力されていません, Properties.Resources.MSG_TTL_入力エラー
                        , MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (txtユーザーID.Text == "")
                {
                    MessageBox.Show(Properties.Resources.MSG_W_ユーザーIDが入力されていません, Properties.Resources.MSG_TTL_入力エラー
                        , MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }
                if (txtパスワード.Text == "")
                {
                    MessageBox.Show(Properties.Resources.MSG_W_077, Properties.Resources.MSG_TTL_入力エラー
                        , MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                Properties.Settings.Default.SMTPサーバー = txtSMTPサーバー.Text;
                Properties.Settings.Default.SMTPサーバーのポート番号 = txtSMTPサーバーのポート番号.Text;
                Properties.Settings.Default.ユーザーID = txtユーザーID.Text;
                Properties.Settings.Default.パスワード = txtパスワード.Text;
                Properties.Settings.Default.メールサーバー設定 = C_メールサーバー設定.済み;
                Properties.Settings.Default.Save();
            }
        }


        #endregion

        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ

        private void _105各種設定_Load(object sender, EventArgs e)
        {
            try
            {
                顧客分析君.D01業務共通TableAdapters.D01属性ta d01属性ta;
                d01属性ta = new 顧客分析君.D01業務共通TableAdapters.D01属性ta();
                txt休眠顧客の無購買期間.Text = d01属性ta.Scalar値(84);

                if (d01属性ta.Scalar値(85) == "0")
                    chk顧客へのメール送信を行う.Checked = false;
                else
                    chk顧客へのメール送信を行う.Checked = true;

                ChangSMTPサーバー();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_104各種設定", "_105各種設定_Load", ex);
            }
        }

        private void chk顧客へのメール送信を行う_CheckedChanged(object sender, EventArgs e)
        {
            try
            {
                ChangSMTPサーバー();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("chk顧客へのメール送信を行う_CheckedChanged", "_105各種設定_Load", ex);
            }
        }

        private void btn確定_Click(object sender, EventArgs e)
        {
            try
            {
                if (DialogResult.Yes != MessageBox.Show(Properties.Resources.MSG_Q_入力した内容を登録しますか
                    , this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
                    return;

                Update休眠顧客設定();
                Updateメールサーバー設定();

                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_008);

                MessageBox.Show(Properties.Resources.MSG_I_登録が完了しました, this.Text, MessageBoxButtons.OK,
                    MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_104各種設定", "btn確定_Click", ex);
            }
        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_104各種設定", "btnキャンセル_Click", ex);
            }
        }

        #endregion



    }
}
