﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

//using System.Globalization;
using Microsoft.Maps.MapControl.WPF;
using Microsoft.Maps.MapControl.WPF.Design;
using System.Xml;
using System.Net;
using System.Xml.XPath;
using System.Web;

using MapCommon;

namespace MAP
{
	/// <summary>
	/// MainWindow.xaml の相互作用ロジック
	/// </summary>
	public partial class MainWindow : Window
	{
		////////////////////////////////////////////////////////////////////////
		// メンバ変数
		////////////////////////////////////////////////////////////////////////
		#region メンバ変数

		string BingMapsKey = "AhPXNf41s0pSlp9Fxm5fRV3TCwdUH9MPrqM1AheQnwA9FDdxUY98d6AQmy3H1Ndn";

		LocationConverter locConverter = new LocationConverter();

		MapLayer polygonPointLayer = new MapLayer();

		#endregion

        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 共通メソッド

		private void SetMAP基本設定()
		{
			myMap.Focus();
			myMap.Visibility = Visibility.Visible;

			//myMap.Mode = new AerialMode(true);	//航空写真モード
			myMap.ZoomLevel = 5;
			myMap.CredentialsProvider = new ApplicationIdCredentialsProvider(BingMapsKey);

			//アニメーションは使わない。
			AnimationLevel newLevel = (AnimationLevel)Enum.Parse(typeof(AnimationLevel), "none", true);
			myMap.AnimationLevel = newLevel;

		}

		#endregion

		////////////////////////////////////////////////////////////////////////
		// イベントハンドラ
		////////////////////////////////////////////////////////////////////////
		#region イベントハンドラ

		public MainWindow()
		{
			InitializeComponent();

			SetMAP基本設定();


			//緯度経度取得
			//string strAdress = HttpUtility.UrlEncode("東京都新宿区西新宿二丁目8番1号");
			//string strURL = string.Format("http://dev.virtualearth.net/REST/v1/Locations?query={0}&key={1}&c=ja-jp&o=xml", strAdress, BingMapsKey);
			//XmlDocument geocodeResponse = GetXmlResponse(strURL);

			//XmlNamespaceManager nsmgr = new XmlNamespaceManager(geocodeResponse.NameTable);
			//nsmgr.AddNamespace("rest", "http://schemas.microsoft.com/search/local/ws/rest/v1");
			//XmlNodeList locationElements = geocodeResponse.SelectNodes("//rest:Location", nsmgr);
			//string latitude = null;
			//string longitude = null;
			//if (locationElements.Count == 0)
			//{
			//    latitude = "0";
			//    longitude = "0";
			//}
			//else
			//{
			//    XmlNodeList displayGeocodePoints = locationElements[0].SelectNodes(".//rest:GeocodePoint/rest:UsageType[.='None']/parent::node()", nsmgr);
			//    latitude = displayGeocodePoints[0].SelectSingleNode(".//rest:Latitude", nsmgr).InnerText;
			//    longitude = displayGeocodePoints[0].SelectSingleNode(".//rest:Longitude", nsmgr).InnerText;
			//}
			double dblLatitude = 0;
			double dblLongitude = 0;
			C01MAP.Get緯度経度("東京都新宿区西新宿二丁目8番1号", ref dblLatitude, ref dblLongitude);

			//マップの表示位置変更
			myMap.Center = new Location(dblLatitude, dblLongitude);
			myMap.ZoomLevel = 12;

			//PINを立てる
			AddPushpinToMap(dblLatitude, dblLongitude, "1");
		}

		private XmlDocument GetXmlResponse(string requestUrl)
		{
			System.Diagnostics.Trace.WriteLine("Request URL (XML): " + requestUrl);
			HttpWebRequest request = WebRequest.Create(requestUrl) as HttpWebRequest;
			using (HttpWebResponse response = request.GetResponse() as HttpWebResponse)
			{
				if (response.StatusCode != HttpStatusCode.OK)
					throw new Exception(String.Format("Server error (HTTP {0}: {1}).",
					response.StatusCode,
					response.StatusDescription));
				XmlDocument xmlDoc = new XmlDocument();
				xmlDoc.Load(response.GetResponseStream());
				return xmlDoc;
			}
		}

		private void FindandDisplayNearbyPOI(XmlDocument xmlDoc)
		{
			//Create namespace manager
			XmlNamespaceManager nsmgr = new XmlNamespaceManager(xmlDoc.NameTable);
			nsmgr.AddNamespace("rest", "http://schemas.microsoft.com/search/local/ws/rest/v1");

			//Get all geocode locations in the response 
			XmlNodeList locationElements = xmlDoc.SelectNodes("//rest:Location", nsmgr);
			if (locationElements.Count == 0)
			{
				//ErrorMessage.Visibility = Visibility.Visible;
				//ErrorMessage.Content = "The location you entered could not be geocoded.";
			}
			else
			{
				//Get the geocode location points that are used for display (UsageType=Display)
				XmlNodeList displayGeocodePoints =
						locationElements[0].SelectNodes(".//rest:GeocodePoint/rest:UsageType[.='Display']/parent::node()", nsmgr);
				string latitude = displayGeocodePoints[0].SelectSingleNode(".//rest:Latitude", nsmgr).InnerText;
				string longitude = displayGeocodePoints[0].SelectSingleNode(".//rest:Longitude", nsmgr).InnerText;

				myMap.Center = new Location(Convert.ToDouble(latitude), Convert.ToDouble(longitude));
				myMap.ZoomLevel = 12;
			}
		}

		private void AddPushpinToMap(double latitude, double longitude, string pinLabel)
		{
			Location location = new Location(latitude, longitude);
			Pushpin pushpin = new Pushpin();
			pushpin.Content = pinLabel;
			pushpin.Location = location;
			myMap.Children.Add(pushpin);
		}

		public XmlDocument Geocode(string addressQuery)
		{
			string strAdress = HttpUtility.UrlEncode("東京都新宿区西新宿二丁目8番1号");
			string geocodeRequest = string.Format("http://dev.virtualearth.net/REST/v1/Locations?query={0}&key={1}&c=ja-jp&o=xml", strAdress, BingMapsKey);

			XmlDocument geocodeResponse = GetXmlResponse(geocodeRequest);
			return (geocodeResponse);
		}

		private void Search_Click(object sender, RoutedEventArgs e)
		{
			myMap.Children.Clear();

			XmlDocument searchResponse = Geocode("newyork");

			FindandDisplayNearbyPOI(searchResponse);
		}

		#endregion
	}
}
