﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using SystemCommon;
using ClientCommon;


namespace 顧客分析君
{
    public partial class _204商品一覧 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // 内部クラス
        ////////////////////////////////////////////////////////////////////////
        #region CSV取込処理内部クラス

        private class 取込処理内部クラス : C03CSV取込処理基底
        {
			//private enum enmCSV取込列
			//{
			//    商品ID = 0,
			//    商品名 = 1,
			//    商品単価 = 2,
			//    商品URL = 3
			//}
			private static class CSV取込列
			{
                public const byte byt商品ID = 0;
                public const byte byt商品名 = 1;
                public const byte byt商品単価 = 2;
                public const byte byt商品URL = 3;
			}

            protected override int 基底CSV取込クラスからの列数取得()
            {
                return CSV取込列.byt商品URL + 1;
            }

            protected override bool 基底CSV取込クラスからの検証(int rowIndex, int colIndex, string value)
            {
                switch (colIndex)
                {
                    case CSV取込列.byt商品ID:
                        //必須入力、桁数、書式検証
                        if (!IsValidate共通(value, true, C_最大文字数.商品ID, C_正規表現.半角英数
                            , Properties.Resources.DGV列名_商品ID))
                            return false;

                        ////DB重複チェック
                        //if (!IsExsist商品ID(value, ((enmCSV取込列)colIndex).ToString()))
                        //    return false;

                        break;

                    case CSV取込列.byt商品名:
                        //必須入力、桁数、書式検証
                        if (!IsValidate共通(value, true, C_最大文字数.商品名, C_正規表現.なし
                            , Properties.Resources.DGV列名_商品名))
                            return false;

                        break;

                    case CSV取込列.byt商品単価:
                        //必須入力、桁数、書式検証
                        value = value.Replace(",", string.Empty);
                        if (!IsValidate共通(value, true, C_最大文字数.商品単価, C_正規表現.半角数字
                            , Properties.Resources.DGV列名_商品単価))
                            return false;

                        break;

                    case CSV取込列.byt商品URL:
                        //必須入力、桁数、書式検証
                        if (!IsValidate共通(value, true, C_最大文字数.URL, C_正規表現.半角英数
                            , Properties.Resources.DGV列名_商品URL))
                            return false;

                        break;

                }
                return true;
            }

            protected override void 基底CSV取込クラスからのデータ変換(int rowIndex, List<string> values, DataTable dt)
            {
                D06商品一覧.D06商品マスタDataTable dt商品マスタ = (D06商品一覧.D06商品マスタDataTable)dt;
                D06商品一覧.D06商品マスタRow row = dt商品マスタ.NewD06商品マスタRow();

                row.新規 = true;
                row.商品ID = values[CSV取込列.byt商品ID];
                row.商品名 = values[CSV取込列.byt商品名];
                string strTmp = values[CSV取込列.byt商品単価].Replace(",", "");
                row.商品単価 = long.Parse(strTmp);

                dt商品マスタ.AddD06商品マスタRow(row);
            }
        }

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

        private class 検索条件
        {
            public string 商品ID { get; set; }
            public string 商品名 { get; set; }
            public Nullable<long> 商品単価 { get; set; }
        }

		//private enum enm商品一覧Cell : int
		//{
		//    新規 = 0,
		//    変更 = 1,
		//    削除 = 2,
		//    商品No = 3,
		//    商品ID = 4,
		//    商品名 = 5,
		//    商品単価 = 6
		//}
		private static class 商品一覧Cell
		{
            public const byte byt新規 = 0;
            public const byte byt変更 = 1;
            public const byte byt削除 = 2;
            public const byte byt商品No = 3;
            public const byte byt商品ID = 4;
            public const byte byt商品名 = 5;
			public const byte byt商品単価 = 6;
		}

		//private 顧客分析君.D06商品一覧TableAdapters.D06商品マスタta d06商品マスタta;
		
		#endregion

        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド 
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _204商品一覧()
        {
			InitializeComponent();

			//this.d06商品マスタta = new 顧客分析君.D06商品一覧TableAdapters.D06商品マスタta();
			
			//this.d06商品マスタta.ClearBeforeFill = true;
		}

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
		////////////////////////////////////////////////////////////////////////
		#region 非公開 共通メソッド Static

		//最終行でかつ全項目未入力となっているかを返す
		private static bool 最終行or全項目未入力(DataGridView dgv, int rowIndex)
		{
			if ((dgv.RowCount - 1) != rowIndex)
				return false;

			if ((dgv.Rows[rowIndex].Cells[商品一覧Cell.byt商品No].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[rowIndex].Cells[商品一覧Cell.byt商品ID].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[rowIndex].Cells[商品一覧Cell.byt商品名].FormattedValue.ToString() == string.Empty) &&
				(dgv.Rows[rowIndex].Cells[商品一覧Cell.byt商品単価].FormattedValue.ToString() == string.Empty))
			{
				return true;
			}

			return false;
		}

		private bool IsValidateDGV商品一覧(DataGridView dgv, int iRow)
		{
			if (iRow < 0)
				return true;

			bool ret = true;

			if (最終行or全項目未入力(dgv, iRow))
				return ret;

			string value;
			for (int iCol = 0; iCol < dgv商品一覧.ColumnCount; iCol++)
			{
				value = dgv商品一覧.Rows[iRow].Cells[iCol].FormattedValue.ToString();

				switch (iCol)
				{
					case 商品一覧Cell.byt商品ID:
						if (!C11ValidateOnForm.IsValidateCell必須入力(dgv商品一覧, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						if (!C11ValidateOnForm.IsValidateCell半角入力(dgv商品一覧, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						break;


					case 商品一覧Cell.byt商品名:
						if (!C11ValidateOnForm.IsValidateCell必須入力(dgv商品一覧, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						break;

					case 商品一覧Cell.byt商品単価:
						if (!C11ValidateOnForm.IsValidateCell必須入力(dgv商品一覧, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						if (!C11ValidateOnForm.IsValidateCell通貨型(dgv商品一覧, iRow, iCol, value))
						{
							ret = false;
							break;
						}

						break;
				}
			}

			return ret;
		}

		private static bool IsValidate未入力行(DataGridViewRow row)
		{
			if ((row.Cells[商品一覧Cell.byt商品No].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[商品一覧Cell.byt商品ID].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[商品一覧Cell.byt商品名].FormattedValue.ToString() == string.Empty) &&
				(row.Cells[商品一覧Cell.byt商品単価].FormattedValue.ToString() == string.Empty))
				return true;
			else
				return false;
		}

		private static bool IsValidate新規変更削除チェック状態(DataGridView dgv, string strFormTitle)
		{
			string strErrMsg;
			for (int iRow = 0; iRow < dgv.RowCount; iRow++)
			{
				if (最終行or全項目未入力(dgv, iRow) == true)
					continue;

				strErrMsg = "";
				if (!C11ValidateOnForm.IsValidate新規変更削除チェック状態(dgv, iRow,
					商品一覧Cell.byt新規, 商品一覧Cell.byt変更, 商品一覧Cell.byt削除,
					商品一覧Cell.byt商品No, ref strErrMsg))
				{
					MessageBox.Show(strErrMsg, strFormTitle, MessageBoxButtons.OK, MessageBoxIcon.Warning);
					return false;
				}
			}

			return true;
		}


		#endregion


		#region 非公開 共通メソッド Non Static

		private void Set列幅()
        {
            dgv商品一覧.Columns[商品一覧Cell.byt新規].Visible = false;
            dgv商品一覧.Columns[商品一覧Cell.byt変更].Visible = false;
            dgv商品一覧.Columns[商品一覧Cell.byt削除].Width = C_列幅.削除;
            dgv商品一覧.Columns[商品一覧Cell.byt商品No].Visible = false;
            dgv商品一覧.Columns[商品一覧Cell.byt商品ID].Width = C_列幅.商品ID;
            dgv商品一覧.Columns[商品一覧Cell.byt商品名].Width = C_列幅.商品名;
            dgv商品一覧.Columns[商品一覧Cell.byt商品単価].Width = C_列幅.商品単価;
        }

        //検索で使用するSQLパラメータの取得
        private 検索条件 Get検索条件()
        {
            検索条件 row = new 検索条件();

            if (txt商品ID.Text == "")
                row.商品ID = null;
            else
                row.商品ID = txt商品ID.Text;

            if (txt商品名.Text == "")
                row.商品名 = null;
            else
                row.商品名 = txt商品名.Text;

            if (txt商品単価.Text == "")
                row.商品単価 = null;
            else
                row.商品単価 = long.Parse(txt商品単価.Text);


            return row;
        }

		private bool IsValidate検索()
		{
			if (txt商品ID.Text != "")
			{
				if (C11ValidateOnForm.IsValidate半角英数(txt商品ID.Text, Properties.Resources.DGV列名_商品ID)
					== false)
					return false;
			}

			if (txt商品単価.Text != "")
			{
				if (C11ValidateOnForm.IsValidate符号無し数値型(txt商品単価.Text, Properties.Resources.DGV列名_商品単価)
					== false)
					return false;
			}

			return true;
		}

        private bool IsValidate()
        {
            //必須入力欄
			if ((dgv商品一覧.RowCount == 1) && (最終行or全項目未入力(dgv商品一覧, 0)))
            {
                MessageBox.Show(Properties.Resources.MSG_W_販売履歴が入力されていません, this.Text, MessageBoxButtons.OK
                    , MessageBoxIcon.Warning);
                dgv商品一覧.Focus();
                return false;
            }

            if (IsValidate新規変更削除チェック状態(dgv商品一覧, this.Text) == false)
                return false;

            //未入力
            bool b新規変更削除にチェック有り = false;
            for (int iRow = 0; iRow < dgv商品一覧.RowCount; iRow++)
            {
				if (最終行or全項目未入力(dgv商品一覧, iRow) == true)
                    continue;

                if ((Boolean)dgv商品一覧.Rows[iRow].Cells[商品一覧Cell.byt新規].Value == false &&
                    (Boolean)dgv商品一覧.Rows[iRow].Cells[商品一覧Cell.byt変更].Value == false &&
                    (Boolean)dgv商品一覧.Rows[iRow].Cells[商品一覧Cell.byt削除].Value == false)
                    continue;

                b新規変更削除にチェック有り = true;
                break;
            }

            if (b新規変更削除にチェック有り == false)
            {
                MessageBox.Show(Properties.Resources.MSG_W_編集された行がありません, this.Text, MessageBoxButtons.OK,
                    MessageBoxIcon.Warning);
                dgv商品一覧.Focus();
                return false;
            }

            //編集されたセルを全てチェックする
            bool isValid = true;
            for (int iRow = 0; iRow < dgv商品一覧.RowCount; iRow++)
            {
				if (最終行or全項目未入力(dgv商品一覧, iRow) == true)
                    continue;

                if ((Boolean)dgv商品一覧.Rows[iRow].Cells[商品一覧Cell.byt新規].Value == false &&
                    (Boolean)dgv商品一覧.Rows[iRow].Cells[商品一覧Cell.byt変更].Value == false &&
                    (Boolean)dgv商品一覧.Rows[iRow].Cells[商品一覧Cell.byt削除].Value == false)
                    continue;

				if (!IsValidateDGV商品一覧(dgv商品一覧, iRow))
                    isValid = false;
            }

            if (!isValid)
            {
                MessageBox.Show(string.Format(Properties.Resources.MSG_W_Aの入力内容に誤りがある為_登録を完了できません, Properties.Resources.MSG_TTL_商品一覧)
                    , this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);

                dgv商品一覧.Focus();
                return false;
            }

            return true;
        }

        private void Insert商品一覧()
        {
            D06商品一覧.D06商品マスタRow[] dr = (D06商品一覧.D06商品マスタRow[])d06商品一覧.D06商品マスタ.Select("新規 = true");

			//string str商品IDリスト = "";
            for (int iRow = 0; iRow < dr.Length; iRow++)
            {
				C06DB共通.d06商品マスタta.Insert(dr[iRow].商品ID, dr[iRow].商品名, dr[iRow].商品単価
                    , C02業務共通処理.miログインスタッフNo);

				//str商品IDリスト += dr[iRow].商品ID + ", ";
            }

            if (dr.Length > 0)
			{
				//C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_011
				//    + "=" + str商品IDリスト.Substring(0, str商品IDリスト.Length - 2));
				C02業務共通処理.Insert操作履歴(this.Text, "新規登録：" + dr.Length.ToString() + "件");
			}
        }

        private void Update商品一覧()
        {
            D06商品一覧.D06商品マスタRow[] dr = (D06商品一覧.D06商品マスタRow[])d06商品一覧.D06商品マスタ.Select("変更 = true");

			//string str商品IDリスト = "";
            for (int iRow = 0; iRow < dr.Length; iRow++)
            {
				C06DB共通.d06商品マスタta.Update(dr[iRow].商品ID, dr[iRow].商品名, dr[iRow].商品単価, dr[iRow].商品No
                    , C02業務共通処理.miログインスタッフNo);

				//str商品IDリスト += dr[iRow].商品ID + ", ";
            }

            if (dr.Length > 0)
			{
				//C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_012 
				//    + "=" + str商品IDリスト.Substring(0, str商品IDリスト.Length - 2));
				C02業務共通処理.Insert操作履歴(this.Text, "更新：" + dr.Length.ToString() + "件");
			}
		}

        private void Delete商品一覧()
        {
			//string str商品IDリスト = "";
            int i削除行数 = 0;
            for (int iRow = 0; iRow < dgv商品一覧.RowCount; iRow++)
            {
                if (dgv商品一覧.Rows[iRow].Cells[商品一覧Cell.byt削除].Value == null)
                    continue;

                if ((Boolean)dgv商品一覧.Rows[iRow].Cells[商品一覧Cell.byt削除].Value == false)
                    continue;

                if (dgv商品一覧.Rows[iRow].Cells[商品一覧Cell.byt商品No].Value.ToString() == "")
                    continue;

				C06DB共通.d06商品マスタta.Delete(int.Parse(dgv商品一覧.Rows[iRow].Cells[商品一覧Cell.byt商品No]
                    .Value.ToString()));

				//str商品IDリスト += dgv商品一覧.Rows[iRow].Cells[商品一覧Cell.byt商品ID]
				//    .Value.ToString() + ", ";

                i削除行数++;
            }

            if (i削除行数 > 0)
			{
				//C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_013
				//     + "=" + str商品IDリスト.Substring(0, str商品IDリスト.Length - 2));
				C02業務共通処理.Insert操作履歴(this.Text, "削除：" + i削除行数.ToString() + "件");
			}
		}

        #endregion

        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ

        private void _204商品一覧_Load(object sender, EventArgs e)
        {
            try
            {

            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_204商品一覧", "_204商品一覧_Load", ex);
            }
            finally
            {
                Set列幅();
            }
        }

        private void _204商品一覧_Resize(object sender, EventArgs e)
        {
            try
            {
                C01FormCommon.画面最小サイズに変更(this, true);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_204商品一覧", "_204商品一覧_Resize", ex);
            }
        }

        private void dgv商品一覧_CellBeginEdit(object sender, DataGridViewCellCancelEventArgs e)
        {
            try
            {
                // 書式変更
                switch (e.ColumnIndex)
                {
                    case 商品一覧Cell.byt商品単価:
                        if (dgv商品一覧.Rows[e.RowIndex].Cells[e.ColumnIndex].Value != null)
                        {
                            DataGridViewCellStyle style = new DataGridViewCellStyle();
                            style.Alignment = DataGridViewContentAlignment.MiddleRight;
                            style.Format = "#0";
                            dgv商品一覧.Rows[e.RowIndex].Cells[e.ColumnIndex].Style = style;
                        }
                        break;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_204商品一覧", "dgv商品一覧_CellBeginEdit", ex);
            }
        }

        private void dgv商品一覧_CellEndEdit(object sender, DataGridViewCellEventArgs e)
        {
            try
            {
                // 書式変更
                switch (e.ColumnIndex)
                {
                    case 商品一覧Cell.byt商品単価:
                        if (dgv商品一覧.Rows[e.RowIndex].Cells[e.ColumnIndex].Value != null)
                        {
                            DataGridViewCellStyle style = new DataGridViewCellStyle();
                            style.Alignment = DataGridViewContentAlignment.MiddleRight;
                            style.Format = "#,##0";
                            dgv商品一覧.Rows[e.RowIndex].Cells[e.ColumnIndex].Style = style;
                        }
                        break;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_204商品一覧", "dgv商品一覧_CellEndEdit", ex);
            }
        }

        private void dgv商品一覧_CellValidating(object sender, DataGridViewCellValidatingEventArgs e)
        {
            try
            {
                //列が変わった場合は書式チェックを実施
                string value = e.FormattedValue.ToString();

                switch (e.ColumnIndex)
                {
                    case 商品一覧Cell.byt商品ID:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell半角入力(dgv商品一覧, e.RowIndex, e.ColumnIndex, value))
                                break;

                            dgv商品一覧.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                    case 商品一覧Cell.byt商品名:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell必須入力(dgv商品一覧, e.RowIndex, e.ColumnIndex, value))
                                break;

                            dgv商品一覧.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;

                    case 商品一覧Cell.byt商品単価:
                        if (value != string.Empty)
                        {
                            if (!C11ValidateOnForm.IsValidateCell通貨型(dgv商品一覧, e.RowIndex, e.ColumnIndex, value))
                                break;

                            dgv商品一覧.Rows[e.RowIndex].Cells[e.ColumnIndex].ErrorText = string.Empty;
                        }

                        break;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_204商品一覧", "dgv商品一覧_CellValidating", ex);
            }
        }

        private void dgv商品一覧_CellValueChanged(object sender, DataGridViewCellEventArgs e)
        {
            try
            {
                //if (e.RowIndex < 0)
                //    return;

                //if (e.ColumnIndex < 3)
                //    return;

                //if (dgv商品一覧.Rows[e.RowIndex].Cells[商品一覧Cell.byt商品No].Value == null)
                //    return;

                //if (int.Parse(dgv商品一覧.Rows[e.RowIndex].Cells[商品一覧Cell.byt商品No].Value.ToString()) < 0)
                //{
                //    // 「変更」列をチェック状態にする
                //    dgv商品一覧.Rows[e.RowIndex].Cells[商品一覧Cell.byt新規].Value = false;
                //    dgv商品一覧.Rows[e.RowIndex].Cells[商品一覧Cell.byt変更].Value = true;
                //    dgv商品一覧.Rows[e.RowIndex].Cells[商品一覧Cell.byt削除].Value = false;
                //}
                //else
                //{
                //    // 「新規」列をチェック状態にする
                //    dgv商品一覧.Rows[e.RowIndex].Cells[商品一覧Cell.byt新規].Value = true;
                //    dgv商品一覧.Rows[e.RowIndex].Cells[商品一覧Cell.byt変更].Value = false;
                //    dgv商品一覧.Rows[e.RowIndex].Cells[商品一覧Cell.byt削除].Value = false;
                //}

                C11ValidateOnForm.新規変更削除列のチェック状態変更(e, 商品一覧Cell.byt商品No,
                    商品一覧Cell.byt新規, 商品一覧Cell.byt変更, 商品一覧Cell.byt削除,
                    ref dgv商品一覧);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_204商品一覧", "dgv商品一覧_CellValueChanged", ex);
            }
        }

        private void dgv商品一覧_DataError(object sender, DataGridViewDataErrorEventArgs e)
        {
            try
            {
                e.Cancel = true;
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_204商品一覧", "dgv商品一覧_DataError", ex);
            }
        }

        private void dgv商品一覧_RowPostPaint(object sender, DataGridViewRowPostPaintEventArgs e)
        {
            try
            {
                C01FormCommon.行数表示(e.RowBounds.Location.X,
                                              e.RowBounds.Location.Y,
                                              dgv商品一覧.RowHeadersWidth,
                                              e.RowBounds.Height,
                                              e.Graphics,
                                              e.RowIndex,
                                              dgv商品一覧.RowHeadersDefaultCellStyle.Font,
                                              dgv商品一覧.RowHeadersDefaultCellStyle.ForeColor);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_204商品一覧", "dgv商品一覧_RowPostPaint", ex);
            }
        }

        private void dgv商品一覧_RowValidating(object sender, DataGridViewCellCancelEventArgs e)
        {
            try
            {
                //行が変わった場合は必須入力チェックを実施
                if (e.RowIndex <= dgv商品一覧.RowCount)
                {
					IsValidateDGV商品一覧(dgv商品一覧, e.RowIndex);
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_204商品一覧", "dgv商品一覧_RowValidating", ex);
            }
        }

        private void btn検索条件をクリア_Click(object sender, EventArgs e)
        {
            try
            {
                txt商品ID.Text = "";
                txt商品名.Text = "";
                txt商品単価.Text = "";
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_204商品一覧", "btn検索条件をクリア_Click", ex);
            }
        }

        private void btn検索_Click(object sender, EventArgs e)
        {
            try
            {
                if (false == IsValidate検索())
                    return;

                Cursor.Current = Cursors.WaitCursor;
                d06商品マスタbs.DataSource = null;

                検索条件 row = Get検索条件();
				C06DB共通.d06商品マスタta.FillBy検索(d06商品一覧.D06商品マスタ, row.商品ID, row.商品名, row.商品単価);

                //見つからない場合はメッセージ表示
                if (d06商品一覧.D06商品マスタ.Rows.Count == 0)
                    MessageBox.Show(Properties.Resources.MSG_W_データは見つかりませんでした, this.Text, 
						MessageBoxButtons.OK, MessageBoxIcon.Warning);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_204商品一覧", "btn検索_Click", ex);
            }
            finally
            {
                d06商品マスタbs.DataSource = d06商品一覧.D06商品マスタ;
				lbl件数.Text = "検索結果：" + d06商品一覧.D06商品マスタ.Count.ToString() + " 件";

                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btnCSVファイル読込_Click(object sender, EventArgs e)
        {
            bool b正常終了 = true;

            try
            {
                OpenFileDialog dlg = new OpenFileDialog();
                dlg.Filter = "CSV " + Properties.Resources.MSG_I_ファイル + "(*.csv)|*.csv";
                if (dlg.ShowDialog(this) == DialogResult.Cancel)
                    return;

                Cursor.Current = Cursors.WaitCursor;

                d06商品マスタbs.DataSource = null;

                取込処理内部クラス 取込処理 = new 取込処理内部クラス();
                D06商品一覧.D06商品一覧DataTable dt = new D06商品一覧.D06商品一覧DataTable();

                if (!取込処理.CSV変換(dlg.FileName, dt, 2))
                {
					//string errmsg = 取込処理.LastErrorMessage 
					//    + "\n\n【" + Properties.Resources.MSG_I_詳細 + "】\n" + 取込処理.ErrorDetail;
					string errmsg = 取込処理.LastErrorMessage;
					MessageBox.Show(errmsg, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                if (dt.Count > C_最大値.CSV取込件数)
                {
                    string errmsg = string.Format(Properties.Resources.MSG_W_最大取込件数A件を超えています, (long)C_最大値.CSV取込件数);
                    MessageBox.Show(errmsg, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

				d06商品一覧.D06商品マスタ.Clear();
				d06商品一覧.D06商品マスタ.Merge(dt);

				lbl件数.Text = "検索結果：" + d06商品一覧.D06商品マスタ.Count.ToString() + " 件";
			}
            catch (Exception ex)
            {
                b正常終了 = false;
                C04システム共通.ErrorLog("_204商品一覧", "btnCSVファイル読込_Click", ex);
            }
            finally
            {
                d06商品マスタbs.DataSource = d06商品一覧.D06商品マスタ;

                Cursor.Current = Cursors.Arrow;
            }

            if (b正常終了 == true)
                MessageBox.Show(Properties.Resources.MSG_I_読込が完了しました, this.Text, MessageBoxButtons.OK
                    , MessageBoxIcon.Information);
            else
                MessageBox.Show(Properties.Resources.MSG_W_ファイルの読込に失敗しました
					, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
        }


        private void btn選択行の削除を全てチェック_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                foreach (DataGridViewRow row in dgv商品一覧.SelectedRows)
                {
                    if (IsValidate未入力行(row))
                        continue;

                    row.Cells[商品一覧Cell.byt新規].Value = false;
                    row.Cells[商品一覧Cell.byt変更].Value = false;
                    row.Cells[商品一覧Cell.byt削除].Value = true;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_204商品一覧", "btn選択行の削除を全てチェック_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn選択行のチェックを全て外す_Click(object sender, EventArgs e)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                foreach (DataGridViewRow row in dgv商品一覧.SelectedRows)
                {
                    row.Cells[商品一覧Cell.byt新規].Value = false;
                    row.Cells[商品一覧Cell.byt変更].Value = false;
                    row.Cells[商品一覧Cell.byt削除].Value = false;
                }
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_204商品一覧", "btn選択行のチェックを全て外す_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn検索結果をクリア_Click(object sender, EventArgs e)
        {
            try
            {
                if (DialogResult.Yes != MessageBox.Show(Properties.Resources.MSG_Q_検索結果をクリアしますか
                    , this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
                    return;

                d06商品一覧.D06商品マスタ.Clear();
				lbl件数.Text = "";
			}
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_204商品一覧", "btn検索結果をクリア_Click", ex);
            }
        }

        private void btn選択行をCSVファイルに出力_Click(object sender, EventArgs e)
        {
            try
            {
                if (dgv商品一覧.SelectedRows.Count == 0)
                {
                    MessageBox.Show(Properties.Resources.MSG_W_073
						, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    return;
                }

                SaveFileDialog sfd = new SaveFileDialog();
                sfd.Filter = "CSV " + Properties.Resources.MSG_I_ファイル + "(*.csv)|*.csv";

                if (sfd.ShowDialog() != DialogResult.OK)
                    return;

                Cursor.Current = Cursors.WaitCursor;

				//C06CSV.CreateCSVファイル(dgv商品一覧, sfd.FileName, true, 4, true, "");
				if (C06CSV.CreateCSVファイル(dgv商品一覧, sfd.FileName, true, 4, true, null) == false)
					return;

                C02業務共通処理.Insert操作履歴(this.Text, Properties.Resources.OPRT_007);

                MessageBox.Show(Properties.Resources.MSG_I_ファイル出力が完了しました
					, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_204商品一覧", "btn選択行をCSVファイルに出力_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btn確定_Click(object sender, EventArgs e)
        {
            try
            {
				if (DialogResult.Yes != MessageBox.Show(Properties.Resources.MSG_Q_入力した内容を登録しますか
					, this.Text, MessageBoxButtons.YesNo, MessageBoxIcon.Question))
					return;

				Cursor.Current = Cursors.WaitCursor;

				if (false == IsValidate())
                    return;

                //d06商品一覧.AcceptChanges();

                Insert商品一覧();
                Update商品一覧();
                Delete商品一覧();

                d06商品一覧.D06商品マスタ.Clear();

                MessageBox.Show(Properties.Resources.MSG_I_登録が完了しました
					, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_204商品一覧", "btn確定_Click", ex);
            }
            finally
            {
                Cursor.Current = Cursors.Arrow;
            }
        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_204商品一覧", "btnキャンセル_Click", ex);
            }
        }

        #endregion



    }
}
