﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
//using System.Reflection;

using SystemCommon;
using ClientCommon;


namespace 顧客分析君
{
    public partial class _404顧客動向表 : Form
    {
        ////////////////////////////////////////////////////////////////////////
        // メンバ変数
        ////////////////////////////////////////////////////////////////////////
        #region メンバ変数

        public int mi画面最小サイズ_縦 = 550;
        public int mi画面最小サイズ_幅 = C_画面最小サイズ.メイン_幅;

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 公開 共通メソッド 
        ////////////////////////////////////////////////////////////////////////
        #region 公開 共通メソッド

        public _404顧客動向表()
        {
            InitializeComponent();
        }

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // 非公開 共通メソッド
        ////////////////////////////////////////////////////////////////////////
        #region 非公開 共通メソッド

        private void Set列幅()
        {
            dgv顧客動向表.Columns[0].Width = C_列幅.RFMランク;

            for (int iCol = 1; iCol <= dgv顧客動向表.ColumnCount - 1; iCol++)
            {
                dgv顧客動向表.Columns[iCol].Width = C_列幅.顧客数;
            }
        }


        private void Set計算条件()
        {
            D05計算.D05RFM計算条件DataTable dt = new D05計算.D05RFM計算条件DataTable();
            d05RFM計算条件ta.Fill(dt);

            //検索条件設定
            if (dt[12].値 == "1")
            {
                //txtR5.Text = dt[0].値.Trim();
                //txtR4.Text = dt[1].値.Trim();
                //txtR3.Text = dt[2].値.Trim();
                //txtR2.Text = dt[3].値.Trim();
                txtF5.Text = dt[4].値.Trim();
                txtF4.Text = dt[5].値.Trim();
                txtF3.Text = dt[6].値.Trim();
                txtF2.Text = dt[7].値.Trim();

                txtM5.Text = string.Format("{0:#,0}", long.Parse(dt[8].値.ToString()));
                txtM4.Text = string.Format("{0:#,0}", long.Parse(dt[9].値.ToString()));
                txtM3.Text = string.Format("{0:#,0}", long.Parse(dt[10].値.ToString()));
                txtM2.Text = string.Format("{0:#,0}", long.Parse(dt[11].値.ToString()));
            }
            else
            {
                //txtR5_動向表.Text = dt[13].値.Trim();
                //txtR4_動向表.Text = dt[14].値.Trim();
                //txtR3_動向表.Text = dt[15].値.Trim();
                //txtR2_動向表.Text = dt[16].値.Trim();
                txtF5.Text = dt[17].値.Trim();
                txtF4.Text = dt[18].値.Trim();
                txtF3.Text = dt[19].値.Trim();
                txtF2.Text = dt[20].値.Trim();

                txtM5.Text = string.Format("{0:#,0}", long.Parse(dt[21].値.ToString()));
                txtM4.Text = string.Format("{0:#,0}", long.Parse(dt[22].値.ToString()));
                txtM3.Text = string.Format("{0:#,0}", long.Parse(dt[23].値.ToString()));
                txtM2.Text = string.Format("{0:#,0}", long.Parse(dt[24].値.ToString()));
            }
        }

        private Boolean Setヘッダー()
        {
            //dgv顧客動向表.RowCount = 16;
            dgv顧客動向表.RowCount = 11;

            D07顧客動向表.D07年月DataTable dt = new D07顧客動向表.D07年月DataTable();
            d07年月ta.Fill(dt);
            dgv顧客動向表.ColumnCount = dt.Count + 1;

            if (dt.Count <= 0)
            {
                MessageBox.Show(Properties.Resources.MSG_W_表示できるデータがありません, this.Text, MessageBoxButtons.OK, 
                    MessageBoxIcon.Warning);
                return false;
            }

            //　年月を設定
            for (int iCol = 1; iCol <= dt.Count; iCol++)
            {
                dgv顧客動向表.Rows[0].Cells[iCol].Value = dt[iCol - 1].年 + "/" + dt[iCol - 1].月 ;
                dgv顧客動向表.Rows[0].Cells[iCol].Style.BackColor = SystemColors.Control;
            }
            dgv顧客動向表.Rows[0].Cells[0].Style.BackColor = SystemColors.Control;

            //　RFMレベルを設定
            int iRFMレベル = 5;
            for (int iRow = 1; iRow <= 5; iRow++)
            {
                //dgv顧客動向表.Rows[iRow].Cells[0].Value = "R" + iRFMレベル.ToString();
                //dgv顧客動向表.Rows[iRow].Cells[0].Style.BackColor = Color.RosyBrown;
                //dgv顧客動向表.Rows[iRow + 5].Cells[0].Value = "F" + iRFMレベル.ToString();
                //dgv顧客動向表.Rows[iRow + 5].Cells[0].Style.BackColor = Color.SandyBrown;
                //dgv顧客動向表.Rows[iRow + 10].Cells[0].Value = "M" + iRFMレベル.ToString();
                //dgv顧客動向表.Rows[iRow + 10].Cells[0].Style.BackColor = Color.SpringGreen;

                dgv顧客動向表.Rows[iRow].Cells[0].Value = "F" + iRFMレベル.ToString();
                dgv顧客動向表.Rows[iRow].Cells[0].Style.BackColor = SystemColors.Control;
                dgv顧客動向表.Rows[iRow + 5].Cells[0].Value = "M" + iRFMレベル.ToString();
                dgv顧客動向表.Rows[iRow + 5].Cells[0].Style.BackColor = SystemColors.Control;

                iRFMレベル--;
            }

            return true;
        }

        private void Setデータ()
        {
            D07顧客動向表.D07顧客動向表DataTable dt = new D07顧客動向表.D07顧客動向表DataTable();

            for (int iCol = 1; iCol <= dgv顧客動向表.ColumnCount - 1; iCol++)
            {
                string[] str年月 = dgv顧客動向表.Rows[0].Cells[iCol].Value.ToString().Split('/');
                d07顧客動向表ta.Fill(dt, str年月[0], str年月[1]);

                for (int iRow = 1; iRow <= dt.Count; iRow++)
                {
                    dgv顧客動向表.Rows[iRow].Cells[iCol].Value = dt[iRow - 1].顧客数;
                    dgv顧客動向表.Rows[iRow].Cells[iCol].Style.BackColor = 
                        Color.FromArgb(dt[iRow - 1].Color_R, dt[iRow - 1].Color_G, dt[iRow - 1].Color_B);
                }
            }
        }

        //入力値検証
        private bool IsValidate()
        {
            if (dgv顧客動向表.SelectedCells[0].ColumnIndex < 1 || dgv顧客動向表.SelectedCells[0].RowIndex < 1)
            {
                MessageBox.Show(Properties.Resources.MSG_W_顧客数が表示されているセル以外が選択されています, this.Text, MessageBoxButtons.OK, MessageBoxIcon.Warning);
                return false;
            }

            return true;
        }

        #endregion


        ////////////////////////////////////////////////////////////////////////
        // イベントハンドラ
        ////////////////////////////////////////////////////////////////////////
        #region イベントハンドラ
        
        private void _404顧客動向表_Load(object sender, EventArgs e)
        {
            bool b正常終了 = true;
            try
            {

                //計算済みチェック
                //if (C02業務共通処理.最後に計算した日時() == "")
				if (C02業務共通処理.最後に計算した日時() == "")
                {
                    b正常終了 = false;
                    MessageBox.Show(Properties.Resources.MSG_W_計算が完了していない為_分析結果を表示できません, this.Text, MessageBoxButtons.OK
                        , MessageBoxIcon.Warning);
                    this.Close();
                    return;
                }

                Cursor.Current = Cursors.WaitCursor;
                //dgv顧客動向表.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.None;

                Set計算条件();

                if (Setヘッダー() == false)
                {
                    Close();
                    return;
                }

                Setデータ();

                //if (C02業務共通処理.分析手法を取得() == enm分析手法.バスケット分析.ToString())
				if (C02業務共通処理.分析手法を取得() == enm分析手法.バスケット分析.ToString())
                    btn顧客リスト.Visible = false;

            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_404顧客動向表", "_404顧客動向表_Load", ex);
            }
            finally
            {
                //dgv顧客動向表.AutoSizeColumnsMode = DataGridViewAutoSizeColumnsMode.AllCells;
                if (b正常終了 == true)
                    Set列幅();

                Cursor.Current = Cursors.Arrow;
            }
        }

        private void _404顧客動向表_Resize(object sender, EventArgs e)
        {
            try
            {
                C01FormCommon.画面最小サイズに変更(this, mi画面最小サイズ_縦, mi画面最小サイズ_幅);
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_404顧客動向表", "_404顧客動向表_Resize", ex);
            }
        }

        private void dgv顧客動向表_ColumnAdded(object sender, DataGridViewColumnEventArgs e)
        {
            e.Column.FillWeight = 1;
        }

        private void btnキャンセル_Click(object sender, EventArgs e)
        {
            try
            {
                this.Close();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_404顧客動向表", "btnキャンセル_Click", ex);
            }

        }

        private void btn顧客リスト_Click(object sender, EventArgs e)
        {
            try
            {
                _403抽出顧客一覧 _403抽出顧客一覧 = null;
                _403抽出顧客一覧 = new _403抽出顧客一覧();
                _403抽出顧客一覧.mbMode = C_抽出顧客Mode.顧客動向表;

                //入力値検証
                if (IsValidate() == false)
                    return;

                string msh年 = dgv顧客動向表.Rows[0].Cells[dgv顧客動向表.SelectedCells[0].ColumnIndex].Value.ToString().Substring(0, 4);
                string mb月 = dgv顧客動向表.Rows[0].Cells[dgv顧客動向表.SelectedCells[0].ColumnIndex].Value.ToString().Substring(5);
                string mbRFM種別 = dgv顧客動向表.Rows[dgv顧客動向表.SelectedCells[0].RowIndex].Cells[0].Value.ToString().Substring(0, 1);
                if (mbRFM種別 == "R")
                    mbRFM種別 = "1";
                else if (mbRFM種別 == "F")
                    mbRFM種別 = "2";
                else if (mbRFM種別 == "M")
                    mbRFM種別 = "3";
                string mbRFMランク = dgv顧客動向表.Rows[dgv顧客動向表.SelectedCells[0].RowIndex].Cells[0].Value.ToString().Substring(1);

                _403抽出顧客一覧.ms年 = short.Parse(msh年);
                _403抽出顧客一覧.mb月 = byte.Parse(mb月);
                _403抽出顧客一覧.mbRFM種別 = byte.Parse(mbRFM種別);
                _403抽出顧客一覧.mbRFMランク = byte.Parse(mbRFMランク);

                C01FormCommon.画面最小サイズに変更(_403抽出顧客一覧, true);
                _403抽出顧客一覧.ShowDialog();
            }
            catch (Exception ex)
            {
                C04システム共通.ErrorLog("_404顧客動向表", "btn顧客リスト_Click", ex);
            }
        }

        #endregion


    }
}
