//--------------------------------------------------------------//
// Particle Effects
//--------------------------------------------------------------//
float4x4 viewProj : ViewProjection;
float4x4 world : World;
float4x4 viewInverse : ViewInverse;
float time;
float startSize;
float endSize;
float4 speedVec; 
float4 smokeColor;

texture smokeTexture;
sampler Smoke = sampler_state
{
   Texture = (smokeTexture);
   MAGFILTER = LINEAR;
   MINFILTER = LINEAR;
   MIPFILTER = LINEAR;
};

struct VS_INPUT 
{
   float4 Pos: POSITION;
};

struct VS_OUTPUT
{
   float4 Pos : POSITION;
   float2 texCoord : TEXCOORD0;
   float  color : TEXCOORD1;
};

VS_OUTPUT vs_main( VS_INPUT In )
{
   VS_OUTPUT Out;
   
   float t = frac(In.Pos.y + time);
   float s = (sin(162 * In.Pos.y)*speedVec.w);
   Out.texCoord = In.Pos.xz*0.5f+0.5f;
   In.Pos.xz *= lerp(startSize , endSize, saturate(pow(t, 1.0f)));

   float3 pos;
   pos.x = speedVec.x*pow(t , 2.0f)+s;
   pos.y = speedVec.y*pow(t , 1.2f)+s;
   pos.z = speedVec.z*pow(t , 2.0f)+s;

   // r{[h
   float4 wld = mul(float4(pos,1), world);
   wld += In.Pos.x * viewInverse[0] + In.Pos.z * viewInverse[1];
   
   Out.Pos = mul(wld, viewProj);
   Out.color = 1 - pow(t, 5.0f);

   return Out;
}


float4 ps_main(VS_OUTPUT In) : COLOR0
{
   float4 smoke = tex2D(Smoke,In.texCoord);
   smoke.w -= 1.0f - In.color;
   smoke *= smokeColor;

   return smoke;

}



//--------------------------------------------------------------//
// Technique
//--------------------------------------------------------------//
technique Smiler_Smoke
{
   pass Pass0
   {
      CULLMODE = NONE;
      ALPHABLENDENABLE = TRUE;
      ZENABLE = TRUE;
      ZWRITEENABLE = FALSE;
      SRCBLEND = SRCALPHA;
      DESTBLEND = INVSRCALPHA;
      VertexShader = compile vs_2_0 vs_main();
      PixelShader = compile ps_2_0 ps_main();
   }

}

