﻿#include <stdio.h>
#include <string.h>

#include <curl/curl.h>
#include <libxml/parser.h>
#include <libxml/tree.h>
#include <libxml/xpath.h>

#include <NicoLib/NicoLib.h>
#include <NicoLib/http.h>
#include <NicoLib/xmlparser.h>
#include <NicoLib/api.h>


int nlc_api_ismaintenance(NLCXMLParser *nlcxml)
{
	char *node = NULL;

	nlc_xmlparser_parse(nlcxml, &node, "/*//error/code");
	if(!node)
	{
		return 0;
	}

	if(!stricmp(node, "maintenance"))
	{
		free(node);
		return 1;
	}

	free(node);
	return 0;
}




