﻿#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <NicoLib/NicoLib.h>
#include <NicoLib/types.h>
#include <NicoLib/error.h>

const char *nlc_err_tostr(NLCResult res)
{
	switch(res)
	{
		case NLCE_OK:
			return "No error";
		case NLCE_API_ERR:
			return "API error";
		case NLCE_BAD_FUNCTION_ARGUMENT:
			return "Bad function argument";
		case NLCE_CURL_ERR:
			return "Error in libcurl";
		case NLCE_LIBXML_ERR:
			return "Error in libxml";
		case NLCE_XMLPARSER_ERR:
			return "Error in NLCXMLParser";
		case NLCE_NO_MEMORY:
			return "No more memory to allocate";


		case NLCE_API_OK:
			return "No API error";
		case NLCE_API_UNK_ERR:
			return "Unknown API error";

		case NLCE_API_MAINTENANCE:
			return "Maintenance mode";
		case NLCE_API_ACCOUNT_DATA_INCORRECT:
			return "Wrong mailaddress/password";
		case NLCE_API_ACCOUNT_LOCKED:
			return "Account is locked";


		case NLCE_API_LIVE_NOT_FOUND:
			return "Stream not found";
		case NLCE_API_LIVE_NOT_PERMITTED:
			return "No permission to access the stream";
		case NLCE_API_LIVE_REQUIRE_COMMUNITY_MEMBER:
			return "Stream requires community member";
		case NLCE_API_LIVE_CLOSED:
			return "Stream is closed";
		case NLCE_API_LIVE_FULL:
			return "Stream is full";
		

		case NLCE_UNK_ERR:
		default:		
			break;
	}
	return "Unknown error";
}

// 整数みたいに扱えるのってすごく便利だよね！
int nlc_err_isvideoerr(NLCResult res)
{
	if(NLCE_API_VIDEO_FIRST < res && res < NLCE_API_VIDEO_LAST)
	{
		return 1;
	}

	return 0;
}

int nlc_err_isseigaerr(NLCResult res)
{
	if(NLCE_API_SEIGA_FIRST < res && res < NLCE_API_SEIGA_LAST)
	{
		return 1;
	}

	return 0;
}


int nlc_err_isliveerr(NLCResult res)
{
	if(NLCE_API_LIVE_FIRST < res && res < NLCE_API_LIVE_LAST)
	{
		return 1;
	}
	
	return 0;
}

