﻿#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <curl/curl.h>
#include <NicoLib/NicoLib.h>

size_t nlc_http_curl_cb(const char *buf, size_t size, size_t nmemb, char **userData)
{
	char *ptr;
	if(*userData == NULL)
	{
		if((ptr = (char *)malloc(strlen(buf)+1)) == NULL)
		{
			// out of memory
			return 0; // returning wrong size will shutdown curl functions
		}
		*userData = ptr;
		strcpy(*userData, buf);
	}
	else
	{
		if((ptr = (char *)realloc(*userData, strlen(*userData)+strlen(buf)+1)) == NULL)
		{
			// out of memory
			return 0;
		}
		*userData = ptr;
		strcat(*userData, buf);
	}

	return size*nmemb;
}

#ifdef NLC_UNICODE2SJIS
void NLC_unicode2sjis(char *sjis, const char *unicode)
{
	#ifdef NLC_USENKF
	SetNkfOption("-s");
	NkfConvert(sjis, unicode);
	#endif
}
#endif

NLCResult nlc_curl_http_get(char **buf, const char *url, const char *query)
{
	char *query2 = NULL;
	CURL *curl;
	CURLcode res;

	if(url == NULL)
	{
		return NLCE_BAD_FUNCTION_ARGUMENT;
	}

	if(query)
	{
		query2 = (char *)malloc(strlen(url) + strlen(query) + 2);
		strcpy(query2, url);
		strcat(query2, "?");
		strcat(query2, query);
	}
	#ifdef NLC_DEBUG
	printf("nlc: accessing [%s]\n", query?query2:url);
	#endif

	curl = curl_easy_init();
	if(!curl)
	{
		#ifdef NLC_DEBUG
		printf("nlc: Failed to initialize libcurl\n");
		#endif
		return NLCE_CURL_ERR;
	}

	curl_easy_setopt(curl, CURLOPT_NOPROGRESS, 1);
	curl_easy_setopt(curl, CURLOPT_SSL_VERIFYHOST, 0);
	curl_easy_setopt(curl, CURLOPT_SSL_VERIFYPEER, 0);

	curl_easy_setopt(curl, CURLOPT_HTTPGET, 1);
	curl_easy_setopt(curl, CURLOPT_URL, query?query2:url);

	curl_easy_setopt(curl, CURLOPT_WRITEDATA, buf);
	curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, nlc_http_curl_cb);
	res = curl_easy_perform(curl);
	if(res != CURLE_OK)
	{
		#ifdef NLC_DEBUG
		printf("nlc: curl_easy_perform: %s\n", curl_easy_strerror(res));
		#endif
		return NLCE_CURL_ERR;
	}
	curl_easy_cleanup(curl);
	
	if(!*buf)
	{
		// HTTP request succeeded,
		// but in some reason
		// response is NULL
		return NLCE_UNK_ERR;
	}

	#ifdef NLC_UNICODE2SJIS
	NLC_unicode2sjis(*buf, *buf);
	#endif

	return NLCE_OK;
}


NLCResult nlc_curl_http_post(char **buf, const char *url, const char *query)
{
	CURL *curl;
	CURLcode res;

	if(url == NULL)
	{
		return NLCE_BAD_FUNCTION_ARGUMENT;
	}

	#ifdef NLC_DEBUG
	printf("nlc: accessing [%s]\n", url);
	printf("nlc: POST parameter is [%s]\n", query);
	#endif

	curl = curl_easy_init();
	if(!curl)
	{
		#ifdef NLC_DEBUG
		printf("nlc: Failed to initialize libcurl\n");
		#endif
		return NLCE_CURL_ERR;
	}

	curl_easy_setopt(curl, CURLOPT_NOPROGRESS, 1);
	curl_easy_setopt(curl, CURLOPT_SSL_VERIFYHOST, 0);
	curl_easy_setopt(curl, CURLOPT_SSL_VERIFYPEER, 0);

	curl_easy_setopt(curl, CURLOPT_HTTPPOST, 1);
	curl_easy_setopt(curl, CURLOPT_URL, url);
	if(query)
	{
		curl_easy_setopt(curl, CURLOPT_POSTFIELDS, query);
	}

	curl_easy_setopt(curl, CURLOPT_WRITEDATA, buf);
	curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, nlc_http_curl_cb);
	res = curl_easy_perform(curl);
	if(res != CURLE_OK)
	{
		#ifdef NLC_DEBUG
		printf("nlc: curl_easy_perform: %s\n", curl_easy_strerror(res));
		#endif
		return NLCE_CURL_ERR;
	}
	curl_easy_cleanup(curl);
	if(!*buf)
	{
		// HTTP request succeeded,
		// but in some reason
		// response is NULL
		return NLCE_UNK_ERR;
	}

	#ifdef NLC_UNICODE2SJIS
	NLC_unicode2sjis(*buf, *buf);
	#endif

	return NLCE_OK;
}



